#ifndef __LREAD_P_H__
#define __LREAD_P_H__

extern Lisp_Object read_filtered_event _P_((int no_switch_frame,
                                            int ascii_required,
                                            int error_nonascii));
extern int openp _P_((Lisp_Object path, Lisp_Object str, char *suffix,
                      Lisp_Object *storeptr, int exec_only));
extern Lisp_Object unreadpure _P_((Lisp_Object dummy));
extern int isfloat_string _P_((register char *cp));
extern Lisp_Object check_obarray _P_((Lisp_Object obarray));
extern Lisp_Object intern _P_((char *str));
extern Lisp_Object oblookup _P_((Lisp_Object obarray,
                                 register char *ptr,
                                 register int size));
extern _VOID_ map_obarray _P_((Lisp_Object obarray,
                               void (*fn)(Lisp_Object tail, Lisp_Object arg),
                               Lisp_Object arg));
extern _VOID_ mapatoms_1 _P_((Lisp_Object sym, Lisp_Object function));
extern _VOID_ init_obarray _P_((void));
extern _VOID_ defsubr _P_((struct Lisp_Subr *sname));
extern _VOID_ defalias _P_((struct Lisp_Subr *sname, char *string));
extern _VOID_ defvar_int _P_((char *namestring, int *address, char *doc));
extern _VOID_ defvar_bool _P_((char *namestring, int *address, char *doc));
extern _VOID_ defvar_lisp _P_((char *namestring, Lisp_Object *address,
                               char *doc));
extern _VOID_ defvar_lisp_nopro _P_((char *namestring, Lisp_Object *address,
                                     char *doc));
extern _VOID_ defvar_per_buffer _P_((char *namestring, Lisp_Object *address,
                                     Lisp_Object type, char *doc));
extern _VOID_ init_lread _P_((void));
extern _VOID_ syms_of_lread _P_((void));

DEFUN_P(Fread_char, (void));
DEFUN_P(Fread_event, (void));
DEFUN_P(Fread_char_exclusive, (void));
DEFUN_P(Fget_file_char, (void));
DEFUN_P(Fload, (Lisp_Object str, Lisp_Object noerror, Lisp_Object nomessage,
                  Lisp_Object nosuffix));
DEFUN_P(Feval_buffer, (Lisp_Object bufname, Lisp_Object printflag));
DEFUN_P(Feval_region, (Lisp_Object b, Lisp_Object e, Lisp_Object printflag));
DEFUN_P(Fread, (Lisp_Object readcharfun));
DEFUN_P(Fread_from_string, (Lisp_Object string, Lisp_Object start,
                              Lisp_Object end));
DEFUN_P(Fintern, (Lisp_Object str, Lisp_Object obarray));
DEFUN_P(Fintern_soft, (Lisp_Object str, Lisp_Object obarray));
DEFUN_P(Fmapatoms, (Lisp_Object function, Lisp_Object obarray));
    
#endif
