source [system path -absolute [info library] oops.tcl]
oClass stateMachine {
    stateMachine {lambda} {
        global oThis
        oSet $oThis theState $lambda
        oSend $lambda enter
    }
    ~stateMachine {} {
        global oThis
        oSend [oGet $oThis theState] exit
    }
    declare {event {args {}}} {
        global oThis
        set oldState [oGet $oThis theState]
        set newState [eval [concat oSend $oldState $event $args]]
        if {[string compare $oldState $newState ]} {
            oSend $oldState exit
            oSend $newState enter
            oSet $oThis theState $newState
        }
    }
}
oClass state {
    enter {} {}
    exit {} {}
}
