#	Calculate various financial factors related to the "time value of money".
#	Release 2.2.49
#	Copyright (c) 1989-1995 by Hamilton Laboratories.  All rights reserved.

proc PV_FutureAmount(i, n)
	#	Calculate the multiplier to convert $1 in period n to a
	#		present value, given interest rate i% per period.
	return 1/(1 + i/100)**n
	end

proc FV_PresentAmount(i, n)
	#	Calculate the multiplier to convert $1 now to a
	#		future value, given interest rate i
	return (1 + i/100)**n
	end

proc PV_Annuity(i, n)
	#	Calculate the multiplier to convert $1 paid each period for n periods
	#		to a present value, given interest rate i% per period.
	@ i /= 100
	return ((1 + i)**n - 1)/(i*(1 + i)**n)
	end

proc FV_Annuity(i, n)
	#	Calculate the multiplier to convert $1 paid each period for n periods
	#		to a future value, given interest rate i% per period.
	@ i /= 100
	return ((1 + i)**n - 1)/i
	end

proc Periods_PV(i, PV)
	#	Calculate the multipler to convert an annuity of $1 paid each period,
	#		given present value and interest rate, to a number of periods.
	@ i /= 100;
	return ceil(-(log(1/i - PV) + log(i))/log(i + 1))
	end

proc Periods_FV(i, FV)
	#	Calculate the multipler to convert an annuity of $1 paid each period,
	#		given future value and interest rate, to a number of periods.
	@ i /= 100
	return ceil(log(i*FV + 1)/log(i + 1))
	end
