#	Calculate the day of the week corresponding to a given date.
#	Copyright (c) 1991 by Hamilton Laboratories.  All rights reserved.

proc weekday(month, day, year)
	local days, i
	set days = Sunday Monday Tuesday Wednesday Thursday Friday Saturday
	# Get the Julian day, but notice that 4713 BC was not a leap year.
	if ((i = `julian $month $day $year`) < 58) @ i++
	return days[(i + 2) % 7]
end

weekday $argv
