#	First-pass fixup of expressions.

#		1. Fixup expression operators and syntax:

#				-n foo		-->		foo != ""
#				-z foo		-->		foo == ""
#				a = b			-->		a == b
#				a -eq b		-->		a == b
#				a -gt b		-->		a > b
#				a -ge b		-->		a >= b
#				a -lt b		-->		a < b
#				a -le b		-->		a <= b
#				a -ne b		-->		a != b
#				a -o b		-->		a || b

#				[ ... ]		-->		( ... )

#		2.	Do `expr ...` evaluation in the C shell:

#				i=`expr ${i} + 1`	-->	@ i=i + 1

#		3. Other assignments become set statements.

/^[^#]* \[[^[].*\]/{
	s/-n  *\([^ ].*\) \]/\1 != "" ]/g
	s/-z  *\([^ ].*\) \]/\1 == "" ]/g
	s/ = / == /g
	s/ -eq / == /g
	s/ -gt / > /g
	s/ -ge / >= /g
	s/ -lt / < /g
	s/ -le / <= /g
	s/ -ne / != /g
	s/ -o / || /g
	s/\[/(/
	s/]/)/
	}

/^[^#]*=`expr.*`/{
	s/`//g
	s/expr //
	/: "\.\*"/s/\([^ 	=][^ 	]*\)[ 	]*: "\.\*"/strlen(\1)/
	/^[ 	]*[a-zA-Z][a-zA-Z0-9_]*[ 	]*=/s/[a-zA-Z]/@ &/
	}

/^[ 	]*[a-zA-Z][a-zA-Z0-9_]*[ 	]*=/s/[a-zA-Z]/set &/
