/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992-1994  Anders Christensen <anders@pvv.unit.no>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Id: extern.h,v 1.17 1993/05/10 05:54:16 anders Exp anders $
 *     such traceing is anabled.
 */

/*
    This code modified for Win32 port by Ataman Software, Inc. June 29, 1995.
*/

/* 
 * Routines in lexsrc.l 
 */
   void initexternal( FILE *fptr ) ; 
   void initinterpret( streng *string ) ;
   void initvalue( streng *string ) ;
   void initmacro( streng *str ) ;
   void initscanner( void ) ;
#ifdef yywrap
#undef yywrap   
   int yywrap( void ) ;
#endif

/* 
 * Routines in parse.c 
 */
   void doparse( streng *source, nodeptr subtree, int end, int point ) ;
   void parseargtree(paramboxptr argbox, nodeptr this, int upper);
   int bmstrstr( streng *heystack, int start, streng *needle ) ;


/* 
 * Routines in debug.c 
 */
   void dumpvars( variableptr *hashptr ) ;
   void dumptree( treenode *this, int level ) ;
   int numsourcelines( void ) ;
   streng *sourceline( int line, lineboxptr, lineboxptr ) ;
   streng *getsourceline( int line, int charnr, lineboxptr, lineboxptr ) ;
#ifndef NDEBUG
   char *getsym( int number ) ;
#endif
#ifdef TRACEMEM
   void marksource( lineboxptr ) ;
#endif


/* 
 * Routines in files.c 
 */
   streng *readkbdline( void ) ;
   void mark_filetable( void ) ;
   void initfiletable( void ) ;
   void fixup_file( streng * ) ;
     

/* 
 * Routines in expr.c
 */
#ifdef WIN32
#define boolean zBoolean
#endif
   int boolean( nodeptr ) ;
   num_descr *calcul( nodeptr, num_descr** ) ;
   void initexpr( void ) ;
   streng *evaluate( nodeptr this, streng **kill ) ;


/*
 * Routines in rexx.h
 */
#ifdef TRACEMEM
#endif /* TRACEMEM */


/* ------------------------------ memory.c ------------------------------ */
#ifdef FLISTS
   void *get_a_chunk( int bytes ) ;
   streng *get_a_streng( int bytes ) ;
   void  give_a_chunk( void *ptr ) ;
   void  give_a_streng( streng *ptr ) ;
   void  init_hash_table( void ) ;
#endif
#ifdef TRACEMEM
   void *mymalloc( int bytes ) ;
   void  myfree( void *ptr ) ;
   void regmarker( void (*func)() ) ;
   int   have_allocated( int flag ) ;
   void  markmemory( void *ptr, int i ) ;
   int   listleaked( int pflag ) ;
   void  memory_stats( void ) ;
   void  mark_listleaked_params( void ) ;
#endif /* TRACEMEM */

#ifdef TRACEMEM
# define Malloc(bytes)     mymalloc(bytes)
# define Free(ptr)         myfree(ptr)
# define Free_string(ptr)  myfree(ptr)
#else
# ifdef FLISTS
#  define Malloc(bytes)     get_a_chunk(bytes)
#  define Free(ptr)         give_a_chunk(ptr)
#  define Free_string(ptr)  give_a_streng(ptr)
# else
#  define Malloc(bytes)     malloc(bytes)
#  define Free(ptr)         free(ptr)
#  define Free_string(ptr)  free(ptr)
# endif /* FLISTS */
#endif /* TRACEMEM */



/* ------------------------------ stack.c ------------------------------ */
   streng *popline( void ) ;
   void stack_lifo( streng *line ) ;
   void stack_fifo( streng *line ) ;
   int lines_in_stack( void ) ;
   int stack_empty( void ) ;
#ifdef TRACEMEM
   void mark_stack( void ) ;
#endif /* TRACEMEM */
   int drop_buffer( int num ) ;
   int make_buffer( void ) ;
   void type_buffer( void ) ;
   void tmp_stack( streng*, int ) ;
   void flush_stack( int is_fifo ) ;


/* 
 * Routines in misc.c 
 */
   streng *upcase( streng *text ) ;
   streng *nullstringptr( void ) ;  
   char *system_type( void ) ;
   double cpu_time( void ) ;
#ifdef _POSIX_SOURCE
   void getsecs( time_t *secs, time_t *usecs ) ;
#endif
     


/* 
 * Routines in error.c 
 */
   char *errortext( int errorno ) ;     
   void exiterror( int errorno ) ;
   void yyerror( char *errtext ) ;
   char *getsym( int numb ) ;
   int lineno_of( nodeptr ) ;
 
  
/* 
 * Routines in variable.c 
 */
   void init_vars( void ) ;
   int var_was_found( void ) ;
   variableptr *create_new_varpool( void ) ;
   void setvalue( streng *name, streng *value ) ;
   num_descr *fix_compoundnum( nodeptr this, num_descr *new ) ;
   void setshortcutnum( nodeptr this, num_descr *value ) ;
   streng *getvalue( streng *name, int trace ) ;
   streng *isvariable( streng *name ) ;
   streng *get_it_anyway( streng *name ) ;
   void expose_var( streng *name ) ;
   void drop_var( streng *name ) ;
   void set_ignore_novalue( void ) ;
   int valid_var_symbol( streng *symbol ) ;
   void clear_ignore_novalue( void ) ;  
#ifdef TRACEMEM
   void markvariables( proclevel ) ;
#endif /* TRACEMEM */
   streng *shortcut( nodeptr ) ;
   num_descr *shortcutnum( nodeptr ) ;
   void setshortcut( nodeptr this, streng *value ) ;
   streng *fix_compound( nodeptr this, streng *value ) ;
   void kill_variables( variableptr *array ) ;
   variableptr get_next_variable( int reset ) ;
   void detach( variableptr ptr ) ;

/* 
 * Routines in shell.c 
 */
   int posix_do_command( streng *command, int flag, int envir ) ;
   streng *run_popen( streng *command, streng *envir ) ;
     


/* 
 * Routines in tracing.c 
 */
   void set_trace( streng * ) ;
   void set_trace_char( char ) ;
   void flush_trace_chars( void ) ;
   void queue_trace_char( char ch ) ;
   void tracenumber( num_descr *num, char type ) ;
   void tracebool( int value, char type ) ;
   int pushcallstack( treenode *this ) ;
   void popcallstack( int value ) ;
   void traceerror( treenode *this, int RC ) ;
   void tracecompound( streng *stem, int length, streng *index, char trch ) ;
   void starttrace( void ) ;
   void tracemsg( void ) ;
   int intertrace( void ) ;
   void tracevalue( streng *str, char type ) ;
   void traceline( treenode *this, char tch, int offset ) ;
   void traceback( void ) ;


/* 
 * Routines in interp.c 
 */
   streng *dovalue( streng *string ) ;
   void dointerpret( streng *string ) ;



/* 
 * Routines in interpret.c 
 */
   void update_envirs( proclevel level ) ;
   proclevel newlevel( proclevel oldlevel ) ;
   streng *interpret( nodeptr rootnode ) ;
   void removelevel( proclevel level ) ;
   void init_spec_vars( void ) ;
#ifdef TRACEMEM
   void mark_statics( void ) ;
#endif
     

/*
 * Routines in yaccsrc.y
 */
   extern int yyparse( void ) ;
   void kill_lines( lineboxptr first ) ;
   void destroytree( nodeptr this ) ;
   void purge( void ) ;


     
/* 
 * Routines in funcs.c 
 */
   streng *buildtinfunc( nodeptr this ) ;
   void deallocplink( paramboxptr first ) ;
   paramboxptr initplist( nodeptr this ) ;
   int myatol( streng *text ) ;
   paramboxptr getnextp( nodeptr this, paramboxptr lastp ) ;
   void checkparam( paramboxptr params, int min, int max ) ;
   char getoptionchar( streng *param, char *options ) ;
   int atozpos( streng *text ) ;
   int atopos( streng *text ) ;
   char getonechar( streng *text ) ;
   streng *cpy( streng *source ) ;     
   streng *param( paramboxptr ptr, int num ) ;
   char getoption( streng * ) ;
   streng *int_to_streng( int input ) ;
#ifdef TRACEMEM
   void mark_param_cache( void ) ;
#endif



   void addtwostrings( char *one, char *two, char *answer ) ;   


/* 
 Functions in cmath.c 
 */
   double myatof( streng *string ) ;
   int myisnumber( streng *string ) ;


/* 
 Functions in rexx.c 
 */
   void mark_systeminfo( void ) ;
   nodeptr treadit( nodeptr ) ;
   sysinfobox *creat_sysinfo( streng *envir ) ;
        
     
/* 
 * Functions in signals.h 
 */
   trap *gettraps( proclevel level ) ;
   sigtype *getsigs( proclevel level ) ;
   void mark_signals( void ) ;
   int condition_hook( int, int, int, streng *) ;
   void signal_setup( void ) ;
   int identify_trap( int type ) ;


/* 
 * functions in library.c 
 */
   int load_package( streng*, streng*, streng* ) ;
   void *loaded_lib_func( streng *name ) ;
   streng *do_loaded_func( void *vptr, paramboxptr first ) ;
   void set_err_message( char *message ) ;
   int loadrxfunc( struct library *lptr, streng *rxname, streng *objnam ) ;

/* 
 * Functions in extlib.c
 */
   int addfunc( streng *name, int type ) ;
   int delfunc( streng *name ) ;
   int external_func( streng *name ) ;


/* 
 * functions in macros.c
 */
   void expand_to_str( variableptr ptr ) ;
   void kill_macro( streng *name, int serial )  ;
   int enter_macro( streng *source, streng *name ) ;
   streng *do_instore(streng *,paramboxptr, streng*, int*, int, int, int, int);
   streng *execute_external(streng*, paramboxptr, streng*, int*, int, int );
   int count_params( paramboxptr ptr, int soft ) ;
   streng *get_parameter( paramboxptr ptr, int number ) ;


/* 
 * Functions in envir.c
 */
   streng *perform( streng *command, streng *envir, nodeptr this ) ;
   void add_envir( streng *name, int type, int subtype ) ;
   void init_envir( void ) ;
   void del_envir( streng *name ) ;
     


/* 
 * Functions in client.c
 */
   int hookup( int type, ... ) ;
   void SetupClient( char *pipes ) ;
   void SetupInternal( char *envir ) ;
   void RunClient( void ) ;
   streng *do_an_external( streng *name, paramboxptr parms ) ;
   streng *SubCom( streng *command, streng *environment, int *rc ) ;




/* 
 * global variables 
 */


extern char trace_stat ;


#ifdef WIN32
#include "w32.h"
#endif
