#include <windows.h>
#include <mmsystem.h>

/*

CDEJECT

Run it, and it ejects the CD from the first CD-ROM drive, if
it can.  If you run it with the control key down, it prints
the about box (no big whoop).

This program is Copyright 1993 by David C. Elliott.   It's freeware,
not shareware, and anyone can use or distribute it as long as they
don't sell it.

*/


static void
about()
{
	MessageBox(NULL, "CD Eject\nCopyright 1993 David C. Elliott", "About CD Eject", MB_OK);
}

int PASCAL WinMain(HANDLE hInstance,
		   HANDLE hPrevInstance,
		   LPSTR  lpszCmdLine,
		   int    nCmdShow)
{
	MCI_OPEN_PARMS op;
	MCI_SET_PARMS mciset;
	DWORD mciErr;
	char ebuf[100];
	int printErrors = 1;

	if (lpszCmdLine[0] == '-' && (lpszCmdLine[1] == 'q' || lpszCmdLine[1] == 'Q')) {
		printErrors = 0;
	}
	
	if (GetKeyState(VK_CONTROL) & 0x8000) {
		about();
		return 0;
	}

	if (GetKeyState(VK_SPACE) & 0x8000) {
		printErrors = 1;
	}
	
	op.lpstrDeviceType = "cdaudio";
	
	mciErr = mciSendCommand(0, MCI_OPEN, MCI_OPEN_TYPE | MCI_WAIT, (LONG)&op);
	if (mciErr != 0) {
		if (printErrors) {
			mciGetErrorString(mciErr, (LPSTR)ebuf, sizeof(ebuf) - 1);
			MessageBox(NULL, ebuf, "CD-ROM error", MB_OK);
		}
		return 0;
	}
	
    mciErr = mciSendCommand(op.wDeviceID, MCI_SET, (DWORD)MCI_SET_DOOR_OPEN,(DWORD)&mciset);
	if (mciErr != 0) {
		if (printErrors) {
			mciGetErrorString(mciErr, (LPSTR)ebuf, sizeof(ebuf) - 1);
			MessageBox(NULL, ebuf, "CD-ROM error", MB_OK);
		}
		return 0;
	}
	
    return 0;

} /*  End of WinMain                                                    */

