/*----------------------------------------------------------------------*
 | Filename:    NEWPAPER.C                                              |
 |                                                                      |
 | Description: Windows 3.1 application to change the Windows wallpaper |
 |              to the 'next' .BMP file found in the current working    |
 |              directory.                                              |
 |                                                                      |
 | Notes:       1. If no wallpaper setting in WIN.INI, it does nothing  |
 |              2. Looks for *.BMP files in 'working directory' as set  |
 |                 in File | Properties.  If no *.BMP files, it does    |
 |                 nothing.                                             |
 |              3. It remembers the first *.BMP file found and then     |
 |                 checks the list of *.BMP files against the current   |
 |                 *.BMP setting.  When it finds the current one, it    |
 |                 selects the next one.  If it doesn't find the current|
 |                 one or if the current one is the last one, it uses   |
 |                 the first one found.                                 |
 |                                                                      |
 | Author:      John A. Grant                                           |
 |              Geological Survey of Canada                             |
 |              Mineral Resources Division                              |
 |              Airborne Geophysics Section                             |
 |              601 Booth St., Room 591                                 |
 |              Ottawa, Ontario, K1A 0E8                                |
 |              (613) 992-1082                                          |
 |              jagrant@gsc.emr.ca                                      |
 |                                                                      |
 | Copyright:   None.  This code is hereby released into the public     | 
 |              domain.  You may do with it as you wish.                |
 *----------------------------------------------------------------------*/
//standard function prototypes
	#define STRICT
	#include <windows.h>
	#include <stdlib.h>             //_fullpath
	#include <string.h>             //strcpy
	#include <dir.h>                //findfirst

//constants
	#define NUL             '\0'
	#define MAX_L_PATHNAME  256
	#define INI_SECTION     "Desktop"
	#define INI_ENTRY       "Wallpaper"

//local function prototypes
	static BOOL ChangeWallpaper(void);

/*----------------------------------------------------------------------*
 | main windows procedure                                               |
 *----------------------------------------------------------------------*/
#pragma argsused
int PASCAL WinMain(HINSTANCE hinstance,HINSTANCE hprevinstance,
				LPSTR cmdline,int showtype)
{
	return(ChangeWallpaper());
}


/*----------------------------------------------------------------------*
 |                                                                      |
 *----------------------------------------------------------------------*/
BOOL ChangeWallpaper(void)
{
char current [MAX_L_PATHNAME+1];
char newpaper[MAX_L_PATHNAME+1];
struct ffblk stuff;
BOOL done,takenextone,result;

	result=FALSE;

	//ignore if no wallpaper set
	*current=NUL;
	GetProfileString(INI_SECTION,INI_ENTRY,"",current,sizeof(current));
	if(*current==NUL) goto bye;

	//ignore if no bmp files
	done=findfirst("*.bmp",&stuff,0);
	if(done) goto bye;

	//convert pathname of current wallpaper bitmap to simple filename
	fnsplit(current,NULL,NULL,newpaper,NULL);
	strcpy(current,newpaper);
	strcat(current,".bmp");

	//find current name and pick the next one
	strcpy(newpaper,stuff.ff_name);         //remember first name

	takenextone=FALSE;
	while(!done){ 
	  if(takenextone){
	    strcpy(newpaper,stuff.ff_name);
	    done=TRUE;
	  }else{
	    takenextone=stricmp(current,stuff.ff_name)==0;
	    done=findnext(&stuff);
	  }
	}
	
	//convert filename to pathname
	_fullpath(current,newpaper,sizeof(current));

	//set new wallpaper pathname
	//MessageBox(NULL,current,"New Wallpaper",MB_OK | MB_ICONINFORMATION);
	SystemParametersInfo(SPI_SETDESKWALLPAPER,0,current,SPIF_UPDATEINIFILE);

	result=TRUE;

bye:    return(result);
}
