/******************************************************************************************************
*                                                                                                     *
*                                      TEST.C                                                          *
*                        OWNERDRAW BUTTON DLL TEST APPLICATION                                        *
*                                    by Ted Ott                                                       *
*                                                                                                     *
*                                                                                                     *
******************************************************************************************************/

#include <windows.h>
#include "test.h"


/***************************************procs*********************************************************/

long FAR PASCAL WndProc                 (HWND, WORD, WORD, LONG);       //main body
/////////////////////////////////////////////////////
//		.DLL functions
/////////////////////////////////////////////////////
int FAR PASCAL CreateButtons (int BtnIDStart, int BtnIDEnd, HWND hwnd, LONG lParam);
int FAR PASCAL DrawButtons (HWND hwnd, LONG lParam);
int FAR PASCAL DeleteBtnBitMaps (int BtnIDStart, int BtnIDEnd);
int FAR PASCAL InitializeButtons (int BtnIDStart, int BtnIDEnd,
				  int BtnWidth, int BtnHeight,
				  int BtnXStartPos, int BtnYStartPos,
				  int BtnXPosIncrement, int BtnYPosIncrement,
				  HANDLE hinst);

/**********************************global variables***************************************************/

char szAppName []                       = "test";                       //app name
HANDLE hInst;                                                           //app instance

/******************************************************************************************************
*                                 WinMain entrypoint                                                  *
******************************************************************************************************/

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                   LPSTR lpszCmdLine, int nCmdShow)
{
	HWND hwnd;                                                      //window identifier
	MSG  msg;                                                       //message identifier
	WNDCLASS wndclass;                                              //window class


	hInst = hInstance;                                              //app instance

	if (!hPrevInstance)
	{
		wndclass.style           =CS_HREDRAW | CS_VREDRAW ;
		wndclass.lpfnWndProc     =(WNDPROC)WndProc ;
                wndclass.cbClsExtra      =0 ;
                wndclass.cbWndExtra      =0 ;
                wndclass.hInstance       =hInstance ;
		wndclass.hIcon           =LoadIcon (hInstance, szAppName) ;
                wndclass.hCursor         =LoadCursor (NULL, IDC_ARROW) ;
                wndclass.hbrBackground   =GetStockObject (WHITE_BRUSH) ;
		wndclass.lpszMenuName    =szAppName ;
		wndclass.lpszClassName   =szAppName ;

		RegisterClass (&wndclass);



	}

////////////////////////////////////////////////////////////////////////////////////////////////
//This function initializes buttons to be used as a button bar in the main window
//The first two parameters specify the first two buttons used in the application
//		(a loop in .Dll is used to initialize them: for(i=0;i<2;i++))
//The second two parameters specify the height and width of the bitmaps used
//The next two specify the upper left X & Y position of the first button
//The next two specify X & Y position increments of buttons
//The last parameter specifies instance of app that contains button bitmaps (located in .RC)
//wndproc will do the work of displaying the buttons
//////////////////////////////////////////////////////////////////////////////////////////////// 

	InitializeButtons (0, 2, 28, 28, 0, 0, 28, 0, hInst);

	hwnd = CreateWindow (szAppName, "Test",
			     WS_OVERLAPPEDWINDOW,
			     CW_USEDEFAULT, CW_USEDEFAULT,
			     CW_USEDEFAULT, CW_USEDEFAULT,				  //intro bitmap size
			     NULL, NULL, hInstance, NULL);


	ShowWindow (hwnd, nCmdShow);
	UpdateWindow (hwnd);
        
        while (GetMessage (&msg, NULL, 0,0))
	{
		TranslateMessage (&msg);
		DispatchMessage (&msg);
	}



	return msg.wParam;
}
/**********************************************************************************************************
*                     TestOne dialog box                                                               *
**********************************************************************************************************/

BOOL FAR PASCAL TestOneProc (HWND hDlg, WORD message, WORD wParam, LONG lParam)
{
	switch (message)
        {
                case WM_INITDIALOG:
////////////////////////////////////////////////////////////////////////
//Initialize next two buttons to use in this dialog box
//Use the .RC to create the child windows (dialog boxes only)
////////////////////////////////////////////////////////////////////////
			InitializeButtons (2, 4, 28, 28, 132, 52, 28, 0,
					GetWindowWord (hDlg, GWW_HINSTANCE));
			return FALSE;
		case WM_DRAWITEM:
///////////////////////////////////////////////////////////////////////
//Used to draw the buttons when nessasary
///////////////////////////////////////////////////////////////////////
			DrawButtons (hDlg, lParam);
			return 0;
		case WM_COMMAND:
		{
			switch (wParam)
                        {
				case IDM_BUTTON_THREE:
					MessageBox (hDlg, "button 3", "test", MB_OK);
					return 0;
				case IDM_BUTTON_FOUR:
					MessageBox (hDlg, "button 4", "test", MB_OK);
					return 0;
                       		case IDOK:
///////////////////////////////////////////////////////////////////////
//Delete the bitmaps for buttons created above. VERY IMPORTANT!
///////////////////////////////////////////////////////////////////////
					DeleteBtnBitMaps (2, 4);
                                	EndDialog (hDlg, 0);
					return TRUE;
                        }
		}
	}
        return FALSE;
}
/**********************************************************************************************************
*                     TestTwo dialog box                                                               *
**********************************************************************************************************/

#pragma argsused

BOOL FAR PASCAL TestTwoProc (HWND hDlg, WORD message, WORD wParam, LONG lParam)
{
	switch (message)
        {
                case WM_INITDIALOG:
//////////////////////////////////////////////////////////////////////
//To use several X & Y positons that can not be incremented,
//initialize seperately with different values
//////////////////////////////////////////////////////////////////////
			InitializeButtons (4, 6, 28, 28, 0, 0, 28, 0,
					GetWindowWord (hDlg, GWW_HINSTANCE));
			InitializeButtons (6, 7, 28, 28, 132, 52, 28, 0,
					GetWindowWord (hDlg, GWW_HINSTANCE));
			return FALSE;
		case WM_DRAWITEM:
///////////////////////////////////////////////////////////////////////
//Used to draw the buttons when nessasary
///////////////////////////////////////////////////////////////////////
			DrawButtons (hDlg, lParam);
			return 0;
		case WM_COMMAND:
		{
			switch (wParam)
                        {
				case IDM_BUTTON_FIVE:
					MessageBox (hDlg, "button 5", "test", MB_OK);
					return 0;
				case IDM_BUTTON_SIX:
					MessageBox (hDlg, "button 6", "test", MB_OK);
					return 0;
				case IDM_BUTTON_SEV:
					MessageBox (hDlg, "button 7", "test", MB_OK);
					return 0;
                       		case IDOK:
///////////////////////////////////////////////////////////////////////
//Delete the bitmaps for buttons created above. VERY IMPORTANT!
///////////////////////////////////////////////////////////////////////
					DeleteBtnBitMaps (4, 7);
                                	EndDialog (hDlg, 0);
					return TRUE;
                        }
		}
	}
        return FALSE;
}


/******************************************************************************************************
*                                  base procedure                                                     *
******************************************************************************************************/


long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
	static HANDLE   hInstance;                                      //app instance
	static FARPROC  lpfnTestOneProc;
	static FARPROC  lpfnTestTwoProc;

	switch (message)
                {
                case WM_CREATE:
			hInstance       = ((LPCREATESTRUCT) lParam)->hInstance;
			lpfnTestOneProc	= MakeProcInstance (TestOneProc, hInstance);
			lpfnTestTwoProc	= MakeProcInstance (TestTwoProc, hInstance);
////////////////////////////////////////////////////////////////////////
//This function creates the child windows in the main window
//for the buttons initialized in WinMain. (Do not used this
//function for dialog boxes, use CONTROL statements in .RC instead)
//////////////////////////////////////////////////////////////////////// 
			CreateButtons (0, 2, hwnd, lParam);
			return 0;
		 case WM_DRAWITEM:
///////////////////////////////////////////////////////////////////////
//draws buttons when needed
///////////////////////////////////////////////////////////////////////
			DrawButtons (hwnd, lParam);
			return 0;
		 case WM_COMMAND:
			switch (wParam)
                        {
				case IDM_TEST1:                                //displays about box
					DialogBox (hInstance, "TestBoxOne", hwnd, lpfnTestOneProc);
					return 0;
				case IDM_TEST2:                                //displays about box
					DialogBox (hInstance, "TestBoxTwo", hwnd, lpfnTestTwoProc);
					return 0;
			      	case IDM_BUTTON_ONE:
					MessageBox (hwnd, "button 1", "test", MB_OK);
					return 0;
				case IDM_BUTTON_TWO:
					MessageBox (hwnd, "button 2", "test", MB_OK);
					return 0;
			}
			break;
                case WM_DESTROY:
//////////////////////////////////////////////////////////////////////
//Deletes bitmaps. VERY IMPORTANT!
//////////////////////////////////////////////////////////////////////
			DeleteBtnBitMaps (0, 2);
			PostQuitMessage (0);
			return 0;
                }


	return DefWindowProc (hwnd, message, wParam, lParam);
}

