'--------------------
'Types
'--------------------
Type GPIPoint
    x As Integer
    Y As Integer
End Type

'--------------------
'DLL Routines
'--------------------
Declare Function GetModuleUsage Lib "Kernel" (ByVal hinst As Integer) As Integer
Declare Function WinGetPrivateProfileInt Lib "Kernel" Alias "GetPrivateProfileInt" (ByVal SectionName$, ByVal KeyName$, ByVal Default%, ByVal IniFileName$) As Integer
Declare Function WinGetPrivateProfileString Lib "Kernel" Alias "GetPrivateProfileString" (ByVal SectionName$, ByVal KeyName$, ByVal Default$, ByVal Ret$, ByVal Size%, ByVal IniFileName$) As Integer
Declare Function WinWritePrivateProfileString Lib "Kernel" Alias "WritePrivateProfileString" (ByVal SectionName$, ByVal KeyName$, ByVal Value$, ByVal IniFileName$) As Integer
Declare Function WinExec Lib "Kernel" (ByVal CommandLine$, ByVal CmdShow As Integer) As Integer

Declare Function FindWindow Lib "User" (ByVal lpClassName As Any, ByVal lpCaption As Any) As Integer
Declare Function ShowWindow Lib "User" (ByVal Handle As Integer, ByVal Cmd As Integer) As Integer
Declare Function SFocus Lib "User" Alias "SetFocus" (ByVal Handle As Integer) As Integer
Declare Sub GetCursorPos Lib "User" (aPoint As GPIPoint)
Declare Function IsWindow Lib "User" (ByVal hWnd) As Integer

'--------------------
'Global Constants
'--------------------
Global Const Blank = 0&

Global Const IniFalse = False
Global Const IniTrue = True

Global Const FormIsNormal = 0
Global Const FormIsMinimized = 1
Global Const FormIsMaximized = 2

Global Const NWCorner = 0
Global Const NECorner = 1
Global Const SWCorner = 2
Global Const SECorner = 3

'--------------------
'Program Constants & Defaults
'--------------------

' Title of main program window
Global Const WindowTitle$ = "Screen Saver Activator"

' Default enable corner
Global Const DefaultActivateCorner = NECorner

' Default disable corner
Global Const DefaultDisableCorner = SECorner

' Default value for Enabled setting
Global Const DefaultEnabled = IniTrue

' Default Hide Icon setting
Global Const DefaultHideIcon = IniTrue

' Name of .ini file
Global Const IniFileName$ = "ScrActt.Ini"

' Name of section within .ini file
Global Const IniSectionName$ = "ScreenSaverActivator"

' Name of corner used to activate the screen saver
Global Const IniActivateCornerKeyName$ = "ActivateCorner"

' Name of corner used to disable screen saver
Global Const IniDisableCornerKeyName$ = "DisableCorner"

' Whether the screen saver activator is enabled
Global Const IniEnabledKeyName$ = "Enabled"

' Whether to hide the icon (i.e., hide instead of minimize)
Global Const IniHideIconKeyName$ = "HideIcon"

'--------------------
'Global Variables
'--------------------
Global IniActivateCorner As Integer
Global IniDisableCorner As Integer
Global IniEnabled As Integer
Global IniHideIcon As Integer
Global ActivateXLow As Integer
Global ActivateXHigh As Integer
Global ActivateYLow As Integer
Global ActivateYHigh As Integer
Global DisableXLow As Integer
Global DisableXHigh As Integer
Global DisableYLow As Integer
Global DisableYHigh As Integer
Global RunningSaver As Integer
Global PrevSaver$

Sub CenterForm (aForm As Form)
    aForm.Left = (Screen.Width - aForm.Width) / 2
    aForm.Top = (Screen.Height - aForm.Height) / 2
End Sub

Sub Main ()
    frmMain.Show
End Sub

Function RetrieveIniInt (IniFileName$, IniSectionName$, KeyName$, Default%, CantBe%) As Integer
    Dim aInt

    aInt = WinGetPrivateProfileInt(IniSectionName$, KeyName$, CantBe%, IniFileName$)
    If aInt = CantBe% Then
        aInt = Default%
        Value$ = Format$(aInt)
        Result = WritePrivateProfileString(IniFileName$, IniSectionName$, KeyName$, Value$)
    End If

    RetrieveIniInt = aInt
End Function

Sub RetrieveIniSettings ()
    ' Declare variables
    Dim KeyName$
    Const CantBe = -1

    KeyName$ = IniActivateCornerKeyName$
    Default% = DefaultActivateCorner
    IniActivateCorner = Abs(RetrieveIniInt(IniFileName$, IniSectionName$, KeyName$, Default%, CantBe%))

    KeyName$ = IniDisableCornerKeyName$
    Default% = DefaultDisableCorner
    IniDisableCorner = Abs(RetrieveIniInt(IniFileName$, IniSectionName$, KeyName$, Default%, CantBe%))

    KeyName$ = IniEnabledKeyName$
    Default% = DefaultEnabled
    IniEnabled = -Abs(RetrieveIniInt(IniFileName$, IniSectionName$, KeyName$, Default%, CantBe%))

    KeyName$ = IniHideIconKeyName$
    Default% = DefaultHideIcon
    IniHideIcon = -Abs(RetrieveIniInt(IniFileName$, IniSectionName$, KeyName$, Default%, CantBe%))
End Sub

Sub SaveIniSettings ()
    ' Declare variables
    Dim KeyName$, Value$
    Dim Result

    KeyName$ = IniActivateCornerKeyName$
    Value$ = Format$(IniActivateCorner)
    Result = WritePrivateProfileString(IniFileName$, IniSectionName$, KeyName$, Value$)

    KeyName$ = IniDisableCornerKeyName$
    Value$ = Format$(IniDisableCorner)
    Result = WritePrivateProfileString(IniFileName$, IniSectionName$, KeyName$, Value$)
    
    KeyName$ = IniEnabledKeyName$
    Value$ = Format$(Abs(IniEnabled))
    Result = WritePrivateProfileString(IniFileName$, IniSectionName$, KeyName$, Value$)

    KeyName$ = IniHideIconKeyName$
    Value$ = Format$(Abs(IniHideIcon))
    Result = WritePrivateProfileString(IniFileName$, IniSectionName$, KeyName$, Value$)
End Sub

Sub SetACornerPosition (ByVal aCorner As Integer, XLow As Integer, XHigh As Integer, YLow As Integer, YHigh As Integer)
    Select Case aCorner
        Case NWCorner
            XLow = 0
            YLow = 0

        Case NECorner
            XLow = Screen.Width / Screen.TwipsPerPixelX - 1
            YLow = 0

        Case SWCorner
            XLow = 0
            YLow = Screen.Height / Screen.TwipsPerPixelY - 1
        
        Case SECorner
            XLow = Screen.Width / Screen.TwipsPerPixelX - 1
            YLow = Screen.Height / Screen.TwipsPerPixelY - 1
    End Select

    XHigh = XLow + 1
    YHigh = YLow + 1
End Sub

Sub SetCornerPositions ()
    SetACornerPosition IniActivateCorner, ActivateXLow, ActivateXHigh, ActivateYLow, ActivateYHigh
    SetACornerPosition IniDisableCorner, DisableXLow, DisableXHigh, DisableYLow, DisableYHigh
End Sub

Function WritePrivateProfileString (ByVal IniFileName$, ByVal SectionName$, ByVal KeyName$, ByVal Value$) As Integer
    Dim Success
    Dim Msg$
    
    Success = WinWritePrivateProfileString(SectionName$, KeyName$, Value$, IniFileName$)
    If Success Then     ' Evaluate results.
    Else
        Msg$ = "Error writing to ini file." + Chr$(13)
        Msg$ = Msg$ + "Ini File: " + IniFileName$ + Chr$(13)
        Msg$ = Msg$ + "Section: " + SectionName$ + Chr$(13)
        Msg$ = Msg$ + "Key: " + KeyName$ + Chr$(13)
        Msg$ = Msg$ + "Value: " + Value$
        MsgBox Msg$          ' Display message.
    End If

    WritePrivateProfileString = Success
End Function

