/* Sample source for STICKS screen saver for Screen Peace */
/* Copyright 1990 Anthony Andersen                        */

#include <windows.h>

#include "sticks.h"

#define IDD_CHECKBOX 10
#define IDD_EDIT     11

unsigned long seed;
char buffer[10];
int  enabled;
unsigned erasecount;

char savername[] = "Sticks";
char appname[] = "Screen Peace";
char keyname[] = "Sticks On";
char key2name[] = "Num Sticks";

/* this is called by the default dll entry code during the  */
/* load library call - always happens BEFORE any other call */
/* in the dll.                                              */

int FAR PASCAL LibMain(hModule, wDataSeg, cbHeapSize, lpszCmdLine)

HANDLE	hModule;
WORD     wDataSeg;
WORD     cbHeapSize;
LPSTR    lpszCmdLine;

{

   /* set up things here */

	erasecount = GetProfileInt(appname,key2name,250);
	GetProfileString(appname,keyname,"y",buffer,9);
	if (buffer[0] != 'n' && buffer[0] != 'N') {
		enabled = TRUE;
	}
	return (1);
}


/* this is called by Windows when the dll is released */

int FAR PASCAL WEP (bSystemExit)
int  bSystemExit;

{
    /* get rid of things you allocated in the LibMain proc here */

    return (1);
}

/* this is called (probably lots of times) by Screen Peace */
/* be careful not to allocate memory or objects here       */

char FAR * FAR PASCAL saverinit(BOOL far *savenabled)

{
	/* tell enable state */

	*savenabled = enabled;

	/* You must return either the saver's name or NULL */

	return(savername);
}

/* dialog proc for user customization */

BOOL FAR PASCAL saverdlgproc(HWND hdlg,unsigned message,WORD wparam,LONG lparam)

{
	switch (message) {

	case WM_INITDIALOG:

		/* set the dialog items */

		SetDlgItemInt(hdlg,IDD_EDIT,erasecount,FALSE);
		SendDlgItemMessage(hdlg,IDD_CHECKBOX,BM_SETCHECK,enabled,0);
		return (TRUE);

	case WM_COMMAND:

		if (wparam == IDOK) {

			/* get the new dialog items */

			erasecount = GetDlgItemInt(hdlg,IDD_EDIT,NULL,FALSE);
			enabled = (int)SendDlgItemMessage(hdlg,IDD_CHECKBOX,BM_GETCHECK,0,0);

			/* write the profile information */

			if (enabled) buffer[0] = 'y';
			else buffer[0] = 'n';
			buffer[1] = '\0';
			WriteProfileString(appname,keyname,buffer);
			wsprintf(buffer,"%u",erasecount);
			WriteProfileString(appname,key2name,buffer);

			/* return value in EndDialog doesn't matter */

			EndDialog(hdlg,TRUE);
			return (TRUE);
		}
		else if (wparam == IDCANCEL) {

			/* just return - return value in EndDialog doesn't matter */

			EndDialog(hdlg,FALSE);
			return (TRUE);
		}
		break;

	}

	return (FALSE);
}

/* returns pseudorandom number from 0 to x-1 */

int arand(int x)
{
	seed = seed*0x343fd+0x269ec3;
	return (int)(((seed>>16)&0x7fff)*x>>15);
}

/* the main drawing routine */

VOID FAR PASCAL saverdraw(HWND hwnd,HDC hdc,HANDLE hinst,BOOL (FAR PASCAL *yieldproc)(VOID)) 

{
	RECT rect;
	HPEN hpen;
	HPEN hOldPen;
	HBRUSH hbrush;
	int  x1,x2,y1,y2;
	int  pw,pc;
	unsigned count;

	/* the rect will fill the screen */

	GetWindowRect(hwnd,&rect);

	/* seed the pseudorandom number generator */

	seed = GetTickCount();

	/* get black brush for erasing screen */

	hbrush = GetStockObject(BLACK_BRUSH);

	count = 0;

	/* You MUST "black out" the screen if you want the screen blacked out */

	FillRect(hdc,&rect,hbrush);

	/* make sure to call yieldproc OFTEN - windows is locked up until */
	/* yieldproc is called.                                           */

	while ((*yieldproc)()) {

		/* get "random" color and width */

 		pc = arand(16);
		pw = arand(10);

		/* select pen and save old pen */

		hpen = CreatePen(PS_SOLID,pw,pc+0x1000000);
		hOldPen = SelectObject(hdc,hpen);

		/* get coordinates of endpoints of line */

		x1 = arand(rect.right);
		x2 = arand(rect.right);
		y1 = arand(rect.bottom);
		y2 = arand(rect.bottom);

		/* draw line */

		MoveTo(hdc,x1,y1);
		LineTo(hdc,x2,y2);

		/* delete pen */

		SelectObject(hdc,hOldPen);
		DeleteObject(hpen);

		/* black out screen if appropriate */

		count++;
		if (count == erasecount) {
			count = 0;
			FillRect(hdc,&rect,hbrush);
		}
	}

}




