
#include "worm.h"

/* ------------------------------------------------------------------ */

int ErrorBox(char *message)
{
 return (MessageBox ( GetFocus(), message,
              "Worming Error", MB_ICONASTERISK | MB_OK));
}

/* ------------------------------------------------------------------ */

void CreateDialogBox(HWND hWnd, FARPROC DlgProc, int idd)
{
   extern HANDLE hInst;
   FARPROC lpProc;

   lpProc = MakeProcInstance(DlgProc, hInst);
   DialogBox(hInst, MAKEINTRESOURCE(idd), hWnd, lpProc);
   FreeProcInstance(lpProc);
}
/* ------------------------------------------------------------------ */
/* The following pseudo-random sequence generator was published in
   Dr. Dobb's Journal, February 1992. I beleive it to be superior to the
   rand function.
*/
unsigned LSFR(void)
{
 static unsigned long reg = 10;

 reg = ((((reg >> 31) /* shift the 32nd bit to the first bit */
      ^ (reg >> 6)   /* XOR it with the seventh bit */
      ^ (reg >> 4)   /* XOR it with the fifth bit   */
      ^ (reg >> 2)   /* XOR it with the third bit   */
      ^ (reg >> 1)   /* XOR it with the second bit  */
      ^ reg)         /* XOR it with the fist bit    */
       & 0x00000001)  /* strip all the other bits off and */
      << 31)         /* move it back to the 32nd bit.    */
      | (reg >> 1);  /* or it with the register shifted right. */

 return (int) reg & 0x00000001; /* return the first bit */

}
/* ------------------------------------------------------------ */
BOOL IsOnDesktop(POINT testPoint)
{
  HWND desktopHandle = GetDesktopWindow();
  POINT point;
  int size = GetSize();

  point.x = testPoint.x + size;
  point.y = testPoint.y + size;
  if(WindowFromPoint(point) != desktopHandle)
     return FALSE;

  point.x = testPoint.x - size;
  if(WindowFromPoint(point) != desktopHandle)
     return FALSE;

  point.y = testPoint.y - size;
  if(WindowFromPoint(point) != desktopHandle)
     return FALSE;

  point.x = testPoint.x + size;
  if(WindowFromPoint(point) != desktopHandle)
     return FALSE;

  return TRUE;
}

/* ------------------------------------------------------------------ */

/* EOF */