

#include "worm.h"

static int _size  = DEFAULT_SIZE;
static int _speed = DEFAULT_SPEED;
static int _step  = DEFAULT_STEP;
static int _rings = DEFAULT_RINGS;

/* ------------------------------------------------- */

void InitGlobalDataFromIniFile(void)
{
   extern HANDLE hInst;
   char fullpath[_MAX_PATH];
   char drive[_MAX_DRIVE];
   char dir[_MAX_DIR];
   char fname[_MAX_FNAME];
   char ext[_MAX_EXT];

   GetModuleFileName(hInst, fullpath, _MAX_PATH);

   _splitpath(fullpath, drive, dir, fname, ext);
   *fullpath=0;
   strcat(fullpath, drive);
   strcat(fullpath, dir);
   strcat(fullpath, fname);
   strcat(fullpath, ".INI");

   if(!(_speed = GetPrivateProfileInt("WORM", "Speed", _speed, fullpath)))
      ErrorBox("Error reading the WORM.INI file!");
   _size  = GetPrivateProfileInt("WORM", "Size",  _size,  fullpath);
   _step  = GetPrivateProfileInt("WORM", "Step",  _step,  fullpath);
   _rings = GetPrivateProfileInt("WORM", "Rings", _rings, fullpath);

}

/* --------------------------------------------------------------------------- */


int GetSize(void)
{ return _size; }

/* ------------------------------------------------- */

int GetSpeed(void)
{  return _speed; }

/* ------------------------------------------------- */

int GetStep(void)
{ return _step; }

/* ------------------------------------------------- */

int GetRings(void)
{ return _rings; }

/* ------------------------------------------------- */

void SetSize( int newSize)
{ _size = newSize; }

/* ------------------------------------------------- */

void SetSpeed( int newSpeed)
{ _speed = newSpeed; }

/* ------------------------------------------------- */

void SetStep( int newStep)
{ _step = newStep; }

/* ------------------------------------------------- */

void SetRings( int newRings)
{ _rings = newRings; }

/* ------------------------------------------------- */

/* EOF */
