
#include "worm.h"

extern RING* rP;
extern HWND hMainWindow;
extern hInst;

BOOL FAR PASCAL OptionsDlgProc(HWND hDlg, unsigned message, WORD wParam,
                             LONG lParam)
{

static int sizePos  = DEFAULT_SIZE;
static int speedPos = DEFAULT_SPEED;
static int stepPos  = DEFAULT_STEP;
static int ringsPos = DEFAULT_RINGS;
char buffer[50];

switch(message) {

    case WM_INITDIALOG:

         sizePos  = GetSize();
         speedPos = GetSpeed();
         stepPos  = GetStep();
         ringsPos = GetRings();

         SetScrollRange(GetDlgItem(hDlg, IDC_SIZE_BAR),  SB_CTL, MIN_SIZE, MAX_SIZE, TRUE);
         SetScrollPos  (GetDlgItem(hDlg, IDC_SIZE_BAR),  SB_CTL, DEFAULT_SIZE, TRUE);

         SetScrollRange(GetDlgItem(hDlg, IDC_SPEED_BAR), SB_CTL, MIN_SPEED, MAX_SPEED, TRUE);
         SetScrollPos  (GetDlgItem(hDlg, IDC_SPEED_BAR), SB_CTL, DEFAULT_SPEED, TRUE);

         SetScrollRange(GetDlgItem(hDlg, IDC_STEP_BAR),  SB_CTL, MIN_STEP, MAX_STEP, TRUE);
         SetScrollPos  (GetDlgItem(hDlg, IDC_STEP_BAR),  SB_CTL, DEFAULT_STEP, TRUE);

         SetScrollRange(GetDlgItem(hDlg, IDC_RINGS_BAR), SB_CTL, MIN_RINGS, MAX_RINGS, TRUE);
         SetScrollPos  (GetDlgItem(hDlg, IDC_RINGS_BAR), SB_CTL, DEFAULT_RINGS, TRUE);

         PostMessage(hDlg, WO_SIZE_UPDATE, NULL, NULL);
         PostMessage(hDlg, WO_SPEED_UPDATE, NULL, NULL);
         PostMessage(hDlg, WO_STEP_UPDATE, NULL, NULL);
         PostMessage(hDlg, WO_RINGS_UPDATE, NULL, NULL);
         return (TRUE);

    case WO_SPEED_UPDATE:
         wsprintf(buffer, "Speed: %d [ticks/sec.]", speedPos);
         SetDlgItemText(hDlg, IDC_SPEED_TEXT, buffer);
         SetScrollPos  (GetDlgItem(hDlg, IDC_SPEED_BAR), SB_CTL, speedPos, TRUE);
         SetSpeed(speedPos);
         KillTimer(hMainWindow, NULL);
         SetTimer (hMainWindow, NULL, 1000 / GetSpeed(), NULL);
         break;

    case WO_STEP_UPDATE:
         wsprintf(buffer, "Step: %d pixels (size+%d)", sizePos+stepPos, stepPos);
         SetDlgItemText(hDlg, IDC_STEP_TEXT, buffer);
         SetScrollPos  (GetDlgItem(hDlg, IDC_STEP_BAR), SB_CTL, stepPos, TRUE);
         CleanUp();
         SetStep(stepPos);
         break;

    case WO_SIZE_UPDATE:
         wsprintf(buffer, "Size: %d pixels", sizePos);
         SetDlgItemText(hDlg, IDC_SIZE_TEXT, buffer);
         SetScrollPos  (GetDlgItem(hDlg, IDC_SIZE_BAR), SB_CTL, sizePos, TRUE);
         CleanUp();
         SetSize(sizePos);
         PostMessage(hDlg, WO_STEP_UPDATE, NULL, NULL);
         break;

    case WO_RINGS_UPDATE:
         wsprintf(buffer, "Rings: %d", ringsPos);
         SetDlgItemText(hDlg, IDC_RINGS_TEXT, buffer);
         SetScrollPos  (GetDlgItem(hDlg, IDC_RINGS_BAR), SB_CTL, ringsPos, TRUE);
         CleanUp();
         FreeWormList();
         SetRings(ringsPos);
         rP = InitWormList();
         break;



    case WM_COMMAND:
         switch(wParam) {
            case IDOK:
                 EndDialog(hDlg, NULL);
                 return (TRUE);
            case IDC_DEFAULT:
                 sizePos  = DEFAULT_SIZE;
                 speedPos = DEFAULT_SPEED;
                 stepPos  = DEFAULT_STEP;
                 ringsPos = DEFAULT_RINGS;
                 PostMessage(hDlg, WO_SIZE_UPDATE, NULL, NULL);
                 PostMessage(hDlg, WO_SPEED_UPDATE, NULL, NULL);
                 PostMessage(hDlg, WO_STEP_UPDATE, NULL, NULL);
                 PostMessage(hDlg, WO_RINGS_UPDATE, NULL, NULL);
                 break;
            case IDC_WRITE_INI:
                 {
                  char buffer[5];
                  char fullpath[_MAX_PATH];
                  char drive[_MAX_DRIVE];
                  char dir[_MAX_DIR];
                  char fname[_MAX_FNAME];
                  char ext[_MAX_EXT];

                  GetModuleFileName(hInst, fullpath, _MAX_PATH);

                  _splitpath(fullpath, drive, dir, fname, ext);
                  *fullpath=0;
                  strcat(fullpath, drive);
                  strcat(fullpath, dir);
                  strcat(fullpath, fname);
                  strcat(fullpath, ".INI");

                  if(!WritePrivateProfileString("WORM", "Speed", itoa(speedPos, buffer, 10), fullpath)) {
                     ErrorBox("Error writing to the WORM.INI file!");
                     break;
                  }
                  WritePrivateProfileString("WORM", "Size",  itoa(sizePos,  buffer, 10), fullpath);
                  WritePrivateProfileString("WORM", "Step",  itoa(stepPos,  buffer, 10), fullpath);
                  WritePrivateProfileString("WORM", "Rings", itoa(ringsPos, buffer, 10), fullpath);
                 }
                 break;

            case IDC_READ_INI:
                 {
                  char fullpath[_MAX_PATH];
                  char drive[_MAX_DRIVE];
                  char dir[_MAX_DIR];
                  char fname[_MAX_FNAME];
                  char ext[_MAX_EXT];

                  GetModuleFileName(hInst, fullpath, _MAX_PATH);
                  _splitpath(fullpath, drive, dir, fname, ext);
                  *fullpath=0;
                  strcat(fullpath, drive);
                  strcat(fullpath, dir);
                  strcat(fullpath, fname);
                  strcat(fullpath, ".INI");

                  if(!(speedPos = GetPrivateProfileInt("WORM", "Speed", speedPos, fullpath))) {
                     ErrorBox("Error reading the WORM.INI file!");
                     break;
                  }
                  sizePos  = GetPrivateProfileInt("WORM", "Size",  sizePos,  fullpath);
                  stepPos  = GetPrivateProfileInt("WORM", "Step",  stepPos,  fullpath);
                  ringsPos = GetPrivateProfileInt("WORM", "Rings", ringsPos, fullpath);
                 }
                 PostMessage(hDlg, WO_SIZE_UPDATE, NULL, NULL);
                 PostMessage(hDlg, WO_SPEED_UPDATE, NULL, NULL);
                 PostMessage(hDlg, WO_STEP_UPDATE, NULL, NULL);
                 PostMessage(hDlg, WO_RINGS_UPDATE, NULL, NULL);
                 break;

         }
         break;


    case WM_HSCROLL:
         switch (wParam) {
            case SB_LINEUP:

                 switch( GetDlgCtrlID(HIWORD(lParam))) {
                    case IDC_SIZE_BAR:
                         if(sizePos > MIN_SIZE) {
                            sizePos--;
                            PostMessage(hDlg, WO_SIZE_UPDATE, NULL, NULL);
                         }
                         return (TRUE);


                    case IDC_SPEED_BAR:
                         if(speedPos > MIN_SPEED) {
                            speedPos--;
                            PostMessage(hDlg, WO_SPEED_UPDATE, NULL, NULL);
                         }
                         return (TRUE);


                    case IDC_STEP_BAR:
                         if(stepPos > MIN_STEP) {
                            stepPos--;
                            PostMessage(hDlg, WO_STEP_UPDATE, NULL, NULL);
                         }
                         return (TRUE);


                    case IDC_RINGS_BAR:
                         if(ringsPos > MIN_RINGS) {
                            ringsPos--;
                            PostMessage(hDlg, WO_RINGS_UPDATE, NULL, NULL);
                         }
                         return (TRUE);
                 } /* switch( GetDlgCtrlID(HIWORD(lParam))) */
                 break;

            case SB_LINEDOWN:
                 switch( GetDlgCtrlID(HIWORD(lParam))) {
                    case IDC_SIZE_BAR:
                         if(sizePos < MAX_SIZE) {
                            sizePos++;
                            PostMessage(hDlg, WO_SIZE_UPDATE, NULL, NULL);
                         }
                         return (TRUE);
                    case IDC_SPEED_BAR:
                         if(speedPos < MAX_SPEED) {
                            speedPos++;
                            PostMessage(hDlg, WO_SPEED_UPDATE, NULL, NULL);
                         }
                         return (TRUE);
                    case IDC_STEP_BAR:
                         if(stepPos < MAX_STEP) {
                            stepPos++;
                            PostMessage(hDlg, WO_STEP_UPDATE, NULL, NULL);
                         }
                         return (TRUE);
                    case IDC_RINGS_BAR:
                         if(ringsPos < MAX_RINGS) {
                            ringsPos++;
                            PostMessage(hDlg, WO_RINGS_UPDATE, NULL, NULL);
                         }
                         return (TRUE);
                 } /* switch( GetDlgCtrlID(HIWORD(lParam))) */
                 break;

            case SB_THUMBPOSITION:
                 switch( GetDlgCtrlID(HIWORD(lParam))) {
                    case IDC_SIZE_BAR:
                         sizePos = LOWORD(lParam);
                         PostMessage(hDlg, WO_SIZE_UPDATE, NULL, NULL);
                         return (TRUE);


                    case IDC_SPEED_BAR:
                         speedPos = LOWORD(lParam);
                         PostMessage(hDlg, WO_SPEED_UPDATE, NULL, NULL);
                         return (TRUE);


                    case IDC_STEP_BAR:
                         stepPos = LOWORD(lParam);
                         PostMessage(hDlg, WO_STEP_UPDATE, NULL, NULL);
                         return (TRUE);


                    case IDC_RINGS_BAR:
                         ringsPos = LOWORD(lParam);
                         PostMessage(hDlg, WO_RINGS_UPDATE, NULL, NULL);
                         return (TRUE);

                 } /* switch( GetDlgCtrlID(HIWORD(lParam))) */
                 break;
         } /* switch (wParam) */
  } /* switch(message) */
   return(FALSE);
}
