
#include <windows.h>
#include <math.h>
#include <malloc.h>
#include <stdlib.h>
#include <string.h>

#include "wormdlg.h"

#define PI 3.1415927

#define IDM_ABOUT    1000
#define IDM_OPTIONS  2000


#define WORM_APPNAME  "Worm"
#define WORM_TITLE    "Worm"
#define INCREMENT     0.1745

#define ACTIVE          0
#define INACTIVE        1

#define INNOCENT        0
#define GUILTY          1

#define CORRECTION      0
#define NO_CORRECTION   1

#define MAX_SIZE        10
#define MAX_SPEED       19
#define MAX_STEP        10
#define MAX_RINGS       50

#define MIN_SIZE        1
#define MIN_SPEED       1
#define MIN_STEP        2
#define MIN_RINGS       2



#define DEFAULT_SIZE    2
#define DEFAULT_SPEED   15 /* a tick aprrox. every 100 msec */
#define DEFAULT_STEP    2
#define DEFAULT_RINGS   5

#define WO_BASE           WM_USER + 100
#define WO_SPEED_UPDATE   WO_BASE + 1
#define WO_STEP_UPDATE    WO_BASE + 2
#define WO_SIZE_UPDATE    WO_BASE + 3
#define WO_RINGS_UPDATE   WO_BASE + 4


/* Type definitions ---------------------------- */

typedef struct ring_s
{
 POINT center;
 int   state      : 1;
 DWORD color;
 struct ring_s *next;
} RING;

/* function Prototypes ------------------------- */
int  rand(void);

/* WormMain.C ------ */
int  PASCAL WinMain(HANDLE, HANDLE, LPSTR, int);

/* WormInit -------- */
BOOL WormInit(HANDLE);

/* WormTop -------- */
long FAR PASCAL WormWndProc(HWND, unsigned, WORD, LONG);

/* About.C --------- */
BOOL FAR PASCAL AboutDlgProc(HWND, unsigned, WORD, LONG);

/* WormDraw.C --------- */
void WormUpdate(void);
BOOL GetScreenSize(void);
BOOL IsOnDesktop(POINT testPoint);
void CleanUp(void);

/* WormList.C ------ */
RING* InitWormList(void);
void  FreeWormList(void);

/* biblio.C --------- */
int      ErrorBox(char *message);
void     CreateDialogBox(HWND hWnd, FARPROC DlgProc, int idd);
unsigned LSFR(void);

/* Options.C --------- */
BOOL FAR PASCAL OptionsDlgProc(HWND, unsigned, WORD, LONG);

/* Global.C ---------- */
void InitGlobalDataFromIniFile(void);
int GetSize(void);
int GetSpeed(void);
int GetStep(void);
int GetRings(void);
void SetSize( int newSize);
void SetSpeed( int newSpeed);
void SetStep( int newStep);
void SetRings( int newSpeed);


/* EOF */

