

#include "worm.h"

RING *rP;
static RECT  _wormcage;

/* ----------------------------------------------------------------- */

BOOL GetScreenSize(void)
{
   HDC    screen;

   /* Create a device context for the screen. */
   screen=CreateDC("DISPLAY", NULL, NULL, NULL);
   if(!screen)
       return(FALSE);

   _wormcage.right  = GetDeviceCaps(screen, HORZRES);
   _wormcage.bottom = GetDeviceCaps(screen, VERTRES);

   /* Delete the device context as soon as possible. */
   DeleteDC(screen);

   _wormcage.top  = 0;
   _wormcage.left = 0;

   /* This creates a worm list. */
   rP = InitWormList();
   return(TRUE);
}

/* ----------------------------------------------------------------- */

void WormUpdate(void)
{
HDC screen;
static double dir=0.0;
POINT  currentTail, currentHead, previousHead;
int size     = GetSize();
int stepSize = GetStep() + size;


/* rP points to the head */
previousHead  = rP->center;
currentTail   = rP->next->center;

/* make rP point to the tail: */
rP = rP->next;

#if 1 /* if using a 386 capable compiler */
if(LSFR())
    dir+=INCREMENT;
else
    dir-=INCREMENT;
#endif
#if 0 /* otherwise use the standard rand() */
if(rand()<16384)
   dir+=INCREMENT;
else
   dir-=INCREMENT;
#endif

/* update the coordinates of the new head (i.e the previous tail) */
CALCULATE_DIR:
   rP->center.x  = previousHead.x + (int)(stepSize*cos(dir));
   rP->center.y  = previousHead.y - (int)(stepSize*sin(dir));


   if(rP->center.x < _wormcage.left)
      rP->center.x = _wormcage.right-1;
   if(rP->center.x > _wormcage.right)
      rP->center.x = _wormcage.left;
   if(rP->center.y < _wormcage.top)
      rP->center.y = _wormcage.bottom-1;
   if(rP->center.y > _wormcage.bottom)
      rP->center.y = _wormcage.top;


   screen=CreateDC("DISPLAY", NULL, NULL, NULL);
   SelectObject(screen, GetStockObject(BLACK_BRUSH) );
   SetROP2(screen, R2_NOTXORPEN);
   SelectObject(screen, GetStockObject(BLACK_PEN) );

   /* erase the currentTail */
   if( (IsOnDesktop(currentTail)) && (rP->state == ACTIVE) &&
       (rP->color == GetPixel(screen, currentTail.x,  currentTail.y))) {
   Ellipse(screen, currentTail.x - size, currentTail.y - size,
                   currentTail.x + size, currentTail.y + size);

   }
   /* display new head */
   currentHead = rP->center;
   if(IsOnDesktop(currentHead)) {
      Ellipse(screen, currentHead.x - size, currentHead.y - size,
                      currentHead.x + size, currentHead.y + size);
      rP->color = GetPixel(screen, currentHead.x,  currentHead.y);
      rP->state = ACTIVE;
   }
   else
      rP->state = INACTIVE;

   /* release the device context as soon as possible */
   DeleteDC(screen);
}

/* -------------------------------------------------------------- */

void CleanUp(void)
{
  HDC screen;
  int i;
  int size = GetSize();
  POINT point;
  RECT  rect;


  screen=CreateDC("DISPLAY", NULL, NULL, NULL);

  SelectObject(screen, GetStockObject(BLACK_BRUSH) );
  SetROP2(screen, R2_NOTXORPEN);
  SelectObject(screen, GetStockObject(BLACK_PEN) );

  for(i=0; i < GetRings() ; i++) {
   point = rP->center;
   if((IsOnDesktop(point))  && (rP->state == ACTIVE) &&
      (rP->color == GetPixel(screen, point.x,  point.y)))
      rect.left   = point.x - size;
      rect.top    = point.y - size;
      rect.right  = point.x + size;
      rect.bottom = point.y + size;
      InvalidateRect(GetDesktopWindow(), &rect, TRUE);
      //Ellipse(screen, point.x - size, point.y - size,
       //               point.x + size, point.y + size);
   rP->state = INACTIVE;
   rP = rP->next;
  } /* for */

  DeleteDC(screen);
}

/* ------------------------------------------------------------------- */


/* EOF */