

#include "worm.h"

HANDLE hInst;

/* ------------------------------------------------------------------------------ */

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
HWND hWnd;
MSG msg;


/* Make sure that the program is running under a 32bit CPU */
if ((GetWinFlags() & WF_CPU286)) {
	 ErrorBox("This program can only be run under a 32bit CPU!");
	 return(NULL);
}
if(hPrevInstance) {
    ErrorBox("Your screen is already wormed!");
	return(NULL);
}

if(!WormInit(hInstance)) {
   ErrorBox("Class registration failed!");
   return(NULL);
}

hInst = hInstance;

hWnd = CreateWindow(
      WORM_APPNAME,
      WORM_TITLE,
      WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT,
      CW_USEDEFAULT,
      0,
      0,
      NULL,
      NULL,
      hInstance,
      NULL
      );


if(!hWnd) {
   ErrorBox("Could not create window!");
   return (NULL);
}


if(!GetScreenSize()) {
   ErrorBox("Could not obtain screen handle!");
   return(NULL);
}

if(!SetTimer(hWnd, NULL, 1000 / GetSpeed(), NULL) ) {
   ErrorBox("No timers available!");
   return(NULL);
}

ShowWindow(hWnd, SW_MINIMIZE);
UpdateWindow(hWnd);

while( GetMessage( &msg, NULL, NULL, NULL) ) {
   TranslateMessage(&msg);
   DispatchMessage(&msg);
}
return(msg.wParam);

} /* WinMain */

/* EOF */

