
#include "worm.h"

extern RING* rP;
HWND hMainWindow = 0;

/* ---------------------------------------------------------------------------- */
long FAR PASCAL WormWndProc(HWND hWnd, unsigned message, WORD wParam, LONG lParam)
{
FARPROC lpProcAbout;
HMENU hMenu;

switch(message)
    {

    case WM_TIMER:
         WormUpdate();
         break;

    case WM_SIZE:
         InvalidateRect(hWnd, NULL, TRUE);
         break;

    case WM_SYSCOMMAND:
         switch(wParam) {

            case IDM_ABOUT:
                 CreateDialogBox(hWnd, AboutDlgProc, IDD_ABOUT);
                 break;

            case IDM_OPTIONS:
                 CreateDialogBox(hWnd, OptionsDlgProc, IDD_OPTIONS);
                 break;

            default:
                 return(DefWindowProc(hWnd, message, wParam, lParam));
        } /* switch(wParam) */
        break;

    case WM_CREATE:
         hMainWindow = hWnd;
         InitGlobalDataFromIniFile();
         hMenu = GetSystemMenu(hWnd, FALSE);
         ChangeMenu(hMenu, NULL, NULL, NULL, MF_APPEND | MF_SEPARATOR);
         ChangeMenu(hMenu, NULL, "A&bout Worm...", IDM_ABOUT, MF_APPEND | MF_STRING);
         ChangeMenu(hMenu, NULL, NULL, NULL, MF_APPEND | MF_SEPARATOR);
         ChangeMenu(hMenu, NULL, "Options", IDM_OPTIONS, MF_APPEND | MF_STRING);
         break;

    case WM_QUERYOPEN:
         return 0L;

    case WM_DESTROY:
         CleanUp();
         FreeWormList();
         KillTimer(hWnd, NULL);
         PostQuitMessage(0);
        break;
    default:
        return (DefWindowProc(hWnd, message, wParam, lParam));
    }
return(NULL);
}


/* EOF */