unit mycommonprogram ask;
uses wintypes,winprocs,wobjects,strings,commdlg;       
type 
	FileOpenHookProc = function (hDlg : HWnd; Message : word; wParam : word; lParam : longint) : word;
var
	hTempBitmap : hBitMap;
	gbMonochrome : boolean;
	ghDlgBrush	: hBrush;
	lpfnFileOpenHook : ^FileOpenHookProc;
	TheDC : HDC;
{$r ask.res}
{$f+}
function FileOpenHook(hDlg : HWnd; Message : word; wParam : word; lParam : longint) : word;export;
{$f-}
var ret : word;
begin
	ret := word(false);
	case Message of
		WM_INITDIALOG:	begin
							ret := word(true);
						end;

		WM_CTLCOLOR:	begin
							if (gbMonochrome=true) or  (ghDlgBrush=0) then
								FileOpenHook := word(false)
							else
							begin
								if (HIWORD(lParam) = CTLCOLOR_LISTBOX) or (HIWORD(lParam) = CTLCOLOR_EDIT) then
									ret := word(false) {Don't mess with the listboxes}
								else
								begin
									if HIWORD(lParam) = CTLCOLOR_DLG then
										UnrealizeObject(ghDlgBrush);  
									SelectObject(HDC(wParam), ghDlgBrush);
									if (HIWORD(lParam) = CTLCOLOR_DLG) then
										SetBrushOrg(HDC(wParam), 0 , 0);
									SetBkMode(HDC(wParam), TRANSPARENT);
									ret := ghDlgBrush;
								end;
							end;
        				end;
	end;
	FileOpenHook := ret;
end;

procedure CMFileOpen;
var
	OFN : TOpenFileName;
	szFilter : array[0..50] of char;
	szFileName,
	szDirName,
	szCommand,
	szFile,szFileTitle:Array[0..512] of Char;
	szFileDir : array[0..512] of Char;
	chReplace : Char;
	P:PChar;
	cbString,i : integer;
begin
	StrCopy(szFilter,'Codewright Init (cw*.ini)');
	StrCopy(@szFilter[StrLen(szFilter)+1],'cw*.ini');
	szFilter[StrLen(szFilter)+9] := chr(0);
	GetProfileString('CViewAsk','LastDir',chr(0),szFileDir,512);
	StrCopy(szFileName,'cw*.ini');
	OFN.lStructSize := sizeof(TOpenFileName);
	OFN.hWndOwner := 0;
	OFN.lpStrFilter := @szFilter;
	OFN.lpStrCustomFilter := nil;
	OFN.nMaxCustFilter := 0;
	OFN.nFilterIndex := LongInt(1);
	OFN.lpStrFile := szFileName;
	OFN.nMaxFile := 255;
	OFN.lpstrfileTitle := szFileTitle;
	OFN.nMaxFileTitle := sizeof(szFileTitle);
	OFN.lpstrInitialDir := szFileDir;
	OFN.lpStrTitle := 'Select default Initialisation File';
	OFN.flags := OFN_FILEMUSTEXIST+OFN_HIDEREADONLY+OFN_ENABLEHOOK;
	OFN.nFileOffset := 0;
	OFN.nFileExtension := 0;
	OFN.lpstrDefext := 'ini';
	OFN.lpfnHook := FileOpenHookProc(lpfnFileOpenHook);
	if GetOpenFileName(OFN) and (StrLen(szFileName) > 0) then
	begin
		StrLCopy(szFileDir,szFileName,OFN.nFileOffset-1);
		WriteProfileString('CViewAsk','LastDir',szFileDir);
		StrCopy(szCommand,'CW /C ');
		StrCat(szCommand,szFileName);
		WinExec(szCommand,SW_SHOWNORMAL);
	end;
end;
begin
	lpfnFileOpenHook := MakeProcInstance(@FileOpenHook, hInstance);
	TheDC := GetDC(0);
	gbMonochrome := (2 = GetDeviceCaps(TheDC, NUMCOLORS));  { Monochrome!}
	ReleaseDC(0, TheDC);
	if not gbMonochrome then
	begin
		hTempBitmap:=LoadBitmap(hInstance, MAKEINTRESOURCE(1));
		if hTempBitmap <> 0 then
		begin
			ghDlgBrush := CreatePatternBrush(hTempBitmap);
			DeleteObject (hTempBitmap);
		end;
	end;
	cmFileOpen;
	if ghDlgBrush <> 0
	then
		DeleteObject(ghDlgBrush);
	if lpfnFileOpenHook <> Nil then
		FreeProcInstance(lpfnFileOpenHook);
end.
	
	

