#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992, 1993  Pedro Mendes
*/

/*************************************/
/*                                   */
/*         GWSIM - Simulation        */
/*        MS-WINDOWS front end       */
/*                                   */
/*             data specs            */
/*             dialog box            */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "commdlg.h"
#include "defines.h"					/* symbols also used in .DLG files		*/
#include "globals.h"					/* gepasi's own symbols					*/
#include "gwsim.h"						/* macros, function prototypes, etc.	*/
#include "gep2.h"						/* gepasi's variables					*/
#include "simgvar.h"					/* global variables						*/
#include "strtbl.h"						/* symbols for the string table			*/
#include "basic.h"

#pragma alloc_text( CODE6, AddElLst, EdDat)

void AddElLst( HWND hControl, struct ou huge * oel, int idx, BOOL scroll )
{
 int i;
 WORD ElWidth;
 HANDLE hDC;

 hDC = GetDC( hControl );
 ElWidth = 5 + LOWORD( GetTextExtent( hDC, oel[idx].title, _fstrlen(oel[idx].title) ) );
 SetTextJustification( hDC, 0, 0 );
 ReleaseDC( hControl, hDC );
 if( ElWidth > lbWidth )
 {
  lbWidth = ElWidth;
  SendMessage( hControl, LB_SETHORIZONTALEXTENT, lbWidth, 0 );
 }
 SendMessage( hControl, LB_INSERTSTRING, -1, (DWORD) oel[idx].title );
 if( scroll ) SendMessage( hControl, WM_VSCROLL, SB_BOTTOM, 0 );
}


BOOL FAR PASCAL EdDat(HWND hDlg, WORD Message, WORD wParam, LONG lParam)
{
 static int tsel;
 static HWND hAvail, hDatLst, hSep, hFName,
             hWidth, hStatEl, hStatDat;
 HWND hRadio;
 int  i, j, nsel;
 char buff[128];
 static char DName[256];
 static char DTitle[13];
 char *p;

 switch(Message)
 {
  case WM_INITDIALOG:
   /* allocate memory for the mirror				*/
   hOel = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, sizeoutp );
   if( hOel == NULL )
   {
    LoadString(hInst, IDS_ERR_NOEXEC, szString, sizeof(szString));
    MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
    EndDialog(hDlg, FALSE);
    return TRUE;
   }

   /* lock the memory block							*/
   oel  = (struct ou huge *) GlobalLock( hOel );

   /* copy params to its mirror									*/
   _fmemcpy( (void __far *) oel,
             (void __far *) outpel,
		     (size_t) sizeoutp );
   strcpy( DName, DatName );
   strcpy( DTitle, DatTitle );

   /* get handles to controls						*/
   hAvail = GetDlgItem( hDlg, IDC_PARAMLST );
   hDatLst = GetDlgItem( hDlg, IDC_DAT );
   hSep = GetDlgItem( hDlg, IDC_SEPAR );
   hWidth = GetDlgItem( hDlg, IDC_WIDTH );
   hStatEl = GetDlgItem( hDlg, IDSTAT_6 );
   hStatDat = GetDlgItem( hDlg, IDSTAT_7 );
   hFName = GetDlgItem( hDlg, IDC_FILENAME );

   /* initialize hAvail: add all output elements	*/
   for( i=0, lbWidth=0; i<noutpel; i++ )
    AddElLst( hAvail, oel, i, FALSE );

   /* copy the number of selected to mirror			*/
   tsel = totsel;
   /* initialize hDatLst: add all selected elements	*/
   for( i=0, lbWidth=0; i<tsel; i++ )
    for( j=0; j<noutpel; j++ )
     if( (oel[j].idx-1) == (unsigned int) i )
      AddElLst( hDatLst, oel, j, TRUE );

   /* write the number of output elements in hStat	*/
   wsprintf( (LPSTR) buff, "%d items", noutpel );
   SendMessage( hStatEl, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );

   wsprintf( (LPSTR) buff, "%d selected", tsel );
   SendMessage( hStatDat, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );

   /* initialize IDC_SEPAR							*/
   SendMessage( hSep, CB_INSERTSTRING, -1, (DWORD)(LPSTR) "space" );
   SendMessage( hSep, CB_INSERTSTRING, -1, (DWORD)(LPSTR) "comma" );
   SendMessage( hSep, CB_INSERTSTRING, -1, (DWORD)(LPSTR) "tab" );
   wsprintf( (LPSTR) buff, "%s",
             (options.datsep==0) ? (LPSTR) "space" :
             (options.datsep==1) ? (LPSTR) "comma" :
             (LPSTR) "tab" );
   SendMessage( hSep, CB_SELECTSTRING, -1, (DWORD)(LPSTR) buff );

   /* initialize IDC_WIDTH							*/
   for( i=8; i<=25; i++ )
   {
    wsprintf( (LPSTR) buff, "%d", i );
    SendMessage( hWidth, CB_INSERTSTRING, -1, (DWORD)(LPSTR) buff );
   }
   SendMessage( hWidth, CB_SETCURSEL, (WORD) (options.datwidth-8), 0 );

   /* initialize "Apply to"							*/
   if( options.dyn && options.ss )
    SendDlgItemMessage( hDlg, IDRB_3E+options.datss,  BM_SETCHECK, (WORD) 1, 0 );
   else
   {
    if( !options.dyn )
    {
     hRadio = GetDlgItem( hDlg, IDRB_3E );
     SendMessage( hRadio, BM_SETCHECK, 0, 0 );
     EnableWindow( hRadio, FALSE );
     options.datss = 1;
     SendDlgItemMessage( hDlg, IDRB_3I,  BM_SETCHECK, (WORD) 1, 0 );
    }
    if( !options.ss )
    {
     hRadio = GetDlgItem( hDlg, IDRB_3I );
     SendMessage( hRadio, BM_SETCHECK, 0, 0 );
     EnableWindow( hRadio, FALSE );
     options.datss = 0;
     SendDlgItemMessage( hDlg, IDRB_3E,  BM_SETCHECK, (WORD) 1, 0 );
    }
   }

   /* set the check on the appropriate radio button	*/
   SendDlgItemMessage( hDlg, IDRB_0E+options.dattit, BM_SETCHECK, (WORD) 1, 0 );
   SendDlgItemMessage( hDlg, IDRB_2E+options.datmca, BM_SETCHECK, (WORD) 1, 0 );

   SendDlgItemMessage( hDlg, IDRB_9I, BM_SETCHECK, (WORD) options.append, 0 );
   SendDlgItemMessage( hDlg, IDRB_9E, BM_SETCHECK, (WORD) options.quotes, 0 );

   /* set the filename 								*/
   SendMessage( hFName, WM_SETTEXT, 0, (DWORD)(LPSTR) DTitle );

   InvalidateRect( hDlg, NULL, FALSE );
   return TRUE;

  case WM_COMMAND:
   switch(wParam)
   {
    case IDC_PARAMLST:
     if( HIWORD( lParam ) == LBN_DBLCLK )
     {
      /* get the index of the element selected					*/
      nsel = (int) SendMessage( hAvail, LB_GETCURSEL, 0, 0 );
      if( nsel != LB_ERR )
       if( oel[nsel].idx == 0 )
       {
        oel[nsel].idx = tsel+1;
        tsel++;
        AddElLst( hDatLst, oel, nsel, TRUE );
        SendMessage( hDatLst, LB_SETCURSEL, (WORD) tsel, 0 );
        wsprintf( (LPSTR) buff, "%d selected", tsel );
        SendMessage( hStatDat, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );
       }
      return TRUE;
     }
     else return FALSE;

    case IDC_DAT:
     if( HIWORD( lParam ) == LBN_DBLCLK )
     {
      /* get the index of the element selected					*/
      nsel = (int) SendMessage( hDatLst, LB_GETCURSEL, 0, 0 );
      if( nsel != LB_ERR )
      {
       SendMessage( hDatLst, LB_DELETESTRING, (WORD) nsel, 0 );
       for( i=0; i<noutpel; i++ )
       {
        if( oel[i].idx > (unsigned int) nsel+1) oel[i].idx--;
        else if( oel[i].idx == (unsigned int) nsel+1) oel[i].idx = 0;
       }
       tsel--;
       wsprintf( (LPSTR) buff, "%d selected", tsel );
       SendMessage( hStatDat, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );
      }
      return TRUE;
     }
     else return FALSE;

    case IDC_DEL:
     SendMessage( hDatLst, LB_RESETCONTENT, 0, 0 );
     for( i=0; i<noutpel; i++ ) oel[i].idx = 0;
     tsel = 0;
     SendMessage( hStatDat, WM_SETTEXT, 0, (DWORD)(LPSTR) "0 selected" );
     return TRUE;

    case IDC_UP:
      nsel = (int) SendMessage( hDatLst, LB_GETCURSEL, 0, 0 );
      if( (nsel>0) && (nsel != LB_ERR) )
      {
       SendMessage( hDatLst, LB_DELETESTRING, (WORD) nsel, 0 );
       for( i=0; i<noutpel; i++ )
       {
        if( oel[i].idx == (unsigned int) nsel+1)
        {
         oel[i].idx--;
         SendMessage( hDatLst, LB_INSERTSTRING, (WORD) nsel-1, (DWORD) oel[i].title );
        }
        else if( oel[i].idx == (unsigned int) nsel) oel[i].idx++;
       }
       SendMessage( hDatLst, LB_SETCURSEL, (WORD) nsel-1, 0 );
      }
     return TRUE;

    case IDC_HELP:            /* Help on this Dialog Box				*/
   	 WinHelp( hDlg, (LPSTR) szHelpFile, HELP_KEY, (DWORD) (LPSTR) "Data file format" );
   	 return TRUE;

    case IDC_FILE:
     if( GetOFileName( hDlg,
       				  (LPSTR) &DName[0], sizeof( DName ),
      				  (LPSTR) "Simulation results data file",
       				  (LPSTR) "simulation results (*.DAT)\0*.DAT\0all files (*.*)\0*.*\0" ) )
     {
      GetFileTitle( (LPSTR) DName, (LPSTR) DTitle, sizeof(DTitle) );
      SendMessage( hFName, WM_SETTEXT, 0, (DWORD)(LPSTR) DTitle );
     }
     return TRUE;

    case IDOK:
     /* get the titles option											*/
     for( i=0; i<3; i++)
      if( SendDlgItemMessage( hDlg, IDRB_0E+i, BM_GETCHECK, 0, 0 ) )
	   options.dattit = i;
	 /* get the quotes option */
	 if( SendDlgItemMessage( hDlg, IDRB_9E, BM_GETCHECK, 0, 0 ) )
      options.quotes = 1;
     else options.quotes = 0;
	 /* get the append option */
	 if( SendDlgItemMessage( hDlg, IDRB_9I, BM_GETCHECK, 0, 0 ) )
      options.append = 1;
     else options.append = 0;
     /* get the MCA options												*/
     if( SendDlgItemMessage( hDlg, IDRB_2E, BM_GETCHECK, 0, 0 ) )
	  options.datmca = 0;
	 else options.datmca = 1;
     /* get the MCA options												*/
     if( SendDlgItemMessage( hDlg, IDRB_3E, BM_GETCHECK, 0, 0 ) )
	  options.datss = 0;
	 else options.datss = 1;

     /* get the separator												*/
     options.datsep = (int) SendMessage( hSep, CB_GETCURSEL, 0, 0 );
     /* get the width of columns										*/
     nsel = (int) SendMessage( hWidth, CB_GETCURSEL, 0, 0 );
     options.datwidth = 8 + nsel;

     /* copy the number of selected from mirror				*/
     totsel = tsel;
	 /* copy params back from its mirror								*/
     _fmemcpy( (void __far *) outpel,
               (void __far *) oel,
		       (size_t) sizeoutp );
     strcpy( DatName, DName );
     strcpy( DatTitle, DTitle );
     /* unlock and free the mirror memory block             */
     GlobalUnlock( hOel );
     GlobalFree( hOel );
     /* signal that changes have been made					*/
	 notsaved = 1;
     EndDialog(hDlg, TRUE);
     return TRUE;

    case IDCANCEL:
     /* unlock and free the mirror memory block             */
     GlobalUnlock( hOel );
     GlobalFree( hOel );
     EndDialog(hDlg, FALSE);
     return TRUE;
   }    /* End of WM_COMMAND                                 */
   return FALSE;

  default:
   return FALSE;
 }
}

