#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/* floating-point exceptions handler */
/*                                   */
/*          MICROSOFT C 6.00         */
/*           QuickC/WIN 1.0          */
/*             ULTRIX cc             */
/*              GNU gcc              */
/*                                   */
/*   (include here compilers that    */
/*   compiled GEPASI successfully)   */
/*                                   */
/*************************************/


#ifdef _MSC_VER /* Microsoft compilers */

#if (_MSC_VER == 610) /* QuickC/WIN compiler */

#define FP_INVALID			0x81
#define FP_DENORMAL			0x82
#define FP_ZERODIVIDE		0x83
#define FP_OVERFLOW			0x84
#define FP_UNDERFLOW		0x85
#define FP_INEXACT			0x86
#define FP_UNEMULATED		0x87
#define FP_SQRTNEG			0x88
#define FP_STACKOVERFLOW	0x8a
#define FP_STACKUNDERFLOW	0x8b
#define FP_EXPLICITGEN 		0x8c

#endif

#if( _MSC_VER <= 600) /* MS C 6.00 and previous compilers */

#define FP_INVALID			FPE_INVALID
#define FP_DENORMAL			FPE_DENORMAL
#define FP_INEXACT			FPE_INEXACT
#define FP_UNEMULATED		FPE_UNEMULATED
#define FP_SQRTNEG			FPE_SQRTNEG
#define FP_STACKOVERFLOW	FPE_STACKOVERFLOW
#define FP_STACKUNDERFLOW	FPE_STACKUNDERFLOW
#define FP_EXPLICITGEN		FPE_EXPLICITGEN
#define FP_FLT_ZERODIVIDE	FPE_ZERODIVIDE
#define FP_FLT_OVERFLOW		FPE_OVERFLOW
#define FP_FLT_UNDERFLOW	FPE_UNDERFLOW

#endif

#endif

#ifdef _ZTC /* Zortech C compiler */

#define FP_INVALID			1
#define FP_DENORMAL			2
#define FP_INEXACT			0x20
#define FP_FLT_ZERODIVIDE	4
#define FP_FLT_OVERFLOW		8
#define FP_FLT_UNDERFLOW	0x10

#endif /* _ZTC */

#ifdef ultrix /* DEC ULTRIX cc compilers */

#define FP_INT_ZERODIVIDE		FPE_INTDIV_TRAP
#define FP_INT_OVERFLOW			FPE_INTOVF_TRAP
#define FP_FLT_ZERODIVIDE		FPE_FLTDIV_TRAP
#define FP_FLT_OVERFLOW			FPE_FLTOVF_TRAP
#define FP_FLT_UNDERFLOW		FPE_FLTUND_TRAP
#define FP_DEC_OVERFLOW			FPE_DECOVF_TRAP
#define FP_OUTOFRANGE			FPE_SUBRNG_TRAP

#endif /* ultrix */

#ifdef _MSC_VER
void fphandler( int sig, int num )
{
 /* Set global for outside check, since we don't want to do I/O in the handler. */
 fperr = num;


 /* Initialize floating-point package. */
 _fpreset();

 /* Restore calling environment and jump back to setjmp. Return -1 so that      */
 /* setjmp will return false for conditional test.								*/
 beep();
 longjmp( mark, -1 );
}
#endif /* _MSC_VER */

#ifdef _ZTC
void fphandler( int sig )
{
 /* Initialize floating-point package. */
 _fpreset();

 /* Restore calling environment and jump back to setjmp. Return -1 so that      */
 /* setjmp will return false for conditional test.								*/
 beep();
 longjmp( mark, -1 );
}
#endif /* _ZTC */

#ifdef ultrix
void fphandler( int sig, int num, struct sigcontext *scp )
{
 /* Set global for outside check, since we don't want to do I/O in the handler. */
 fperr = num;

 /* Restore calling environment and jump back to setjmp. Return -1 so that      */
 /* setjmp will return false for conditional test.								*/
 beep();
 longjmp( mark, -1 );
}
#endif /* ultrix */

void fpcheck( void )
{
 switch( fperr )
 {

#ifdef _ZTC
  case FP_INVALID:        strcpy( fpstr, "Invalid number" ); break;

  case FP_INEXACT:        strcpy( fpstr, "Inexact number" ); break;

  case FP_FLT_ZERODIVIDE:     strcpy( fpstr, "Floating point divide by zero" ); break;

  case FP_FLT_OVERFLOW:       strcpy( fpstr, "Floating point overflow" ); break;

  case FP_FLT_UNDERFLOW:      strcpy( fpstr, "Floating point underflow" ); break;
#endif /* _ZTC */

#ifdef _MSC_VER
#if (_MSC_VER < 800)				/* QuickC/WIN or C/C++ 7.0				*/
  case FP_INVALID:        strcpy( fpstr, "Invalid number" ); break;

  case FP_UNEMULATED:     strcpy( fpstr, "Co-processor function unemulated" ); break;

  case FP_SQRTNEG:        strcpy( fpstr, "Square root of negative number" ); break;

  case FP_STACKUNDERFLOW: strcpy( fpstr, "Co-processor stack underflow" ); break;

  case FP_STACKOVERFLOW:  strcpy( fpstr, "Co-processor stack overflow" ); break;

  case FP_OVERFLOW:       strcpy( fpstr, "Floating point overflow" ); break;

  case FP_UNDERFLOW:      strcpy( fpstr, "Floating point underflow" ); break;

  case FP_ZERODIVIDE:     strcpy( fpstr, "Floating point divide by zero" ); break;

#endif /* _MSC_VER<800 */
#if (_MSC_VER == 800)				/* Visual C/C++ 					*/
  case _FPE_INVALID:        strcpy( fpstr, "Invalid number" ); break;

  case _FPE_UNEMULATED:     strcpy( fpstr, "Co-processor function unemulated" ); break;

  case _FPE_SQRTNEG:        strcpy( fpstr, "Square root of negative number" ); break;

  case _FPE_STACKUNDERFLOW: strcpy( fpstr, "Co-processor stack underflow" ); break;

  case _FPE_STACKOVERFLOW:  strcpy( fpstr, "Co-processor stack overflow" ); break;

  case _FPE_OVERFLOW:       strcpy( fpstr, "Floating point overflow" ); break;

  case _FPE_INEXACT:        strcpy( fpstr, "Inexact number" ); break;

  case _FPE_UNDERFLOW:      strcpy( fpstr, "Floating point underflow" ); break;

  case _FPE_ZERODIVIDE:     strcpy( fpstr, "Floating point divide by zero" ); break;
#endif /* _MSC_VER==800 */
#endif /* _MSC_VER */

#ifdef ultrix
  case FP_DEC_OVERFLOW:
#endif /* ultrix */

/*#if( _MSC_VER != 610 )
  case FP_FLT_OVERFLOW:   strcpy( fpstr, "Floating point overflow" ); break;

  case FP_FLT_UNDERFLOW:  strcpy( fpstr, "Floating point underflow" ); break;

  case FP_FLT_ZERODIVIDE: strcpy( fpstr, "Floating point divide by zero" ); break;
#endif *//*_MSC_VER!=610*/

#ifdef ultrix
  case FP_INT_ZERODIVIDE: strcpy( fpstr, "Integer divide by zero" ); break;

  case FP_INT_OVERFLOW:   strcpy( fpstr, "Integer overflow" ); break;

  case FP_OUTOFRANGE:     strcpy( fpstr, "Subscript out of range" ); break;
#endif /*ultrix */

  default:                strcpy( fpstr, "Undefined floating point error" ); break;
 }
 printf( "\n  * %s: (%d)\n", fpstr, fperr );
}
