/*
 * Copyright (c) 1987, 1988, 1989 Stanford University
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Stanford not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Stanford makes no representations about
 * the suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * STANFORD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * time related functions for digital clock
 */

#include "clocktime.h"
#include <string.h>
#include <stdio.h>

Clock::Clock () {
    gettime(&gmt);
    nextMinute = 60 - gmt.ti_sec;
}

int Clock::NextTick () {
    gettime(&gmt);
    int nM = 60 - gmt.ti_sec;
    if (nM < nextMinute) {
        nextMinute = nM;
        return nM;
    } else {
        nextMinute = nM;
        return -1;
    }
}

void Clock::GetTime (char* date, int& h, int& m, int& s) {
    struct time local;
    struct date d;

    gettime(&local);
    h = local.ti_hour;
    m = local.ti_min;
    s = local.ti_sec;
    char ds[26];
    getdate(&d);
    sprintf(ds, "%d-%d-%d\0", d.da_year, d.da_mon, d.da_day);
    strcpy(date, ds);		/* day, month, day of month */
    nextMinute = 60 - s;
}
