/*
 * Copyright (c) 1987, 1988, 1989 Stanford University
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Stanford not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Stanford makes no representations about
 * the suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * STANFORD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * Sensors describe input events of interest.
 */

#ifndef sensor_h
#define sensor_h

#include <InterViews/event.h>
#include <InterViews/resource.h>

const int initmask   	= 0x0000;
const int motionmask 	= 0x0001;
const int keymask    	= 0x0002;
const int entermask     = 0x0004;
const int leavemask     = 0x0008;
const int focusmask     = 0x0010;
const int substructmask = 0x0020;
const int upmask        = 0x0040;
const int downmask      = 0x0080;

class Sensor : public Resource {
public:
    Sensor();
    Sensor(Sensor*);
    ~Sensor();

    void Catch(EventType);
    void CatchButton(EventType, int);
    void CatchChannel(int);
    void CatchTimer(int, int);
    void Ignore(EventType);
    void IgnoreButton(EventType, int);
    void IgnoreChannel(int);
    void CatchRemote();
    void IgnoreRemote();
    virtual boolean Interesting(Event&);

protected:
    unsigned mask;
    unsigned int down[16];
    unsigned int up[16];
    unsigned channels;
    int maxchannel;
    boolean timer;
    long clkticks;
    int sec, usec;

    int ButtonIndex (unsigned b) { return (b >> 4) & 07; }
    unsigned int ButtonFlag (unsigned b) { return 1 << (b & 0xf); }
    void SetButton (unsigned int a[], unsigned b) {
	a[ButtonIndex(b)] |= ButtonFlag(b);
    }
    void ClearButton (unsigned int a[], unsigned b) {
	a[ButtonIndex(b)] &= ~ButtonFlag(b);
    }
    boolean ButtonIsSet (unsigned int a[], unsigned b) {
	return (a[ButtonIndex(b)] & ButtonFlag(b)) != 0;
    }
    void SetMouseButtons (unsigned int a[]) { a[0] |= 0x7; }
    void ClearMouseButtons (unsigned int a[]) { a[0] &= ~0x7; }
    boolean MouseButtons (unsigned int a[]) { return (a[0] & 0x7) != 0; }

private:
    friend class Interactor;
    friend class Scene;
};

extern Sensor* allEvents;
extern Sensor* onoffEvents;
extern Sensor* updownEvents;
extern Sensor* noEvents;

#endif
