#ifndef dash_h
#define dash_h

#include "windows.h"
#include <Interviews\canvas.h>
#include <Interviews\color.h>
#include <Interviews\brush.h>
#include <Interviews\defs.h>
#include <Interviews\X11\painterr.h>

class Dash {
public:
    Dash();
    ~Dash();
    void SetPattern(Brush*);
    void Init(Canvas*, PainterRep*);

    void Point(Coord, Coord);
    virtual void Line(Coord, Coord, Coord, Coord);
    virtual void Circle(Coord, Coord, int);
    virtual void Ellipse(Coord, Coord, int, int);
    virtual void Rect(Coord, Coord, Coord, Coord);
    virtual void Polygon(Coord[], Coord[], int);
    virtual void PolyLine(Coord[], Coord[], int);

protected:
    virtual void PutPixel();
    virtual void _Init();
    virtual void _Finish();

    void _Line(Coord, Coord, Coord, Coord);
    void _Circle(Coord, Coord, int);
    void _Ellipse(Coord, Coord, int, int);
    void _Rect(Coord, Coord, Coord, Coord);
    void _Polygon(Coord[], Coord[], int);
    void _PolyLine(Coord[], Coord[], int);

    void _MoveTo(Coord, Coord);
    void _LineTo(Coord, Coord);

    Canvas* canvas;
    PainterRep* rep;

    HRGN holdRgn;
    COLORREF foreground, background;
    HDC hDC;

    int* pattern;
    int count;
    Coord x0, y0;
    Coord x, y;
    int set;
    int index;
};

class PixelDash : public Dash {
protected:
    void PutPixel();
    void _Init();
    void _Finish();
};

class BitmapDash : public Dash {
public:
    BitmapDash(int);

    void Line(Coord, Coord, Coord, Coord);
    void Circle(Coord, Coord, int);
    void Ellipse(Coord, Coord, int, int);
    void Rect(Coord, Coord, Coord, Coord);
    void Polygon(Coord[], Coord[], int);
    void PolyLine(Coord[], Coord[], int);

private:
    void PutPixel();
    void _Init();
    void _Finish();
    void SaveSettings();
    void RestoreSettings();

    int width;
    HDC hMemDC;
    int offset;
    int save_count;
    COLORREF save_foreground;
    HBITMAP hBitmap, holdBitmap;
    int save_pattern0, save_pattern1;
    HBRUSH hBrush, holdBrush, holdBrush1;
};
#endif