/*
 *  MS - dependent World representation.
 */

#ifndef worldrep_h
#define worldrep_h

#include <windows.h>
#include <InterViews\defs.h>

class InteractorTable;
class WorldRep;

extern WorldRep* _world;
extern int    saved_argc;
extern char** saved_argv;

const int PALETTE_SIZE = 12;
const int TIMER_ENTERLEAVE = 16;

extern class WorldView* _worldview;

class WorldRep {
public:
    WorldRep();
    ~WorldRep();      // delete Palette

    HANDLE 	      hinstance();
    HANDLE 	      hprevinstance();
    char* 	      hostname();
    HWND   	      root();
    WORD   	      max_palette_entry();
    InteractorTable*  itable();
    HDC               hdc();

    int               XBorder;
    int               YBorder;
    int               YCaption;
    HWND              hTimerWindow;

private:
    friend class World;

    HANDLE    _hinstance;
    HANDLE    _hprevinstance;
    char      _host[10];
    HWND      _root;
    HPALETTE  _cmap;
    WORD      _max_palette_entry;
    HDC       _hDC;
    InteractorTable* _itable;
};

#endif

