/*
 * Copyright (c) 1987, 1988, 1989 Stanford University
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Stanford not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Stanford makes no representations about
 * the suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * STANFORD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 *  MS Windows dependent raster code
 */

#include <InterViews/X11/palette.h>
#include <InterViews/canvas.h>
#include <InterViews/raster.h>
#include <InterViews/X11/worldrep.h>

static int RasterImageSize(int w, int h) {
    return w * h * sizeof(unsigned long);
}

RasterRep::RasterRep(int w, int h) {
    width = w;
    height = h;
    data = nil;
}

RasterRep::RasterRep(Canvas* c, int x0, int y0, int w, int h) {
    width = w;
    height = h;
    HDC hDC = GetDC((HWND)c->Id());
    HDC hMemDC = CreateCompatibleDC(hDC);
    data = (void*)CreateCompatibleBitmap(hDC, width, height);
    HBITMAP holdBitmap = SelectObject(hMemDC, (HBITMAP)data);
    int new_y0 = c->Height() -1 - y0 - h;
    BitBlt(hMemDC, 0, 0, w, h, hDC, x0, new_y0, SRCCOPY);
    SelectObject(hMemDC, holdBitmap);
    DeleteDC(hMemDC);
    ReleaseDC((HWND)c->Id(), hDC);
}


RasterRep::RasterRep(RasterRep* r) {
    width = r->width;
    height = r->height;
    data = (void*)CreateCompatibleBitmap(_world->hdc(), width, height);
    HDC hSourceDC = CreateCompatibleDC(_world->hdc());
    HDC hTargetDC = CreateCompatibleDC(_world->hdc());
    HBITMAP holdBitmap_source = SelectObject(hSourceDC, (HBITMAP)r->GetData());
    HBITMAP holdBitmap_target = SelectObject(hTargetDC, (HBITMAP)data);

    BitBlt(hTargetDC, 0, 0, width, height, hSourceDC, 0, 0, SRCCOPY);

    SelectObject(hSourceDC, holdBitmap_source);
    SelectObject(hTargetDC, holdBitmap_target);
    DeleteDC(hTargetDC);
    DeleteDC(hSourceDC);
}

RasterRep::~RasterRep() {
    if (data != nil) {
	DeleteObject((HBITMAP)data);
    }
}

void* RasterRep::GetData() {
    if (data == nil) {
	data = (void*)CreateCompatibleBitmap(_world->hdc(), width, height);
    }
    return data;
}

void RasterRep::PutPixel(int x, int y, Color* c) {
    HDC hMemDC = CreateCompatibleDC(_world->hdc());
    HBITMAP holdBitmap = SelectObject(hMemDC, (HBITMAP)GetData());
    ColorIntensity r, g, b;
    c->DisplayIntensities(r, g, b);
    SetPixel(hMemDC, x, height - y -1, RGB(r, g, b));
    SelectObject(hMemDC, holdBitmap);
    DeleteDC(hMemDC);
}

						/* return Palette-Entry */
long unsigned RasterRep::GetPixel(int x, int y) {
    long unsigned result;

    HDC hMemDC = CreateCompatibleDC(_world->hdc());
    HBITMAP holdBitmap = SelectObject(hMemDC, (HBITMAP)data);
    result = ::GetPixel(hMemDC, x, height - y -1);
    SelectObject(hMemDC, holdBitmap);
    DeleteDC(hMemDC);
    return result;
}
