/*
 * MS-dependent sensor code
 */

#include <InterViews\itable.h>
#include <InterViews\sensor.h>
#include <InterViews\X11\eventrep.h>
#include <InterViews\X11\worldrep.h>

static Sensor*  grabber;

boolean Sensor::Interesting(Event& m) {
    MSG msg = m.rep->Message();

    switch (msg.message) {

	case WM_MOUSEMOVE:
		   if (mask & motionmask) {
		       m.GetMotionInfo();
		       return  true;
		   };
		   break;

	case WM_CHAR:
		   if (mask & keymask) {
		       m.GetKeyInfo();
		       return ButtonIsSet(down, m.button);
		   };
		   break;

	case WM_LBUTTONDOWN:
	case WM_MBUTTONDOWN:
	case WM_RBUTTONDOWN:
		    if (mask & downmask) {
			m.GetButtonInfo(DownEvent);
			boolean b = ButtonIsSet(down, m.button);
			if (b && ButtonIsSet(up, m.button))
			    grabber = this;
			else
			    grabber = nil;
			return b;
		    };
		    break;

	case WM_LBUTTONUP:
	case WM_MBUTTONUP:
	case WM_RBUTTONUP:
	       if (mask & upmask) {
		   m.GetButtonInfo(UpEvent);
		   return (ButtonIsSet(up, m.button) || (grabber != nil));
	       };
	       break;

	case WM_SETFOCUS:
	       if (mask & focusmask) {
		   m.eventType = FocusInEvent;
		   return true;
	       };
	       break;

	case WM_KILLFOCUS:
	       if (mask & focusmask) {
		   m.eventType = FocusOutEvent;
		   return true;
	       };
	       break;

	case WM_ENTERWINDOW:
	       if (mask & entermask) {
		   return m.GetCrossingInfo(EnterEvent);
	       }
	       break;

	case WM_LEAVEWINDOW:
	       if (mask & leavemask) {
		   return m.GetCrossingInfo(LeaveEvent);
	       }
	       break;
	default:
	       /* ignore */;
    }
    return false;
}

