/*FILE:
*******************************************************************************
**
**  File:     splines.h
**
**  Descrip:  Header for the splines DLL.
**
**  Copyright (C) Andrew S. Dean 1993
**
*******************************************************************************
*/

#ifndef  SPLINES_H
#define  SPLINES_H

#include <windows.h>



/*-----------------------------------------------------------------------------
**  Define Public typedefs
**-----------------------------------------------------------------------------
*/
typedef struct xyz_td {
    float           x, y, z;
} xyz_td;

typedef xyz_td FAR * lpxyzTD;








																						 /* A regular B spline has a
																							  tension of 1.0. )         */
long FAR PASCAL Bspline(long    lRes,        /* Resolution.  Number of    */
																						 /* points in each segment.   */
                        float   tension,     /* Tension parameter.        */
                        long    lNumControl, /* Number of control points. */
                        lpxyzTD Control,     /* Control polygon.          */
                        lpxyzTD Curve );     /* Returned curve.           */


long FAR PASCAL Bezier(long     lRes,
                       long     lNumControl,
                       lpxyzTD  Control,
                       lpxyzTD  Curve );


long FAR PASCAL BetaSpline(long    lRes,
                           float   fTension,
													 float   fBias,
													 long    lNumControl,
													 lpxyzTD Control,
													 lpxyzTD Curve );

long FAR PASCAL TauSpline(long    lRes,
                          float   fTension,
													float   fBias,
													long    lNumControl,
													lpxyzTD Control,
													lpxyzTD Curve );


#endif SPLINES_H

