/*
 * tex2rtf.h
 *
 * Main include for all converters
 *
 */

// Define a new application type
class MyApp: public wxApp
{ public:
    wxFrame *OnInit(void);
};

// Define a new frame type
class MyFrame: public wxFrame
{ public:
    wxTextWindow *textWindow;
    MyFrame(wxFrame *frame, char *title, int x, int y, int w, int h);
    void OnMenuCommand(int id);
    inline Bool OnClose(void) { return TRUE; }
};

/*
 * Itemize/enumerate structure
 *
 */

#define LATEX_ENUMERATE   1
#define LATEX_ITEMIZE     2
#define LATEX_DESCRIPTION 3
 
class ItemizeStruc: public wxObject
{
  public:
    int listType;
    int currentItem;
    inline ItemizeStruc(int lType) { listType = lType; currentItem = 0; }
};

// ID for the menu quit command
#define TEX_QUIT 1
#define TEX_GO   2

#define TEX_SET_INPUT   3
#define TEX_SET_OUTPUT  4

#define TEX_VIEW_LATEX  5
#define TEX_VIEW_OUTPUT 6

#define TEX_VIEW_CUSTOM_MACROS 7
#define TEX_LOAD_CUSTOM_MACROS 8

#define TEX_MODE_RTF    9
#define TEX_MODE_WINHELP 10
#define TEX_MODE_HTML   11
#define TEX_MODE_XLP    12

#define TEX_HELP        13
#define TEX_ABOUT       14

#define TEX_RTF  1
#define TEX_XLP  2
#define TEX_HTML 3

extern TexChunk *currentSection;
extern TexChunk *currentMember;
extern Bool startedSections;
extern char *contentsString;
extern Bool suppressNameDecoration;
extern Bool winHelp;  // Output in Windows Help format if TRUE, linear otherwise
extern Bool isInteractive;
extern Bool runTwice;
extern Bool convertMode;
extern wxList itemizeStack;

extern FILE *Contents;
extern FILE *Chapters;
extern FILE *Sections;
extern FILE *Subsections;
extern FILE *Subsubsections;

extern char *InputFile;
extern char *OutputFile;
extern char *MacroFile;

extern char FileRoot[];
extern char ContentsName[];    // Contents page from last time around
extern char TmpContentsName[]; // Current contents page
extern char RefName[];         // Reference file name

void ChooseOutputFile(Bool force = FALSE);
void ChooseInputFile(Bool force = FALSE);

void RTFOnMacro(char *name, int no_args, Bool start);
Bool RTFOnArgument(char *name, int arg_no, Bool start);

void HTMLOnMacro(char *name, int no_args, Bool start);
Bool HTMLOnArgument(char *name, int arg_no, Bool start);

void XLPOnMacro(char *name, int no_args, Bool start);
Bool XLPOnArgument(char *name, int arg_no, Bool start);

Bool RTFGo(void);
Bool HTMLGo(void);
Bool XLPGo(void);

