




                                                     WIL Reference Manual


         ________________________________________________________________

                     Copyright (c) 1988-1992 by Morrie Wilson.
                                All rights reserved.




        No part of this manual may be reproduced or transmitted in any
        form or by any means, electronic or mechanical, including
        photocopying and recording, for any purpose without the express
        written permission of Wilson WindowWare, Inc.  Information in
        this document is subject to change without notice and does not
        represent a commitment by Wilson WindowWare, Inc.



        The software described herein is furnished under a license
        agreement.  It is against the law to copy this software under any
        circumstances except as provided by the license agreement.












        U.S. Government Restricted Rights
        Use, duplication, or disclosure by the Government is subject to
        restrictions as set forth in subdivision (b)(3)(ii) of the Rights
        in Technical Data and Computer Software clause at 252.227-7013.
        Contractor/manufacturer is Wilson WindowWare, Inc. / 2701
        California Ave SW #212 / Seattle, WA 98116 / Orders: 800-762-8383
        / Support: 206-937-9335 / Fax: 206-935-7129.




        Trademarks
        Microsoft and MS-DOS are registered trademarks of Microsoft
        Corporation.
        Windows, Word for Windows, and Excel are trademarks of Microsoft
        Corporation.

        WinEdit is a trademark of Wilson WindowWare, Inc.




         ________________________________________________________________
                                                                       ii

                                                                 CONTENTS
         ________________________________________________________________


                                      CONTENTS


        CONTENTS                                       iii

        INTRODUCTION                                     1
           About This Manual                             1
           Notational Conventions                        2
           Acknowledgements                              3

        MENU FILES                                       5
           About Menu Files                              5
           Menu File Structure                           5
           Modifying Menus                               8
           Menu Hotkeys                                  8

        WIL TUTORIAL                                    10
           WIL Basics                                   10
             What is a WIL Program?                     10
             Our First WIL Program                      11
             Functions and Parameters                   11
             Displaying Text                            13
             Getting Input                              14
             Using Variables                            16
             Making Decisions                           16
             Branching                                  18
           Exploring WIL                                20
             Running Programs                           20
             Display and Input                          21
             Manipulating Windows                       24
             Files and Directories                      28
             Handling Errors                            30
             Selection Menus                            32
             Nicer File Selection                       35
             Nicer Messages                             36
             Running DOS Programs                       38
             Sending Keystrokes to Programs             39
             Our Completed WIL File                     40

        THINGS TO KNOW                                  43
             Recovering from Cancel                     43
             Aborting WIL processing                    43
             Default program for unknown extension      43
             Partial window names                       44
             Sounds                                     44

        WIL LANGUAGE                                    45
           Menu Structure {*M}                          45
           Menu Items {*M}                              45
           Language Components                          46

         ________________________________________________________________
                                                                      iii

                                                                 CONTENTS
         ________________________________________________________________

             Constants                                  46
             Identifiers                                48
             Variables                                  48
             Lists                                      48
             Keywords                                   49
             Operators                                  49
             Precedence and evaluation order            50
             Comments                                   50
             Statements                                 51
             Substitution                               51
           Function Parameters                          52
           Error Handling                               53
           The Functions & Statements                   54
             Inputting Information                      54
             Displaying Information                     54
             File Management                            55
             Directory Management                       56
             Disk Drive Management                      57
             Window Management                          57
             Program Management                         59
             String Handling                            59
             Arithmetic Functions                       61
             Clipboard Handling                         61
             Process Control                            61
             Miscellaneous Functions                    63
             System Information                         63
             DDE Functions                              64
             Network Functions                          65
             Multimedia Functions                       66
             Menu Management                            66

        WIL FUNCTION REFERENCE                          67
           WIL Introduction                             67
           Abs                                          68
           AppExist                                     69
           AppWaitClose                                 70
           AskLine                                      71
           AskPassword                                  73
           AskYesNo                                     74
           Average                                      75
           Beep                                         76
           ButtonNames                                  77
           Call                                         78
           Char2Num                                     80
           ClipAppend                                   81
           ClipGet                                      82
           ClipPut                                      83
           CurrentFile {*M}                             84
           DateTime                                     85
           DDEExecute                                   87
           DDEInitiate                                  88

         ________________________________________________________________
                                                                       iv

                                                                 CONTENTS
         ________________________________________________________________

           DDEPoke                                      89
           DDERequest                                   90
           DDETerminate                                 91
           DDETimeout                                   92
           Debug                                        93
           Delay                                        96
           Dialog                                       97
           DialogBox                                   102
           DirChange                                   104
           DirGet                                      105
           DirHome                                     106
           DirItemize                                  107
           DirMake                                     108
           DirRemove                                   109
           DirRename                                   110
           DirWindows                                  111
           DiskFree                                    112
           DiskScan                                    113
           Display                                     114
           DOSVersion                                  115
           Drop                                        116
           Else                                        117
           EndSession                                  118
           Environment                                 119
           ErrorMode                                   120
           Exclusive                                   121
           Execute                                     122
           Exit                                        123
           FileAppend                                  124
           FileAttrGet                                 125
           FileAttrSet                                 126
           FileClose                                   127
           FileCopy                                    128
           FileDelete                                  129
           FileExist                                   130
           FileExtension                               131
           FileItemize                                 132
           FileLocate                                  133
           FileMove                                    134
           FileOpen                                    135
           FilePath                                    136
           FileRead                                    137
           FileRename                                  138
           FileRoot                                    139
           FileSize                                    140
           FileTimeGet                                 141
           FileTimeTouch                               142
           FileWrite                                   143
           Goto                                        144
           IconArrange                                 145
           If...Then                                   146

         ________________________________________________________________
                                                                        v

                                                                 CONTENTS
         ________________________________________________________________

           IgnoreInput                                 147
           IniDelete                                   148
           IniDeletePvt                                149
           IniItemize                                  150
           IniItemizePvt                               151
           IniRead                                     152
           IniReadPvt                                  153
           IniWrite                                    154
           IniWritePvt                                 155
           IntControl                                  156
           IsDefined                                   159
           IsKeyDown                                   160
           IsLicensed                                  161
           IsMenuChecked {*M}                          162
           IsMenuEnabled {*M}                          163
           IsNumber                                    164
           ItemCount                                   165
           ItemExtract                                 166
           ItemInsert                                  167
           ItemLocate                                  168
           ItemRemove                                  169
           ItemSelect                                  170
           ItemSort                                    172
           LastError                                   173
           LogDisk                                     174
           Max                                         175
           MenuChange {*M}                             176
           Message                                     177
           Min                                         178
           MouseInfo                                   179
           NetAddCon                                   181
           NetAttach                                   182
           NetBrowse                                   183
           NetCancelCon                                184
           NetDetach                                   185
           NetDialog                                   186
           NetGetCaps                                  187
           NetGetCon                                   189
           NetGetUser                                  190
           NetLogin                                    191
           NetLogout                                   192
           NetMapRoot                                  193
           NetMemberGet                                194
           NetMemberSet                                195
           NetMsgAll                                   196
           NetMsgSend                                  197
           Num2Char                                    198
           ParseData                                   199
           Pause                                       200
           PlayMedia                                   201
           PlayMidi                                    203

         ________________________________________________________________
                                                                       vi

                                                                 CONTENTS
         ________________________________________________________________

           PlayWaveForm                                204
           Random                                      206
           Reload {*M}                                 207
           Return                                      208
           Run                                         209
           RunHide                                     210
           RunHideWait                                 211
           RunIcon                                     212
           RunIconWait                                 213
           RunWait                                     214
           RunZoom                                     215
           RunZoomWait                                 216
           SendKey                                     217
           SKDebug                                     220
           SnapShot                                    221
           Sounds                                      222
           StrCat                                      223
           StrCmp                                      224
           StrFill                                     225
           StrFix                                      226
           StriCmp                                     227
           StrIndex                                    228
           StrLen                                      229
           StrLower                                    230
           StrReplace                                  231
           StrScan                                     232
           StrSub                                      233
           StrTrim                                     234
           StrUpper                                    235
           Terminate                                   236
           TextBox                                     237
           TextBoxSort                                 239
           TextSelect                                  240
           Then                                        241
           Version                                     242
           VersionDLL                                  243
           WaitForKey                                  244
           WallPaper                                   245
           WinActivate                                 246
           WinArrange                                  247
           WinClose                                    248
           WinCloseNot                                 249
           WinConfig                                   250
           WinExeName                                  251
           WinExist                                    252
           WinGetActive                                253
           WinHelp                                     254
           WinHide                                     256
           WinIconize                                  257
           WinItemize                                  258
           WinMetrics                                  259

         ________________________________________________________________
                                                                      vii


         ________________________________________________________________

           WinName                                     261
           WinParmGet                                  262
           WinParmSet                                  264
           WinPlace                                    265
           WinPlaceGet                                 267
           WinPlaceSet                                 268
           WinPosition                                 270
           WinResources                                271
           WinShow                                     272
           WinState                                    273
           WinTitle                                    274
           WinVersion                                  275
           WinWaitClose                                276
           WinZoom                                     277
           Yield                                       278

        APPENDIX A  Predefined Constants               279

        APPENDIX B  Errors                             281
           Minor Errors                                281
           Moderate Errors                             282
           Fatal Errors                                283

        APPENDIX C  Browser                            286

        INDEX                                          287


























         ________________________________________________________________
                                                                     viii

                                                             INTRODUCTION
         ________________________________________________________________


                                    INTRODUCTION

        WIL (Windows Interface Language) is a powerful, yet easy-to-learn,
        procedural language, which provides a rich set of functions to
        Windows users.  It can:


           .  Run Windows and DOS programs.

           .  Send keystrokes directly to Windows applications.

           .  Rearrange, resize, hide, and close windows.

           .  Run programs either concurrently or sequentially.

           .  Display information to the user in various formats.

           .  Prompt the user for any needed input.

           .  Present scrollable file and directory lists.

           .  Copy, move, delete, and rename files.

           .  Read and write files directly.

           .  Copy text to and from the Clipboard.

           .  Perform string and arithmetic operations.

           .  Make branching decisions based upon numerous factors.


        And much, much more.




        About This Manual
        WIL is not a stand-alone product.  Rather, it is a language
        interpreter which can be integrated into many different types of
        Windows applications.  This manual is a function reference for the
        WIL language itself, as well as a guide to creating basic WIL
        programs.  Because WIL can be implemented in many different ways,
        this manual must at times be somewhat general.  Therefore, you will
        need to refer to your application's User's Guide for information on
        any additional functions which may be available, as well as
        functions which may be unavailable or which may operate differently
        than presented here.  In all cases, your product-specific
        documentation supersedes the information provided in this Reference
        Manual.

         ________________________________________________________________
                                                                        1

                                                             INTRODUCTION
         ________________________________________________________________

        WIL can be implemented in two basic "flavors": menu and batch.  In
        a menu system, WIL commands are defined in one or more menu files,
        each of which can contain many different tasks, or menu items.  In
        a batch system, each task is contained in a separate batch file.
        In this manual, we will use the term WIL program to refer to both
        an individual menu item and to a batch file, each of which performs
        an individual task (which can, in turn, consist of many different
        commands).  We will use the term WIL Interpreter to refer to that
        part of your application which is responsible for executing WIL
        programs.

        The symbol {*M} will be used to indicate a function or a section of
        the manual which applies only to menu-based implementations of the
        WIL Interpreter.




        Notational Conventions
        NOTE: Not used in disk-based version of the manual.  These
        conventions apply to the printed version only.



        Throughout this manual, we use the following conventions to
        distinguish elements of text:

        ALL-CAPS
           Used for filenames.

        Boldface
           Used for important points, programs, function names, and parts
           of syntax that must appear as shown.

        system
           Used for items in menus and dialogs, as they appear to the user.

        Small fixed-width
           Used for WIL sample code.

        Italics
           Used for emphasis, and to liven up the documentation just a bit.










         ________________________________________________________________
                                                                        2

                                                             INTRODUCTION
         ________________________________________________________________

        Acknowledgements


        WIL software developed by Morrie Wilson.

        Documentation written by Richard Merit.

        Development funded by registered users.












































         ________________________________________________________________
                                                                        3

                                                               MENU FILES
         ________________________________________________________________


                                     MENU FILES




        About Menu Files
        This section of the manual shows how to create WIL menu files.  It
        is presented here so that you will be able to follow along with the
        tutorial material which follows.  It is not important at this point
        to understand the actual commands which are shown in the menus.

          If you are using a batch file-based implementation of WIL, you
          can skip this section and move on to the WIL Tutorial (pg. 10).




        Menu File Structure
        WIL menus are defined in standard ASCII text files (the kind
        created by Notepad).  See your product documentation for the name
        of the default menu file that it uses.

        Every menu file contains one or more menu items which appear in
        drop-down menus.  They may also contain top-level menu names which
        show up in a main menu bar (refer to your product documentation for
        more information).  Each menu item consists of a title which
        identifies the item, followed by one or more lines of menu code
        which the WIL Interpreter will execute when you choose the item.

        Your application probably included a pre-defined sample menu, and
        you should refer to it as a practical example of correct menu
        structure.  Here is an extremely simple menu file:

         &Games
          &Solitaire
            Run("sol.exe", "")


        The first line, &Games, begins in column 1, and therefore defines a
        top-level menu item.  Depending on the product you are using, it
        may either appear on a menu bar or it may appear on the first-level
        drop-down menu.  The ampersand (&) is optional; it defines an Alt-
        key combination for the entry (Alt-G in this example).  It will
        appear in the menu as Games. {Imagine the G underlined.}

        The second line, &Solitaire, begins in column 2, and defines the
        title for an individual menu item.  Again, the ampersand (&) is
        optional, and defines an Alt-key combination of Alt-S.  This item
        will appear in the menu as Solitaire.


         ________________________________________________________________
                                                                        5

                                                               MENU FILES
         ________________________________________________________________

        The third line, Run("sol.exe", ""), is the actual code which will
        be executed when this menu item is selected.  Like all menu code,
        it must be indented at least four spaces (i.e., it must begin in
        column 5 or higher).  This third line is really the entire WIL
        program; the two lines above it are simply titles which define the
        position of the program (i.e., the menu item) in the overall menu
        structure.

        Here's a slightly expanded version of the program:

         &Games
          &Solitaire
            Display(1, "Game Time", "About to play Solitaire")
            Run("sol.exe", "")


        Here, we've simply added a line of code, changing this into a two-
        line program.  Notice that each additional line of code is still
        indented the same four spaces.

        Now, let's look at a menu file which contains two menu items:

         &Games
          &Solitaire
            Run("sol.exe", "")
          &Minesweeper
            Run("winmine.exe", "")


        We've added a new menu item, Minesweeper, which begins in column 2
        (like Solitaire) and will appear under the top-level menu item
        Games (like Solitaire).

        To add a new top-level menu item, just create a new entry beginning
        in column 1:

        &Games
         &Solitaire
             Run("sol.exe", "")
         &Minesweeper
             Run("winmine.exe", "")

        &Applications
         &Notepad
             Run("notepad.exe", "")
         &WinEdit
             Run("winedit.exe", "")





         ________________________________________________________________
                                                                        6

                                                               MENU FILES
         ________________________________________________________________

        Now there are two top-level menu titles, Games and Applications,
        each of which contains two individual items (the blank line between
        Games and Applications is not necessary, but is there just for
        readability).

        In addition to top-level menus, you can optionally define one or
        two levels of submenus.  The titles for the first-level and second-
        level submenus must begin in columns 2, and 3, respectively, and
        the individual menu items they contain must be indented one
        additional column.  For example:

        &Applications
         &Editors
          &Notepad
             Run("notepad.exe", "")
          &WinEdit
             Run("winedit.exe", "")

         &Excel
             Run("excel.exe", "")



        In the above example, Editors is a submenu (which begins in column
        2), which contains two menu items (which begin in column 3).  Excel
        also begins in column 2, but since it does not have any submenus
        defined below it, it is a bottom-level (i.e., individual) menu
        item.  Here's an even more complex example:

        &Applications
         &Editors
          &Notepad
             Run("notepad.exe", "")
          &WinEdit
             Run("winedit.exe", "")

         |&Spreadsheets
          &Windows-based
           &Excel
             Run("excel.exe", "")

          _&DOS-based
           &Quattro
             Run("q.exe", "")



        We've added an additional level of submenus under Spreadsheets, so
        that the bottom-level menu items (Excel and Quattro) now begin in
        column 4.  There are also two special symbols presented in this
        menu: the underscore (_), which causes a horizontal separator line

         ________________________________________________________________
                                                                        7

                                                               MENU FILES
         ________________________________________________________________

        to be drawn above the associated menu title, and the vertical bar
        (|), which causes the associated menu title to appear in a new
        column.

        It is possible to place an individual (bottom-level) menu item in
        column 1:

        &Notepad
             Run("notepad.exe", "")



        in which case it will appear on the top-level menu, but will be
        executed immediately upon being selected (i.e., there will be no
        drop-down menu).




        Modifying Menus
        As stated earlier, menu files must be created and edited with an
        editor, such as Notepad, that is capable of saving files in pure
        ASCII text format.  After you have edited your menu, it must be
        reloaded into memory for the changes to take effect.  You may be
        able to do this manually, via the application's control menu (see
        your product documentation for information).  Or, you can have a
        menu item use the Reload function.  Otherwise, the menus will be
        reloaded automatically the next time you execute any menu item.
        However, if the menus are reloaded automatically, the WIL
        Interpreter will not be able to determine which menu item you had
        just selected, and it will therefore display a message telling you
        that you need to re-select it.




        Menu Hotkeys
        In addition to the standard methods for executing a menu item
        (double-clicking on it, highlighting it and pressing Enter, or
        using Alt + the underlined letter), you may be able to define
        optional hotkeys for your menu items (depending on the
        implementation of WIL in the product you are using), which will
        cause an item to be executed immediately upon pressing the
        designated hot key.  Hotkeys are defined by following the menu item
        with a backslash (\) and then the hotkey:

        &Accessories
         &Notepad  \  {F2}
             Run("notepad.exe", "")
         &Calculator  \  ^C
             Run("calc.exe", "")

         ________________________________________________________________
                                                                        8


         ________________________________________________________________



        In the above example, the F2 key is defined as the hotkey for
        Notepad, and Ctrl-C is defined as the hotkey for Calculator.

        Most single keys and key combinations may be used as hotkeys,
        except for the F10 key, and except for Alt and Alt-Shift key
        combinations (although you may use Alt-Ctrl key combinations).
        Refer to the SendKey function (pg. 216) for a list of special
        keycodes which may also be used as hot keys.

        If you always access a menu item by using its hotkey, you may not
        need or want the menu item to appear in the pull-down menus.  If
        so, you can make it a non-displayed menu item by placing a @ symbol
        in front of the title.  For example:

        &Accessories
         @Notepad  \  {F2}
             Run("notepad.exe", "")


        In this case, Notepad would not appear in the pull-down menus, but
        could still be accessed by using the F2 hotkey.

        Note:  Hotkeys and non-displayed menu items may not work in all
        implementations of the WIL Interpreter.


























         ________________________________________________________________
                                                                        9

                                                             WIL TUTORIAL
         ________________________________________________________________


                                    WIL TUTORIAL




        WIL Basics



        What is a WIL Program?
        A WIL program, like a DOS batch file, is simply a list of commands
        for the computer to process.  Any task which will be run more than
        once, or which requires entering multiple commands or even a single
        complex command, is a good candidate for automation as a WIL
        program.  For example, suppose you regularly enter the following
        commands to start Windows:

        First:

         cd\windows

        then:

         win

        and then:

         cd\

        Here, you are changing to the Windows directory, running Windows,
        and then returning to the root directory.  Instead of having to
        type these three commands every time you run Windows, you can
        create a DOS batch file, called WI.BAT, which contains those exact
        same commands:

         cd\windows
         win
         cd\

        Now, to start Windows, you merely need to type the single command
        WI, which runs the WI.BAT batch file, which executes your three
        commands.

        WIL programs work basically the same way.







         ________________________________________________________________
                                                                       10

                                                             WIL TUTORIAL
         ________________________________________________________________




        Our First WIL Program
        Our first WIL program will simply run our favorite Windows
        application: Solitaire.  If you are using a menu script-based
        implementation of the WIL Interpreter, refer to the preceding
        section on Menu Files (pg. 5) for instructions on how to create and
        edit WIL menu items.  If you are using a batch file-based
        implementation of the WIL Interpreter, you will be creating your
        batch files using an editor, such as Notepad, that is capable of
        saving text in pure ASCII format.  In either case, let's create a
        WIL program containing the following line of text:

         Run("sol.exe", "")

        Save the program, and run it (refer to your product documentation
        for information on how to execute a WIL program).  Presto!  It's
        Solitaire.




        Functions and Parameters
        Now, let's look more closely at the line we entered:

         Run("sol.exe", "")

        The first part, Run, is a WIL function.  As you might have guessed,
        its purpose is to run a Windows program.  There are a large number
        of functions and commands in WIL, and each has a certain syntax
        which must be used.  The correct syntax for all WIL functions may
        be found in the WIL Function Reference (pg. 67).  The entry for Run
        starts off as follows:


        Syntax:
         Run (program-name, parameters)

        Parameters:
         (s) program-name = the name of the desired .EXE, .COM, .PIF, .BAT
                      file, or a data file.
         (s) parameters =   optional parameters as required by the
                      application.


        Like all WIL functions, Run is followed by a number of parameters,
        enclosed in parentheses.  Parameters are simply additional pieces
        of information which are provided when a particular function is
        used; they may be either required or optional.  Optional parameters
        are indicated by being enclosed in square brackets.  In this case,

         ________________________________________________________________
                                                                       11

                                                             WIL TUTORIAL
         ________________________________________________________________

        Run has two required parameters: the name of the program to run,
        and the parameters to be passed to the program.

        WIL functions use several types of parameters.  Multiple parameters
        are separated by commas.  In the example

         Run("sol.exe", "")

        "sol.exe" and "" are both string constants.  String constants can
        be identified by the quote marks which delimit (surround) them.
        You may use either double ("), single forward (') or single back
        (`) quote marks as string delimiters; the examples in this manual
        will use double quotes.

        Note:  In our shorthand method for indicating syntax the (s) in
        front of a parameter indicates that it is a string parameter.

        You may have noticed how we said earlier that the two parameters
        for the Run function are required, and yet the entry for Run in the
        WIL Function Reference describes the second parameter "parameters"
        as being optional.  Well then, which one is correct?  Well, from
        a language standpoint, the second parameter is required.  That is,
        if you omit it, you will get a syntax error, and your WIL program
        will not run properly.  However, the program that you are running
        may not need any parameters.  Solitaire, for example, does not take
        any parameters.  The way we handle this in our programs is to
        specify a null string  --- two quote marks with nothing in between
        --- as the second parameter, as we have done in our example above.

        To illustrate this further, let's create a WIL program containing
        the following line:

         Run("notepad.exe", "")

        This is just like our previous file, with only the name of the
        program having been changed.  Save the file, and run it.  You
        should now be in Notepad.  Now, edit the WIL program as follows:

         Run("notepad.exe", "c:\autoexec.bat")

        Save the program, exit Notepad, and run the WIL program again.  You
        should now be in Notepad, with AUTOEXEC.BAT loaded.  As we've just
        demonstrated, Notepad is an example of a program which can be run
        with or without a file name parameter passed to it by WIL.

        It can often be helpful to add descriptive text to your WIL
        programs:

         ; This is an example of the Run function in WIL
         Run("notepad.exe", "c:\autoexec.bat")


         ________________________________________________________________
                                                                       12

                                                             WIL TUTORIAL
         ________________________________________________________________

        The semicolon at the beginning of the first line signifies a
        comment, and causes that line to be ignored.  You can place comment
        lines, and/or blank lines anywhere in your WIL programs.  In
        addition, you can place a comment on the same line as a WIL
        statement by preceding the comment with a semicolon.  For example:

         Run("sol.exe", "")   ; this is a very useful function

        Everything to the right of a semicolon is ignored.  However, if a
        semicolon appears in a string delimited by quotes, it is treated as
        part of the string.




        Displaying Text
        Now, let's modify our original WIL program as follows:

         ; solitare.program
         Display(5, "Good Luck!", "Remember ... it's only a game.")
         Run("sol.exe", "")

        And run it.  Notice the message box which pops up on the screen
        with words of encouragement:

               ....................................
               .            Good Luck!            .
               ....................................
               .                                  .
               .  Remember ... it's only a game.  .
               .                                  .
               ....................................

        That's done by the Display function in the second line above.
        Here's the reference for Display:


        Syntax:
         Display (seconds, title, text)

        Parameters:
         (i) seconds =  Seconds to display the message (1-3600).
         (s) title   =  Title of the window to be displayed.
         (s) text    =  Text of the window to be displayed.


        Note that the Display function has three parameters.  The first
        parameter  --- in our example, 5 --- tells the number of seconds
        which the display box will remain on the screen (you can make the
        box disappear before then by pressing any key or mouse button).
        This is a numeric constant, and  --- unlike string constants ---

         ________________________________________________________________
                                                                       13

                                                             WIL TUTORIAL
         ________________________________________________________________

        it does not need to be enclosed in quotes (although it can be, if
        you wish, as WIL will automatically try to convert string variables
        to numeric variables when necessary, and vice versa).  The second
        parameter is the title of the message box, and the third parameter
        is the actual text displayed in the box.

        Note:  In our shorthand method for indicating syntax the (i) in
        front of a parameter indicates that it is a string parameter.

        Now, exit Solitaire (if you haven't done so already), and edit the
        WIL program by placing a semicolon at the beginning of the line
        with the Run function.  This is a handy way to disable, or "comment
        out," lines in your WIL programs when you want to modify and test
        only certain segments.  Your WIL program should look like this:

         ; solitare.program
         Display(5, "Good Luck!", "Remember ... it's only a game.")
         ; Run("sol.exe", "")

        Now, experiment with modifying the parameters in the Display
        function.  Try adjusting the value of the first parameter.  If you
        look up Display in the WIL reference section, you will see that the
        acceptable values for this parameter are 1-3600.  If you use a
        value outside this range, WIL will adjust it to "make it fit"; that
        is, it will treat numbers less than 1 as if they were 1, and
        numbers greater than 3600 as 3600.  Also, try using a non-integer
        value, such as 2.5, and see what happens (you should receive an
        error message).  Play around with the text in the two string
        parameters; try making one, or both, null strings ("").




        Getting Input
        Now, let's look at ways of getting input from a user and making
        decisions based on that input.  The most basic form of input is a
        simple Yes/No response, and, indeed, there is a WIL function called
        AskYesNo:


        Syntax:
         AskYesNo (title, question)

        Parameters
         (s) title    =     title of the question box.
         (s) question =     question to be put to the user.

        Returns:
         (i)          @YES or @NO, depending on the button pressed.



         ________________________________________________________________
                                                                       14

                                                             WIL TUTORIAL
         ________________________________________________________________

        You should be familiar with the standard syntax format by now; it
        shows us that AskYesNo has two required parameters.  The Parameters
        section tells us that these parameters both take strings, and tells
        us what each of the parameters means.

        You will notice that there is also a new section here, called
        Returns.  This section shows you the possible values that may be
        returned by this function.  All functions return values.  We
        weren't concerned with the values returned by the Run and Display
        functions.  But with AskYesNo, the returned value is very
        important, because we will need that information to decide how to
        proceed.  We see that AskYesNo returns an integer value.  An
        integer is a whole (non-fractional) number, such as 0, 1, or 2 (the
        number 1.5 is not an integer).  We also see that the integer value
        returned by AskYesNo is either @YES or @NO.  @YES and @NO are
        predefined constants in WIL.  All predefined constants begin with
        an @ symbol, and we will distinguish them further by typing them in
        all caps.  You will find a list of all predefined constants in
        Appendix A (pg. 278).  Even though the words Yes and No are
        strings, it is important to remember that the predefined constants
        @YES and @NO are not string variables.  (Actually, @YES is equal to
        1, and @NO is equal to 0.  Don't worry if this is confusing; you
        really don't need to remember or even understand it.)

        Now, let's modify our WIL program as follows:

         AskYesNo("Really?", "Play Solitaire now?")
         Run("sol.exe", "")

        and run it.  You should have gotten a nice dialog box which asked
        if you wanted to play Solitaire:


             .....................................
             .             Really?               .
             .....................................
             .                                   .
             .       Play Solitaire now?         .
             .                                   .
             .     [Yes]    [No]    [Cancel]     .
             .....................................



        but no matter what you answered, it started Solitaire anyway.  This
        is not very useful.  We need a way to use the Yes/No response to
        determine further processing.  First, we need to explore the
        concept and use of variables.




         ________________________________________________________________
                                                                       15

                                                             WIL TUTORIAL
         ________________________________________________________________




        Using Variables
        A variable is simply a placeholder for a value.  The value that the
        variable stands for can be either a text string (string variable)
        or a number (numeric variable).  You may remember from Algebra 101
        that if X=3, then X+X=6.  X is simply a numeric variable, which
        stands here for the number 3.  If we change the value of X to 4
        (X=4), then the expression X+X is now equal to 8.

        Okay.  We know that the AskYesNo function returns a value of either
        @YES or @NO.  What we need to do is create a variable to store the
        value that AskYesNo returns, so that we can use it later on in our
        WIL program.  First, we need to give this variable a name.  In WIL,
        variable names must begin with a letter, may contain any
        combination of letters or numbers, and may be from 1 to 30
        characters long.  So, let's use a variable called response.  (We
        will distinguish variable names in this text by printing them in
        all lowercase letters; we will print function and command names
        starting with a capital letter.  However, in WIL, the case is not
        significant, so you can use all lowercase, or all uppercase, or
        whatever combination you prefer.)  We assign the value returned by
        AskYesNo to the variable response, as follows:

         response = AskYesNo("Really?", "Play Solitaire now?")

        Notice the syntax.  The way that WIL processes this line is to
        first evaluate the result of the AskYesNo function.  The function
        returns a value of either @YES or @NO.  Then, WIL assigns this
        returned value to response.  Therefore, response is now equal to
        either @YES or @NO, depending on what the user enters.

        Now, we need a way to make a decision based upon this variable.




        Making Decisions
        WIL provides a way to conditionally execute a statement, and that
        is by using the If ... Then command.  Actually, there are two
        separate parts to this construct: If and Then.  The format is:

           If condition Then statement

        (We refer to If ... Then as a command, rather than a function,
        because functions are followed by parameters in parentheses, while
        commands are not.  Commands are used for system control.)

        The use of If ... Then can easily be illustrated by going back to
        our WIL program and making these modifications:

         ________________________________________________________________
                                                                       16

                                                             WIL TUTORIAL
         ________________________________________________________________

         response = AskYesNo("Really?", "Play Solitaire now?")
         If response == @YES Then Run("sol.exe", "")

        In this example, we are using If ... Then to test whether the value
        of the variable response is @YES.  If it is @YES, we start
        Solitaire.  If it isn't @YES, we don't.  The rule is: if the
        condition following the If keyword is true, then the statement
        following the Then keyword is performed.  If the condition
        following the If keyword is false, then anything following the Then
        keyword is ignored.

        There is something extremely important that you should note about
        the syntax of the If ... Then command: the double equal signs (==).
        In WIL, a single equal sign (=) is an assignment operator  ---
        assigns the value on the right of the equal sign to the variable on
        the left of the equal sign.  As in:

         response = AskYesNo("Really?", "Play Solitaire now?")

        This is saying, in English: "Assign the value returned by the
        AskYesNo function to the variable named response."  But in the
        statement:

         If response == @YES Then Run("sol.exe", "")

        we do not want to assign a new value to response, we merely want to
        test whether it is equal to @YES.  Therefore, we use the double
        equal signs (==), which is the equality operator in WIL.  The
        statement above is saying, in English: "If the value of the
        variable named response is equal to @YES, then run the program
        SOL.EXE."  If you used a single equal sign (=) here by mistake, you
        would get an error message:

            ....................................................
            .   3074: Expression continues past expected end   .
            ....................................................
            .                                                  .
            .    If response == @YES Then Run("Sol.exe","")    .
            .                                                  .
            .                       [OK]                       .
            ....................................................



        Which is WIL's way of telling you to re-check your syntax.

        If you've become confused, just remember that a single equal sign
        (=) is an assignment operator, used to assign a value to a
        variable.  Double equal signs (==) are an equality operator, used
        to test whether the values on both sides of the operator are the
        same.  If you have a problem with one of your WIL programs, make

         ________________________________________________________________
                                                                       17

                                                             WIL TUTORIAL
         ________________________________________________________________

        sure to check whether you've used one of these symbols incorrectly.
        It's a very common mistake, which is why we emphasize it so
        strongly!

        We've seen what happens when the condition following the Then
        keyword is true.  But what happens when it is false?  Remember we
        said that when the If condition is false, the Then statement is
        ignored.  There will be times, however when we want to perform an
        alternate action in this circumstance.  For example, suppose we
        want to display a message if the user decides that he or she
        doesn't want to play Solitaire.  We could write:

         response = AskYesNo("Really?", "Play Solitaire now?")
         If response == @YES Then Run("sol.exe", "")
         If response == @NO Then Display(5, "", "Game canceled")

        In this case there are two If statements being evaluated, with one
        and only one of them possibly being true.  However, this is
        inefficient from a processing standpoint.  Furthermore, what would
        happen if you had several functions you wanted to perform if the
        user answered Yes?  You would end up with something unwieldy:

         response = AskYesNo("Really?", "Play Solitaire now?")
         If response == @YES Then Display(5, "", "On your mark ...")
         If response == @YES Then Display(5, "", "Get set ...")
         If response == @YES Then Display(5, "", "Go!")
         If response == @YES Then Run("sol.exe", "")

        Clearly, there must be a better way of handling this.




        Branching
        Enter the Goto command.  Goto, in combination with If ... Then,
        gives you the ability to redirect the flow of control in your WIL
        programs.  Goto does exactly what it says  ---
        of control to go to another point in the WIL program.  You must
        specify where you want the flow of control to be transferred, and
        you must mark this point with a label.  A label is simply a
        destination address, or marker.  The form of the Goto command is:

           Goto label

        where label is an identifier that you specify.  The same rules
        apply to label names as to variable names (the first character must
        be a letter, the label name may consist of any combination of
        letters and numbers, and the label name may be from 1 to 30
        characters long).  In addition, the label is preceded by a colon
        (:) at the point where it is being used as a destination address.
        Here's an example:

         ________________________________________________________________
                                                                       18

                                                             WIL TUTORIAL
         ________________________________________________________________

         response = AskYesNo("Really?", "Play Solitaire now?")
         If response == @NO Then Goto quit
         Display(5, "", "On your mark ...")
         Display(5, "", "Get set ...")
         Display(5, "", "Go!")
         Run("sol.exe", "")
         :quit

        If the If condition is true (that is, if the user answers No), then
        the Goto statement is performed.  The Goto statement is saying, in
        English "go to the line marked :quit, and continue processing from
        there."  Notice how the label quit is preceded by a colon on the
        last line, but not on the line where it follows the Goto keyword.
        This is important.  Although you can have multiple lines in your
        WIL program which say Goto quit, you can have only one line marked
        :quit (just like you can have several people going to your house,
        but can have only one house with a particular address).  Of course,
        you can use many different labels in a WIL program, just as you can
        use many different variables, as long as each has a unique name.
        For example:

         response = AskYesNo("Really?", "Play Solitaire now?")
         If response == @NO Then Goto quit
         Display(5, "", "On your mark ...")
         Display(5, "", "Get set ...")
         Display(5, "", "Go!")
         Run("sol.exe", "")
         Goto done
         :quit
         Display(5, "", "Game canceled")
         :done

        This is a little more complicated.  It uses two labels, quit and
        done.  If the user answers No, then the If condition is true,
        control passes to the line marked :quit, and a message is
        displayed.  If, on the other hand, the user answers Yes, then the
        If condition is false, and the Goto quit line is ignored.  Instead,
        the next four lines are processed, and then the Goto done statement
        is performed.  The purpose of this line is to bypass the Display
        line which follows, by transferring control to the end of the WIL
        program.  There is another way to keep the processing from "falling
        through" to unwanted lines at the end of a program, and that is
        with the Exit command.  Exit causes a WIL program to end
        immediately.  So, for example, we could rewrite the above WIL
        program as follows:







         ________________________________________________________________
                                                                       19

                                                             WIL TUTORIAL
         ________________________________________________________________

         response = AskYesNo("Really?", "Play Solitaire now?")
         If response == @NO Then Goto quit
         Display(5, "", "On your mark ...")
         Display(5, "", "Get set ...")
         Display(5, "", "Go!")
         Run("sol.exe", "")
         Exit
         :quit
         Display(5, "", "Game canceled")

        Since the Run function is the last thing we want to do if the user
        answers Yes, the Exit command simply ends the program at that
        point.  Note that we could put an Exit command at the end of the
        program as well, but it isn't necessary.  An Exit is implied at the
        end of a WIL program.



        This concludes the first part of our tutorial.  You now have the
        building blocks you need to create useful WIL programs.  In the
        second part, which follows, we will look in more detail at some of
        the WIL functions which are available for your use.




        Exploring WIL
        What follows is just a sample of the many functions and commands
        available in WIL.  These should be sufficient to begin creating
        versatile and powerful WIL programs.  For complete information on
        these and all WIL functions and commands, refer to the WIL Function
        Reference (pg. 67).




        Running Programs
        There are three functions which you can use to start an
        application, each of which shares a common syntax:


        Run (program-name, parameters)
        We've already seen the Run function.  This function starts a
        program in a "normal" window.  Windows, or the application itself,
        decides where to place the application's window on the screen.

        Example:
         Run("notepad.exe", "myfile.txt")

        If the program has an EXE extension, its extension may be omitted:


         ________________________________________________________________
                                                                       20

                                                             WIL TUTORIAL
         ________________________________________________________________

         Run("notepad", "myfile.txt")

        Also, you can "run" data files if they have an extension in WIN.INI
        which is associated with an executable program.  So, if TXT files
        are associated with Notepad:

         Run("myfile.txt", "")

        would start Notepad, using the file MYFILE.TXT.

        When you specify a file to run, WIL looks first in the current
        directory, and then in the directories on your DOS path.  If the
        file is not found, WIL will return an error.  You can also specify
        a full path name for WIL to use, as in:

         Run("c:\windows\apps\winedit.exe", "")

        RunZoom (program-name, parameters)
        RunZoom is like Run, but starts a program as a full-screen window.

        Example:
         RunZoom("excel", "bigsheet.xls")

        RunIcon (program-name, parameters)
        RunIcon starts a program as an icon at the bottom of the screen.

        Example:
         RunIcon("clock", "")



        Display and Input
        Here we have functions which display information to the user and
        prompt the user for information, plus a couple of relevant system
        functions.


        Display (seconds, title, text)
        Displays a message to the user for a specified period of time.  The
        message will disappear after the time expires, or after any
        keypress or mouse click.

        Example:
         Display(2, "", "Loading Solitaire now")

              ......................................
              .                                    .
              ......................................
              .                                    .
              .      Loading Solitaire now         .
              ......................................

         ________________________________________________________________
                                                                       21

                                                             WIL TUTORIAL
         ________________________________________________________________


        Message (title, text)
        This command displays a message box with a title and text you
        specify, which will remain on the screen until the user presses the
        OK button.

        Example:
         Message("Sorry", "That file cannot be found")

              ..............................
              .            Sorry           .
              ..............................
              .                            .
              . That file cannot be found  .
              .           [OK]             .
              ..............................


        Pause (title, text)
        This command is similar to Message, except an exclamation-point
        icon appears in the message box, and the user can press OK or
        Cancel.  If the user presses Cancel, the WIL program ends (or goes
        to the label :cancel, if one is defined).

        Example:
         Pause("Delete Backups", "Last chance to stop!")
         ; if we got this far, the user pressed OK
         FileDelete("*.bak")

              ..................................
              .        Delete Backups          .
              ..................................
              .                                .
              .      Last chance to stop!      .
              .                                .
              .      [OK]        [Cancel]      .
              ..................................

        AskYesNo (title, question)
        Displays a dialog box with a given title, which presents the user
        with three buttons: Yes, No, and Cancel.  If the user presses
        Cancel, the WIL program ends (or goes to the label :cancel, if one
        is defined).  Otherwise, the function returns a value of @YES or
        @NO.



        Example:
         response = AskYesNo("End Session", "Really quit Windows?")



         ________________________________________________________________
                                                                       22

                                                             WIL TUTORIAL
         ________________________________________________________________

              ...............................
              .         End Session         .
              ...............................
              .                             .
              .   Really quit Windows?      .
              .                             .
              .  [Yes]    [No]     [Cancel] .
              ...............................


        AskLine (title, prompt, default)
        Displays a dialog box with a given title, which prompts the user
        for a line of input.  Returns the default if the user just presses
        the OK button.

        Example:
         yourfile = AskLine("Edit File", "Filename:", "newfile.txt")
         Run("notepad", yourfile)

              ............................................
              .                                          .
              ............................................
              .  FileName:                               .
              .                                          .
              .    __________________________________    .
              .   | newfile.txt                      |   .
              .   |__________________________________|   .
              .                                          .
              .    [OK]                    [CANCEL]      .
              ............................................


        If you specify a default value (as we have with NEWFILE.TXT), it
        will appear in the response box, and will be replaced with whatever
        the user types.  If the user doesn't type anything, the default is
        used.


        Beep
        Beeps once.

         Beep

        And if one beep isn't enough for you:

         Beep
         Beep
         Beep

        Delay (seconds)
        Pauses WIL program execution.

         ________________________________________________________________
                                                                       23

                                                             WIL TUTORIAL
         ________________________________________________________________

        The Delay function lets you suspend processing for a fixed period
        of time, which can be anywhere from 1 to 3600 seconds.




        Manipulating Windows
        There are a large number of functions which allow you to manage the
        windows on your desktop.  Here are some of them:


        WinZoom (partial-windowname)
        Maximizes an application window to full-screen.


        WinIconize (partial-windowname)
        Turns an application window into an icon.


        WinShow (partial-windowname)
        Shows a window in its "normal" state.



        These three functions are used to modify the size of an already-
        running window.  WinZoom is the equivalent of selecting Maximize
        from a window's control menu, WinIconize is like selecting
        Minimize, and WinShow is like selecting Restore.

        The window on which you are performing any of these functions does
        not have to be the active window.  If the specified window is in
        the background, and a WinZoom or WinShow function causes the size
        of the window to change, then the window will be brought to the
        foreground.  The WinZoom function has no effect on a window which
        is already maximized; likewise, WinShow has no effect on a window
        which is already "normal."

        Each of these functions accepts a partial windowname as a
        parameter.  The windowname is the name which appears in the title
        bar at the top of the window.  You can specify the full name if you
        wish, but it may often be advantageous not to have to do so.  For
        example, if you are editing the file SOLITARE.WBT in a Notepad
        window, the windowname will be Notepad - SOLITARE.WBT:









         ________________________________________________________________
                                                                       24

                                                             WIL TUTORIAL
         ________________________________________________________________
              ..........................................................
              . - .          Notepad - SOLITARE.WBT                    .
              ..........................................................
              .  File  Edit  Search  Help                              .
              ..........................................................
              .                                                        .
              .                                                        .
              .    {Contents of solitare.wbt shown here}               .
              .                                                        .
              .                                                        .
              .                                                        .
              .                                                        .
              .                                                        .
              .                                                        .
              .                                                        .
              .                                                        .
              .                                                        .
              .                                                        .
              ..........................................................

        You probably don't want to have to hard-code this entire name into
        your WIL program as:

         WinZoom("Notepad - SOLITARE.WBT")

        Instead, you can specify the partial windowname "Notepad":

         WinZoom("Notepad")

        If you have more than one Notepad window open, WIL will use the one
        which was most recently used or started.

        Note that WIL matches the partial windowname beginning with the
        first character, so that while

         WinZoom("Note")

        would be correct,

         WinZoom("pad")

        would not result in a match.

        Also, the case (upper or lower) of the title is significant, so

         WinZoom("notepad")

        would not work either.


        WinActivate (partial-windowname)
        Makes an application window the active window.

         ________________________________________________________________
                                                                       25

                                                             WIL TUTORIAL
         ________________________________________________________________

        This function makes a currently-open window the active window.  If
        the specified window is an icon, it will be restored to normal
        size; otherwise, its size will not be changed.


        WinClose (partial-windowname)
        Closes an application window.

        This is like selecting Close from an application's control menu.
        You will still receive any closing message(s) that the application
        would normally give you, such as an "unsaved-file" dialog box.


        WinCloseNot (partial-windowname
             [, partial-windowname]...)
        Closes all application windows except those specified.

        This function lets you close all windows except the one(s) you want
        to remain open.  For example:

         WinCloseNot("Program Man")

        would leave only the Program Manager open, and:

         WinCloseNot("Program Man", "Solit")

        would leave the Program Manager and Solitaire windows open.


        WinWaitClose (partial-windowname)
        Waits until an application window is closed.

        This function causes your WIL program to pause until you have
        manually closed a specified window.  This is a convenient way to
        get WIL to open several windows sequentially, thereby not having
        unnecessary windows all over your desktop.  For example:

         RunZoom("invoices.xls", "")        ;balance the books
         WinWaitClose("Microsoft Ex")       ;wait till Excel closed
         RunZoom("sol", "")                 ;you deserve a break
         WinWaitClose("Solitaire")          ;wait until Solit closed
         Run("winword", "agenda.doc")       ;more paperwork
         WinWaitClose("Microsoft Wor")      ;wait until W4W closed
         Run("clock","")                    ;lunchtime yet?


        WinExist (partial-windowname)
        Tells if a window exists.




         ________________________________________________________________
                                                                       26

                                                             WIL TUTORIAL
         ________________________________________________________________

        This function returns @TRUE or @FALSE, depending on whether a
        matching window can be found.  This provides a way of insuring that
        only one copy of a given window will be open at a time.

        If you've been following this tutorial faithfully from the
        beginning, you probably have several copies of Solitaire running at
        the moment.  (You can check by pressing Ctrl-Esc and bringing up
        the Task Manager.  You say you've got five Solitaire windows open?
        Okay, close them all.)  Now, let's modify our WIL program.  First,
        trim out the excess lines so that it looks like this:

         Run("sol.exe", "")

        Now, let's use the WinExist function to make sure that the WIL
        program only starts Solitaire if it isn't already running:

         If WinExist("Solitaire") == @FALSE Then Run("sol.exe", "")

        And this should work fine.  Run the WIL program twice now, and see
        what happens.  The first time you run it, it should start
        Solitaire; the second (and subsequent) time, it should not do
        anything.

        However, it's quite likely that you want the WIL program to do
        something if Solitaire is already running  ---
        Solitaire window to the foreground.  This can be accomplished by
        using the WinActivate function, along with a couple of Goto
        statements:

         If WinExist("Solitaire") == @FALSE Then Goto open
         WinActivate("Solitaire")
         Goto loaded
         :open
         Run("sol.exe", "")
         :loaded

        Note that we can change this to have WinExist check for a True
        value instead, by modifying the structure of the WIL program:

         If WinExist("Solitaire") == @TRUE Then Goto activate
         Run("sol.exe", "")
         Goto loaded
         :activate
         WinActivate("Solitaire")
         :loaded

        Either format is perfectly correct, and the choice of which to use
        is merely a matter of personal style.  The result is exactly the
        same.



         ________________________________________________________________
                                                                       27

                                                             WIL TUTORIAL
         ________________________________________________________________


        EndSession ( )
        Ends the current Windows session.

        This does exactly what it says.  It will not ask any questions
        (although you will receive any closing messages that your
        currently-open windows would normally display), so you may want to
        build in a little safety net:

         sure = AskYesNo("End Session", "Really quit Windows?")
         If sure == @YES Then EndSession()

        EndSession is an example of a WIL function which does not take any
        parameters, as indicated by the empty parentheses which follow it.
        The parentheses are still required, though.




        Files and Directories

        DirChange (pathname)
        Changes the directory to the pathname specified.

        Use this function when you want to run a program which must be
        started from its own directory.  "Pathname" may optionally include
        a drive letter.

        Example:
         DirChange("c:\windows\winword")
         Run("winword.exe", "")

        DirGet ( )
        Gets the current working directory.

        This function is especially useful in conjunction with DirChange,
        to save and then return to the current directory.

        Example:
         origdir = DirGet()
         DirChange("c:\windows\winword")
         Run("winword.exe", "")
         DirChange(origdir)

        FileExist (filename)
        Determines if a file exists.

        This function will return @TRUE if the specified file exists, and
        @FALSE if it doesn't exist.



         ________________________________________________________________
                                                                       28

                                                             WIL TUTORIAL
         ________________________________________________________________

        Example:
         If FileExist("win.bak") == @FALSE Then FileCopy("win.ini",
             "win.bak", @FALSE)
         Run("notepad.exe", "win.ini")


        FileCopy (from-list, to-file, warning)
        Copies files.

        If warning is @TRUE, WIL will pop up a dialog box warning you if
        you are about to overwrite an existing file, and giving you an
        opportunity to change your mind.  If warning is @FALSE, it will
        overwrite existing files with no warning.

        Example:
         FileCopy("win.ini", "*.sav", @TRUE)
         Run("notepad.exe", "win.ini")

        The asterisk (*) is a wildcard character, which matches any letter
        or group of letters in a file name.  In this case, it will cause
        WIN.INI to be copied as WIN.SAV.


        FileDelete (file-list)
        Deletes files.

        Example:
         If FileExist("win.bak") == @TRUE Then FileDelete("win.bak")


        FileRename (from-list, to-file)
        Renames files to another set of names.



        We can illustrate the use of these WIL program functions with a
        typical WIL application.  Let's suppose that our word processor
        saves a backup copy of each document, with a BAK extension, but we
        want a larger safety net when editing important files.  We want to
        keep the five most recent versions of the wonderful software manual
        we're writing.  Here's a WIL program to accomplish this:











         ________________________________________________________________
                                                                       29

                                                             WIL TUTORIAL
         ________________________________________________________________

         If FileExist("wil.bak") == @TRUE Then Goto backup
         :edit
         Run("winword.exe", "wil.doc")
         Exit
         :backup
         FileDelete("wil.bk5")
         FileRename("wil.bk4", "wil.bk5)
         FileRename("wil.bk3", "wil.bk4)
         FileRename("wil.bk2", "wil.bk3)
         FileRename("wil.bk1", "wil.bk2)
         FileRename("wil.bak", "wil.bk1)
         Goto edit

        If the file WIL.BAK exists, it means that we have made a change to
        WIL.DOC.  So, before we start editing, we delete the oldest backup
        copy, and perform several FileRename functions, until eventually
        WIL.BAK becomes WIL.BK1.  Notice how the flow of control moves to
        the line labeled :backup, and then back to the line labeled :edit,
        and how we terminate processing with the Exit command.  If we did
        not include the Exit command, the WIL program would continue in an
        endless loop.

        However, this still isn't quite right.  What would happen if the
        file WIL.BK5 didn't exist?  In the DOS batch language, we would get
        an error message, and processing would continue.  But in WIL, the
        error would cause the WIL program to terminate:

              .................................................
              .   1017  File Delete:  No matching files found .
              .................................................
              .                                               .
              .    FileDelete("WIL.BK5")                      .
              .                                               .
              .                                               .
              .                    [OK]                       .
              .................................................


        There are two ways that we can handle this.  We could use an If
        FileExist test before every file operation, and test the returned
        value for a @TRUE before proceeding.  But this is clumsy, even with
        such a small WIL program, and would become unwieldy with a larger
        one.




        Handling Errors
        Luckily, there is a WIL system function to help us here: ErrorMode.
        The ErrorMode function lets you decide what will happen if an error
        occurs during WIL processing.  Here's the syntax:

         ________________________________________________________________
                                                                       30

                                                             WIL TUTORIAL
         ________________________________________________________________


        ErrorMode (mode)
        Specifies how to handle errors.


        Parameters:
         (i) mode =   @CANCEL, @NOTIFY, or @OFF.

        Returns:
         (i)          previous error setting.

        Use this command to control the effects of runtime errors.  The
        default is @CANCEL, meaning the execution of the WIL program will
        be canceled for any error.

        @CANCEL:  All runtime errors will cause execution to be canceled.
        The user will be notified which error occurred.

        @NOTIFY:  All runtime errors will be reported to the user, and they
        can choose to continue if it isn't fatal.

        @OFF:  Minor runtime errors will be suppressed. Moderate and fatal
        errors will be reported to the user.  User has the option of
        continuing if the error is not fatal.

        As you can see, the default mode is @CANCEL, and it's a good idea
        to leave it like this.  However, it is quite reasonable to change
        the mode for sections of your WIL program where you anticipate
        errors occurring.  This is just what we've done in our modified WIL
        program:

         If FileExist("wil.bak") == @TRUE Then Goto backup
         :edit
         Run("winword.exe", "wil.doc")
         Exit
         :backup
         ErrorMode(@OFF)
         FileDelete("wil.bk5")
         FileRename("wil.bk4", "wil.bk5)
         FileRename("wil.bk3", "wil.bk4)
         FileRename("wil.bk2", "wil.bk3)
         FileRename("wil.bk1", "wil.bk2)
         FileRename("wil.bak", "wil.bk1)
         ErrorMode(@CANCEL)
         Goto edit

        Notice how we've used ErrorMode(@OFF) to prevent errors in the
        section labeled backup: from aborting the WIL program, and then
        used ErrorMode(@CANCEL) at the end of the that section to change
        back to the default error mode.  This is a good practice to follow.


         ________________________________________________________________
                                                                       31

                                                             WIL TUTORIAL
         ________________________________________________________________




        Selection Menus
        So far, whenever we have needed to use a file name, we've hard-
        coded it into our WIL programs.  For example:

         Run("notepad.exe", "agenda.txt")

        Naturally, there should be a way to get this information from the
        user "on the fly", so that we wouldn't have to write hundreds of
        different WIL program.  And there is a way.  Three or four ways,
        actually.  Consider, first, a function that we have already seen,
        AskLine:

         file = AskLine("", "Enter Filename to edit?", "")
         Run("notepad.exe", file)

        This will prompt for a filename, and run Notepad on that file:

              ..................................................
              .                                                .
              ..................................................
              .                                                .
              .  Enter Filename to edit?                       .
              .                                                .
              .   ___________________________________________  .
              .  |                                           | .
              .  |___________________________________________| .
              .                                                .
              .         [OK]                 [Cancel]          .
              .                                                .
              ..................................................

        There are only three problems with this approach.  First, the user
        might not remember the name of the file.  Second, the user might
        enter the name incorrectly.  And finally, modern software is
        supposed to be sophisticated and user-friendly enough to handle
        these things the right way.  And WIL certainly can.

        There are two new functions we need to use for an improved file
        selection routine: FileItemize and ItemSelect.


        FileItemize (file-list)
        Returns a space-delimited list of files.

        This function compiles a list of filenames and separates the names
        with spaces.  There are several variations we can use:

         FileItemize("*.doc")

         ________________________________________________________________
                                                                       32

                                                             WIL TUTORIAL
         ________________________________________________________________


        would give us a list of all files in the current directory with a
        DOC extension,

         FileItemize("*.com *.exe")

        would give us a list of all files in the current directory with a
        COM or EXE extension, and

         FileItemize("*.*")

        would give us a list of all files in the current directory.

        Of course, we need to be able to use this list, and for that we
        have:


        ItemSelect (title, list, delimiter)
        Displays a listbox filled with items from a list you specify in a
        string.  The items are separated in your string by a delimiter
        character.

        This is the function which actually displays the list box.
        Remember that FileItemize returns a file list delimited by spaces,
        which would look something like this:

           FILE1.DOC FILE2.DOC FILE3.DOC

        When we use ItemSelect, we need to tell it that the delimiter is a
        space.  We do this as follows:

         textfiles = FileItemize("*.doc *.txt")
         yourfile = ItemSelect("Select file to edit", textfiles, " ")
         Run("notepad.exe", yourfile)

              ....................................................
              .                Select file to edit               .
              ....................................................
              .    ____________________________________________  .
              .   |  WINBATCH.DOC                              | .
              .   |  CMDPOST.DOC                               | .
              .   |  SYSINI.TXT                                | .
              .   |  SYSINI2.TXT                               | .
              .   |  WININI.TXT                                | .
              .   |  WININI2.TXT                               | .
              .   |                                            | .
              .   |                                            | .
              .   |____________________________________________| .
              .                                                  .
              .       [OK]                      [Cancel]         .
              ....................................................

         ________________________________________________________________
                                                                       33

                                                             WIL TUTORIAL
         ________________________________________________________________



        First, we use FileItemize to build a list of filenames with DOC and
        TXT extensions.  We assign this list to the variable textfiles.
        Then, we use the ItemSelect function to build a list box, passing
        it the variable textfiles as its second parameter.  The third
        parameter we use for ItemSelect is simply a space with quote marks
        around it; this tells ItemSelect that the variable textfiles is
        delimited by spaces.  (Note that this is different from the null
        string that we've seen earlier  ---
        between the quote marks.)  Finally, we assign the value returned by
        ItemSelect to the variable yourfile, and run Notepad using that
        file.

        In the list box, if the user presses Enter or clicks on the OK
        button without a file being highlighted, ItemSelect returns a null
        string.  If you want, you can test for this condition:

         textfiles = FileItemize("*.doc *.txt")
         :retry
         yourfile = ItemSelect("Select file to edit", textfiles, " ")
         If yourfile == "" Then Goto retry
         Run("notepad.exe", yourfile)

        DirItemize (dir-list)
        Returns a space-delimited list of directories.

        This function is similar to FileItemize, but instead of returning a
        list of files, it returns a list of directories.  Remember we said
        that FileItemize only lists files in the current directory.  Often,
        we want to be able to use files in other directories as well.  We
        can do this by first letting the user select the appropriate
        directory, using the DirItemize and ItemSelect combination:

         DirChange("\")
         subdirs = DirItemize("*")
         targdir = ItemSelect("Select dir", subdirs, " ")
             DirChange(targdir)
         files = FileItemize("*.*")
         file = ItemSelect("Select file", files, " ")
         Run("notepad.exe", file)

        First we change to the root directory.  Then we use DirItemize to
        get a list of all the subdirectories off of the root directory.
        Next, we use ItemSelect to give us a list box of directories from
        which to select.  Finally, we change to the selected directory, and
        use FileItemize and ItemSelect to pick a file.

        Although this WIL program works, it needs to be polished up a bit.
        What happens if the file we want is in the \WINDOWS\BATCH
        directory?  Our WIL program doesn't go more than one level deep

         ________________________________________________________________
                                                                       34

                                                             WIL TUTORIAL
         ________________________________________________________________

        from the root directory.  We want  to continue down the directory
        tree, but we also need a way of telling when we're at the end of a
        branch.  As it happens, there is such a way: DirItemize will return
        a null string if there are no directories to process.  Given this
        knowledge, we can set up a loop to test when we are at the lowest
        level:

         DirChange("\")
         :getdir
         subdirs = DirItemize("*")
         If subdirs == "" Then Goto getfile
         targdir = ItemSelect("Select dir (OK = curr)", subdirs, " ")
         If targdir == "" Then Goto getfile
         DirChange(targdir)
         Goto getdir
         :getfile
         files = FileItemize("*.*")
         file = ItemSelect("Select file", files, " ")
         If file == "" Then Goto getfile
         Run("notepad.exe", file)

        After we use the DirItemize function, we test the returned value
        for a null string.  If we have a null string, then we know that the
        current directory has no subdirectories, and so we proceed to
        select the filename from the current directory (Goto getfile).  If,
        however, DirItemize returns a non-blank list, then we know that
        there is, in fact, at least one subdirectory.  In that case, we use
        ItemSelect to present the user with a list box of directories.
        Then, we test the value returned by ItemSelect.  If the returned
        value is a null string, it means that the user did not select a
        directory from the list, and presumably wants a file in the current
        directory.  We happily oblige (Goto getfile).  On the other hand, a
        non-blank value returned by ItemSelect indicates that the user has
        selected a subdirectory from the list box.  In that case, we change
        to the selected directory, and loop back to the beginning of the
        directory selection routine (Goto getdir).  We continue this
        process until either (a) the user selects a directory, or (b) there
        are no directories left to select.  Eventually, we get to the
        section labeled :getfile.




        Nicer File Selection
        An even more elegant way of selecting a file name is provided by
        the Dialog function (pg. 97), which also allows the user to select
        various options via check boxes and radio buttons.





         ________________________________________________________________
                                                                       35

                                                             WIL TUTORIAL
         ________________________________________________________________




        Nicer Messages
        Have you tried displaying long messages, and found that WIL didn't
        wrap the lines quite the way you wanted?  Here are a couple of
        tricks.


        Num2Char (integer)
        Converts a number to its character equivalent.

        We want to be able to insert a carriage return/line feed
        combination at the end of each line in our output, and the Num2Char
        function will let us do that.  A carriage return has an ASCII value
        of 13, and a line feed has an ASCII value of 10 (don't worry if you
        don't understand what this sentence means).  To be able to use
        these values, we must convert them to characters, as follows:

         cr = Num2Char(13)
         lf = Num2Char(10)

        Now, we need to be able to place the variables cr and lf in our
        message.  For example, let's say we want to do this:

         Message("", "This is line one This is line two")

        If we just inserted the variables into the string, as in:

         cr = Num2Char(13)
         lf = Num2Char(10)
         Message("", "This is line one cr lf This is line two")

        we would not get the desired effect.  WIL would simply treat them
        as ordinary text:

              ...............................................
              .                                             .
              ...............................................
              .                                             .
              .   This is line one cr lf This is line two   .
              .                                             .
              .                   [OK]                      .
              ...............................................



        However, WIL does provide us with a method of performing variable
        substitution such as this, and that is by delimiting the variables
        with percentage signs (%).  If we do this:


         ________________________________________________________________
                                                                       36

                                                             WIL TUTORIAL
         ________________________________________________________________

         cr = Num2Char(13)
         lf = Num2Char(10)
         Message("", "This is line one %cr% %lf%This is line two")

        we will get what we want:

              .............................
              .                           .
              .............................
              .                           .
              .     This is line one      .
              .                           .
              .     This is line two      .
              .                           .
              .           [OK]            .
              .............................


        Note that there is no space after %lf%; this is so that the second
        line will be aligned with the first line (every space within the
        delimiting quote marks of a string variable is significant).

        Now, wouldn't it be convenient if we could combine cr and lf into a
        single variable?  We can.


        StrCat (string[, string]...)
        Concatenates strings together.

        The StrCat function lets us combine any number of string constants
        and/or string variables.  Here's how we combine the variables cr
        and lf into the single variable crlf:

         crlf = StrCat(cr, lf)

        Note that the strings to be concatenated are separated by commas,
        within the parentheses.  Now, we can rewrite our example, as
        follows:

         cr = Num2Char(13)
         lf = Num2Char(10)
         crlf = StrCat(cr, lf)
         Message("", "This is line one %crlf%This is line two")

        If we wanted to re-use this message a number of times, it would be
        quite convenient to use the StrCat function to make a single
        variable out of it:





         ________________________________________________________________
                                                                       37

                                                             WIL TUTORIAL
         ________________________________________________________________

         cr = Num2Char(13)
         lf = Num2Char(10)
         crlf = StrCat(cr, lf)
         line1 = "This is line one"
         line2 = "This is line two"
         mytext = StrCat(line1, crlf, line2)
         Message("", mytext)



        Running DOS Programs
        WIL can run DOS programs, just like it runs Windows programs:

         DirChange("c:\game")
         Run("scramble.exe", "")

        If you want to use an internal DOS command, such as DIR or TYPE,
        you can do so by running the DOS command interpreter, COMMAND.COM,
        with the /c program parameter, as follows:

         Run("command.com", "/c type readme.txt")

        Everything that you would normally type on the DOS command line
        goes after the /c in the second parameter.  Here's another example:

         Run("command.com", "/c type readme.txt | more")

        These examples assume that COMMAND.COM is in a directory on your
        DOS path.  If it isn't, you could specify a full path name for it:

         Run("c:\command.com", "/c type readme.txt | more")

        Or, better still, you could use the WIL Environment function.


        Environment (env-variable)
        Gets a DOS environment variable.

        Since DOS always stores the full path and filename of the command
        processor in the DOS environment variable COMSPEC, it is an easy
        matter to retrieve this information:

         coms = Environment("COMSPEC")

        and use it in our WIL program:

         coms = Environment("COMSPEC")
         Run(coms, "/c type readme.txt")

        To get a DOS window, just run COMMAND.COM with no parameters:


         ________________________________________________________________
                                                                       38

                                                             WIL TUTORIAL
         ________________________________________________________________

         coms = Environment("COMSPEC")
         Run(coms, "")



        Sending Keystrokes to Programs
        Here we come to one of the most useful and powerful features of
        WIL: the ability to send keystrokes to Windows programs, just as if
        you were typing them directly from the keyboard.


        SendKey (character-codes)
        Sends keystrokes to the active application.

        This is an ideal way to make the computer automatically type the
        keystrokes that you enter every time you start a certain program.
        For example, to start up Notepad and have it prompt you for a file
        to open, you would use:

         Run("notepad.exe", "")
         SendKey("!fo")

        The parameter you specify for SendKey is the string that you want
        sent to the program.  This string consists of standard characters,
        as well as some special characters which you will find listed under
        the entry for SendKey in the WIL Function Reference (pg. 216).  In
        the example above, the exclamation mark (!) stands for the Alt key,
        so !f is the equivalent of pressing and holding down the Alt key
        while simultaneously pressing the F key.  The o in the example
        above is simply the letter O, and is the same as pressing the O key
        by itself:

             |-----------------------------~
             |   <<File>>   Edit   Search
             |-----------------------------~
             |   New            |
             | <<Open>>         |
             |   Save           |
             |   Save As        |
             |   Print          |
             |   Page Setup     |
             |   Printer Setup  |
             |------------------|
             |   Exit           |
             --------------------

        Here's another example:

         RunZoom("sol.exe", "")
         SendKey("!gc{RIGHT}{SP}~")


         ________________________________________________________________
                                                                       39

                                                             WIL TUTORIAL
         ________________________________________________________________

        This starts up Solitaire, brings up the Game menu (!g), and selects
        Deck (c) from that menu:

               |-----------------------~
               |   <<Game>>  Help
               |-----------------------~
               |   Deal       |
               |--------------|
               |   Undo       |
               | <<Deck>>     |
               |   Options    |
               |--------------|
               |   Exit       |
               ----------------

        Then it moves the cursor to the next card back style on the right
        ({RIGHT}), selects that card back ({SP}), and then selects OK (~).

              ............................................
              .              Select Card Deck            .
              ............................................
              .   xxxxx   ooooo   vvvvv   bbbbb   zzzzz  .
              .   xxxxx   ooooo   vvvvv   bbbbb   zzzzz  .
              .   xxxxx   ooooo   vvvvv   bbbbb   zzzzz  .
              .   xxxxx   ooooo   vvvvv   bbbbb   zz zz  .
              .                                          .
              .   fffff   ttttt   uuuuu   aaaaa   hhhhh  .
              .   fffff   ttttt   uuuuu   aaaaa   hhhhh  .
              .   fffff   ttttt   uuuuu   aaaaa   hhhhh  .
              .   fffff   ttttt   uuuuu   aaaaa   hhhhh  .
              .                                          .
              .        [OK]                [Cancel]      .
              ............................................




        And voila!  A different card design every time you play!




        Our Completed WIL File
        Here is the final working version of the WIL program that we've
        slowly been building throughout this tutorial:







         ________________________________________________________________
                                                                       40


         ________________________________________________________________

         ; solitare.wbt
         mins = AskLine("Solitaire", "How many minutes to play?","")
         If WinExist("Solitaire") == @TRUE Then Goto activate
         RunZoom("sol.exe", "")
         Goto loaded
         :activate
         WinActivate("Solitaire")
         WinZoom("Solitaire")
         :loaded
         SendKey("!gc{RIGHT}{SP}~")
         goal = mins * 60
         timer = 0
         :moretime
         remain = goal - timer
         WinTitle("Solitaire", "Solitaire (%remain% seconds left)")
         Delay(10)
         timer = timer + 10
         If WinExist("Solitaire") == @FALSE Then Exit
         If timer < goal Then Goto moretime
         Beep
         WinClose("Solitaire")
         Message("Time's up", "Get back to work!")

        It incorporates many of the concepts that we've discussed so far,
        as well as using some arithmetic (*, -, +) and relational (<)
        operators that are covered in the section on the WIL Language (pg.
        45).

        It can also be improved and customized in a number of ways, but
        we'll leave that up to you.

        If you can understand and follow the structures and processes
        illustrated in this sample file, and can begin to incorporate them
        into your own WIL programs, you are well on your way to becoming a
        true WIL guru!

















         ________________________________________________________________
                                                                       41

                                                           THINGS TO KNOW
         ________________________________________________________________


                                   THINGS TO KNOW

        This section covers some miscellaneous items, of a more advanced
        nature.




        Recovering from Cancel
        If the user presses the Cancel button (in any dialog which has
        one), the label :CANCEL will be searched for in the WIL program,
        and, if found, control will be transferred there.  If no label
        :CANCEL is found, processing simply stops.

        This allows the program developer to perform various bits of
        cleanup processing after a user presses Cancel.




        Aborting WIL processing
        A currently-executing WIL program can be terminated immediately by
        pressing the <Ctrl-Shift-Break> key combination.




        Default program for unknown extension
        The Run function (and related members of the Run... family of
        functions) allow you to run a data file if it is associated with a
        program via the [Extensions] section of the WIN.INI file.  You can
        also (optionally) create a special default program entry in that
        section, as follows:

           *=program.exe

        where an asterisk is used instead of a file extension.  Then, if
        you try to run a data file whose extension is not specified in
        [Extensions], WIL will run "program.exe."  Even though the
        customary ^.ext is not included in the example line above, WIL will
        pass the name of the data file as a command-line parameter to
        "program.exe."

        Note: WIL does not use the Windows registration database to match
        data files with their associated programs.






         ________________________________________________________________
                                                                       43


         ________________________________________________________________




        Partial window names
        Those WIL functions which take a partial windowname as a parameter
        can be directed to accept only an exact match, by ending the window
        name with a tilde (~).  For example, WinShow("Note~") would only
        match a window whose title was "Note"; it would not match
        "Notepad".




        Sounds
        If you have Windows Multimedia extensions, and hardware capable of
        playing WAV waveform files, there will be sounds audible at various
        points in the execution of WIL programs.  By default, these sounds
        are enabled.  If you want sounds to be off by default, enter the
        line:

             Sounds=Off

        in the [Main] section of the WWWBATCH.INI file.

        You can also use the Sounds function to turn sounds on and off from
        within a WIL program.

        If you add to the [Sounds] section of your WIN.INI file a line such
        as:

           StartProgram=CHIMES.WAV,Program Launch

        then the WIL Interpreter will make sounds whenever a new program is
        launched.


















         ________________________________________________________________
                                                                       44

                                                             WIL LANGUAGE
         ________________________________________________________________


                                    WIL LANGUAGE




        Menu Structure {*M}
        Menus are defined in a menu file.  Each menu file consists of one
        or more lines of menu statements.  Each line is terminated with a
        carriage return / line feed (CRLF) combination, and can be up to
        255 characters long.

        There are two main parts of a menu file:

        The first section, which is optional, is the initialization code.
        This section is executed once when the menu is first loaded and
        run.  It's located before the first menu item declaration.

        The remainder of the menu file consists of menu item titles and
        their associated statements.  The code under each menu title is
        executed when the corresponding menu item is selected.  Execution
        begins at the first statement under a menu item and continues up to
        the definition of the next item.




        Menu Items {*M}
        Menu titles can consist of letters, digits, spaces, punctuation
        marks  ---
        can create.

        There are special characters you can use to modify the appearance
        of items in the menus.

        &    Causes the following character to be underlined in the menu
        item.  The user can select the item by pressing the ALT key with
        the character instead of using the mouse.

        |  In a main menu, puts this item on a new line.
        |  In a dropdown menu, this item starts a new column.
        _  Used to create a horizontal bar (in dropdown menus only).

        @  Causes the item not to be displayed in the menu.

        In order to identify a menu item within a WIL statement, each menu
        item you define has an associated menu name.  The menu name is
        built using only the letters and digits that make up the menu
        title.  Menu names are case-insensitive; you don't have to worry
        about how the actual menu title is capitalized in order to identify
        it.

         ________________________________________________________________
                                                                       45

                                                             WIL LANGUAGE
         ________________________________________________________________

        For menu items in a popup menu, the menu name consists of its
        parent menu's name, plus the popup menu item's name concatenated at
        the end.

        These menu names are valid as soon as the menu file is loaded, so
        you can use the menu management functions in the initialization
        code before the menus even appear.

        Top-level menu names must begin in column 1.  Submenu names are
        optional, and if used must begin in column 2-4; each column of
        indentation represents an additional level of submenu nesting.
        Actual menu code must begin in column 5 or higher, and must appear
        directly under the menu name to which it belongs.

        Example:
             PW=AskLine ("","Enter your password:", "")
             ;assuming the resident guru's pw is already in WIN.INI:
             RealPW = IniRead ("Our Company", "Tech Guru PW", "")
             Terminate (PW==RealPW, "Access", "You have FULL access")

             MenuChange("SystemUtilitiesCleanupDir",  @DISABLE)
             MenuChange("SystemUtilitiesEditBatFiles",@DISABLE)
             MenuChange("SystemUtilitiesEditWinIni",  @DISABLE)
             Message ("Access", "You have LIMITED access")

         &System Utilities  ;name = "SystemUtilities"
          &Cleanup Dir      ;name = "SystemUtilitiesCleanupDir"
             ...
          &Edit BAT Files...;name = "SystemUtilitiesEditBatFiles"
             ...
          &Edit WIN.INI     ;name = "SystemUtilitiesEditWinIni"
             ...



        Language Components
        WIL statements are constructed from constants, variables,
        operators, functions, commands, and comments.

        Each line in a WIL program can be up to 255 characters long.




        Constants
        The programming language supports both integer and string
        constants.





         ________________________________________________________________
                                                                       46

                                                             WIL LANGUAGE
         ________________________________________________________________


        Integer Constants
        Integer constants are built from the digits 0 through 9.  They can
        range in magnitude from negative to positive 231 - 1 (approximately
        two billion).  Constants larger than these permissible magnitudes
        will produce unpredictable results.

        Examples of integer constants:

         1
         -45
         377849
         -1999999999

        String Constants
        String constants are comprised of displayable characters bounded by
        quote marks.  You can use double quotes ("), single quotes ('), or
        back quotes (`) to enclose a string constant, as long as the same
        type of quote is used to both start and end it.  If you need to
        embed the delimiting quote mark inside the string constant, use the
        delimiting quote mark twice.

        Examples of string constants:

         "a"
         `Betty Boop`
         "This constant has an embedded "" mark"
         'This constant also has an embedded " mark'

        Predefined Constants
        The programming language has a number of built-in integer constants
        that can be used for various purposes.  These start with the @-
        sign, and are case-insensitive (although we prefer to use ALL
        CAPS).

        Some predefined constants:

           @FALSE                             @TILE
           @NO                                @TRUE
           @STACK                             @YES



        A list of all the predefined constants can be found in Appendix A
        on page 280.







         ________________________________________________________________
                                                                       47

                                                             WIL LANGUAGE
         ________________________________________________________________




        Identifiers
        Identifiers are the names supplied for variables, functions, and
        commands in your program.

        An identifier is a sequence of one or more letters or digits that
        begins with a letter.  Identifiers may have up to 30 characters.

        All identifiers are case insensitive.  Upper-case and lower-case
        characters may be mixed at will inside variable names, commands or
        functions.

        For example, these statements all mean the same thing:

         AskLine(MyTitle, Prompt, Default)
         ASKLINE(MYTITLE, PROMPT, DEFAULT)
         aSkLiNe(MyTiTlE, pRoMpT, dEfAuLt)



        Variables
        A variable may contain an integer, a string, a list, or a string
        representing an integer.  Automatic conversions between integers
        and strings are performed as a matter of course during execution.

        If a function requires a string parameter and an integer parameter
        is supplied, the variable will be automatically modified to include
        the representative string.

        If a function requires an integer parameter and a string parameter
        is supplied, an attempt will be made to convert the string to an
        integer.  If it does not convert successfully, an error will
        result.




        Lists
        A list is a string variable which itself contains one or more
        strings, each of which is delimited (separated) by a common
        character.  For example, the FileItemize function returns a list of
        file names, delimited by spaces, and the WinItemize function
        returns a list of window names, delimited by tabs.  In order to use
        functions which accept a list as a parameter, such as ItemSelect,
        you will need to know what character is being used to delimit your
        list.




         ________________________________________________________________
                                                                       48

                                                             WIL LANGUAGE
         ________________________________________________________________




        Keywords
        Keywords are the predefined identifiers that have special meaning
        to the programming language.  These cannot be used as variable
        names.

        WIL keywords consist of the functions, commands, and predefined
        constants.

        Some examples of reserved keywords:

           Beep
           DirChange
           @Yes
           FileCopy



        Operators
        The programming language operators take one operand ("unary
        operators") or two operands ("binary operators").

        Unary operators (integers only):
           -           Arithmetic Negation (Two's complement)
           +           Identity (Unary plus)
           ~           Bitwise Not.  Changes each 0 bit to 1, and
                       vice-versa.
           !           Logical Not.  Produces 0 (@FALSE) if the operand is
                       nonzero, else 1 (@TRUE) if the operand is zero.

        Binary arithmetic operators (integers only):
           *           Multiplication
           /           Division
           mod         Modulo
           +           Addition
           -           Subtraction
           <<          Left Shift
           >>          Right Shift
           &           Bitwise And
           |           Bitwise Or
           ^           Bitwise Exclusive Or  (XOR)
           &&          Logical And
           ||          Logical Or


        Binary relational operators (integers and strings):
           >           Greater-than
           >=          Greater-than or equal
           <           Less-than

         ________________________________________________________________
                                                                       49

                                                             WIL LANGUAGE
         ________________________________________________________________

           <=          Less-than or equal
           ==          Equality
           != or <>    Inequality

        Assignment operator (integers and strings):
           =      Assigns evaluated result of an expression to a variable




        Precedence and evaluation order
        The precedence of the operators affect the evaluation of operands
        in expressions.  Operands associated with higher-precedence
        operators are evaluated before the lower-precedence operators.

        The table below shows the precedence of the operators.  Where
        operators have the same precedence, they are evaluated from left to
        right.

        Operator                 Description
           ( )                   Parenthetical grouping
           ~ ! - +               Unary operators
           * / mod               Multiplication & Division
           + -                   Addition & Subtraction
           <<  >>                Shift operators
           < <= == >= > != <>    Relational operators
           & ^ |                 Bit manipulation operators
           && ||                 Logical operators



        Comments
        A comment is a sequence of characters that are ignored when
        processing a command.  A semicolon (not otherwise part of a string
        constant) indicates the beginning of a comment.

        All characters to the right of the semicolon are considered
        comments, and are ignored.

        Blank lines are also ignored.

        Examples of comments:
         ; This is a comment
         abc = 5  ; This is also a comment








         ________________________________________________________________
                                                                       50

                                                             WIL LANGUAGE
         ________________________________________________________________




        Statements

        Assignment Statements
        Assignment statements are used to set variables to specific or
        computed values.  Variables may be set to integers or strings.

        Examples:
         a = 5
         value = Average(a, 10, 15)
         location = "Northern Hemisphere"
         world = StrCat(location, " ", "Southern Hemisphere")

        Control Statements
        Control statements are generally used to execute system management
        functions and consist of a call to a command without assigning any
        return values.

        Examples:
         Exit
         Yield



        Substitution
        The WIL language has a powerful substitution feature which inserts
        the contents of a string variable into a statement before the line
        is parsed.

        To substitute the contents of a variable in the statement, simply
        put a percent-sign (%) on both sides of the variable name.

        Examples:
         mycmd = "DirChange('c:\')"   ;set mycmd to a command
         %mycmd%                      ;execute the command

        Or consider this one:

         IniWrite("PC", "User", "Richard")
         ...
         name = IniRead("PC", "User", "somebody")
         message("", "Thank you, %name%")

        will produce this message box:






         ________________________________________________________________
                                                                       51

                                                             WIL LANGUAGE
         ________________________________________________________________

              ..........................
              .                        .
              ..........................
              .                        .
              .   Thank you, Richard   .
              .                        .
              .          [OK]          .
              ..........................

        The variable substitution feature can be used to simulate an
        "array" of strings.  For example, if you wanted to read the lines
        contained in a file into an array of variables named line1 through
        line# (where # is the line number of the last line in the file),
        and then write them to a new file in reverse order, you could do so
        as follows:

         handle = FileOpen("c:\config.sys", "READ")
         num = 0
         :readnext
         num = num + 1
         line%num% = FileRead(handle)
         If line%num% != "*EOF*" Then Goto readnext
         FileClose(handle)
         handle = FileOpen("c:\config.rev", "WRITE")
         :writenext
         num = num - 1
         FileWrite(handle, line%num%)
         If num > 1 Then Goto writenext
         FileClose(handle)
         Message("Processing complete", "CONFIG.REV created")


        To put a single percent-sign (%) on a source line, specify a double
        percent sign(%%).  This is required even inside quoted strings.

        Note:  The length of a line, after any substitution occurs, may not
        exceed 255 characters.




        Function Parameters
        Most of the functions and commands in the language require
        parameters.  These come in several types:

           Integer
           String
           List
           Variable name



         ________________________________________________________________
                                                                       52

                                                             WIL LANGUAGE
         ________________________________________________________________

        The interpreter performs automatic conversions between strings and
        integers, so in general you can use them interchangeably.

        Integer parameters may be any of the following:

           An integer (i.e. 23)
           A string representing an integer (i.e. "23")
           A variable containing an integer
           A variable containing a string representing an integer


        String parameters may be any of the following:

           A string
           An integer
           A variable containing a string
           A variable containing a list
           A variable containing an integer




        Error Handling
        There are three types of errors that can occur while processing a
        WIL program:  Minor, Moderate, and Fatal.  What happens when an
        error occurs depends on the current error mode, which is set with
        the ErrorMode function.

        There are three possible modes you can specify:

        @CANCEL
           User is notified when any error occurs, and then the WIL program
           is canceled.  This is the default.

        @NOTIFY
           User is notified when any error occurs, and has option to
           continue unless the error is fatal.

        @OFF
           User is only notified if the error is moderate or fatal.  User
           has option to continue unless the error is fatal.

        The function LastError returns the code of the most-recent error
        encountered during the currently-executing WIL program.

        Minor errors are numbered from    1000 to 1999.
        Moderate errors are numbered from 2000 to 2999.
        Fatal errors are numbered from    3000 to 3999.

        Error handling is reset to @CANCEL at the start of each WIL
        program.

         ________________________________________________________________
                                                                       53

                                                             WIL LANGUAGE
         ________________________________________________________________




        The Functions & Statements



        Inputting Information
        AskLine (title, prompt, default)
           Lets user enter a line of information.

        AskPassword (title, prompt)
           Prompts the user for a password.

        AskYesNo (title, question)
           Lets user choose from Yes, No, or Cancel.

        ItemSelect (title, list, delimiter)
           Chooses an item from a listbox.

        TextBox (title, filename)
           Fills a listbox with text strings from a file.

        TextBoxSort (title, filename)
           Fills a sorted listbox with text strings from a file.

        TextSelect (title, list, delimiter)
           Allows the user to choose an item from an unsorted listbox.




        Displaying Information
        Beep
           Beeps at the user.

        Dialog (dialog-name)
           Displays a user-defined dialog box.

        DialogBox (title, WDG file)
           Pops up a Windows dialog box defined by the WDG template file.

        Display (seconds, title, text)
           Momentarily displays a string.

        Message (title, text)
           Displays text in a message box.

        Pause (title, text)
           Displays text in a message box.


         ________________________________________________________________
                                                                       54

                                                             WIL LANGUAGE
         ________________________________________________________________

        TextBox (title, filename)
           Fills a listbox with text strings from a file.

        TextBoxSort (title, filename)
           Fills a sorted listbox with text strings from a file.

        TextSelect (title, list, delimiter)
           Allows the user to choose an item from an unsorted listbox.




        File Management
        FileAppend (from-list, to-file)
           Appends one or more files to another file.

        FileAttrGet (filename)
           Returns file attributes.

        FileAttrSet (file-list, settings)
           Sets file attributes.

        FileClose (filehandle)
           Closes a file.

        FileCopy (from-list, to-file, warning)
           Copies files.

        FileDelete (file-list)
           Deletes files.

        FileExist (filename)
           Determines if a file exists.

        FileExtension (filename)
           Returns extension of file.

        FileItemize (file-list)
           Builds a list of files.

        FileLocate (filename)
           Finds a file within the current DOS path.

        FileMove (from-list, to-file, warning)
           Moves files to another set of pathnames.

        FileOpen (filename, open-type)
           Opens a STANDARD ASCII (only) file for reading or writing.

        FilePath (filename)
           Returns path of file.

         ________________________________________________________________
                                                                       55

                                                             WIL LANGUAGE
         ________________________________________________________________

        FileRead (filehandle)
           Reads data from a file.

        FileRename (from-list, to-file)
           Renames files to another set of names.

        FileRoot (filename)
           Returns root of file.

        FileSize (file-list)
           Adds up the total size of a set of files.

        FileTimeGet (filename)
           Returns file date and time.

        FileTimeTouch (file-list)
           Sets file(s) to current time.

        FileWrite (filehandle,output-data)
           Writes data to a file.

        IniDelete (section, keyname)
           Removes a line or section from WIN.INI.

        IniDeletePvt (section, keyname, filename)
           Removes a line or section from a private INI file.

        IniItemize (section)
           Lists keywords or sections in WIN.INI.

        IniItemizePvt (section, filename)
           Lists keywords or sections in a private INI file.

        IniRead (section, keyname, default)
           Reads a string from the WIN.INI file.

        IniReadPvt (section, keyname, default, filename)
           Reads a string from a private INI file.

        IniWrite (section, keyname, string)
           Writes a string to the WIN.INI file.

        IniWritePvt (section, keyname, data, filename)
           Writes a string to a private INI file.




        Directory Management
        DirChange ([d:]path)
           Changes the current directory.

         ________________________________________________________________
                                                                       56

                                                             WIL LANGUAGE
         ________________________________________________________________

        DirGet ( )
           Returns the current directory path.

        DirHome ( )
           Returns the initial directory path.

        DirItemize (dir-list)
           Builds a list of directories.

        DirMake ([d:]path)
           Creates a new directory.

        DirRemove ([d:]path)
           Removes an existing directory.

        DirRename ([d:]oldpath, [d:]newpath)
           Renames a directory.

        DirWindows (request#)
           Returns the name of the Windows or Windows System directory.




        Disk Drive Management
        DiskFree (drive-list)
           Returns the amount of free space on a set of drives.

        DiskScan (request#)
           Returns list of drives.

        LogDisk (drive)
           Changes the logged disk drive.




        Window Management
        AppExist (program-name)
           Tells if an application is running.

        AppWaitClose (program-name)
           Suspends WIL program execution until a specified application has
           been closed.

        IconArrange ( )
           Rearranges icons.

        WinActivate (partial-winname)
           Makes an application window the active window.


         ________________________________________________________________
                                                                       57

                                                             WIL LANGUAGE
         ________________________________________________________________

        WinArrange (style)
           Arranges all running application windows on the screen.

        WinClose (partial-winname)
           Closes an application window.

        WinCloseNot (partial-winname [, partial-winname...])
           Closes all application windows except those specified.

        WinExeName (partial-winname)
           Returns the name of the executable file which created a
           specified window.

        WinExist (partial-winname)
           Tells if window exists.

        WinGetActive ( )
           Gets the title of the active window.

        WinHide (partial-winname)
           Hides an application window.

        WinIconize (partial-winname)
           Turns an application window into an icon.

        WinItemize ( )
           Lists all the main windows currently running.

        WinName ( )
           Returns the name of the window calling the WIL Interpreter.

        WinPlace (x-ul, y-ul, x-br, y-br, partial-winname)
           Changes the size and position of an application window on the
           screen.

        WinPlaceGet (win-type, partial-winname)
           Returns window coordinates.

        WinPlaceSet (win-type, partial-winname, position-string)
           Sets window coordinates.

        WinPosition (partial-winname)
           Returns window position.

        WinShow (partial-winname)
           Shows a currently-hidden application window.

        WinState (partial-winname)
           Returns the current state of a window.



         ________________________________________________________________
                                                                       58

                                                             WIL LANGUAGE
         ________________________________________________________________

        WinTitle (partial-winname, new-winname)
           Changes the title of an application window.

        WinWaitClose (partial-winname)
           Waits until an application window is closed.

        WinZoom (partial-winname)
           Maximizes an application window to full-screen.




        Program Management
        Run (program-name, parameters)
           Runs a program as a normal window.

        RunHide (program-name, parameters)
           Runs a program in a hidden window.

        RunHideWait (program-name, parameters)
           Runs a program in a hidden window, and waits for it to close.

        RunIcon (program-name, parameters)
           Runs a program as an icon.

        RunIconWait (program-name, parameters)
           Runs a program as an icon, and waits for it to close.

        RunWait (program-name, parameters)
           Runs a program as a normal window, and waits for it to close.

        RunZoom (program-name, parameters)
           Runs a program in a maximized window.

        RunZoomWait (program-name, parameters)
           Runs a program in a maximized window, and waits for it to close.




        String Handling
        Char2Num (string)
           Returns the ANSI code of a string's first character.

        IsNumber (string)
           Determines if a string represents a valid number.

        ItemCount (list, delimiter)
           Returns the number of items in a list.



         ________________________________________________________________
                                                                       59

                                                             WIL LANGUAGE
         ________________________________________________________________

        ItemExtract (select, list, delimiter)
           Returns the selected item from a list.

        ItemInsert (item, index, list, delimiter)
           Adds an item to a list.

        ItemLocate (item, list, delimiter)
           Returns the position of an item in a list.

        ItemRemove (index, list, delimiter)
           Removes an item from a list.

        ItemSort (list, delimiter)
           Sorts a list.

        Num2Char (number)
           Converts a number to the ANSI character it represents.

        ParseData (string)
           Parses the passed string, just like passed parameters
           are parsed.

        StrCat (string[, string...])
           Concatenates strings together.

        StrCmp (string1, string2)
           Compares two strings.

        StrFill (string, string-length)
           Builds a string from a repeated smaller string.

        StrFix (base-string, padding-string, length)
           Pads or truncates a string to a fixed length.

        StriCmp (string1, string2)
           Compares two strings, ignoring their case.

        StrIndex (main-str, sub-str, start, direction)
           Locates a string within a larger string.

        StrLen (string)
           Returns the length of a string

        StrLower (string)
           Converts a string to all lower-case characters.

        StrReplace (string, old, new)
           Replaces all occurances of a substring with another.

        StrScan (main-str, delims, start, direction)
           Finds an occurrence of one or more delimiter characters in a
           string.
         ________________________________________________________________
                                                                       60

                                                             WIL LANGUAGE
         ________________________________________________________________

        StrSub (string, start, length)
           Returns a substring from within a string.

        StrTrim (string)
           Trims leading and trailing blanks from a string.

        StrUpper (string)
           Converts a string to all upper-case characters.




        Arithmetic Functions
        Abs (number)
           Returns the absolute value of a number.

        Average (num [, num...])
           Returns the average of a list of numbers.

        Max (num [, num...])
           Determines the highest number in a list.

        Min (num [, num...])
           Determines the lowest number in a list.

        Random (max)
           Generates a positive random number.




        Clipboard Handling
        ClipAppend (string)
           Appends a string to the end of the Clipboard.

        ClipGet ( )
           Returns the Clipboard contents into a string.

        ClipPut (string)
           Replaces the Clipboard contents with a string.




        Process Control
        Call (filename, parameters)
           Calls a WIL batch file as a subroutine.

        Debug (mode)
           Turns Debug mode on or off.


         ________________________________________________________________
                                                                       61

                                                             WIL LANGUAGE
         ________________________________________________________________

        Delay (seconds)
           Pauses WIL program execution.

        Drop (var [, var...])
           Deletes variables to recover their memory.

        Else statement
           Continues a previous If statement.

        EndSession ( )
           Ends the current Windows session.

        ErrorMode (mode)
           Sets what happens in the event of an error.

        Exclusive (mode)
           Controls whether or not other Windows program will get any time
           to execute.

        Execute statement
           Directly executes a WIL statement.

        Exit
           Unconditionally ends a WIL program.

        Goto label
           Changes the flow of control in a WIL program.

        If condition Then statement
           Conditionally performs a function.

        IgnoreInput (mode)
           Turns off hardware input to windows.

        IsDefined (variable)
           Determines if a variable is currently defined.

        IsKeyDown (key-codes)
           Tells about keys/mouse.

        LastError ( )
           Returns the last error encountered.

        Return
           Returns from a Call to the calling program.

        SKDebug (mode)
           Controls how SendKey works

        Terminate
           Conditionally ends a WIL program.

         ________________________________________________________________
                                                                       62

                                                             WIL LANGUAGE
         ________________________________________________________________

        Then statement
           Continues a previous If statement.

        WaitForKey
           Waits for a specific key to be pressed.

        Yield
           Pauses WIL processing so other applications can process some
           messages.




        Miscellaneous Functions
        ButtonNames (OK-name, Cancel-name)
           Changes the names of the buttons which appear in WIL dialogs.

        IntControl (request#, p1, p2, p3, p4)
           Internal control functions.

        Reload ( )
           Reloads menu file(s).

        SendKey (character-codes)
           Sends keystrokes to the active application.

        SnapShot (request#)
           Takes a snapshot of the screen and pastes it to the clipboard.

        WallPaper (bmp-name, tile)
           Changes the Windows wallpaper.

        WinParmSet (request#, new-value, ini-control)
           Sets system information.

        WinHelp (help-file, function, keyword)
           Calls a Windows help file.




        System Information
        DateTime ( )
           Returns the current date and time.

        DOSVersion (level)
           Returns the version numbers of the current version of DOS.

        Environment (env-variable)
           Returns the value of a DOS environment variable.


         ________________________________________________________________
                                                                       63

                                                             WIL LANGUAGE
         ________________________________________________________________

        IsLicensed ( )
           Tells if the calling application is licensed.

        MouseInfo (request#)
           Returns assorted mouse information.

        Version ( )
           Returns the version of the parent program currently running.

        VersionDLL ( )
           Returns the version of the WIL Interpreter currently running.

        WinConfig ( )
           Returns WIN3 mode flags.

        WinMetrics (request#)
           Returns Windows system information.

        WinParmGet (request#)
           Returns system information.

        WinParmSet (request#, new-value, ini-control)
           Sets system information.

        WinResources (request#)
           Returns information on available memory and resources.

        WinVersion (level)
           Returns the version of Windows that is currently running.




        DDE Functions
        DDEExecute (channel, command string)
           Sends commands to a DDE server application.

        DDEInitiate (app name, topic name)
           Opens a DDE channel.

        DDEPoke (channel, item name, item value)
           Sends data to a DDE server application.

        DDERequest (channel, item name)
           Gets data from a DDE server application.

        DDETerminate (channel)
           Closes a DDE channel.

        DDETimeout (value)
           Sets the DDE timeout value.

         ________________________________________________________________
                                                                       64

                                                             WIL LANGUAGE
         ________________________________________________________________




        Network Functions
        NetAddCon (net-path, password, local-name)
           Connects network resources to imaginary local disk drives or
           printer ports.

        NetAttach (server-name)
           Attaches to a network file server.

        NetBrowse (request#)
           Displays a network dialog box allowing the user to select a
           network resource.

        NetCancelCon (name, force)
           Breaks a network connection.

        NetDetach (server-name)
           Detaches from a network file server.

        NetDialog ( )
           Brings up the network driver's dialog box.

        NetGetCaps (request#)
           Returns information on network capabilities.

        NetGetCon (local-name)
           Returns the name of a connected network resource.

        NetGetUser ( )
           Returns the name of the user currently logged into the network.

        NetLogin(server-name, user-name, password)
           Performs a network login.

        NetLogout(server-name)
           Performs a network logout.

        NetMapRoot(local-name, net-path)
           Maps a local drive to a network resource.

        NetMemberGet(server-name, group-name)
           Determines whether the current user is a member of a specific
           group.

        NetMemberSet(server-name, group-name)
           Sets the current user as a member of a group.

        NetMsgAll(server-name, message)
           Broadcasts a message to all users on the network.

         ________________________________________________________________
                                                                       65


         ________________________________________________________________

        NetMsgSend(server-name, user-name, message)
           Sends a message to a specific user on the network.




        Multimedia Functions
        PlayMedia (command-string)
           Controls multimedia devices.

        PlayMidi (filename, mode)
           Plays a MID or RMI sound file.

        PlayWaveForm (filename, mode)
           Plays a WAV sound file.

        Sounds (request#)
           Turns sounds on or off.




        Menu Management
        CurrentFile ( )
           Returns the selected filename.

        IsMenuChecked (menuname)
           Determines if a menu item has a checkmark next to it.

        IsMenuEnabled (menuname)
           Determines if a menu item has been enabled.

        MenuChange (menuname, flags)
           Checks, unchecks, enables, or disables a menu item.


















         ________________________________________________________________
                                                                       66

                                                         WIL INTRODUCTION
         ________________________________________________________________


                                        WIL
                                      FUNCTION
                                     REFERENCE




        WIL Introduction
        The WIL programming language consists of a large number of
        functions and commands, which we describe in detail in this
        section.

        We use a shorthand notation to indicate the syntax of the
        functions.

        Function names and other actual characters you type are in
        boldface.  Optional parameters are enclosed in square brackets "[
        ]".  When a function takes a variable number of parameters, the
        variable parts will be followed by ellipses ("...").

        Take, for example, string concatenation:

        StrCat (string[, string...])

        This says that the StrCat function takes at least one string
        parameter.  Optionally, you can specify more strings to
        concatenate.  If you do, you must separate the strings with commas.

        For each function and command, we show you the Syntax, describe the
        Parameters (if any), the value it Returns (if any), a description
        of the function, Example code (shown in Courier type), and related
        functions you may want to See Also.

        Items marked {*M} are available only in menu script usages.

        (i) indicates an integer parameter or return value.
        (s) indicates a string parameter or return value.














         ________________________________________________________________
                                                                       67

                                                                      Abs
         ________________________________________________________________




        Abs
        Returns the absolute value of a number.


        Syntax:
         Abs (integer)

        Parameters:
         (i) integer  integer whose absolute value is desired.

        Returns:
         (i)          absolute value of integer.

        This function returns the absolute (positive) value of the integer
        which is passed to it, regardless of whether that integer is
        positive or negative.


        Example:
         dy = Abs(y1 - y2)
         Message("Years", "There are %dy% years 'twixt %y1% and %y2%")


        See Also:
           Average, IsNumber, Max, Min
























         ________________________________________________________________
                                                                       68

                                                                 AppExist
         ________________________________________________________________




        AppExist
        Tells if an application is running.


        Syntax:
         AppExist (program-name)

        Parameters:
         (s) program-name   name of a Windows EXE or DLL file.

        Returns:
         (i)          @TRUE if the specified application is running;
                      @FALSE if the specified application is not running.

        Use this function to determine whether a specific Windows
        application is currently running.  Unlike WinExist, you can use
        AppExist without knowing the title of the application's window.

        "Program-name" is the name of a Windows EXE or DLL file, including
        the file extension (and, optionally, a full path to the file).


        Example:
         If AppExist("clock.exe") == @FALSE Then Run("clock.exe", "")


        See Also:
           AppWaitClose, Run, WinExeName, WinExist





















         ________________________________________________________________
                                                                       69

                                                             AppWaitClose
         ________________________________________________________________




        AppWaitClose
        Suspends WIL program execution until a specified application has
        been closed.


        Syntax:
         AppWaitClose (program-name)

        Parameters:
         (s) program-name   name of a Windows EXE or DLL file.

        Returns:
         (i)          @TRUE if the specified application is running;
                      @FALSE if the specified application is not running.

        Use this function to suspend the WIL program's execution until the
        user has finished using a given application and has manually closed
        it.  Unlike WinWaitClose, you can use AppWaitClose without knowing
        the title of the application's window.

        "Program-name" is the name of a Windows EXE or DLL file, including
        the file extension (and, optionally, a full path to the file).


        Example:
         Run("clock.exe", "")
         Display(4, "Note", "Close Clock to continue")
         AppWaitClose("clock.exe")
         Message("Continuing...", "Clock closed")


        See Also:
           AppExist, Delay, RunWait, WinExeName, Yield
















         ________________________________________________________________
                                                                       70

                                                                  AskLine
         ________________________________________________________________




        AskLine
        Prompts the user for one line of input.


        Syntax:
         AskLine (title, prompt, default)

        Parameters:
         (s) title    title of the dialog box.
         (s) prompt   question to be put to the user.
         (s) default  default answer.

        Returns:
         (s)          user response.

        Use this function to query the user for a line of data.  The entire
        user response will be returned if the user presses the OK button or
        the Enter key.  If the user presses the Cancel button or the Esc
        key, the processing of the WIL program is canceled.


        Example:
         name = AskLine("Game", "Please enter your name", "")
         game = AskLine("Game", "Favorite game?", "Solitaire")
         message(StrCat(name,"'s favorite game is "), game)

        produces:
              ..............................................
              .                Game                        .
              ..............................................
              .  Please enter your name                    .
              .   ______________________________________   .
              .  | Richard                              |  .
              .  |______________________________________|  .
              .                                            .
              .        [OK]                [Cancel]        .
              ..............................................


              ..............................................
              .                 Game                       .
              ..............................................
              .  Favorite game?                            .
              .   ______________________________________   .
              .  | Solitaire                            |  .
              .  |______________________________________|  .
              .                                            .
              .        [OK]                [Cancel]        .
              ..............................................
         ________________________________________________________________
                                                                       71

                                                                  AskLine
         ________________________________________________________________



        And then, if Richard types "Scramble" and clicks on the OK button:

              ....................................
              .     Richard's favorite game is   .
              ....................................
              .                                  .
              .             Scramble             .
              .               [OK]               .
              ....................................

        See Also:
           AskPassword, AskYesNo, Dialog, Display, ItemSelect, Message,
           Pause, TextBox, TextSelect





































         ________________________________________________________________
                                                                       72

                                                              AskPassword
         ________________________________________________________________




        AskPassword
        Prompts the user for a password.


        Syntax:
         AskPassword (title, prompt)

        Parameters:
         (s) title    title of the dialog box.
         (s) prompt   question to be put to the user.

        Returns:
         (s)          user response.

        Pops up a special dialog box to ask for a password.  An asterisk
        (*) is echoed for each character that the user types; the actual
        characters entered are not displayed.  The entire user response
        will be returned if the user presses the OK button or the Enter
        key.  If the user presses the Cancel button or the Esc key, the
        processing of the WIL program is canceled.


        Example:
         pw = AskPassword("Security check", "Please enter your password")
         If StriCmp(pw, "winguy") != 0 Then Goto nogo
         Run(Environment("COMSPEC"), "")
         Exit
         :nogo
         Pause("Security breach", "Invalid password entered")


        See Also:
           AskLine, AskYesNo, Dialog
















         ________________________________________________________________
                                                                       73

                                                                 AskYesNo
         ________________________________________________________________




        AskYesNo
        Prompts the user for a Yes or No answer.


        Syntax:
         AskYesNo (title, question)

        Parameters
         (s) title      title of the question box.
         (s) question   question to be put to the user.

        Returns:
         (i)          @YES or @NO, depending on the button pressed.

        This function displays a message box with three pushbuttons - Yes,
        No, and Cancel.  If the user presses Cancel, the current WIL
        program is ended, so there is no return value.


        Example:
         q = AskYesNo('Testing', 'Please press "YES"')
         If q == @YES Then Exit
         Display(3, 'ERROR', 'I said press "YES"')

        Produces:

              ....................................
              .             Testing              .
              ....................................
              .                                  .
              .   Please press "YES"             .
              .                                  .
              .   [Yes]      [No]      [Cancel]  .
              ....................................


        And then, if the user presses No:

              ..........................
              .          ERROR         .
              ..........................
              .                        .
              .   I said press "YES"   .
              .                        .
              ..........................

        See Also:
           AskLine, AskPassword, Dialog, Display, ItemSelect, Message,
           Pause, TextBox
         ________________________________________________________________
                                                                       74

                                                                  Average
         ________________________________________________________________




        Average
        Returns the average of a list of numbers.


        Syntax:
         Average (integer [, integer...])

        Parameters:
         (i) integer  integers to get the average of.

        Returns:
         (i)          average of the integers.

        Use this function to compute the mean average of a series of
        numbers, delimited by commas.  This function returns an integer
        value, so there can be some rounding error involved.


        Example:
         avg = Average(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)
         Message("The average is", avg)


        See Also:
           Abs, Max, Min, Random
























         ________________________________________________________________
                                                                       75

                                                                     Beep
         ________________________________________________________________




        Beep
        Beeps once.


        Syntax:
         Beep

        Parameters:
         (none)

        Returns:
         (not applicable)


        Use this command to produce a short beep, generally to alert the
        user to an error situation or to get the user's attention.


        Example:
         Beep
         Pause("WARNING!!!", "You are about to destroy data!")


        See Also:
           PlayMedia, PlayMidi, PlayWaveForm, Sounds
























         ________________________________________________________________
                                                                       76

                                                              ButtonNames
         ________________________________________________________________




        ButtonNames
        Changes the names of the buttons which appear in WIL dialogs.


        Syntax:
         ButtonNames (OK-name, Cancel-name)

        Parameters:
         (s) OK-name        new name for the OK button.
         (s) Cancel-name    new name for the Cancel button.

        Returns:
         (i)          always 1.


        This function allows you to specify alternate names for the OK
        and/or Cancel buttons which appear in any dialogs displayed by the
        WIL Interpreter.  Each use of the ButtonNames statement only
        affects the next WIL dialog which is displayed.

        You can specify a null string ("") for either the OK-name or
        Cancel-Name parameter, to use the default name for that button
        (i.e., "OK" or "Cancel").

        You can place an ampersand before the character which you want to
        be the underlined character in the dialog.


        Example:
         ButtonNames("", "&Abort")
         user = AskLine("Hello", "What is your name", "")
         Message("Hello", user)

















         ________________________________________________________________
                                                                       77

                                                                     Call
         ________________________________________________________________




        Call
        Calls a WIL batch file as a subroutine.


        Syntax:
         Call (filename, parameters)

        Parameters:
         (s) filename       the WIL batch file you are calling (including
                            extension).
         (s) parameters     the parameters to pass to the file, if any, in
                            the form
                            "p1 p2 p3 ... pn".

        Returns:
         (i)          always 0.


        This function is used to pass control temporarily to a secondary
        WIL batch file.  The main WIL program can optionally pass
        parameters to the secondary WIL batch file.  All variables are
        common (global) between the calling program and the called WIL
        batch file, so that the secondary WIL batch file may modify or
        create variables.  The secondary WIL batch file should end with a
        Return statement, to pass control back to the main WIL program.

        If a string of parameters is passed to the secondary WIL batch
        file, it will automatically be parsed into individual variables
        with the names param1, param2, etc., (maximum of nine parameters).
        The variable param0 will be a count of the total number of
        parameters in the string.


        Example:
         ; MAIN.WBT
         name = AskLine("", "What is your name?", "")
         age = AskLine("", "How old are you?", "")
         valid = @NO
         Call("chek-age.wbt", age)
         If valid == @NO Then Message("", "Invalid age")

         ; CHEK-AGE.WBT
         userage = param1
         really = AskYesNo("", "%name%, are you really %userage%?")
         If really == @NO Then Return
         If (userage > 0) && (userage < 150) Then valid = @YES
         Return


         ________________________________________________________________
                                                                       78

                                                                     Call
         ________________________________________________________________


        See Also:
           ParseData, Return

















































         ________________________________________________________________
                                                                       79

                                                                 Char2Num
         ________________________________________________________________




        Char2Num
        Converts the first character of a string to its numeric equivalent.


        Syntax:
         Char2Num (string)

        Parameters:
         (s) string   any text string.  Only the first character will be
                      converted.

        Returns:
         (i)          ANSI character code.

        This function returns the 8-bit ANSI code corresponding to the
        first character of the string parameter.

        Note:  For the commonly-used characters (with codes below 128),
        ANSI and ASCII characters are identical.


        Example:
         ; Show the hex equivalent of entered character
         inpchar = AskLine("ANSI Equivalents", "Char:", "")
         ansi = StrSub(inpchar, 1, 1)
         ansiequiv = Char2Num(InpChar)
         Message("ANSI Codes", "%ansi% => %ansiequiv%")


        See Also:
           IsNumber, Num2Char


















         ________________________________________________________________
                                                                       80

                                                               ClipAppend
         ________________________________________________________________




        ClipAppend
        Appends a string to the Clipboard.


        Syntax:
         ClipAppend (string)

        Parameters:
         (s) string   text string to add to Clipboard.

        Returns:
         (i)          @TRUE if string was appended;
                      @FALSE if Clipboard ran out of memory.

        Use this function to append a string to the Windows Clipboard.  The
        Clipboard must either contain text data or be empty for this
        function to succeed.


        Example:
         ; The code below will append 2 copies of the
         ; Clipboard contents back to the Clipboard, resulting
         ; in 3 copies of the original contents with a CR/LF
         ; between each copy.
         a = ClipGet()
         crlf = StrCat(Num2Char(13), Num2Char(10))
         ClipAppend(crlf)
         ClipAppend(a)
         ClipAppend(crlf)
         ClipAppend(a)


        See Also:
           ClipGet, ClipPut















         ________________________________________________________________
                                                                       81

                                                                  ClipGet
         ________________________________________________________________




        ClipGet
        Returns the contents of the Clipboard.


        Syntax:
         ClipGet ( )

        Parameters:
         (none)

        Returns:
         (s)          Clipboard contents.

        Use this function to copy text from the Windows Clipboard into a
        string variable.

        Note:  If the Clipboard contains an excessively large string a
        (fatal) out of memory error may occur.


        Example:
         ; The code below will convert Clipboard contents to
         ; uppercase
         ClipPut(StrUpper(ClipGet()))
         a = ClipGet()
         Message("UPPERCASE Clipboard Contents", a)


        See Also:
           ClipAppend, ClipPut



















         ________________________________________________________________
                                                                       82

                                                                  ClipPut
         ________________________________________________________________




        ClipPut
        Copies a string to the Clipboard.


        Syntax:
         ClipPut (string)

        Parameters:
         (s) string   any text string.

        Returns:
         (i)          @TRUE if string was copied;
                      @FALSE if Clipboard ran out of memory.

        Use this function to copy a string to the Windows Clipboard.  The
        previous Clipboard contents will be lost.


        Example:
         ; The code below will convert Clipboard contents to
         ; lowercase
         ClipPut(StrLower(ClipGet()))
         a = ClipGet()
         Message("lowercase Clipboard Contents", a)


        See Also:
           ClipAppend, ClipGet, SnapShot





















         ________________________________________________________________
                                                                       83

                                                         CurrentFile {*M}
         ________________________________________________________________




        CurrentFile {*M}
        Returns the selected filename.


        Syntax:
         CurrentFile ( )

        Parameters:
         (none)

        Returns:
         (s)          currently-selected file's name.

        When a WIL menu shell displays the files in the current directory,
        one of them may be "selected."  This function returns the name of
        that file, if any.

        This is different than a "highlighted" file.  When a file is
        highlighted, it shows up in inverse video (usually white-on-black).
        To find the filenames that are highlighted, see FileItemize.

        Note: This command is not part of the WIL Interpreter package, but
        is documented here because it has been implemented in many of the
        shell or file manager-type applications which use the WIL
        Interpreter.


        Example:
         ; ask which program to run (default = current file)
         thefile = AskLine("Run It", "Program:", CurrentFile())
         Run(thefile, "")


        See Also:
           DirGet, DirItemize, FileItemize














         ________________________________________________________________
                                                                       84

                                                                 DateTime
         ________________________________________________________________




        DateTime
        Provides the current date and time.


        Syntax:
         DateTime ( )

        Parameters:
         (none)

        Returns:
         (s)          today's date and time

        This function will return the current date and time in a pre-
        formatted string.  The format of the string depends on the current
        settings in the [Intl] section of the WIN.INI file:

        ddd mm/dd/yy hh:mm:ss XX
        ddd dd/mm/yy hh:mm:ss XX
        ddd yy/mm/dd hh:mm:ss XX

        Where:
           ddd is day of the week (e.g. Mon)
           mm  is the month (e.g. 10)
           dd  is the day of the month (e.g. 23)
           yy  is the year (e.g. 90)
           hh  is the hours
           mm  is the minutes
           ss  is the seconds
           XX  is the Day/Night code (e.g. AM or PM)

        Note:  Windows provides even more formatting options than this.

        The WIN.INI file will be examined to determine which format to use.
        You can adjust the WIN.INI file via the [Intl] section of Control
        Panel if the format isn't what you prefer.


        Example:
         ; assuming the current standard is U.S.
         ; (i.e. day  dd/mm/yy hh:mm:ss AM)
         Message("Current Date & Time", DateTime())

        would produce:





         ________________________________________________________________
                                                                       85

                                                                 DateTime
         ________________________________________________________________

              ................................
              .     Current Date & Time      .
              ................................
              .                              .
              .   Sat 7/23/91  9:29:23 PM    .
              .                              .
              .             [OK]             .
              ................................


        See Also:
           FileTimeGet








































         ________________________________________________________________
                                                                       86

                                                               DDEExecute
         ________________________________________________________________




        DDEExecute
        Sends commands to a DDE server application.


        Syntax:
         DDEExecute (channel, command string)

        Parameters:
         (i) channel    same integer that was returned by DDEInitiate.
         (s) command    string one or more commands to be executed by the
                        server app.

        Returns:
         (i)          @TRUE if successful; @FALSE if unsuccessful.

        Use the DDEInitiate function to obtain a channel number.

        In order to use this function successfully, you will need
        appropriate documentation for the server application you wish to
        access, which must provide information on the DDE functions that it
        supports and the correct syntax to use.


        Example:
         Run("wincheck.exe", "TUT")
         channel = DDEInitiate("wincheck", "TUT")
         If channel == 0 Then Goto failed
         result = DDEExecute(channel, '[WriteCheck:p="Shorewood
             Apartments",t=580.00,l="Rent"]')
         DDETerminate(channel)
         WinClose("WinCheck")
         If result == @FALSE Then Goto Failed
         Message("DDE Execute", "Operation complete")
         Exit
         :failed
         Message("DDE operation unsuccessful", "Check your syntax")


        See Also:
           DDEInitiate, DDEPoke, DDERequest, DDETerminate, DDETimeout









         ________________________________________________________________
                                                                       87

                                                              DDEInitiate
         ________________________________________________________________




        DDEInitiate
        Opens a DDE channel.


        Syntax:
         DDEInitiate (app name, topic name)

        Parameters:
         (s) app name       name of the application
                            (usually the filename w/o the EXE extension).
         (s) topic name     name of the topic you wish to access.

        Returns:
         (i)                communications channel.

        This function opens a DDE communications channel with a server
        application.  The communications channel can be subsequently used
        by the DDEExecute, DDEPoke, and DDERequest functions.  You should
        close this channel with DDETerminate when you are finished using
        it.  If the communications channel cannot be opened as requested,
        DDEInitiate returns a channel number of 0.

        You can call DDEInitiate more than once, in order to carry on
        multiple DDE conversations (with multiple applications)
        simultaneously.

        In order to use this function successfully, you will need
        appropriate documentation for the server application you wish to
        access, which must provide information on the DDE functions that it
        supports and the correct syntax to use.


        Example:
         Run("wincheck.exe", "TUT")
         channel = DDEInitiate("WinCheck", "TUT")
         If channel == 0 Then Goto failed
         output = DDERequest(channel, "GetChecking")
         DDETerminate(channel)
         WinClose("WinCheck")
         If output == "" Then Goto Failed
         Message("Account balance", output)
         Exit
         :failed
         Message("DDE operation unsuccessful", "Check your syntax")


        See Also:
           DDEExecute, DDEPoke, DDERequest, DDETerminate, DDETimeout

         ________________________________________________________________
                                                                       88

                                                                  DDEPoke
         ________________________________________________________________




        DDEPoke
        Sends data to a DDE server application.


        Syntax:
         DDEPoke (channel, item name, item value)

        Parameters:
         (i) channel        same integer that was returned by DDEInitiate.
         (s) item name      identifies the type of data being sent.
         (s) item value     actual data to be sent to the server.

        Returns:
         (i)          @TRUE if successful; @FALSE if unsuccessful.

        Use the DDEInitiate function to obtain a channel number.

        In order to use this function successfully, you will need
        appropriate documentation for the server application you wish to
        access, which must provide information on the DDE functions that it
        supports and the correct syntax to use.


        Example:
         Run("reminder.exe", "")
         channel = DDEInitiate("Reminder", "items")
         If channel == 0 Then Goto failed
         result = DDEPoke(channel, "all", "11/3/92 Misc Remember to vote")
         DDETerminate(channel)
         WinClose("Reminder")
         If result == @FALSE Then Goto Failed
         Message("DDE Poke", "Operation complete")
         Exit
         :failed
         Message("DDE operation unsuccessful", "Check your syntax")


        See Also:
           DDEExecute, DDEInitiate, DDERequest, DDETerminate, DDETimeout










         ________________________________________________________________
                                                                       89

                                                               DDERequest
         ________________________________________________________________




        DDERequest
        Gets data from a DDE server application.


        Syntax:
         DDERequest (channel, item name)

        Parameters:
         (i) channel     same integer that was returned by DDEInitiate.
         (s) item name   identifies the data to be returned by the server.

        Returns:
         (s)          information returned from the server.

        Use the DDEInitiate function to obtain a channel number.

        In order to use this function successfully, you will need
        appropriate documentation for the server application you wish to
        access, which must provide information on the DDE functions that it
        supports and the correct syntax to use.


        Example:
         Run("wincheck.exe", "TUT")
         channel = DDEInitiate("WinCheck", "TUT")
         If channel == 0 Then Goto failed
         output = DDERequest(channel, "GetChecking")
         DDETerminate(channel)
         WinClose("WinCheck")
         If output == "" Then Goto Failed
         Message("Account balance", output)
         Exit
         :failed
         Message("DDE operation unsuccessful", "Check your syntax")


        See Also:
           DDEExecute, DDEInitiate, DDEPoke, DDETerminate, DDETimeout











         ________________________________________________________________
                                                                       90

                                                             DDETerminate
         ________________________________________________________________




        DDETerminate
        Closes a DDE channel.


        Syntax:
         DDETerminate (channel)

        Parameters:
         (i) channel    same integer that was returned by DDEInitiate.

        Returns:
         (i)            always 1.

        This function closes a communications channel that was opened with
        DDEInitiate.

        Example:
         Run("wincheck.exe", "TUT")
         channel = DDEInitiate("WinCheck", "TUT")
         If channel == 0 Then Goto failed
         output = DDERequest(channel, "GetChecking")
         DDETerminate(channel)
         WinClose("WinCheck")
         If output == "" Then Goto Failed
         Message("Account balance", output)
         Exit
         :failed
         Message("DDE operation unsuccessful", "Check your syntax")


        See Also:
           DDEExecute, DDEInitiate, DDEPoke, DDERequest, DDETimeout

















         ________________________________________________________________
                                                                       91

                                                               DDETimeout
         ________________________________________________________________




        DDETimeout
        Sets the DDE timeout value.


        Syntax:
         DDETimeout (value)

        Parameters:
         (i) value    DDE timeout time.

        Returns:
         (i)          previous timeout value.

        Sets the timeout time for subsequent DDE functions to specified
        value in milliseconds (1/1000 second).  Default is 3000
        milliseconds (3 seconds).  If the time elapses with no response,
        the WIL Interpreter will return an error.  The value set with
        DDETimeout stays in effect until changed by another DDETimeout
        statement or until the WIL program ends, whichever comes first.


        Example:
         DDETimeout(5000)
         Run("wincheck.exe", "TUT")
         channel = DDEInitiate("WinCheck", "TUT")
         If channel == 0 Then Goto failed
         output = DDERequest(channel, "GetChecking")
         DDETerminate(channel)
         WinClose("WinCheck")
         If output == "" Then Goto Failed
         Message("Account balance", output)
         Exit
         :failed
         Message("DDE operation unsuccessful", "Check your syntax")


        See Also:
           DDEExecute, DDEInitiate, DDEPoke, DDERequest, DDETerminate











         ________________________________________________________________
                                                                       92

                                                                    Debug
         ________________________________________________________________




        Debug
        Controls the debug mode.


        Syntax:
         Debug (mode)

        Parameters:
         (i) mode     @ON or @OFF

        Returns:
         (i)          previous debug mode

        Use this function to turn the debug mode on or off.  The default is
        @OFF.

        When debug mode is on, the WIL Interpreter will display the
        statement just executed, its result (if any), any error conditions,
        and the next statement to execute.

        The statements are displayed in a special dialog box which gives
        the user four options:  Next, Run, Cancel and Show Var.

        Next executes the next statement and remains in debug mode.

        Run exits debug mode and runs the rest of the program normally.

        Cancel terminates the current WIL program.

        Show Var displays the contents of a variable whose name the user
        entered in the edit box.


        Example:
         Debug(@ON)
         a = 6
         q = AskYesNo("Testing Debug Mode", "Is the Pope Catholic")
         Debug(@OFF)
         b = a + 4

        produces:








         ________________________________________________________________
                                                                       93

                                                                    Debug
         ________________________________________________________________


              ...................................................
              .                   DEBUG                         .
              ...................................................
              .  *** Debug Initialized ***                      .
              .  Value => 0                                     .
              .                                                 .
              .  Next Statement                                 .
              .  a=6                                            .
              .  __________________________________             .
              . |                                  | [Show Var] .
              . |__________________________________|            .
              .                                                 .
              .   [Next]         [Run]         [Cancel]         .
              ...................................................


        ... then, if the user presses Next:

              ...................................................
              .                   DEBUG                         .
              ...................................................
              .  a=6                                            .
              .  Value => 6                                     .
              .                                                 .
              .  Next Statement                                 .
              .  q = AskYesNo("Testing Debug Mode", "Is the Po  .
              .  __________________________________             .
              . |                                  | [Show Var] .
              . |__________________________________|            .
              .                                                 .
              .   [Next]         [Run]         [Cancel]         .
              ...................................................


        ... and presses Next again:


              ...................................
              .       Testing Debug Mode        .
              ...................................
              .                                 .
              .      Is the Pope Catholic?      .
              .                                 .
              .   [Yes]     [No]     [Cancel]   .
              ...................................


        ... and then presses Yes:



         ________________________________________________________________
                                                                       94

                                                                    Debug
         ________________________________________________________________


              ...................................................
              .                   DEBUG                         .
              ...................................................
              .  q = AskYesNo("Testing Debug Mode", "Is the Po  .
              .  Value => 1                                     .
              .                                                 .
              .  Next Statement                                 .
              .  Debug(@OFF)                                    .
              .  __________________________________             .
              . |                                  | [Show Var] .
              . |__________________________________|            .
              .                                                 .
              .   [Next]         [Run]         [Cancel]         .
              ...................................................


        etc.  (If the user had pressed No it would have said "VALUE=>0".)


        See Also:
           ErrorMode, LastError, SKDebug






























         ________________________________________________________________
                                                                       95

                                                                    Delay
         ________________________________________________________________




        Delay
        Pauses execution for a specified amount of time.


        Syntax:
         Delay (seconds)

        Parameters:
         (i) seconds    integer seconds to delay (2 - 3600)

        Returns:
         (i)            always 1

        This function causes the currently-executing WIL program to be
        suspended for the specified period of time.  Seconds must be an
        integer between 2 and 3600.  Smaller or larger numbers will be
        adjusted accordingly.


        Example:
         Message("Wait", "About 15 seconds")
         Delay(15)
         Message("Hi", "I'm Baaaaaaack")


        See Also:
           Yield






















         ________________________________________________________________
                                                                       96

                                                                   Dialog
         ________________________________________________________________




        Dialog
        Displays a user-defined dialog box.


        Syntax:
         Dialog (dialog-name)

        Parameters:
         (s) dialog-name    name of the dialog box.

        Returns:
         (i)          value of the pushbutton used to close the dialog box.


        The text which follows describes how to define a dialog box for use
        by the Dialog function.  Please refer to your product-specific
        documentation for any additional information which may supplement
        or supersede that which is described here.

        Before the Dialog function is called, you must include a section of
        code in your WIL program which will define the characteristics of
        the dialog box to be displayed.  First of all, the dialog must be
        declared, and a name must be assigned to it.  This is done with a
        line of the following format:

         <name>Format="WWWDLGED,4.0"

        where <name> is the dialog name.  This should follow the standard
        rules for WIL variable names, and may not exceed 17 characters in
        length.

        Next, the format of the dialog box is defined, as follows:

         <name>X           = <x-origin>
         <name>Y           = <y-origin>
         <name>Width       = <box-width>
         <name>Height      = <box-height>
         <name>NumControls = <control-count>
         <name>Caption     = "<box-caption>"

        where:








         ________________________________________________________________
                                                                       97

                                                                   Dialog
         ________________________________________________________________

         <name>          is the name of the dialog box, as described above.
         <x-origin>      is the horizontal coordinate of the upper left
                         corner of dialog box.
         <y-origin>      is the vertical coordinate of the upper left
                         corner of the dialog box.
         <box-width>     is the width of the dialog box.
         <box-height>    is the height of the dialog box.
         <control-count> is the total number of controls in the dialog box
                         (see below).
         <box-caption>   is the text which will appear in the title bar of
                         the dialog box.

        Finally, you will need to define the objects, or controls, which
        will appear inside the dialog box.  Each control is defined with a
        line of the following format:

         <name>nn = `x,y,width,height,type,var,"text",value`

        where:

         "nn"         is the ordinal position of the control in the
                      dialog box (starting with 1).
         "<name>"     is the name of the dialog box, as described above.
         "x"          is the horizontal coordinate of the upper left
                      corner of the control.
         "y"          is the vertical coordinate of the upper left corner
                      of the control.
         "width"      is the width of the control.
         "height"     is the height of the control.
                      [This should be DEFAULT for all controls except
                      filelistboxes.]
         "type"       is the type of control, (see below).
         "var"        is the name of the variable affected by the control.
         "text"       is the description which will be displayed with the
                      control.  [Use a null string ("") if the control
                      should appear blank.]
         "value"      is the value returned by the control.  [Use only for
                      pushbuttons, radiobuttons, and checkboxes.]


        Note: The numbers used for "x-origin", "y-origin", "box-width",
        "box-height", "x", "y", "width," and "height" are expressed in a
        unit of measure known as "Dialog Units."  Basically speaking:

           1 width unit  = 1/4 width of system font.
           1 height unit = 1/4 width of system font.
           4 units wide  = Average width of the system font.
           8 units high  = Average height of the system font.


        There are seven types of controls available:

         ________________________________________________________________
                                                                       98

                                                                   Dialog
         ________________________________________________________________


           PUSHBUTTON  A button, which can be labeled and used as desired.

                       When the user presses a pushbutton, the Dialog
                       function will exit and will return the "value"
                       assigned to the button which was pressed. Therefore,
                       you should assign a unique "value" to each
                       pushbutton in a dialog.

                       Pushbuttons with values of 0 and 1 have special
                       meaning.  If the user presses a pushbutton which has
                       a value of 0, the WIL program will be terminated (or
                       will go to the label marked ":CANCEL", if one is
                       defined);  this corresponds to the behavior of the
                       familiar Cancel button.  A pushbutton with a value
                       of 1 is the default pushbutton, and will be selected
                       if the user presses the Enter key; this corresponds
                       to the behavior of the familiar OK button.

                       Note: Every dialog box must contain at least one
                                 pushbutton.
                             For pushbuttons, "var" should be DEFAULT.


           RADIOBUTTON One of a group of circular buttons, only one of
                       which can be "pressed" (filled in) at any given
                       time.  You can have more than one group of radio
                       buttons in a dialog box, but each group must use a
                       different "var".  When the Dialog function exits,
                       the value of "var" will be equal to the "value"
                       assigned to the radiobutton which is pressed.
                       Therefore, you should assign a unique "value" to
                       each radiobutton in a group.

                       Normally, when a dialog box opens, the default
                       radiobutton in each group (i.e., the one which is
                       pressed) is the one which has a value of 1.  You can
                       change this by assigning a different value to "var"
                       before calling the Dialog function.


           CHECKBOX    A square box, in which an "X" appears when selected.
                       A check box can have a value of 0 (un-checked) or 1
                       (checked).

                       Each checkbox in a dialog should use a unique "var".

                       Normally, when a dialog box opens, every checkbox
                       defaults to being un-checked.  You can change this
                       by assigning a value of 1 to "var" before calling
                       the Dialog function.

         ________________________________________________________________
                                                                       99

                                                                   Dialog
         ________________________________________________________________

                       Note for advanced users only: it is possible to
                       define a group of checkboxes which have the same
                       "var".  Each box in the group must have a unique
                       value, which must be a power of 2 (1, 2, 4, etc.).
                       The user can check and uncheck individual checkboxes
                       in the group, and when the Dialog function exits the
                       value of "var" will be equal to the values of all
                       the checkboxes in the group, combined using the
                       bitwise OR operator (|).

           EDITBOX     A box in which text can be typed.  Whatever the user
                       types in the editbox will be assigned to the
                       variable    "var".

                       Normally, when a dialog box opens, editboxes are
                       empty.  You can change this by assigning a value to
                       the string variable "var" before calling the Dialog
                       function, in which case the value of "var" will be
                       displayed in the editbox.


           STATICTEXT  Descriptive text, which does not change.  This can
                       be used to display titles, instructions, etc.

                       For statictext controls, "var" should be DEFAULT.


           VARYTEXT    Variable text.  The current value of "var" is
                       displayed.  If "var" is not assigned a value in the
                       WIL program before calling the Dialog function, the
                       "text" field of the control definition will be used.

           FILELISTBOX A file selection listbox.  This will allow the user
                       to select a file from any directory or drive on the
                       system.

                       The value of "var" will be set to the selected
                       filename; if you need to know what directory the
                       file is in, use the DirGet function after the Dialog
                       function exits.

                       Normally, when a dialog box opens, filelistboxes
                       display files matching a filemask of "*.*"
                       (i.e., all files).  You can change this by assigning
                       a different filemask value to the string variable
                       "var" before calling the Dialog function.

                       In combination with the filelistbox, you can include
                       an EDITBOX control which has the same "var" name as
                       the filelistbox.  If you do, the user can type a
                       filemask into the editbox (eg., "*.TXT"), which

         ________________________________________________________________
                                                                      100

                                                                   Dialog
         ________________________________________________________________

                       will cause the filelistbox to be redrawn to display
                       only those files which match the specified filemask.

                       Also in combination with the filelistbox, you can
                       include a VARYTEXT control which has the same "var"
                       name as the filelistbox.  If you do, this control
                       will show the  name of the directory currently
                       displayed in the  filelistbox.

                       For filelistboxes, "text" should be DEFAULT.

                       Note: You can have only one filelistbox in a dialog.


        Example:
         GeorgeFormat=`WWWDLGED,4.0`

         GeorgeCaption=`Sample Dialog`
         GeorgeX=56
         GeorgeY=72
         GeorgeWidth=228
         GeorgeHeight=113
         GeorgeNumControls=12

         George01=`20,88,64,DEFAULT,PUSHBUTTON,DEFAULT,"&Ok",1`
         George02=`140,88,64,DEFAULT,PUSHBUTTON,DEFAULT,"&Cancel",0`
         George03=`8,6,98,DEFAULT,STATICTEXT,DEFAULT,"Enter your name:"`
         George04=`108,6,94,DEFAULT,EDITBOX,UserName,"<Enter name here>"`
         George05=`8,24,108,DEFAULT,STATICTEXT,DEFAULT,"Choose an OpSys:"`
         George06=`18,38,64,DEFAULT,RADIOBUTTON,Rad,"DOS",1`
         George07=`18,50,64,DEFAULT,RADIOBUTTON,Rad,"Windows",2`
         George08=`18,62,64,DEFAULT,RADIOBUTTON,Rad,"OS/2",3`
         George09=`130,24,88,DEFAULT,STATICTEXT,DEFAULT,"Check ones used:"`
         George10=`144,38,64,DEFAULT,CHECKBOX,CHKDOS,"DOS",1`
         George11=`144,50,64,DEFAULT,CHECKBOX,CHKWIN,"Windows",1`
         George12=`144,62,64,DEFAULT,CHECKBOX,CHKOS2,"OS/2",1`

         Dialog("George")


        See Also:
           AskLine, AskPassword, AskYesNo, DialogBox, ItemSelect










         ________________________________________________________________
                                                                      101

                                                                DialogBox
         ________________________________________________________________




        DialogBox
        Pops up a Windows dialog box defined by the WDG template file.


        Syntax:
         DialogBox (title, WDG-file)

        Parameters:
         (s) title      the title of the dialog box.
         (s) WDG-file   the name of the WDG template file.

        Returns:
         (i)            always 0.

        Note:  This function has been entirely supplanted by the Dialog
        function, but is retained in the WIL language and documented here
        for backwards compatibility.

        Each element in the template file is enclosed in square brackets,
        and consists of a variable name, followed by one of the following
        symbols:

           Symbol Meaning                   Example

             +    check box                 [backup+1Save backup]
             #    edit box                  [newfile#   ]
             \    file selection listbox    [editfile\     ]
             ^    radio button              [prog^1Note]     [prog^2Write]
             $    variable                  [var$]

        The number following the check box and radio button symbols is the
        value which will get assigned to the variable if its corresponding
        box is checked, or button is selected.  Following the number is the
        descriptive text which will appear next to the box or button.

        When used in conjunction with a file selection list box variable
        with the same name, two of these symbols have special meanings:

             #    file mask edit box            [editfile#     ]
             $    directory variable            [editfile$     ]

        Anything not appearing within square brackets is displayed as text.







         ________________________________________________________________
                                                                      102

                                                                DialogBox
         ________________________________________________________________


        Example:
         DialogBox("Edit a file", "edit.wdg")
         If backup == 0 Then Goto nobackup
         filebackupname = StrCat(FileRoot(editfile), ".", "bak")
         FileCopy(editfile, filebackupname, @TRUE)
         :nobackup
         If prog == 1 Then Run("notepad.exe", editfile)
         If prog == 2 Then Run("c:\win\apps\winedit.exe", editfile)

        Here is the template file, EDIT.WDG:

         [editfile$       ]
              File mask [editfile#    ]
         [editfile\                      ]
         [editfile\                      ]
         [editfile\                      ]
         [editfile\                      ]
         [editfile\                      ]
         [backup+1Save backup of file]
         [prog^1Notepad]     [prog^2WinEdit]


        See Also:
           AskLine, AskPassword, AskYesNo, Dialog, ItemSelect



























         ________________________________________________________________
                                                                      103

                                                                DirChange
         ________________________________________________________________




        DirChange
        Changes the current directory.  Can also log a new drive.


        Syntax:
         DirChange ([d:]path)

        Parameters:
         (s) [d:]     an optional disk drive to log onto.
         (s) path     the desired path.

        Returns:
         (i)          @TRUE if directory was changed;
                      @FALSE if the path could not be found.

        Use this function to change the current working directory to
        another directory, either on the same or a different disk drive.


        Example:
         DirChange("c:\")
         TextBox("This is your CONFIG.SYS file", "config.sys")


        See Also:
           DirGet, DirHome, LogDisk























         ________________________________________________________________
                                                                      104

                                                                   DirGet
         ________________________________________________________________




        DirGet
        Gets the current working directory.


        Syntax:
         DirGet ( )

        Parameters:
         (none)

        Returns:
         (s)          current working directory.

        Use this function to determine which directory we are currently in.
        It's especially useful when changing drives or directories
        temporarily.


        Example:
         ; Get, then restore current working directory
         origdir = DirGet()
         DirChange("c:\")
         FileCopy("config.sys", "%origdir%xxxtemp.xyz", @FALSE)
         DirChange(origdir)


        See Also:
           CurrentFile, DirHome, DirWindows





















         ________________________________________________________________
                                                                      105

                                                                  DirHome
         ________________________________________________________________




        DirHome
        Returns directory containing the WIL Interpreter's executable
        files.


        Syntax:
         DirHome ( )

        Parameters:
         (none)

        Returns:
         (s)          pathname of the home directory.

        Use this function to determine the directory where the current WIL
        Interpreter's executable files are stored.


        Example:
         a = DirHome()
         Message("WIL Executable is in ", a)


        See Also:
           DirGet, DirWindows
























         ________________________________________________________________
                                                                      106

                                                               DirItemize
         ________________________________________________________________




        DirItemize
        Returns a space-delimited list of directories.


        Syntax:
         DirItemize (dir-list)

        Parameters:
         (s) dir-list    a string containing a set of subdirectory names,
                         which may be wildcarded.

        Returns:
         (s)             list of directories.

        This function compiles a list of subdirectories and separates the
        names with spaces.

        This is especially useful in conjunction with the ItemSelect
        function, which enables the user to choose an item from such a
        space-delimited list.

        DirItemize("*.*") returns all subdirectories under the current
        directory.

        Note: Some shell or file manager applications using the WIL
        Interpreter allow an empty string ("") to be used as the "dir-list"
        parameter, in which case all subdirectories highlighted in the file
        display are returned.  However, if there are any directory names or
        wildcards in the string, all subdirectories matching the pathnames
        are returned, regardless of which ones are highlighted.


        Example:
         a = DirItemize("*.*")
         ItemSelect("Directories", a, " ")


        See Also:
           CurrentFile, FileItemize, ItemSelect, TextSelect, WinItemize










         ________________________________________________________________
                                                                      107

                                                                  DirMake
         ________________________________________________________________




        DirMake
        Creates a new directory.


        Syntax:
         DirMake ([d:]path)

        Parameters:
         (s) [d:]     the desired disk drive.
         (s) path     the path to create.

        Returns:
         (i)          @TRUE if the directory was successfully created;
                      @FALSE if it wasn't.

        Use this function to create a new directory.


        Example:
         DirMake("c:\xxxstuff")


        See Also:
           DirRemove, DirRename

























         ________________________________________________________________
                                                                      108

                                                                DirRemove
         ________________________________________________________________




        DirRemove
        Removes a directory.


        Syntax:
         DirRemove (dir-list)

        Parameters:
         (s) dir-list   a space-delimited list of directory pathnames.

        Returns:
         (i)            @TRUE if the directory was successfully removed;
                        @FALSE if it wasn't.

        Use this function to delete directories.  You can delete one or
        more at a time by separating directory names with spaces.  You
        cannot, however, use wildcards.


        Examples:
         DirRemove("c:\xxxstuff")

         DirRemove("tempdir1 tempdir2 tempdir3")


        See Also:
           DirMake, DirRename






















         ________________________________________________________________
                                                                      109

                                                                DirRename
         ________________________________________________________________




        DirRename
        Renames a directory.


        Syntax:
         DirRename ([d:]oldpath, [d:]newpath)

        Parameters:
         (s) oldpath    existing directory name, with optional drive.
         (s) newpath    new name for directory.

        Returns:
         (i)            @TRUE if the directory was successfully renamed;
                        @FALSE if it wasn't.


        Example:
         DirRename("c:\temp", "c:\work")


        See Also:
           DirMake, DirRemove



























         ________________________________________________________________
                                                                      110

                                                               DirWindows
         ________________________________________________________________




        DirWindows
        Returns the name of the Windows or Windows System directory.


        Syntax:
         DirWindows (request#)

        Parameters:
         (i) request#    see below.


        Returns:
         (s)             directory name.

        This function returns the name of either the Windows directory or
        the Windows System directory, depending on the request# specified.

           Req#   Return value

           0      Windows directory
           1      Windows System directory


        Example:
         DirChange(DirWindows(0))
         ini = ItemSelect("Select file to edit", FileItemize("*.ini"), " ")
         Run("notepad.exe", ini)


        See Also:
           DirGet, DirHome


















         ________________________________________________________________
                                                                      111

                                                                 DiskFree
         ________________________________________________________________




        DiskFree
        Finds the total space available on a group of drives.


        Syntax:
         DiskFree (drive-list)

        Parameters:
         (s) drive-list     one or more drive letters, separated by spaces.

        Returns:
         (i)                the number of bytes available on all the
                            specified drives.

        This function takes a string consisting of drive letters, separated
        by spaces.  Only the first character of each non-blank group of
        characters is used to determine the drives, so you can use just the
        drive letters, or add a colon (:), or add a backslash (\), or even
        a whole pathname, and still get a perfectly valid result.


        Example:
         size = DiskFree("c d")
         Message("Space Available on C: and D:", size)


        See Also:
           DiskScan, FileSize





















         ________________________________________________________________
                                                                      112

                                                                 DiskScan
         ________________________________________________________________




        DiskScan
        Returns list of drives.


        Syntax:
         DiskScan (request#)

        Parameters:
         (i) request#   see below.

        Returns:
         (s)            drive list.

        Scans disk drives on the system, and returns a space-delimited list
        of drives of the type specified by request#, in the form "A: B: C:
        D: ".

        The request# is a bitmask, so adding the values together (except
        for 0) returns all drive types specified; eg., a request# of 3
        returns floppy plus local hard drives.

           Req#   Return value

           0      List of unused disk IDs
           1      List of removable (floppy) drives
           2      List of local fixed (hard) drives
           4      List of remote (network) drives


        Example:
         hd = DiskScan(2)
         Message("Hard drives on system", hd)


        See Also:
           DiskFree, LogDisk













         ________________________________________________________________
                                                                      113

                                                                  Display
         ________________________________________________________________




        Display
        Displays a message to the user for a specified period of time.


        Syntax:
         Display (seconds, title, text)

        Parameters:
         (i) seconds    seconds to display the message (1-3600).
         (s) title      title of the window to be displayed.
         (s) text       text of the window to be displayed.

        Returns:
         (i)            @TRUE if terminated by user; @FALSE otherwise.

        Use this function to display a message for a few seconds, and then
        continue processing without user input.

        Seconds must be an integer between 1 and 3600.  Smaller or larger
        numbers will be adjusted accordingly.

        The user can make the displayed message disappear before the
        designated time has elapsed by clicking a mouse button, or by
        pressing any key.  If the user terminates the function in this
        manner, it will return a value of @TRUE; otherwise, it will return
        @FALSE.


        Example:
         Display(3, "Current window is", WinGetActive())

        which produces something like this:

              ............................
              .     Current window is    .
              ............................
              .                          .
              .        COMMAND POST      .
              ............................

        See Also:
           Message, Pause







         ________________________________________________________________
                                                                      114

                                                               DOSVersion
         ________________________________________________________________




        DOSVersion
        Returns the version numbers of the current version of DOS.


        Syntax:
         DOSVersion (level)

        Parameters:
         (i) level    @MAJOR or @MINOR.

        Returns:
         (i)          integer or decimal part of DOS version number.

        @MAJOR returns the integer part (to the left of the decimal).
        @MINOR returns the decimal part (to the right of the decimal).

        If the version of DOS in use is 5.0, then:

           DOSVersion(@MAJOR)    ==   5
           DOSVersion(@MINOR)    ==   0


        Example:
         i = DOSVersion(@MAJOR)
         d = DOSVersion(@MINOR)
         If StrLen(d) == 1 Then d = StrCat("0", d)
         Message("DOS Version", "%i%.%d%")


        See Also:
           Environment, Version, WinVersion


















         ________________________________________________________________
                                                                      115

                                                                     Drop
         ________________________________________________________________




        Drop
        Removes variables from memory.


        Syntax:
         Drop (var, [var...])

        Parameters:
         (i) var      variable names to remove.

        Returns:
         (i)          always 1.

        This function removes variables from the WIL Interpreter's variable
        list, and recovers the memory associated with the variable (and
        possibly related string storage).

        A variable is defined the first time it appears to the left of an
        equal sign in a statement.  It stays defined until it is explicitly
        dropped with the Drop function, or until the current invocation of
        the WIL Interpreter gets closed.

        Generally speaking: in batch file-based implementations of WIL, all
        variables are dropped automatically at the end of every batch file;
        and in menu-based implementations of WIL, variables stay defined
        until explicitly dropped.


        Example:
         a = "A variable"
         b = "Another one"
         Drop(a, b)       ; This removes A and B from memory


        See Also:
           IsDefined













         ________________________________________________________________
                                                                      116

                                                                     Else
         ________________________________________________________________




        Else
        Continues a previous If statement.


        Syntax:
         Else statement

        Parameters:
         (s) statement any valid WIL function or command.

        This command continues the last-encountered If command.  It allows
        the user to specify an alternate action to be taken if the If
        condition was false.  If the previous If condition was false, the
        statement following the Else keyword is executed.  If the previous
        If condition was true, the statement following the Else keyword is
        ignored.


        Example:
         windir = DirWindows(0)
         inifiles = FileItemize("%windir%*.ini")
         ini = ItemSelect("INI file to edit", inifiles, " ")
         If ini == "" Then Exit
         Else Run("notepad.exe", ini)


        See Also:
           Goto, If ... Then, Then





















         ________________________________________________________________
                                                                      117

                                                               EndSession
         ________________________________________________________________




        EndSession
        Ends the Windows session.


        Syntax:
         EndSession ( )

        Parameters:
         (none)

        Returns:
         (i)          always 0.

        Use this command to end the current Windows session, just like
        selecting Close from Program Manager's control menu.  If any active
        applications pop up dialog boxes in response to this command (such
        as prompting to save data files which have changed), the user will
        need to respond to them before Windows will close.


        Example:
         sure = AskYesNo ("End Session", "You SURE you want to exit
             Windows?")
         If sure == @No Then Goto cancel
         EndSession()
         :cancel
         Message("", "Exit Windows canceled")


        See Also:
           Exit, WinClose, WinCloseNot


















         ________________________________________________________________
                                                                      118

                                                              Environment
         ________________________________________________________________




        Environment
        Gets a DOS environment variable.


        Syntax:
         Environment (env-variable)

        Parameters:
         (s) env-variable    any defined environment variable.

        Returns:
         (s)                 environment variable contents.

        Use this function to get the value of a DOS environment variable.

        Note: It is not possible to change a DOS environment variable from
        within Windows.


        Example:
         ; Display the PATH for this DOS session
         currpath = Environment("PATH")
         Message("Current DOS Path", currpath)


        See Also:
           IniRead, Version, WinMetrics, WinParmGet






















         ________________________________________________________________
                                                                      119

                                                                ErrorMode
         ________________________________________________________________




        ErrorMode
        Specifies how to handle errors.


        Syntax:
         ErrorMode (mode)

        Parameters:
         (i) mode     @CANCEL or @NOTIFY or @OFF.

        Returns:
         (i)          previous error setting.

        Use this function to control the effects of runtime errors.  The
        default is @CANCEL, meaning the execution of the WIL program will
        be canceled upon any error.

        @CANCEL:  All runtime errors will cause execution to be canceled.
        The user will be notified which error occurred.

        @NOTIFY:  All runtime errors will be reported to the user, and the
        user can choose to continue if it isn't fatal.

        @OFF:  Minor runtime errors will be suppressed. Moderate and fatal
        errors will be reported to the user.  User has the option of
        continuing if the error is not fatal.

        In general, we suggest the normal state of the program should be
        ErrorMode(@CANCEL), especially if you are writing a WIL program for
        others to use.  You can always suppress errors you expect will
        occur and then re-enable ErrorMode (@CANCEL).


        Example:
         ; Delete xxxtest.xyz.  If file doesn't exist,
         ; continue execution; don't stop
         prevmode = ErrorMode(@OFF)
         FileDelete("c:\xxxtest.xyz")
         ErrorMode(prevmode)


        See Also:
           Debug, Execute, LastError






         ________________________________________________________________
                                                                      120

                                                                Exclusive
         ________________________________________________________________




        Exclusive
        Controls whether or not other Windows programs will get any time to
        execute.


        Syntax:
         Exclusive (mode)

        Parameters:
         (i) mode     @ON or @OFF.

        Returns:
         (i)          previous Exclusive mode.

        Exclusive(@OFF) is the default mode.  In this mode,the WIL
        Interpreter is well-behaved toward other Windows applications.

        Exclusive(@ON) allows WIL programs to run somewhat faster, but
        causes the WIL Interpreter to be "greedier" about sharing
        processing time with other active Windows applications.  For the
        most part, this mode is useful only when you have a series of WIL
        statements which must be executed in quick succession.


        Example:
         Exclusive(@ON)
         x = 0
         start = DateTime()
         :add
         x = x + 1
         If x < 1000 Then Goto add
         stop = DateTime()
         crlf = StrCat(Num2Char(13), Num2Char(10))
         Message("Times", "Start: %start%%crlf%Stop:  %stop%")
         Exclusive(@OFF)


        See Also:
           Yield










         ________________________________________________________________
                                                                      121

                                                                  Execute
         ________________________________________________________________




        Execute
        Executes a statement in a protected environment.  Any errors
        encountered are recoverable.


        Syntax:
         Execute statement

        Parameters:
         (s) statement    any executable WIL statement.

        Returns:
         (not applicable)

        Use this command to execute computed or user-entered statements.
        Due to the built-in error recovery associated with Execute, it is
        ideal for interactive execution of user-entered commands.

        Note that the Execute command doesn't operate on a string, per se,
        but rather on a direct statement.  If you want to put a code
        segment into a string variable, you must use the substitution
        feature of the language, as in the example below.


        Example:
         cmd = ""
         cmd = AskLine("WIL Interactive", "Command:", cmd)
         Execute %cmd%


        See Also:
           ErrorMode

















         ________________________________________________________________
                                                                      122

                                                                     Exit
         ________________________________________________________________




        Exit
        Unconditionally ends a WIL program.


        Syntax:
         Exit

        Parameters:
         (none)

        Returns:
         (not applicable)

        Use this command to immediately terminate a WIL program.  An Exit
        is implied at the end of each WIL program, and so is not necessary
        there.


        Example:
         a = 100
         Message("The value of a is", a)
         Exit


        See Also:
           Pause, Return, Terminate























         ________________________________________________________________
                                                                      123

                                                               FileAppend
         ________________________________________________________________




        FileAppend
        Appends one or more files to another file.


        Syntax:
         FileAppend (source-list, destination)

        Parameters:
         (s) source-list    a string containing one or more filenames,
                            which may be wildcarded.
         (s) destination    target file name.

        Returns:
         (i)          @TRUE if all files were appended successfully;
                      @FALSE if at least one file wasn't appended.

        Use this function to append an individual file or a group of files
        to the end of an existing file.  If destination does not exist, it
        will be created.

        The file(s) specified in source-list will not be modified by this
        function.

        Source-list may contain * and ? wildcards.  Destination may not
        contain wildcards of any type; it must be a single file name.


        Examples:
         FileAppend("c:\config.sys", "c:\misc\config.sav")

         DirChange("c:\batch")
         FileDelete("allbats.fil")
         FileAppend("*.bat", "allbats.fil")


        See Also:
           FileCopy, FileDelete, FileExist












         ________________________________________________________________
                                                                      124

                                                              FileAttrGet
         ________________________________________________________________




        FileAttrGet
        Returns file attributes.


        Syntax:
         FileAttrGet (filename)

        Parameters:
         (s) filename file whose attributes you want to determine.

        Returns:
         (s)          attribute settings.

        Returns attributes for the specified file, in a string of the form
        "RASH".  This string is composed of four individual attribute
        characters, as follows:

           Char   Symbol    Meaning

           1      R    Read-only ON
           2      A    Archive ON
           3      S    System ON
           4      H    Hidden ON

        A hyphen in any of these positions indicates that the specified
        attribute is OFF.  For example, the string "-A-H" indicates a file
        which has the Archive and Hidden attributes set.


        Example:
         editfile = "c:\config.sys"
         attr = FileAttrGet(editfile)
         If StrSub(attr, 1, 1) == "R" Then Goto readonly
         Run("notepad.exe", editfile)
         Exit
         :readonly
         Message("File is read-only", "Cannot edit %editfile%")


        See Also:
           FileAttrSet, FileTimeGet








         ________________________________________________________________
                                                                      125

                                                              FileAttrSet
         ________________________________________________________________




        FileAttrSet
        Sets file attributes.


        Syntax:
         FileAttrSet (file-list, settings)

        Parameters:
         (s) file-list space-delimited list of files.
         (s) settings new attribute settings for those file(s).

        Returns:
         (i)          always 0.

        The attribute string consists of one or more of the following
        characters (an upper case letter turns the specified attribute ON,
        a lower case letter turns it OFF):

           R read only ON
           A archive   ON
           S system    ON
           H hidden    ON

           r read only OFF
           a archive   OFF
           s system    OFF
           h hidden    OFF


        Examples:
         FileAttrSet("win.ini system.ini", "rAsH")

         FileAttrSet("c:\command.com", "R")


        See Also:
           FileAttrGet, FileTimeTouch












         ________________________________________________________________
                                                                      126

                                                                FileClose
         ________________________________________________________________




        FileClose
        Closes a file.


        Syntax:
         FileClose (filehandle)

        Parameters:
         (i) filehandle     same integer that was returned by FileOpen.

        Returns:
         (i)                always 0.


        Example:
         ; the hard way to copy an ASCII file
         old = FileOpen("config.sys", "READ")
         new = FileOpen("sample.txt", "WRITE")
         :top
         x = FileRead(old)
         If x != "*EOF*" Then FileWrite(new, x)
         If x != "*EOF*" Then Goto top
         FileClose(new)
         FileClose(old)


        See Also:
           FileOpen, FileRead, FileWrite





















         ________________________________________________________________
                                                                      127

                                                                 FileCopy
         ________________________________________________________________




        FileCopy
        Copies files.


        Syntax:
         FileCopy (source-list, destination, warning)

        Parameters:
         (s) source-list    a string containing one or more filenames,
                            which may be wildcarded.
         (s) destination    target file name.
         (i) warning        @TRUE if you want a warning before overwriting
                                  existing files;
                            @FALSE if no warning desired.

        Returns:
         (i)          @TRUE if all files were copied successfully;
                      @FALSE if at least one file wasn't copied.

        Use this function to copy an individual file, a group of files
        using wildcards, or several groups of files by separating the names
        with spaces.

        You can also copy files to any COM or LPT device, but do not place
        a colon after the name of the device.

        Source-list may contain * and ? wildcards.  Destination may contain
        the * wildcard only.


        Examples:
         FileCopy("c:\config.sys", "d:", @FALSE)

         FileCopy("c:\*.sys", "d:devices\*.sys", @TRUE)

         FileCopy("c:\config.sys", "LPT1", @FALSE)


        See Also:
           FileDelete, FileExist, FileLocate, FileMove, FileRename









         ________________________________________________________________
                                                                      128

                                                               FileDelete
         ________________________________________________________________




        FileDelete
        Deletes files.


        Syntax:
         FileDelete (file-list)

        Parameters:
         (s) file-list    a string containing one or more filenames, which
                          may be wildcarded.

        Returns:
         (i)          @TRUE if all the files were deleted;
                      @FALSE if a file didn't exist or is marked with the
                      READ-ONLY attribute.

        Use this function to delete an individual file, a group of files
        using wildcards, or several groups of files by separating the names
        with spaces.


        Example:
         FileDelete("*.bak temp???.fil")


        See Also:
           FileExist, FileLocate, FileMove, FileRename






















         ________________________________________________________________
                                                                      129

                                                                FileExist
         ________________________________________________________________




        FileExist
        Tests for the existence of files.


        Syntax:
         FileExist (filename)

        Parameters:
         (s) filename   either a fully qualified filename with drive and
                        path, or just a filename and extension.

        Returns:
         (i)          @TRUE if the file exists;
                      @FALSE if it doesn't exist or if the pathname is
                      invalid.

        This function is used to test whether or not a specified file
        exists.

        If a fully-qualified file name is used, only the specified drive
        and directory will be checked for the desired file.  If only the
        root and extension are specified, then first the current directory
        is checked for the file, and then, if the file is not found in the
        current directory, all directories in the DOS path are searched.


        Examples:
         ; check for file in current directory
         fex = FileExist(StrCat(DirGet(), "myfile.txt"))
         tex = StrSub("NOT", 1, StrLen("NOT") * fex)
         Message("MyFile.Txt"," Is %tex%in the current directory")

         ; check for file someplace along path
         fex = FileExist("myfile.txt")
         tex = StrSub("NOT", 1, StrLen("NOT") * fex)
         Message("MyFile.Txt", " Is %tex% in the DOS path")


        See Also:
           FileLocate









         ________________________________________________________________
                                                                      130

                                                            FileExtension
         ________________________________________________________________




        FileExtension
        Returns extension of file.


        Syntax:
         FileExtension (filename)

        Parameters:
         (s) filename [optional path]full file name, including extension.

        Returns:
         (s)          file extension.

        This function parses the passed filename and returns the extension
        part of the filename.

        Example:
         ; prevent the user from editing a COM or EXE file
         allfiles = FileItemize("*.*")
         editfile = ItemSelect("Select file to edit", allfiles, " ")
         ext = FileExtension(editfile)
         If (ext == "com") || (ext == "exe") Then Goto noedit
         run("notepad.exe", editfile)
         exit
         :noedit
         Message ("Sorry", "You may not edit a program file")


        See Also:
           Dialog, FilePath, FileRoot



















         ________________________________________________________________
                                                                      131

                                                              FileItemize
         ________________________________________________________________




        FileItemize
        Returns a space-delimited list of files.


        Syntax:
         FileItemize (file-list)

        Parameters:
         (s) file-list    a string containing a list of filenames, which
                          may be wildcarded.

        Returns:
         (s)              space-delimited list of files.

        This function compiles a list of filenames and separates the names
        with spaces.

        This is especially useful in conjunction with the ItemSelect
        function, which lets the user choose an item from such a space-
        delimited list.

        Note: Some shell or file manager applications using the WIL
        Interpreter allow an empty string ("") to be used as the "file-
        list" parameter, in which case all files highlighted in the file
        display are returned.  However, if there are any file names or
        wildcards in the string, all files matching the file names are
        returned, regardless of which ones are highlighted.


        Examples:
         FileItemize("*.bak")         ;all BAK files

         FileItemize("*.arc *.zip *.lzh")  ;compressed files

         ; Get which .INI file to edit
         ifiles = FileItemize("c:\windows\*.ini")
         ifile = ItemSelect(".INI Files", ifiles, " ")
         RunZoom("notepad", ifile)
         Drop(ifiles, ifile)


        See Also:
           CurrentFile, DirItemize, ItemSelect, TextSelect, WinItemize






         ________________________________________________________________
                                                                      132

                                                               FileLocate
         ________________________________________________________________




        FileLocate
        Finds file in current directory or along the DOS path.


        Syntax:
         FileLocate (filename)

        Parameters:
         (s) filename      full file name, including extension.

        Returns:
         (s)               fully-qualified path name.

        This function is used to obtain the fully qualified path name of a
        file.  The current directory is checked first, and if the file is
        not found, the DOS path is searched.  The first occurrence of the
        file is returned.


        Example:
         ; Edit WIN.INI
         winini = FileLocate("win.ini")
         If winini == "" Then Goto notfound
         Run("notepad.exe", winini)
         Exit
         :notfound
         Message("???", "WIN.INI not found")


        See Also:
           FileExist


















         ________________________________________________________________
                                                                      133

                                                                 FileMove
         ________________________________________________________________




        FileMove
        Moves files.


        Syntax:
         FileMove (source-list, destination, warning)

        Parameters:
         (s) source-list    one or more filenames separated by spaces.
         (s) destination    target filename.
         (i) warning        @TRUE if you want a warning before overwriting
                                  existing files;
                            @FALSE if no warning desired.

        Returns:
         (i)          @TRUE if the file was moved;
                      @FALSE if the source file was not found or had the
                      READ-ONLY attribute, or the target filename is
                      invalid.

        Use this function to move an individual file, a group of files
        using wildcards, or several groups of files by separating the names
        with spaces.

        You can move files to another drive.  You can also move a file to a
        COM or LPT port, which would cause the file to be copied to the
        port and then deleted (do not put a colon after the name of the
        port).

        Source-list may contain * and ? wildcards.  Destination may contain
        the * wildcard only.


        Examples:
         FileMove("c:\config.sys", "d:", @FALSE)

         FileMove("c:\*.sys", "d:*.sys", @TRUE)


        See Also:
           FileCopy, FileDelete, FileExist, FileLocate, FileRename








         ________________________________________________________________
                                                                      134

                                                                 FileOpen
         ________________________________________________________________




        FileOpen
        Opens a STANDARD ASCII (only) file for reading or writing.


        Syntax:
         FileOpen (filename, open-type)

        Parameters:
         (s) filename      name of the file to open.
         (s) open-type     "READ" or "WRITE".

        Returns:
         (i)               filehandle

        The filehandle returned by the FileOpen function may be
        subsequently used by the FileRead, FileWrite, and FileClose
        functions.


        Examples:
         ; To open for reading:
         handle = FileOpen("stuff.txt", "READ")

         ; To open for writing:
         handle = FileOpen("stuff.txt", "WRITE")


        See Also:
           FileClose, FileRead, FileWrite




















         ________________________________________________________________
                                                                      135

                                                                 FilePath
         ________________________________________________________________




        FilePath
        Returns path of file.


        Syntax:
         FilePath (filename)

        Parameters:
         (s) filename     fully qualified file name, including path.

        Returns:
         (s)              fully qualified path name.


        FilePath parses the passed filename and returns the drive and path
        of the file specification, if any.

        Example:
         coms = Environment("COMSPEC")
         compath = FilePath(coms)
         Message("", "Your command processor is located in %compath%")


        See Also:
           FileExtension, FileRoot
























         ________________________________________________________________
                                                                      136

                                                                 FileRead
         ________________________________________________________________




        FileRead
        Reads data from a file.


        Syntax:
         FileRead (filehandle)

        Parameters:
         (i) filehandle     same integer that was returned by FileOpen.

        Returns:
         (s)                line of data read from file.


        When the end of the file is reached, the string *EOF* will be
        returned.


        Example:
         handle = FileOpen("autoexec.bat", "READ")
         :readnext
         line = FileRead(handle)
         Display(4, "AUTOEXEC DATA", line)
         If line != "*EOF*" Then Goto readnext
         FileClose(handle)


        See Also:
           FileClose, FileOpen, FileWrite




















         ________________________________________________________________
                                                                      137

                                                               FileRename
         ________________________________________________________________




        FileRename
        Renames files.


        Syntax:
         FileRename (source-list, destination)

        Parameters:
         (s) source-list    one or more filenames, separated by spaces.
         (s) destination    target filename.

        Returns:
         (i)          @TRUE if the file was renamed;
                      @FALSE if the source file was not found or had the
                      READ-ONLY attribute, or the target filename is
                      invalid.

        Use this function to rename an individual file, a group of files
        using wildcards, or several groups of files by separating the names
        with spaces.

        Note: Unlike FileMove, you cannot make a file change its resident
        disk drive with FileRename.

        Source-list may contain * and ? wildcards.  Destination may contain
        the * wildcard only.


        Examples:
         FileRename("c:\config.sys", "config.old")

         FileRename("c:\*.txt", "*.bak")


        See Also:
           FileCopy, FileExist, FileLocate, FileMove













         ________________________________________________________________
                                                                      138

                                                                 FileRoot
         ________________________________________________________________




        FileRoot
        Returns root of file.


        Syntax:
         FileRoot (filename)

        Parameters:
         (s) filename   [optional path]full file name, including extension

        Returns:
         (s)            file root.


        FileRoot parses the passed filename and returns the root part of
        the filename.


        Example:
         allfiles = FileItemize("*.*")
         editfile = ItemSelect("Select file to edit", allfiles, " ")
         root = FileRoot(editfile)
         ext = FileExtension(editfile)
         lowerext = StrLower(ext)
         nicefile = StrCat(root, ".", lowerext)
         Message("", "You are about to edit %nicefile%.")
         Run("notepad.exe", editfile)


        See Also:
           FileExtension, FilePath


















         ________________________________________________________________
                                                                      139

                                                                 FileSize
         ________________________________________________________________




        FileSize
        Finds the total size of a group of files.


        Syntax:
         FileSize (file-list)

        Parameters:
         (s) file-list     zero or more filenames, separated by spaces.

        Returns:
         (i)               total bytes taken up by the specified file(s).

        This function returns the total size of the specified files.  Note
        that it doesn't handle wildcarded filenames.  You can, however, use
        FileItemize on a wildcarded filename and use the resulting string
        as a FileSize parameter.


        Example:
         size = FileSize(FileItemize("*.*"))
         Message("Size of All Files in Directory", size)


        See Also:
           DiskFree























         ________________________________________________________________
                                                                      140

                                                              FileTimeGet
         ________________________________________________________________




        FileTimeGet
        Returns file date and time.


        Syntax:
         FileTimeGet (filename)

        Parameters:
         (s) filename     name of file for which you want the date and time

        Returns:
         (s)              file date and time.

        This function will return the date and time of a file, in a pre-
        formatted string.  The format of the string depends on the current
        settings in the [Intl] section of the WIN.INI file:

        mm/dd/yy  hh:mmXX
        dd/mm/yy  hh:mmXX
        yy/mm/dd  hh:mmXX

        Where:
           mm  is the month (e.g. 10)
           dd  is the day of the month (e.g. 23)
           yy  is the year (e.g. 90)
           hh  is the hours
           mm  is the minutes
           XX  is the Day/Night code (e.g. AM or PM)

        Note:  There are two spaces between the date and the time.

        The WIN.INI file will be examined to determine which format to use.
        You can adjust the WIN.INI file via the International icon in
        Control Panel if the format isn't what you prefer.


        Example:
         oldtime = FileTimeGet("win.ini")
         Run("notepad.exe", "win.ini")
         WinWaitClose("Notepad - WIN.INI")
         newtime = FileTimeGet("win.ini")
         If StrCmp(oldtime, newtime) == 0 Then Exit
         Message("", "WIN.INI has been changed")


        See Also:
           DateTime, FileAttrGet, FileTimeTouch


         ________________________________________________________________
                                                                      141

                                                            FileTimeTouch
         ________________________________________________________________




        FileTimeTouch
        Sets file(s) to current time.


        Syntax:
         FileTimeTouch (file-list)

        Parameters:
         (s) file-list     a space-delimited list of files

        Returns:
         (i)               always 0

        File-list is a space-delimited list of files, which may not contain
        wildcards.  The path is searched if the file is not found in
        current directory and if the directory is not specified in file-
        list.


        Example:
         FileTimeTouch("wac.c wac.rc")
         Run("make.exe", "-fwac.mak")


        See Also:
           FileAttrSet, FileTimeGet























         ________________________________________________________________
                                                                      142

                                                                FileWrite
         ________________________________________________________________




        FileWrite
        Writes data to a file.


        Syntax:
         FileWrite (filehandle, output-data)

        Parameters:
         (i) filehandle     same integer that was returned by FileOpen.
         (s) output-data    data to write to file.

        Returns:
         (i)                always 0.



        Example:
         handle = FileOpen("stuff.txt", "WRITE")
         FileWrite(handle, "Gobbledygook")
         FileClose(handle)


        See Also:
           FileClose, FileOpen, FileRead

























         ________________________________________________________________
                                                                      143

                                                                     Goto
         ________________________________________________________________




        Goto
        Changes the flow of control in a WIL program.


        Syntax:
         Goto label

        Parameters:
         (s) label    user-defined identifier.

        Goto label causes an unconditional branch to the line in the
        program marked :label, where the identifier is preceded by a colon
        (:).


        Example:
         If WinExist("Solitaire") == @FALSE Then Goto open
         WinActivate("Solitaire")
         Goto loaded
         :open
         Run("sol.exe", "")
         :loaded


        See Also:
           Else, If ... Then, Then























         ________________________________________________________________
                                                                      144

                                                              IconArrange
         ________________________________________________________________




        IconArrange
        Rearranges icons.


        Syntax:
         IconArrange ( )

        Parameters:
         (none)

        Returns:
         (i)          always 0.

        This function rearranges the icons at the bottom of the screen,
        spacing them evenly.  It does not change the order in which the
        icons appear.


        Example:
         IconArrange ( )


        See Also:
           RunIcon, WinArrange, WinIconize, WinPlaceSet

























         ________________________________________________________________
                                                                      145

                                                                If...Then
         ________________________________________________________________




        If...Then
        Conditionally performs a function.


        Syntax:
         If condition Then statement

        Parameters:
         (s) condition     an expression to be evaluated.
         (s) statement     any valid WIL function or command.

        If the condition following the If keyword is true, the statement
        following the Then keyword is executed.  If the condition following
        the If keyword is false, the statement following the Then keyword
        is ignored.

        See the Else and Then commands for additional flexibility in
        conditional processing.


        Example:
         sure = AskYesNo("End Session", "Really quit Windows?")
         If sure == @YES Then EndSession()


        See Also:
           Else, Goto, Then






















         ________________________________________________________________
                                                                      146

                                                              IgnoreInput
         ________________________________________________________________




        IgnoreInput
        Turns off hardware input to windows.


        Syntax:
         IgnoreInput (mode)

        Parameters:
         (i) mode     @TRUE or @FALSE.

        Returns:
         (i)          previous IgnoreInput mode.


        IgnoreInput causes mouse movements, clicks and keyboard entry to be
        completely ignored.  Good for self-running demos.

        Warning: If you are not careful with the use of IgnoreInput, you
        can easily lock up your computer!


        Example:
         username = AskLine("Hello", "Please enter your name","")
         IgnoreInput(@TRUE)
         Call("demo.wbt", username)
         IgnoreInput(@FALSE)


        See Also:
           WaitForKey



















         ________________________________________________________________
                                                                      147

                                                                IniDelete
         ________________________________________________________________




        IniDelete
        Removes a line or section from WIN.INI.


        Syntax:
         IniDelete (section, keyname)

        Parameters:
         (s) section    the major heading under which the item is located.
         (s) keyname    the name of the item to delete.

        Returns:
         (i)            always 0

        This function will remove the specified line from the specified
        section in WIN.INI.  You can remove an entire section, instead of
        just a single line, by specifying a keyword of @WHOLESECTION.  Case
        is not significant in section or keyname.


        Examples:
         IniDelete("Desktop", "Wallpaper")

         IniDelete("Quicken",@WHOLESECTION)


        See Also:
           IniDeletePvt, IniItemize, IniRead, IniWrite





















         ________________________________________________________________
                                                                      148

                                                             IniDeletePvt
         ________________________________________________________________




        IniDeletePvt
        Removes a line or section from a private INI file.


        Syntax:
         IniDeletePvt (section, keyname, filename)

        Parameters:
         (s) section    the major heading under which the item is located.
         (s) keyname    the name of the item to delete.
         (s) filename   name of the INI file.

        Returns:
         (i)            always 0.

        This function will remove the specified line from the specified
        section in a private INI file.  You can remove an entire section,
        instead of just a single line, by specifying a keyword of
        @WHOLESECTION.  Case is not significant in section or keyname.


        Example:
         IniDeletePvt("Current Users", "Excel", "meter.ini")


        See Also:
           IniDelete, IniItemizePvt, IniReadPvt, IniWritePvt






















         ________________________________________________________________
                                                                      149

                                                               IniItemize
         ________________________________________________________________




        IniItemize
        Lists keywords or sections in WIN.INI.


        Syntax:
         IniItemize (section)

        Parameters:
         (s) section    the major heading to itemize.

        Returns:
         (s)            list of keywords or sections.

        IniItemize will scan the specified section in WIN.INI, and return a
        tab-delimited list of all keyword names contained within that
        section.  If a null string ("") is given as the section name,
        IniItemize will return a list of all section names contained within
        WIN.INI.  It returns the string "(NONE)" if the specified section
        does not exist, and returns a null string ("") if the section
        exists but is empty.  Case is not significant in section names.


        Examples:
         ; Returns all keywords in the [Extensions] section
         keywords = IniItemize("Extensions")

         ; Returns all sections in the entire WIN.INI file
         sections = IniItemize("")


        See Also:
           IniDelete, IniItemizePvt, IniRead, IniWrite

















         ________________________________________________________________
                                                                      150

                                                            IniItemizePvt
         ________________________________________________________________




        IniItemizePvt
        Lists keywords or sections in a private INI file.


        Syntax:
         IniItemizePvt (section, filename)

        Parameters:
         (s) section     the major heading to itemize.
         (s) filename    name of the INI file.

        Returns:
         (s)             list of keywords or sections.

        IniItemizePvt will scan the specified section in a private INI
        file, and return a tab-delimited list of all keyword names
        contained within that section.  If a null string ("") is given as
        the section name, IniItemizePvt will return a list of all section
        names contained within the file.  It returns the string "(NONE)" if
        the specified section does not exist, and returns a null string
        ("") if the section exists but is empty.  Case is not significant
        in section names.


        Example:
         ; Returns all keywords in the [Boot] section of SYSTEM.INI
         keywords = IniItemizePvt("Boot", "system.ini")


        See Also:
           IniDeletePvt, IniItemize, IniReadPvt, IniWritePvt


















         ________________________________________________________________
                                                                      151

                                                                  IniRead
         ________________________________________________________________




        IniRead
        Reads data from the WIN.INI file.


        Syntax:
         IniRead (section, keyname, default)

        Parameters:
         (s) section     the major heading to read the data from.
         (s) keyname     the name of the item to read.
         (s) default     string to return if the desired item is not found.

        Returns:
         (s)             data from WIN.INI file.

        This function allows a program to read data from the WIN.INI file.

        The WIN.INI file has the form:

           [section]
           keyname=settings


        Most of the entries in WIN.INI are set from the Windows Control
        Panel program, but individual applications can also use it to store
        option settings in their own sections.


        Example:
         ; Find the default output device
         a = IniRead("windows", "device", "No Default")
         Message("Default Output Device", a)


        See Also:
           Environment, IniDelete, IniItemize, IniReadPvt, IniWrite













         ________________________________________________________________
                                                                      152

                                                               IniReadPvt
         ________________________________________________________________




        IniReadPvt
        Reads data from a private INI file.


        Syntax:
         IniReadPvt (section, keyname, default, filename)

        Parameters:
         (s) section     the major heading to read the data from.
         (s) keyname     the name of the item to read.
         (s) default     string to return if the desired item is not found.
         (s) filename    name of the INI file.

        Returns:
         (s)             data from the INI file.

        Looks up a value in the "filename".INI file.  If the value is not
        found, the "default" will be returned.


        Example:
         IniReadPvt("Main", "Lang", "English", "WB.INI")

        Given the following segment from WB.INI:

           [Main]
           Lang=French

        The statement above would return:

           French


        See Also:
           Environment, IniDeletePvt, IniItemizePvt, IniRead, IniWritePvt














         ________________________________________________________________
                                                                      153

                                                                 IniWrite
         ________________________________________________________________




        IniWrite
        Writes data to the WIN.INI file.


        Syntax:
         IniWrite (section, keyname, data)

        Parameters:
         (s) section     major heading to write the data to.
         (s) keyname     name of the data item to write.
         (s) data        string to write to the WIN.INI file.

        Returns:
         (i)             always 1.

        This command allows a program to write data to the WIN.INI file.
        "section" is added to the file if it doesn't already exist.


        Example:
         ; Change the list of pgms to load upon Windows
         ; startup
         loadprogs = IniRead("windows", "load", "")
         newprogs = AskLine("Add Pgm To LOAD= Line", "Add:", loadprogs)
         IniWrite("windows", "load", newprogs)


        See Also:
           IniDelete, IniItemize, IniRead, IniWritePvt




















         ________________________________________________________________
                                                                      154

                                                              IniWritePvt
         ________________________________________________________________




        IniWritePvt
        Writes data to a private INI file.


        Syntax:
         IniWritePvt (section, keyname, data, filename)

        Parameters:
         (s) section     major heading to write the data to.
         (s) keyname     name of the data item to write.
         (s) data        string to write to the INI file.
         (s) filename    name of the INI file.

        Returns:
         (i)             always 1.

        Writes a value in the "filename".INI file.


        Example:
         IniWritePvt("Main", "Lang", "French, "MYFILE.INI")

        This would create the following entry in MYFILE.INI:

           [Main]
           Lang=French


        See Also:
           IniDeletePvt, IniItemizePvt, IniReadPvt, IniWrite



















         ________________________________________________________________
                                                                      155

                                                               IntControl
         ________________________________________________________________




        IntControl
        Internal control functions.


        Syntax:
         IntControl (request#, p1, p2, p3, p4)

        Parameters:
         (i) request#    specifies which sub-function is to be performed
                         (see below).
         (s) p1 - p4     parameters which may be required by the function
                         (see below).

        Returns:
         (s)          varies (see below).

        Short for Internal Control, a special function that permits
        numerous internal operations in the various products.  The first
        parameter of IntControl defines exactly what the function does, the
        other parameters are possible arguments to the function.

        Refer to your product documentation for any further information on
        this function.

        Warning: Many of these operations are useful only under special
        circumstances, and/or by technically knowledgeable users.  Some
        could lead to adverse side effects.  If it isn't clear to you what
        a particular function does, don't use it.


        IntControl (1, p1, 0, 0, 0)
        Just a test IntControl.  It echoes back P1 & P2 and P3 & P4 in a
        pair of message boxes.


        IntControl (4, p1, 0, 0, 0)
        Controls whether or not a dialog box with a file listbox in it has
        to return a file name, or may return merely a directory name or
        nothing.

           P1   Meaning

           0    May return nothing, or just a directory name
           1    Must return a file name (default)


        IntControl (5, p1, 0, 0, 0)
        Controls whether system & hidden files are seen and processed.

         ________________________________________________________________
                                                                      156

                                                               IntControl
         ________________________________________________________________

           P1   Meaning

           0    System & Hidden files not used (default)
           1    System & Hidden files seen and used


        IntControl (10, p1, 0, 0, 0)
        Interrogates the Command Extender DLL status

           P1   Meaning

           0    Command Extender present
                0     No
                1     Yes

           1    Command Extender version
                -1      No Extender present
                 0      Incompatible extender present
                (other) Extender version code

           2    Interpreter's Extender interface code

           3    Name of Extender DLL


        IntControl (20, 0, 0, 0, 0)
        Returns window handle of current parent window.


        IntControl (21, p1, 0, 0, 0)
        Returns window handle of window matching the partial window-name in
        p1.


        IntControl (22, p1, p2, p3, p4)
        Issues a Windows "SendMessage".

           p1   Window handle to send to
           p2   Message ID number (in decimal)
           p3   wParam value
           p4   assumed to be a character string.  String is copied to a
                GMEM_LOWER buffer, and a LPSTR to the copied string is
                passed as lParam. The GMEM_LOWER buffer is freed
                immediately upon return from the SendMessage


        IntControl (23, 0, 0, 0, 0)
        Issues a windows PostMessage

           p1   Window handle
           p2   Message ID number (in decimal)

         ________________________________________________________________
                                                                      157

                                                               IntControl
         ________________________________________________________________

           p3   wParam
           p4   lParam  ---


        IntControl (26, 0, 0, 0, 0)
        Re-assesses the language currently being used (using the method
        described in WWWDLANG.DLL), and makes any necessary changes to the
        language strings used by the WIL Interpreter.  Normally, this is
        done by default at program startup.


        IntControl (66, 0, 0, 0, 0)
        Restarts Windows, just like exiting to DOS and typing WIN again.
        Could be used to restart Windows after editing the SYSTEM.INI file
        to change video modes.


        IntControl (67, 0, 0, 0, 0)
        Performs a warm boot of the system, just like <Ctrl-Alt-Del>.
        Could be used to reboot the system after editing the AUTOEXEC.BAT
        or CONFIG.SYS files.

        Note: IntControl(67) requires Windows 3.1 or higher.  Under Windows
        3.0, it behaves just like IntControl(66) and restarts Windows.




























         ________________________________________________________________
                                                                      158

                                                                IsDefined
         ________________________________________________________________




        IsDefined
        Determines if a variable name is currently defined.


        Syntax:
         IsDefined (var)

        Parameters:
         (s) var      a variable name.

        Returns:
         (i)          @YES if the variable is currently defined;
                      @NO if it was never defined or has been dropped.

        A variable is defined the first time it appears to the left of an
        equal sign in a statement.  It stays defined until it is explicitly
        dropped with the Drop function, or until the current invocation of
        the WIL Interpreter gets closed.

        Generally speaking: in batch file-based implementations of WIL, all
        variables are dropped automatically at the end of every batch file;
        and in menu-based implementations of WIL, variables stay defined
        until explicitly dropped.


        Example:
         def = IsDefined(thisvar)
         If def == @FALSE Then Message("ERROR!", "Variable not defined")


        See Also:
           Drop

















         ________________________________________________________________
                                                                      159

                                                                IsKeyDown
         ________________________________________________________________




        IsKeyDown
        Tells about keys/mouse.

        Syntax:
         IsKeyDown(keycodes)

        Parameters:
         (i) keycodes    @SHIFT and/or @CTRL.

        Returns:
         (i)             @YES if the key is down;
                         @NO if the key is not down.


        Determines if the Shift key or the Ctrl key is currently down.

        Note: The right mouse button is the same as Shift, and the middle
        mouse button is the same as Ctrl.


        Examples:
         IsKeyDown(@SHIFT)

         IsKeyDown(@CTRL)

         IsKeyDown(@CTRL | @SHIFT)

         IsKeyDown(@CTRL & @SHIFT)


        See Also:
           WaitForKey

















         ________________________________________________________________
                                                                      160

                                                               IsLicensed
         ________________________________________________________________




        IsLicensed
        Tells if the calling application is licensed.


        Syntax:
         IsLicensed ( )

        Parameters:
         (none)

        Returns:
         (i)          @YES if it is licensed;
                      @NO if it is not licensed.


        Returns information on whether or not the currently-running version
        of the calling application is a licensed copy.


        Example:
         IsLicensed()


        See Also:
           Version
























         ________________________________________________________________
                                                                      161

                                                       IsMenuChecked {*M}
         ________________________________________________________________




        IsMenuChecked {*M}
        Determines if a menu item has a checkmark next to it.


        Syntax:
         IsMenuChecked (menuname)

        Parameters:
         (s) menuname   name of the menu item to test.

        Returns:
         (i)            @YES if the menu item has a checkmark;
                        @NO if it doesn't.

        You can place a checkmark next to a menu item with the MenuChange
        command, to indicate an option has been enabled.  This function
        lets you determine if the menu item has already been checked or
        not.

        Note: This command is not part of the WIL Interpreter package, but
        is documented here because it has been implemented in many of the
        shell or file manager-type applications which use the WIL
        Interpreter.


        Example:
         ; assume we've defined a "Misc | Prompt Often" menu item
         prompt = IsMenuChecked("MiscPromptOften")
         ifprompt = SubStr(";", 1, (prompt == @FALSE))
         Execute %ifprompt% confirm = AskYesNo("???", "REALLY do this?")
         ; some risky operation the user has just confirmed they want to do
         Execute %ifprompt% Terminate(confirm != @YES, "", "")


        See Also:
           IsMenuEnabled, MenuChange













         ________________________________________________________________
                                                                      162

                                                       IsMenuEnabled {*M}
         ________________________________________________________________




        IsMenuEnabled {*M}
        Determines if a menu item has been enabled.


        Syntax:
         IsMenuEnabled (menuname)

        Parameters:
         (s) menuname name of the menu item to test.

        Returns:
         (i)          @YES if the menu item is enabled;
                      @NO if it is disabled & grayed.

        You can disable a menu item with the MenuChange command if you want
        to prevent the user from choosing it.  It shows up on the screen as
        a grayed item.  IsMenuEnabled lets you determine if the menu item
        is currently enabled or not.

        Note: This command is not part of the WIL Interpreter package, but
        is documented here because it has been implemented in many of the
        shell or file manager-type applications which use the WIL
        Interpreter.


        Example:
         ; allow editing of autoexec.bat file only if choice enabled
         Terminate(!IsMenuEnabled("UtilitiesEditBatFile"), "", "")
         Run("notepad.exe", "c:\autoexec.bat")


        See Also:
           IsMenuChecked, MenuChange
















         ________________________________________________________________
                                                                      163

                                                                 IsNumber
         ________________________________________________________________




        IsNumber
        Determines whether a variable contains a valid number.


        Syntax:
         IsNumber (string)

        Parameters:
         (s) string   string to test to see if it represents a valid
                      number.

        Returns:
         (i)          @YES if it contains a valid number;
                      @NO if it doesn't.

        This function determines if a string variable contains a valid
        integer.  Useful for checking user input prior to using it in
        computations.


        Example:
         a = AskLine("ISNUMBER", "Enter a number", "0")
         If IsNumber(a) == @NO Then Message("", "You didn't enter a
             number")


        See Also:
           Abs, Char2Num, Num2Char





















         ________________________________________________________________
                                                                      164

                                                                ItemCount
         ________________________________________________________________




        ItemCount
        Returns the number of items in a list.


        Syntax:
         ItemCount (list, delimiter)

        Parameters:
         (s) list         a string containing a list of items.
         (s) delimiter    a character to act as a delimiter between items
                          in the list.

        Returns:
         (i)              the number of items in the list.

        If you create the list with the FileItemize or DirItemize functions
        you will be using a space-delimited list.  WinItemize, however,
        creates a tab-delimited list of window titles since titles can have
        embedded spaces.


        Example:
         a = FileItemize("*.*")
         n = ItemCount(a, " ")
         Message("Note", "There are %n% files")


        See Also:
           ItemExtract, ItemSelect




















         ________________________________________________________________
                                                                      165

                                                              ItemExtract
         ________________________________________________________________




        ItemExtract
        Returns the selected item from a list.


        Syntax:
         ItemExtract (index, list, delimiter)

        Parameters:
         (i) index        the position in list of the item to be selected.
         (s) list         a string containing a list of items.
         (s) delimiter    a character to act as a delimiter between items
                          in the list.

        Returns:
         (s)              the selected item.

        If you create the list with the FileItemize or DirItemize functions
        you will be using a space-delimited list.  WinItemize, however,
        creates a tab-delimited list of window titles since titles can have
        embedded blanks.


        Example:
         bmpfiles = FileItemize("*.bmp")
         bmpcount = ItemCount(bmpfiles, " ")
         pos = (Random(bmpcount - 1)) + 1
         paper = ItemExtract(pos, bmpfiles, " ")
         Wallpaper(paper, @FALSE)


        See Also:
           ItemCount, ItemLocate, ItemSelect, ItemSort

















         ________________________________________________________________
                                                                      166

                                                               ItemInsert
         ________________________________________________________________




        ItemInsert
        Adds an item to a list.


        Syntax:
         ItemInsert (item, index, list, delimiter)

        Parameters:
         (s) item         a new item to add to list.
         (i) index        the position in list after which the item will be
                          inserted.
         (s) list         a string containing a list of items.
         (s) delimiter    a character to act as a delimiter between items
                          in the list.

        Returns:
         (s)              new list, with item inserted.

        This function inserts a new item into an existing list, at the
        position following index.  It returns a new list, with the
        specified item inserted; the original list (list) is unchanged.
        For example, specifying an index of 1 causes the new item to be
        inserted after the first item in the list; i.e., the new item
        becomes the second item in the list.

        You can specify an index of 0 to add the item to the beginning of
        the list, and an index of -1 to append the item to the end of the
        list.

        If you create the list with the FileItemize or DirItemize functions
        you will be using a space-delimited list.  WinItemize, however,
        creates a tab-delimited list of window titles since titles can have
        embedded blanks.


        Example:
         newlist = ItemInsert(item, index, list, delimiter)


        See Also:
           ItemCount, ItemRemove








         ________________________________________________________________
                                                                      167

                                                               ItemLocate
         ________________________________________________________________




        ItemLocate
        Returns the position of an item in a list.


        Syntax:
         ItemLocate (item, list, delimiter)

        Parameters:
         (s) item         item to search for in list.
         (s) list         a string containing a list of items.
         (s) delimiter    a character to act as a delimiter between items
                          in the list.

        Returns:
         (i)              position in list of item, or 0 if no match found.

        This function finds the first occurrence of item in the specified
        list, and returns the position of the item (the first item in a
        list has a position of 1).  If the item is not found, the function
        will return a 0.

        If you create the list with the FileItemize or DirItemize functions
        you will be using a space-delimited list.  WinItemize, however,
        creates a tab-delimited list of window titles since titles can have
        embedded blanks.


        Example:
         ItemLocate(item, list, delimiter)


        See Also:
           ItemExtract
















         ________________________________________________________________
                                                                      168

                                                               ItemRemove
         ________________________________________________________________




        ItemRemove
        Removes an item from a list.


        Syntax:
         ItemRemove (index, list, delimiter)

        Parameters:
         (i) index       the position in list of the item to be removed.
         (s) list        a string containing a list of items.
         (s) delimiter   a character to act as a delimiter between items in
                         the list.

        Returns:
         (s)             new list, with item removed.

        This function removes the item at the position specified by index
        from a list.  The delimiter following the item is removed as well.
        It returns a new list, with the specified item removed; the
        original list (list) is unchanged.

        If you create the list with the FileItemize or DirItemize functions
        you will be using a space-delimited list.  WinItemize, however,
        creates a tab-delimited list of window titles since titles can have
        embedded spaces.


        Example:
         newlist = ItemRemove(index, list, delimiter)


        See Also:
           ItemCount, ItemInsert
















         ________________________________________________________________
                                                                      169

                                                               ItemSelect
         ________________________________________________________________




        ItemSelect
        Allows the user to choose an item from a listbox.


        Syntax:
         ItemSelect (title, list, delimiter)

        Parameters:
         (s) title       the title of the dialog box to display.
         (s) list        a string containing a list of items.
         (s) delimiter   a character to act as a delimiter between items in
                         the list.

        Returns:
         (s)             the selected item.

        This function displays a dialog box with a listbox inside.  This
        listbox is filled with a sorted list of items taken from a string
        you provide to the function.

        Each item in the string must be separated ("delimited") by a
        character, which you also pass to the function.

        The user selects one of the items by either doubleclicking on it,
        or single-clicking and pressing OK.  The item is returned as a
        string.

        If you create the list with the FileItemize or DirItemize functions
        you will be using a space-delimited list.  WinItemize, however,
        creates a tab-delimited list of window titles since titles can have
        embedded spaces.


        Example:
         DirChange("c:\winword")
         alldotfiles = FileItemize("*.dot")
         dotfile = ItemSelect("W4W Templates", alldotfiles, " ")
         Run("winword.exe", dotfile)

        Which would produce:









         ________________________________________________________________
                                                                      170

                                                               ItemSelect
         ________________________________________________________________

              ....................................................
              .                    W4W Templates                 .
              ....................................................
              .    ____________________________________________  .
              .   |  WINBATCH.DOT                           |^|  .
              .   |  CMDPOST.DOT                            |x|  .
              .   |  SYSINI.DOT                             |x|  .
              .   |  SYSINI2.DOT                            |x|  .
              .   |  WININI.DOT                             |x|  .
              .   |  WININI2.DOT                            |x|  .
              .   |  NEWSTUFF.DOT                           |x|  .
              .   |  NORMAL.DOT                             |x|  .
              .   |_________________________________________|v|  .
              .                                                  .
              .       [OK]                      [Cancel]         .
              ....................................................


        See Also:
           AskYesNo, Dialog, DirItemize, Display, FileItemize, ItemCount,
           ItemExtract, Message, Pause, TextBox, TextBoxSort, TextSelect,
           WinItemize






























         ________________________________________________________________
                                                                      171

                                                                 ItemSort
         ________________________________________________________________




        ItemSort
        Sorts a list.


        Syntax:
         ItemSort (list, delimiter)

        Parameters:
         (s) list        a string containing a list of items.
         (s) delimiter   a character to act as a delimiter between items in
                         the list.

        Returns:
         (s)             new, sorted list.

        This function sorts a list, using an ANSI sort sequence.  It
        returns a new, sorted list; the original list is unchanged.

        If you create the list with the FileItemize or DirItemize functions
        you will be using a space-delimited list.  WinItemize, however,
        creates a tab-delimited list of window titles since titles can have
        embedded spaces.


        Example:
         newlist = ItemSort(list, delimiter)


        See Also:
           ItemExtract



















         ________________________________________________________________
                                                                      172

                                                                LastError
         ________________________________________________________________




        LastError
        Returns the most-recent error encountered during the current WIL
        program.


        Syntax:
         LastError ( )

        Parameters:
         (none)

        Returns:
         (i)          most-recent WIL error code encountered.

        WIL errors are numbered according to their severity.  "Minor"
        errors go from 1000 through 1999.  Moderate errors are 2000 through
        2999.  Fatal errors are numbered 3000 to 3999.

        Depending on which error mode is active when an error occurs, you
        may not get a chance to check the error code.  See ErrorMode for a
        discussion of default error handling.

        Don't bother checking for "fatal" error codes.  When a fatal error
        occurs, the WIL program is canceled before the next WIL statement
        gets to execute (regardless of which error mode is active).

        Every time the LastError function is called, the "last error"
        indicator is reset to zero.

        A full listing of possible errors you can encounter in processing a
        WIL program is in Appendix B (pg. 279).


        Example:
         ErrorMode(@OFF)
         FileCopy("data.dat", "c:\backups", @FALSE)
         ErrorMode(@CANCEL)
         If LastError() == 1006 Then Message("Error", "Please call  Tech
         Support at 555-9999.")


        See Also:
           Debug, ErrorMode






         ________________________________________________________________
                                                                      173

                                                                  LogDisk
         ________________________________________________________________




        LogDisk
        Logs (activates) a disk drive.


        Syntax:
         LogDisk (drive-letter)

        Parameters:
         (s) drive-letter   the disk drive to log into.

        Returns:
         (i)                @TRUE if the current drive was changed;
                            @FALSE if the drive doesn't exist.

        Use this function to change to a different disk drive.


        Example:
         LogDisk("c:")


        See Also:
           DirChange, DiskScan


























         ________________________________________________________________
                                                                      174

                                                                      Max
         ________________________________________________________________




        Max
        Returns largest number in a list of numbers.


        Syntax:
         Max (integer [, integer...])

        Parameters:
         (i) integer  an integer number.

        Returns:
         (i)          largest parameter.

        Use this function to determine the largest of a set of comma-
        delimited integers.


        Example:
         a = Max(5, -37, 125, 34, 2345, -32767)
         Message("Largest number is", a)


        See Also:
           Abs, Average, Min, Random

























         ________________________________________________________________
                                                                      175

                                                          MenuChange {*M}
         ________________________________________________________________




        MenuChange {*M}
        Checks, unchecks, enables, or disables a menu item.


        Syntax:
         MenuChange (menuname, flags)

        Parameters:
         (s) menuname    menu item whose status you wish to change.
         (s) flags       @CHECK, @UNCHECK, @ENABLE, or @DISABLE.

        Returns:
         (i)          always 1.

        There are currently two ways you can modify a menu item:

        You can check and uncheck the item to imply that it corresponds to
        an option that can be turned on or off.

        You can temporarily disable the item (it shows up as gray) and
        later re-enable it.

        The two sets of flags (@Check/@UnCheck and @Enable/@Disable) can be
        combined in one function call by using the | (or) operator.

        Note: This command is not part of the WIL Interpreter package, but
        is documented here because it has been implemented in many of the
        shell or file manager-type applications which use the WIL
        Interpreter.


        Example:
         MenuChange("FilePrint", @Disable)
         MenuChange("WPWrite", @Enable | @Check)


        See Also:
           IsMenuChecked, IsMenuEnabled











         ________________________________________________________________
                                                                      176

                                                                  Message
         ________________________________________________________________




        Message
        Displays a message to the user.


        Syntax:
         Message (title, text)

        Parameters:
         (s) title    title of the message box.
         (s) text     text to display in the message box.

        Returns:
         (i)          always 1.

        Use this function to display a message to the user.  The user must
        respond by selecting the OK button before processing will continue.


        Example:
         Message("Current directory is", DirGet())

        which produces:

              ...............................
              .     Current directory is    .
              ...............................
              .                             .
              .         C:\WINDOWS          .
              .                             .
              .            [OK]             .
              ...............................


        See Also:
           Display, Pause














         ________________________________________________________________
                                                                      177

                                                                      Min
         ________________________________________________________________




        Min
        Returns lowest number in a list of numbers.


        Syntax:
         Min (integer [, integer...])

        Parameters:
         (i) integer  an integer number.

        Returns:
         (i)          lowest parameter.

        Use this function to determine the lowest of a set of comma-
        delimited integers.


        Example:
         a = Min( 5, -37, 125, 34, 2345, -32767)
         Message("Smallest number is", a)


        See Also:
           Abs, Average, Max, Random

























         ________________________________________________________________
                                                                      178

                                                                MouseInfo
         ________________________________________________________________




        MouseInfo
        Returns assorted mouse information.


        Syntax:
         MouseInfo (request#)

        Parameters:
         (i) request#   see below.

        Returns:
         (s)            see below.

        The information returned by MouseInfo depends on the value of
        request#.

           Req# Return value

           0    Window name under mouse
           1    Top level parent window name under mouse
           2    Mouse coordinates, assuming a 1000x1000 virtual screen
           3    Mouse coordinates in absolute numbers
           4    Status of mouse buttons, as a bitmask:

                  BinaryDecimal  Meaning

                  000   0      No buttons down
                  001   1      Right button down
                  010   2      Middle button down
                  011   3      Right and Middle buttons down
                  100   4      Left button down
                  101   5      Left and Right buttons down
                  110   6      Left and Middle buttons down
                  111   7      Left, Middle, and Right buttons down

        For example, if mouse is at the center of a 640x480 screen and
        above the "Clock" window, and the left button is down, the
        following values would be returned:

           Req# Return value

           1    "Clock"
           2    "500 500"
           3    "320 240"
           4    "4"




         ________________________________________________________________
                                                                      179

                                                                MouseInfo
         ________________________________________________________________


        Example:
         Display(1, "", "Press a mouse button to continue")
         :loop
         buttons = MouseInfo(4)
         If buttons == 0 Then Goto loop
         If buttons & 4 Then Display(1, "", "Left button was pressed")
         If buttons & 1 Then Display(1, "", "Right button was pressed")


        See Also:
           WinMetrics, WinParmGet








































         ________________________________________________________________
                                                                      180

                                                                NetAddCon
         ________________________________________________________________




        NetAddCon
        Connects network resources to imaginary local disk drives or
        printer ports.


        Syntax:
         NetAddCon (net-path, password, local-name)

        Parameters:
         (s) net-path     net resource or string returned by NetBrowse.
         (s) password     password required to access resource, or "".
         (s) local-name   local drive name or printer port.

        Returns:
         (i)          @TRUE if successful; @FALSE if unsuccessful.

        You can use NetAddCon to connect a local drive to a network
        directory, in which case "local-name" will be a drive name (eg,
        "Z:").  You can also connect a local printer port to a network
        print queue, in which case "local-name" will be the name of the
        printer port (eg, "LPT1").

        Use the NetBrowse function to obtain a value for "net-path".

        If no password is required, use a null string ("") for the
        "password" parameter.


        Example:
         availdrive = DiskScan(0)
         drvlen = StrLen(availdrive)
         If drvlen == 0 Then Goto nomore
         availdrive = StrSub(availdrive, drvlen - 2, 2)
         netpath = NetBrowse(0)
         pwd = AskPassword("Enter password for", netpath)
         NetAddCon(netpath, pwd, availdrive)
         Exit
         :nomore
         Message("Connect Drive to Net", "No drives avail for assignment")


        See Also:
           NetAttach, NetBrowse, NetCancelCon, NetGetCon, NetMapRoot






         ________________________________________________________________
                                                                      181

                                                                NetAttach
         ________________________________________________________________




        NetAttach
        Attaches to a network file server.


        Syntax:
         NetAttach (server-name)

        Parameters:
         (s) server-name    name of the network file server.

        Returns:
         (i)                @TRUE if successful; @FALSE if unsuccessful.

        This function may not work with all networks.


        Example:
         NetAttach("userapps")


        See Also:
           NetAddCon, NetDetach, NetLogin



























         ________________________________________________________________
                                                                      182

                                                                NetBrowse
         ________________________________________________________________




        NetBrowse
        Displays a network dialog box allowing the user to select a network
        resource.


        Syntax:
         NetBrowse   (request#)

        Parameters:
         (i) request#   see below.

        Returns:
         (s)            see below.

        Specifying a request# of 0 allows selection of a network directory,
        and specifying a request# of 1 allows selection of a network print
        queue.  This function returns a string that can be used by
        NetAddCon to add a connection.


        Example:
         availdrive = DiskScan(0)
         drvlen = StrLen(availdrive)
         If drvlen == 0 Then Goto nomore
         availdrive = StrSub(availdrive, drvlen - 2, 2)
         netpath = NetBrowse(0)
         pswd = AskPassword("Enter password for", netpath)
         NetAddCon(netpath, pswd, availdrive)
         Exit
         :nomore
         Message("Connect Drive to Net", "No drives avail for assignment")


        See Also:
           NetAddCon, NetMapRoot














         ________________________________________________________________
                                                                      183

                                                             NetCancelCon
         ________________________________________________________________




        NetCancelCon
        Breaks a network connection.


        Syntax:
         NetCancelCon (name, force)

        Parameters:
         (s) name     network resource name or local name.
         (i) force    force flag (see below).

        Returns:
         (i)          @TRUE if successful; @FALSE if unsuccessful.

        If force is set to 0, NetCancelCon will not break the connection if
        any files on that connection are still open.  If force is set to 1,
        the connection will be broken regardless.


        Example:
         availdrive = DiskScan(4)
         n = ItemCount(availdrive, " ")
         If n == 0 Then Exit
         i = 1
         dislist = ""
         :loop
         drv = ItemExtract(i, availdrive, " ")
         dislist = StrCat(drv, Num2Char(9), NetGetCon(drv), "|")
         i = i + 1
         If i < n Then Goto loop
         availdrive = ItemSelect("Disconnect", dislist, "|")
         NetCancelCon(availdrive, 0)


        See Also:
           NetAddCon, NetDetach, NetGetCon













         ________________________________________________________________
                                                                      184

                                                                NetDetach
         ________________________________________________________________




        NetDetach
        Detaches from a network file server.


        Syntax:
         NetDetach (server-name)

        Parameters:
         (s) server-name    name of the network file server.

        Returns:
         (i)                @TRUE if successful; @FALSE if unsuccessful.

        This function may not work with all networks.


        Example:
         NetDetach("userapps")


        See Also:
           NetAttach, NetCancelCon



























         ________________________________________________________________
                                                                      185

                                                                NetDialog
         ________________________________________________________________




        NetDialog
        Brings up the network driver's dialog box.


        Syntax:
         NetDialog ( )

        Parameters:
         (none)

        Returns:
         (i)          @TRUE if successful; @FALSE if unsuccessful.

        A network driver's dialog box displays copyright information, and
        may allow access to the network, depending on the particular
        network driver.  The WIL program will wait until the network dialog
        terminates before continuing.


        Example:
         NetDialog()




























         ________________________________________________________________
                                                                      186

                                                               NetGetCaps
         ________________________________________________________________




        NetGetCaps
        Returns information on network capabilities.


        Syntax:
         NetGetCaps (request#)

        Parameters:
         (i) request#   see below.

        Returns:
         (i)            see below.

        NetGetCaps returns 0 if no network is installed (it is the only
        network function you can use without having a network installed and
        not get an error).

           Req# Return value

           1    Network driver specification number

           2    Type of network installed:
                0        None
                256      MS Network
                512      Lan Manager
                768      Novell NetWare
                1024     Banyan Vines
                1280     10 Net
                (other)  Other network

           3    Network driver version number

           4    Returns 1 if any network is installed

           6    Bitmask indicating whether the network driver supports the
                following connect functions:
                1    AddConnection
                2    CancelConnection
                4    GetConnection
                8    AutoConnect via DOS
                16   BrowseDialog

           7    Bitmask indicating whether the network driver supports the
                following print functions:
                2    Open Print Job
                4    Close Print Job

         ________________________________________________________________
                                                                      187

                                                               NetGetCaps
         ________________________________________________________________

                16   Hold Print Job
                32   Release Print Job
                64   Cancel Print Job
                128  Set number of copies
                256  Watch Print Queue
                512  Unwatch Print Queue
                1024 Lock Queue Data
                2048 Unlock Queue Data
                4096 Driver will send QueueChanged messages to
                     Print Manager
                8192 Abort Print Job


        Example:
         caps = NetGetCaps(6)
         If caps & 16 Then Message("", "Your network supports
         BrowseDialog")

        See Also:
           NetGetUser, WinConfig, WinMetrics, WinParmGet
































         ________________________________________________________________
                                                                      188

                                                                NetGetCon
         ________________________________________________________________




        NetGetCon
        Returns the name of a connected network resource.


        Syntax:
         NetGetCon (local-name)

        Parameters:
         (s) local-name     local drive name or printer port.

        Returns:
         (s)                name of network resource.

        NetGetCon returns the name of the network resource currently
        connected to "local-name".


        Example:
         local = AskLine("NetGetCon", "Enter local drive name", "")
         If local == "" Then Exit
         resource = NetGetCon(local)
         Message("NetGetCon", "%local% is connected to %resource%")


        See Also:
           NetAddCon, NetCancelCon























         ________________________________________________________________
                                                                      189

                                                               NetGetUser
         ________________________________________________________________




        NetGetUser
        Returns the name of the user currently logged into the network.


        Syntax:
         NetGetUser ( )

        Parameters:
         (none)

        Returns:
         (s)          name of current user.


        Example:
         IniWritePvt("Current Users", "Excel", NetGetUser(),
         "usagelog.ini")
         Run("excel.exe", "")


        See Also:
           NetGetCaps



























         ________________________________________________________________
                                                                      190

                                                                 NetLogin
         ________________________________________________________________




        NetLogin
        Performs a network login.


        Syntax:
         NetLogin (server-name, user-name, password)

        Parameters:
         (s) server-name    name of the network file server.
         (s) user-name      name of the current user.
         (s) password       password required to access server, or "".

        Returns:
         (i)          @TRUE if successful; @FALSE if unsuccessful.

        This function may not work with all networks.


        Example:
         pwd = AskPassword("Hello", "Enter password for network access")
         NetLogin("userapps", "admin1", pwd)


        See Also:
           NetAttach, NetLogout
























         ________________________________________________________________
                                                                      191

                                                                NetLogout
         ________________________________________________________________




        NetLogout
        Performs a network logout.


        Syntax:
         NetLogout (server-name)

        Parameters:
         (s) server-name    name of the network file server.

        Returns:
         (i)                @TRUE if successful; @FALSE if unsuccessful.

        This function may not work with all networks.


        Example:
         NetLogout("userapps")


        See Also:
           NetLogin



























         ________________________________________________________________
                                                                      192

                                                               NetMapRoot
         ________________________________________________________________




        NetMapRoot
        Maps a local drive to a network resource.


        Syntax:
         NetMapRoot (local-name, net-path)

        Parameters:
         (s) local-name     local drive name.
         (s) net-path       net resource or string returned by NetBrowse.

        Returns:
         (i)                @TRUE if successful; @FALSE if unsuccessful.

        This function maps a local drive letter as the fake root to a
        network resource.  This is supported by Novell NetWare, but may not
        work with any other networks.


        Example:
         availdrive = DiskScan(0)
         drvlen = StrLen(availdrive)
         If drvlen == 0 Then Goto nomore
         availdrive = StrSub(availdrive, drvlen - 2, 2)
         netpath = NetBrowse(0)
         NetMapRoot(availdrive, netpath)
         Exit
         :nomore
         Message("Connect Drive to Net", "No drives avail for assignment")


        See Also:
           NetAddCon, NetBrowse, NetCancelCon
















         ________________________________________________________________
                                                                      193

                                                             NetMemberGet
         ________________________________________________________________




        NetMemberGet
        Determines whether the current user is a member of a specific
        group.


        Syntax:
         NetMemberGet (server-name, group-name)

        Parameters:
         (s) server-name    name of the network file server.
         (s) group-name     name of the group.

        Returns:
         (i)                @TRUE if successful; @FALSE if unsuccessful.

        This function may not work with all networks.


        Example:
         member = NetMemberGet("userapps", "sales")
         If member == @YES Then Run("notepad.exe", "dailyrpt.txt")


        See Also:
           NetMemberSet
























         ________________________________________________________________
                                                                      194

                                                             NetMemberSet
         ________________________________________________________________




        NetMemberSet
        Sets the current user as a member of a group.


        Syntax:
         NetMemberSet (server-name, group-name)

        Parameters:
         (s) server-name    name of the network file server.
         (s) group-name     name of the group.

        Returns:
         (i)                @TRUE if successful; @FALSE if unsuccessful.

        This function may not work with all networks.


        Example:
         NetMemberSet("userapps", "sales")


        See Also:
           NetMemberGet


























         ________________________________________________________________
                                                                      195

                                                                NetMsgAll
         ________________________________________________________________




        NetMsgAll
        Broadcasts a message to all users on the network.


        Syntax:
         NetMsgAll (server-name, message)

        Parameters:
         (s) server-name    name of the network file server.
         (s) message        message to be broadcast.

        Returns:
         (i)                @TRUE if successful; @FALSE if unsuccessful.

        This function may not work with all networks.


        Example:
         NetMsgAll("userapps", "System going down in 5 minutes.")


        See Also:
           NetMsgSend


























         ________________________________________________________________
                                                                      196

                                                               NetMsgSend
         ________________________________________________________________




        NetMsgSend
        Sends a message to a specific user on the network.


        Syntax:
         NetMsgSend (server-name, user-name, message)

        Parameters:
         (s) server-name    name of the network file server.
         (s) user-name      name of the user to whom the message should
                            be sent.
         (s) message        message to be sent.

        Returns:
         (i)                @TRUE if successful; @FALSE if unsuccessful.

        This function may not work with all networks.


        Example:
         NetMsgSend("userapps", "compmgr", "Are those reports ready yet?")


        See Also:
           NetMsgAll
























         ________________________________________________________________
                                                                      197

                                                                 Num2Char
         ________________________________________________________________




        Num2Char
        Converts a number to its character equivalent.


        Syntax:
         Num2Char (integer)

        Parameters:
         (i) number   any number from 0 to 255.

        Returns:
         (s)          one-byte string containing the character which the
                      number represents.

        Use this function to convert a number to its ASCII equivalent.


        Example:
         ; Build a variable containing a CRLF combo
         crlf = StrCat(Num2Char(13), Num2Char(10))
         Message("NUM2CHAR", StrCat("line1", crlf, "line2"))


        See Also:
           Char2Num, IsNumber
























         ________________________________________________________________
                                                                      198

                                                                ParseData
         ________________________________________________________________




        ParseData
        Parses the passed string.


        Syntax:
         ParseData (string)

        Parameters:
         (s) string   string to be parsed.

        Returns:
         (i)          number of parameters in string.

        This function breaks a string constant or string variable into new
        sub-string variables named param1, param2, etc. (maximum of nine
        parameters).  Blank spaces in the original string are used as
        delimiters to create the new variables.

        Param0 is the count of how many sub-strings are found in "string".


        Example:
         username = AskLine("Hello", "Please enter your name","")
         ParseData(username)

        If the user enters:

           Joe Q. User

        ParseData would create the following variables:

           param1 ==   Joe
           param2 ==   Q.
           param3 ==   User
           param0 ==   3


        See Also:
           ItemExtract, StrSub










         ________________________________________________________________
                                                                      199

                                                                    Pause
         ________________________________________________________________




        Pause
        Provides a message to user.  User may cancel processing.


        Syntax:
         Pause (title, text)

        Parameters:
         (s) title    title of pause box.
         (s) text     text of the message to be displayed.

        Returns:
         (i)          always 1.

        This function displays a message to the user with an exclamation
        point icon.  The user may respond by selecting the OK button, or
        may cancel the processing by selecting Cancel.

        The Pause function is similar to the Message function, except for
        the addition of the Cancel button and icon.


        Example:
         Pause("Change Disks", "Insert new disk into Drive A:")

        which produces:

              ....................................
              .           Change Disks           .
              ....................................
              .                                  .
              .   Insert new disk into Drive A:  .
              .                                  .
              .      [Ok]           [Cancel]     .
              ....................................


        See Also:
           Display, Exit, Message, Terminate










         ________________________________________________________________
                                                                      200

                                                                PlayMedia
         ________________________________________________________________




        PlayMedia
        Controls multimedia devices.


        Syntax:
         PlayMedia (command-string)

        Parameters:
         (s) command-string     string to be sent to the multimedia device.

        Returns:
         (s)                    response from the device.

        If the appropriate Windows multimedia extensions are present, this
        function can control multimedia devices.  Valid command strings
        depend on the multimedia devices and drivers installed.  The basic
        Windows multimedia package has a waveform device to play and record
        waveforms, and a sequencer device to play MID files.  Refer to the
        appropriate documentation for information on command strings.

        Many multimedia devices accept the WAIT or NOTIFY parameters as
        part of the command string:

           WAIT          Causes the system to stop processing input until
                         the requested operation is complete.  You cannot
                         switch tasks when WAIT is specified.

           NOTIFY        Causes the WIL program to suspend execution until
                         the requested operation completes.  You can
                         perform other tasks and switch between tasks when
                         NOTIFY is specified.

           WAIT NOTIFY   Same as WAIT

        If neither WAIT nor NOTIFY is specified, the multimedia operation
        is started and control returns immediately to the WIL program.

        In general, if you simply want the WIL program to wait until the
        multimedia operation is complete, use the NOTIFY keyword.  If you
        want the system to hang until the operation is complete, use WAIT.
        If you just want to start a multimedia operation and have the
        program continue processing, don't use either keyword.

        The return value from PlayMedia is whatever string the driver
        returns.  This will depend on the particular driver, as well as on
        the type of operation performed.



         ________________________________________________________________
                                                                      201

                                                                PlayMedia
         ________________________________________________________________


        Example:
         ; Plays a music CD on a CDAudio player.  It plays whatever is in
         ; the drive, from start to finish
         stat = PlayMedia("status cdaudio mode")
         answer = 1
         If stat == "playing" Then answer = AskYesNo("CD Audio", "CD is
               Playing.  Stop?")
         If answer == 0 Then Exit
         PlayMedia("open cdaudio shareable alias donna notify")
         PlayMedia("set donna time format tmsf")
         PlayMedia("play donna from 1")
         PlayMedia("close donna")
         Exit
         :cancel
         PlayMedia("set cdaudio door open")


        See Also:
           Beep, PlayMidi, PlayWaveForm, Sounds
































         ________________________________________________________________
                                                                      202

                                                                 PlayMidi
         ________________________________________________________________




        PlayMidi
        Plays a MID or RMI sound file.


        Syntax:
         PlayMidi (filename, mode)

        Parameters:
         (s) filename    name of the MID or RMI sound file.
         (i) mode        play mode (see below).

        Returns:
         (i)             @TRUE if successful; @FALSE if unsuccessful.

        If Windows multimedia sound extensions are present, and MIDI-
        compatible hardware is installed, this function will play a MID or
        RMI sound file.  If "filename" is not in the current directory and
        a directory is not specified, the path will be searched to find the
        file.

        If "mode" is set to 0, the WIL program will wait for the sound file
        to complete before continuing.  If "mode" is set to 1, it will
        start playing the sound file and continue immediately.


        Example:
         PlayMidi("canyon.mid", 1)


        See Also:
           Beep, PlayMedia, PlayWaveForm, Sounds


















         ________________________________________________________________
                                                                      203

                                                             PlayWaveForm
         ________________________________________________________________




        PlayWaveForm
        Plays a WAV sound file.


        Syntax:
         PlayWaveForm (filename, mode)

        Parameters:
         (s) filename   name of *.WAV waveform file
         (i) mode       play mode (see below).

        Returns:
         (i)            @TRUE if successful; @FALSE if unsuccessful.

        If Windows multimedia sound extensions are present, and waveform-
        compatible hardware is installed, this function will play a WAV
        sound file.  If "filename" is not in the current directory and a
        directory is not specified, the path will be searched to find the
        file.  If "filename is not found, the WAV file associated with the
        "SystemDefault" keyword is played, (unless the "NoDefault" setting
        is on).

        Instead of specifying an actual filename, you may specify a keyword
        name from the [Sound] section of the WIN.INI file (eg,
        "SystemStart"), in which case the WAV file associated with that
        keyword name will be played.

        "Mode" is a bitmask, composed of the following bits:

           Mode Meaning

           0    Wait for the sound to end before continuing.
           1    Don't wait for the sound to end.  Start the sound and
                immediately process more statements.
           2    If sound file not found, do not play a default sound
           9    Continue playing the sound forever, or until a
                PlayWaveForm("", 0) statement is executed
           16   If another sound is already playing, do not interrupt it.
                Just ignore this PlayWaveForm request.

        You can combine these bits using the binary OR operator.

        The command PlayWaveForm("", 0) can be used at any time to stop
        sound.





         ________________________________________________________________
                                                                      204

                                                             PlayWaveForm
         ________________________________________________________________


        Examples:
         PlayWaveForm("tada.wav", 0)

         PlayWaveForm("SystemDefault", 1 | 16)


        See Also:
           Beep, PlayMedia, PlayMidi, Sounds











































         ________________________________________________________________
                                                                      205

                                                                   Random
         ________________________________________________________________




        Random
        Computes a pseudo-random number.


        Syntax:
         Random (max)

        Parameters:
         (i) max      largest desired integer number.

        Returns:
         (i)          unpredictable positive number.

        This function will return a random integer between 0 and max.


        Example:
         a = Random(79)
         Message("Random number between 0 and 79", a)


        See Also:
           Average, Max, Min


























         ________________________________________________________________
                                                                      206

                                                              Reload {*M}
         ________________________________________________________________




        Reload {*M}
        Reloads menu file(s).


        Syntax:
         Reload ( )

        Parameters:
         (none)

        Returns:
         (i)          always 1.

        This function is used to reload the WIL Interpreter's menu file(s).
        It is useful after editing a menu file, to cause the changes to
        immediately take effect.

        Note:  This command does not take effect until the WIL program has
        completed, regardless of where the command may appear in the
        program.


        Example:
         RunZoomWait("notepad.exe", "c:\win\cmdpost.cpm")
         Reload()
























         ________________________________________________________________
                                                                      207

                                                                   Return
         ________________________________________________________________




        Return
        Used to return from a Call to the calling program.


        Syntax:
         Return

        Parameters:
         (none)

        Returns:
         (not applicable)


        If the current program was not called by another program, an Exit
        is assumed.


        Example:
         Display(2, "End of subroutine", "Returning to MAIN.WBT")
         Return


        See Also:
           Call, Exit
























         ________________________________________________________________
                                                                      208

                                                                      Run
         ________________________________________________________________




        Run
        Runs a program as a normal window.


        Syntax:
         Run (program-name, parameters)

        Parameters:
         (s) program-name   the name of the desired .EXE, .COM, .PIF, .BAT
                            file, or a data file.
         (s) parameters     optional parameters as required by the
                            application.

        Returns:
         (i)                @TRUE if the program was found;
                            @FALSE if it wasn't.

        Use this command to run an application.

        If the drive and path are not part of the program name, the current
        directory will be examined first, followed by the Windows and
        Windows System directories, and then the DOS path will be searched
        to find the desired executable file.

        If the "program-name" doesn't have an extension of .EXE, .COM,
        .PIF, or .BAT, it will be run in accordance with whatever is in the
        [extensions] section of the WIN.INI file.  When this happens, any
        "parameters" you specified are ignored.


        Examples:
         Run("notepad.exe", "abc.txt")

         Run("clock.exe", "")

         Run("paint.exe", "pict.msp")


        See Also:
           AppExist, RunHide, RunIcon, RunWait, RunZoom, WinClose,
           WinExeName, WinWaitClose








         ________________________________________________________________
                                                                      209

                                                                  RunHide
         ________________________________________________________________




        RunHide
        Runs a program as a hidden window.


        Syntax:
         RunHide (program-name, parameters)

        Parameters:
         (s) program-name   the name of the desired .EXE, .COM, .PIF, .BAT
                            file, or a data file.
         (s) parameters     optional parameters as required by the
                            application.

        Returns:
         (i)                @TRUE if the program was found;
                            @FALSE if it wasn't.

        Use this command to run an application as a hidden window.

        If the drive and path are not part of the program name, the current
        directory will be examined first, followed by the Windows and
        Windows System directories, and then the DOS path will be searched
        to find the desired executable file.

        If the "program-name" doesn't have an extension of .EXE, .COM,
        .PIF, or .BAT, it will be run in accordance with whatever is in the
        [extensions] section of the WIN.INI file.  When this happens, any
        "parameters" you specified are ignored.

        Note:  When this command launches an application, it informs it
        that you want it to run as a hidden window.  Whether or not the
        application honors your wish is beyond RunHide's control.


        Examples:
         RunHide("notepad.exe", "abc.txt")

         RunHide("clock.exe", "")

         RunHide("paint.exe", "pict.msp")


        See Also:
           Run, RunHideWait, RunIcon, RunZoom, WinClose, WinExeName,
           WinHide, WinWaitClose




         ________________________________________________________________
                                                                      210

                                                              RunHideWait
         ________________________________________________________________




        RunHideWait
        Runs a program as a hidden window, and waits for it to close.


        Syntax:
         RunHideWait (program-name, parameters)

        Parameters:
         (s) program-name   the name of the desired .EXE, .COM, .PIF, .BAT
                            file, or a data file.
         (s) parameters     optional parameters as required by the
                            application.

        Returns:
         (i)                @TRUE if the program was found;
                            @FALSE if it wasn't.

        Use this command to run an application as a hidden window.  The WIL
        program will suspend processing until the application is closed.

        If the drive and path are not part of the program name, the current
        directory will be examined first, followed by the Windows and
        Windows System directories, and then the DOS path will be searched
        to find the desired executable file.

        If the "program-name" doesn't have an extension of .EXE, .COM,
        .PIF, or .BAT, it will be run in accordance with whatever is in the
        [extensions] section of the WIN.INI file.  When this happens, any
        "parameters" you specified are ignored.

        Note:  When this command launches an application, it informs it
        that you want it to run as a hidden window.  Whether or not the
        application honors your wish is beyond RunHideWait's control.


        Example:
         NetAddCon("winword", "", "g:")
         RunHideWait("winword.exe", "")
         NetCancelCon("g:", 0)


        See Also:
           RunHide, RunIconWait, RunWait, RunZoomWait, WinWaitClose






         ________________________________________________________________
                                                                      211

                                                                  RunIcon
         ________________________________________________________________




        RunIcon
        Runs a program as an iconic (minimized) window.


        Syntax:
         RunIcon (program-name, parameters)

        Parameters:
         (s) program-name   the name of the desired .EXE, .COM, .PIF, .BAT
                            file, or a data file.
         (s) parameters     optional parameters as required by the
                            application.

        Returns:
         (i)                @TRUE if the program was found;
                            @FALSE if it wasn't.

        Use this command to run an application as an icon.

        If the drive and path are not part of the program name, the current
        directory will be examined first, followed by the Windows and
        Windows System directories, and then the DOS path will be searched
        to find the desired executable file.

        If the "program-name" doesn't have an extension of .EXE, .COM,
        .PIF, or .BAT, it will be run in accordance with whatever is in the
        [extensions] section of the WIN.INI file.  When this happens, any
        "parameters" you specified are ignored.

        Note:  When this command launches an application, it merely informs
        it that you want it to begin as an icon.  Whether or not the
        application honors your wish is beyond RunIcon's control.


        Examples:
         RunIcon("notepad.exe", "abc.txt")

         RunIcon("clock.exe", "")

         RunIcon("paint.exe", "pict.msp")


        See Also:
           IconArrange, Run, RunHide, RunIconWait, RunZoom, WinClose,
           WinExeName, WinIconize, WinWaitClose




         ________________________________________________________________
                                                                      212

                                                              RunIconWait
         ________________________________________________________________




        RunIconWait
        Runs a program as an iconic (minimized) window, and waits for it to
        close.


        Syntax:
         RunIconWait (program-name, parameters)

        Parameters:
         (s) program-name   the name of the desired .EXE, .COM, .PIF, .BAT
                            file, or a data file.
         (s) parameters     optional parameters as required by the
                            application.

        Returns:
         (i)                @TRUE if the program was found;
                            @FALSE if it wasn't.

        Use this command to run an application as an icon.  The WIL program
        will suspend processing until the application is closed.

        If the drive and path are not part of the program name, the current
        directory will be examined first, followed by the Windows and
        Windows System directories, and then the DOS path will be searched
        to find the desired executable file.

        If the "program-name" doesn't have an extension of .EXE, .COM,
        .PIF, or .BAT, it will be run in accordance with whatever is in the
        [extensions] section of the WIN.INI file.  When this happens, any
        "parameters" you specified are ignored.

        Note:  When this command launches an application, it merely informs
        it that you want it to begin as an icon.  Whether or not the
        application honors your wish is beyond RunIconWait's control.


        Example:
         NetAddCon("winword", "", "g:")
         RunIconWait("winword.exe", "")
         NetCancelCon("g:", 0)


        See Also:
           IconArrange, RunHideWait, RunIcon, RunWait, RunZoomWait,
           WinWaitClose




         ________________________________________________________________
                                                                      213

                                                                  RunWait
         ________________________________________________________________




        RunWait
        Runs a program as a normal window, and waits for it to close.


        Syntax:
         RunWait (program-name, parameters)

        Parameters:
         (s) program-name   the name of the desired .EXE, .COM, .PIF, .BAT
                            file, or a data file.
         (s) parameters     optional parameters as required by the
                            application.

        Returns:
         (i)                @TRUE if the program was found;
                            @FALSE if it wasn't.

        Use this command to run an application.  The WIL program will
        suspend processing until the application is closed.

        If the drive and path are not part of the program name, the current
        directory will be examined first, followed by the Windows and
        Windows System directories, and then the DOS path will be searched
        to find the desired executable file.

        If the "program-name" doesn't have an extension of .EXE, .COM,
        .PIF, or .BAT, it will be run in accordance with whatever is in the
        [extensions] section of the WIN.INI file.  When this happens, any
        "parameters" you specified are ignored.


        Example:
         NetAddCon("winword", "", "g:")
         RunWait("winword.exe", "")
         NetCancelCon("g:", 0)


        See Also:
           AppWaitClose, Run, RunHideWait, RunIconWait, RunZoomWait,
           WinWaitClose









         ________________________________________________________________
                                                                      214

                                                                  RunZoom
         ________________________________________________________________




        RunZoom
        Runs a program as a full-screen (maximized) window.


        Syntax:
         RunZoom (program-name, parameters)

        Parameters:
         (s) program-name   the name of the desired .EXE, .COM, .PIF, .BAT
                            file, or a data file.
         (s) parameters     optional parameters as required by the
                            application.

        Returns:
         (i)                @TRUE if the program was found;
                            @FALSE if it wasn't.

        Use this command to run an application as a full-screen window.

        If the drive and path are not part of the program name, the current
        directory will be examined first, followed by the Windows and
        Windows System directories, and then the DOS path will be searched
        to find the desired executable file.

        If the "program-name" doesn't have an extension of .EXE, .COM,
        .PIF, or .BAT, it will be run in accordance with whatever is in the
        [Extensions] section of the WIN.INI file.  When this happens, any
        "parameters" you specified are ignored.

        Note:  When this command launches an application, it merely informs
        it that you want it to be maximized to full-screen.  Whether or not
        the application honors your wish is beyond RunZoom's control.


        Examples:
         RunZoom("notepad.exe", "abc.txt")

         RunZoom("clock.exe", "")

         RunZoom("paint.exe", "pict.msp")


        See Also:
           Run, RunHide, RunIcon, RunZoomWait, WinClose, WinExeName,
           WinWaitClose, WinZoom




         ________________________________________________________________
                                                                      215

                                                              RunZoomWait
         ________________________________________________________________




        RunZoomWait
        Runs a program as a full-screen (maximized) window, and waits for
        it to close.


        Syntax:
         RunZoomWait (program-name, parameters)

        Parameters:
         (s) program-name   the name of the desired .EXE, .COM, .PIF, .BAT
                            file, or a data file.
         (s) parameters     optional parameters as required by the
                            application.

        Returns:
         (i)                @TRUE if the program was found;
                            @FALSE if it wasn't.

        Use this command to run an application as a full-screen window.
        The WIL program will suspend processing until the application is
        closed.

        If the drive and path are not part of the program name, the current
        directory will be examined first, followed by the Windows and
        Windows System directories, and then the DOS path will be searched
        to find the desired executable file.

        If the "program-name" doesn't have an extension of .EXE, .COM,
        .PIF, or .BAT, it will be run in accordance with whatever is in the
        [Extensions] section of the WIN.INI file.  When this happens, any
        "parameters" you specified are ignored.

        Note:  When this command launches an application, it merely informs
        it that you want it to be maximized to full-screen.  Whether or not
        the application honors your wish is beyond RunZoomWait's control.


        Example:
         NetAddCon("winword", "", "g:")
         RunZoomWait("winword.exe", "")
         NetCancelCon("g:", 0)


        See Also:
           RunHideWait, RunIconWait, RunWait, RunZoom, WinWaitClose




         ________________________________________________________________
                                                                      216

                                                                  SendKey
         ________________________________________________________________




        SendKey
        Sends keystrokes to the active application.


        Syntax:
         SendKey (char-string)

        Parameters:
         (s) char-string    string of regular and/or special characters.

        Returns:
         (i)          always 0.

        This function is used to send keystrokes to the current window,
        just as if they had been entered from the keyboard.  Any
        alphanumeric character, and most punctuation marks and other
        symbols which appear on the keyboard, may be sent simply by placing
        it in the "char-string."  In addition, the following special
        characters, enclosed in "curly" braces, may be placed in "char-
        string" to send the corresponding special characters:

           Key         SendKey equivalent

           ~           {~}
           !           {!}
           ^           {^}
           +           {+}

           Alt         {ALT}
           Backspace   {BACKSPACE} or {BS}
           Caps Lock   {CAPSLOCK}
           Clear       {CLEAR}
           Delete      {DELETE} or {DEL}
           Down Arrow  {DOWN}
           End         {END}
           Enter       {ENTER} or ~
           Escape      {ESCAPE} or {ESC}
           F1 thru F16 {F1} through {F16}
           Help        {HELP}
           Home        {HOME}
           Insert      {INSERT} or {INS}
           Left Arrow  {LEFT}
           Num Lock    {NUMLOCK}
           Page Down   {PGDN}
           Page Up     {PGUP}
           Print Scrn  {PRTSC}    *** See Snapshot function ***
           Right Arrow {RIGHT}
           Space       {SPACE} or {SP}

         ________________________________________________________________
                                                                      217

                                                                  SendKey
         ________________________________________________________________

           Tab         {TAB}
           Up Arrow    {UP}

        To enter an Alt, Control, or Shift key combination, precede the
        desired character with one or more of the following symbols:

           Alt         !
           Control     ^
           Shift       +

        To enter Alt-S:

         SendKey("!s")

        Note: You should use lower-case letters to represent Alt-key
        combinations and other menu shortcut keys.

        To enter Ctrl-Shift-F7:

         SendKey("^+{F7}")

        You may also repeat a key by enclosing it in braces, followed by a
        space and the total number of repetitions desired.

        To type 20 asterisks:

         SendKey("{* 20}")

        To move the cursor down 8 lines:

         SendKey("{DOWN 8}")

        It is possible to use SendKey to send keystrokes to a DOS
        application, but only if you are running Windows in 386 Enhanced
        mode.  You would then transfer the keystrokes to the DOS
        application via the Clipboard.  It is only possible to send
        standard ASCII characters to DOS applications; you cannot send
        function key or Alt-key combinations.


        Examples:
         ; start Notepad, and use *.* for filenames
         Run("notepad.exe", "")
         SendKey("!fo*.*~")








         ________________________________________________________________
                                                                      218

                                                                  SendKey
         ________________________________________________________________

         ; run DOS batch file which starts our editor
         Run("edit.bat", "")
         ; wait 15 seconds for editor to load
         Delay(15)
         ; send string (with carriage return) to the clipboard
         crlf = StrCat(Num2Char(13), Num2Char(10))
         ClipPut("Hello%crlf%")
         ; paste contents of clipboard to DOS window
         SendKey("!{SP}ep")


        In those cases where you have an application which can accept text
        pasted in from the clipboard, it will often be more efficient to
        use the ClipGet function:

         Run("notepad.exe", "")
         crlf = StrCat(Num2Char(13), Num2Char(10))
         ; copy some text to the clipboard
         ClipPut("Dear Sirs:%crlf%%crlf%")
         ; paste the text into Notepad (using Shift-Ins)
         SendKey("+{INSERT}")



        Note:  If your SendKey statement doesn't seem to be working (eg.,
        all you get are beeping noises), you may need to place a
        WinActivate statement before the SendKey statement to insure that
        you are sending the keystrokes to the correct window.


        See Also:
           ClipGet, SKDebug, SnapShot, WinActivate




















         ________________________________________________________________
                                                                      219

                                                                  SKDebug
         ________________________________________________________________




        SKDebug
        Controls how SendKey works


        Syntax:
         SKDebug (mode)

        Parameters:
         (i) mode     @OFF        Keystrokes sent to application.  No debug
                                  file  written.  Default mode.
                      @ON         Keystrokes sent to application.  Debug
                                  file written.
                      @PARSEONLY  Keystrokes not sent to application.
                                  Debug file written.

        Returns:
         (i)          previous SKDebug mode.

        This function allows you to direct the keystrokes generated by your
        SendKey statements to a disk file in addition to, or instead of,
        the application window.  Normally, keystrokes are sent only to the
        application.  If you specify SKDebug (@ON), keystrokes are sent to
        a disk file as well as to the application.  If you specify SKDebug
        (@PARSEONLY), keystrokes are sent only to the disk file, and not to
        the application.  SKDebug (@OFF) returns to the default mode.

        By default, the file which will receive the parsed keystrokes is
        named C:\@@SKDBUG.TXT.  You can override this by making an entry in
        the [Main] section of the WWWBATCH.INI file, as follows:

           SKDFile=debug.fil

        where debug.fil is the filename, including complete path
        specification, that you want to receive the keystrokes.


        Example:
         Run("notepad.exe", "")
         SKDebug(@ON)
         SendKey("!fo*.*~")
         SKDebug(@OFF)


        See Also:
           Debug, SendKey




         ________________________________________________________________
                                                                      220

                                                                 SnapShot
         ________________________________________________________________




        SnapShot
        Takes a snapshot of the screen and pastes it to the clipboard.


        Syntax:
         SnapShot (request#)

        Parameters:
         (i) request# see below.

        Returns:
         (i)          always 0.

           Req# Meaning

           0    Take snapshot of entire screen
           1    Take snapshot of client area of parent window of active
                window
           2    Take snapshot of entire area of parent window of active
                window
           3    Take snapshot of client area of active window
           4    Take snapshot of entire area of active window


        Example:
         SnapShot(2)


        See Also:
           ClipPut



















         ________________________________________________________________
                                                                      221

                                                                   Sounds
         ________________________________________________________________




        Sounds
        Turns sounds on or off.


        Syntax:
         Sounds (request#)

        Parameters:
         (i) request#    see below.

        Returns:
         (i)             previous Sound setting.

        If Windows multimedia sound extensions are present, this function
        turns sounds made by the WIL Interpreter on or off.  Specify a
        request# of 0 to turn sounds off, and a request# of 1 to turn them
        on.

        By default, the WIL Interpreter makes noise.  You can override this
        by entering:

           Sounds=0

        in the [Main] section of the WWWBATCH.INI file.


        Example:
         Sounds(0)

        See Also:
           Beep, PlayMedia, PlayMidi, PlayWaveForm


















         ________________________________________________________________
                                                                      222

                                                                   StrCat
         ________________________________________________________________




        StrCat
        Concatenates two or more strings.


        Syntax:
         StrCat (string1, string2[, ..., stringN])

        Parameters:
         (s) string1, etc.    at least two strings you want to concatenate.

        Returns:
         (s)                  concatenation of the entire list of input
                              strings.

        Use this command to stick character strings together, or to format
        display messages.


        Example:
         user = AskLine("Login", "Your Name:", "")
         msg = StrCat("Hi, ", user)
         Message("Login", msg)

         ; note that this is the same as the second line above:
         msg = "Hi, %user%"


        See Also:
           StrFill, StrFix, StrTrim




















         ________________________________________________________________
                                                                      223

                                                                   StrCmp
         ________________________________________________________________




        StrCmp
        Compares two strings.


        Syntax:
         StrCmp (string1, string2)

        Parameters:
         (s) string1, string2    strings to compare.

        Returns:
         (i)          -1, 0, or 1; depending on whether string1 is less
                      than, equal to, or greater than string2,
                      respectively.

        Use this command to determine whether two strings are equal, or
        which precedes the other in an ANSI sorting sequence.

        Note:  This command has been included for semantic completeness.
        The relational operators >, >=, ==, !=, <=, and < provide the same
        capability.


        Example:
         a = AskLine("STRCMP", "Enter a test line", "")
         b = AskLine("STRCMP", "Enter another test line", "")
         c = StrCmp(a, b)
         c = c + 1
         d = StrSub("less than   equal to    greater than", c * 12, 12)
         ; Note that above string is grouped into 12-character
         ; chunks.
         ; Desired chunk is removed with the StrSub statement.
         Message("STRCMP", "%a% is %d% %b%")


        See Also:
           StriCmp, StrIndex, StrLen, StrScan, StrSub












         ________________________________________________________________
                                                                      224

                                                                  StrFill
         ________________________________________________________________




        StrFill
        Creates a string filled with a series of characters.


        Syntax:
         StrFill (filler, length)

        Parameters:
         (s) filler    a string to be repeated to create the return string.
                       If the filler string is null, spaces will be used
                       instead.
         (i) length    the length of the desired string.

        Returns:
         (s)           character string.

        Use this function to create a string consisting of multiple copies
        of the filler string concatenated together.


        Example:
         Message("My Stars", StrFill("*", 30))

        which produces:

              ......................................
              .             My Stars               .
              ......................................
              .                                    .
              .   ******************************   .
              .                                    .
              .               [OK]                 .
              ......................................


        See Also:
           StrCat, StrFix, StrLen, StrTrim












         ________________________________________________________________
                                                                      225

                                                                   StrFix
         ________________________________________________________________




        StrFix
        Pads or truncates a string to a fixed length.


        Syntax:
         StrFix (base-string, pad-string, length)

        Parameters:
         (s) base-string    string to be adjusted to a fixed length.
         (s) pad-string     appended to base-string if needed to fill out
                            the desired length.  If pad-string is null,
                            spaces are used instead.
         (i) length         length of the desired string.

        Returns:
         (s)                fixed size string.

        This function "fixes" the length of a string, either by truncating
        it on the right, or by appending enough copies of pad-string to
        achieve the desired length.


        Example:
         a = StrFix("Henry", " ", 15)
         b = StrFix("Betty", " ", 15)
         c = StrFix("George", " ", 15)
         Message("Spaced Names", StrCat(a, b, c))

        which produces:

              ....................................................
              .                   Spaced names                   .
              ....................................................
              .                                                  .
              .   Henry          Betty          George           .
              .                                                  .
              .                     [OK]                         .
              ....................................................


        See Also:
           StrFill, StrLen, StrTrim







         ________________________________________________________________
                                                                      226

                                                                  StriCmp
         ________________________________________________________________




        StriCmp
        Compares two strings without regard to case.


        Syntax:
         StriCmp (string1, string2)

        Parameters:
         (s) string1, string2    strings to compare.

        Returns:
         (i)          -1, 0, or 1; depending on whether string1 is less
                      than, equal to, or greater than string2,
                      respectively.

        Use this command to determine whether two strings are equal, or
        which precedes the other in an ANSI sorting sequence, when case is
        ignored.


        Example:
         a = AskLine("STRICMP", "Enter a test line", "")
         b = AskLine("STRICMP", "Enter another test line", "")
         c = StriCmp(a, b)
         c = c + 1
         d = StrSub("less than   equal to    greater than", c * 12, 12)
         ; Note that above string is grouped into 12-character
         ; chunks.
         ; Desired chunk is removed with the StrSub statement.
         Message("STRICMP", "%a% is %d% %b%")


        See Also:
           StrCmp, StrIndex, StrLen, StrScan, StrSub















         ________________________________________________________________
                                                                      227

                                                                 StrIndex
         ________________________________________________________________




        StrIndex
        Searches a string for a substring.


        Syntax:
         StrIndex (string, substring, start, direction)

        Parameters:
         (s) string      the string to be searched for a substring.
         (s) substring   the string to look for within the main string.
         (i) start       the position in the main string to begin search.
                         The first character of a string is position 1.
         (i) direction   the search direction.  @FWDSCAN searches forward,
                         while @BACKSCAN searches backwards.

        Returns:
         (i)             position of substring within string, or 0 if not
                         found.

        This function searches for a substring within a "target" string.
        Starting at the "start" position, it goes forward or backward
        depending on the value of the "direction" parameter.  It stops when
        it finds the "substring" within the "target" string, and returns
        its position.

        A start position of 0 has special meaning depending on which
        direction you are scanning.  For forward searches, zero indicates
        the search should start at the beginning of the string.  For
        reverse searches, zero causes it to start at the end of the string.


        Example:
         instr = AskLine("STRINDEX", "Type a sentence:", "")
         start = 1
         end = StrIndex(instr, " ", start, @FWDSCAN)
         If end == 0 Then Goto error
         Message("STRINDEX", StrCat("The first word is: ", StrSub(instr,
             start, end - 1))
         Exit
         :error
         Message("Sorry...", "No spaces found")


        See Also:
           StrLen, StrScan, StrSub




         ________________________________________________________________
                                                                      228

                                                                   StrLen
         ________________________________________________________________




        StrLen
        Provides the length of a string.


        Syntax:
         StrLen (string)

        Parameters:
         (s) string   any text string.

        Returns:
         (i)          length of string.

        Use this command to determine the length of a string variable or
        expression.


        Example:
         myfile = AskLine("Filename", "File to process:", "")
         namlen = StrLen(myfile)
         If namlen > 13 Then Message("", "Filename too long!")


        See Also:
           StrFill, StrFix, StrIndex, StrScan, StrTrim
























         ________________________________________________________________
                                                                      229

                                                                 StrLower
         ________________________________________________________________




        StrLower
        Converts a string to lowercase.


        Syntax:
         StrLower (string)

        Parameters:
         (s) string     any text string.

        Returns:
         (s)            lowercase string.

        Use this command to convert a text string to lower case.


        Example:
         a = AskLine("STRLOWER", "Enter text", "")
         b = StrLower(a)
         Message(a, b)


        See Also:
           StriCmp, StrUpper

























         ________________________________________________________________
                                                                      230

                                                               StrReplace
         ________________________________________________________________




        StrReplace
        Replaces all occurances of a substring with another.


        Syntax:
         StrReplace (string, old, new)

        Parameters:
         (s) string   string in which to search.
         (s) old      target substring.
         (s) new      replacement substring.

        Returns:
         (s)          updated string, with old replaced by new.


        StrReplace scans the "string", searching for occurrences of "old"
        and replacing each occurrence with "new".


        Example:
         ; Copy all INI files to clipboard
         a = FileItemize("*.ini")
         crlf = StrCat(Num2Char(13), Num2Char(10))
         b = StrReplace(a, " ", crlf)
         ClipPut(b)


        See Also:
           StrIndex, StrScan, StrSub



















         ________________________________________________________________
                                                                      231

                                                                  StrScan
         ________________________________________________________________




        StrScan
        Searches string for occurrence of delimiters.


        Syntax:
         StrScan (string, delimiters, start, direction)

        Parameters:
         (s) string         the string that is to be searched.
         (s) delimiters     a string of delimiters to search for within
                            string.
         (i) start          the position in the main string to begin
                            search.  The first character of a string is
                            position 1.
         (i) direction      the search direction.  @FWDSCAN searches
                            forward, while @BACKSCAN searches backwards.

        Returns:
         (i)                position of delimiter in string, or 0 if not
                            found.

        This function searches for delimiters within a target "string".
        Starting at the "start" position, it goes forward or backward
        depending on the value of the "direction" parameter.  It stops when
        it finds any one of the characters in the "delimiters" string
        within the target "string".


        Example:
         thestr = "123,456.789:abc"
         start = 1
         end = StrScan(thestr, ",.:", start, @FWDSCAN)
         If end == 0 Then Goto error
         Message("The first parameter", StrSub(thestr, start, end -
             start + 1))
         Exit
         :error
         Message("Sorry...", "No delimiters found")


        See Also:
           StrLen, StrSub







         ________________________________________________________________
                                                                      232

                                                                   StrSub
         ________________________________________________________________




        StrSub
        Extracts a substring out of an existing string.


        Syntax:
         StrSub (string, start, length)

        Parameters:
         (s) string   the string from which the substring is to be
                      extracted.
         (i) start    character position within string where the substring
                      starts.  (The first character of the string is at
                      position 1).
         (i) length   length of desired substring.  If you specify a length
                      of zero it will return a null string.

        Returns:
         (s)          substring of parameter string.

        This function extracts a substring from within a "target" string.
        Starting at the "start" position, it copies up to "length"
        characters into the substring.


        Example:
         a = "My dog has fleas"
         animal = StrSub(a, 4, 3)
         Message("STRSUB", "My animal is a %animal%")


        See Also:
           StrLen, StrScan

















         ________________________________________________________________
                                                                      233

                                                                  StrTrim
         ________________________________________________________________




        StrTrim
        Removes leading and trailing blanks from a character string.


        Syntax:
         StrTrim (string)

        Parameters:
         (s) string   a string with unwanted spaces at the beginning and/or
                      end.

        Returns:
         (s)          string devoid of leading and trailing spaces.

        This function removes spaces and tab characters from the beginning
        and end of a text string.


        Example:
         myfile = AskLine("STRTRIM", "Filename ('exit' cancels)", "")
         tstexit = StrTrim(StrLower(myfile))
         If tstexit == "exit" Then Goto cancel
         ; processing of myfile continues...
         : cancel
         Message("Canceled", "...by user request")


        See Also:
           StrFill, StrFix, StrLen




















         ________________________________________________________________
                                                                      234

                                                                 StrUpper
         ________________________________________________________________




        StrUpper
        Converts a string to uppercase.


        Syntax:
         StrUpper (string)

        Parameters:
         (s) string   any text string.

        Returns:
         (s)          uppercase string.

        Use this function to convert a text string to upper case.


        Example:
         a = AskLine("STRUPPER", "Enter text","")
         b = StrUpper(a)
         Message(a, b)


        See Also:
           StriCmp, StrLower

























         ________________________________________________________________
                                                                      235

                                                                Terminate
         ________________________________________________________________




        Terminate
        Conditionally ends a WIL program.


        Syntax:
         Terminate (expression, title, message)

        Parameters:
         (s) expression     any logical expression.
         (s) title          the title of a message box to be displayed
                            before termination.
         (s) message        the message in the message box.

        Returns:
         (i)                always 1.

        This command ends processing for the WIL program if "expression" is
        nonzero.  Note that many functions return @TRUE (1) or @FALSE (0),
        which you can use to decide whether to cancel a menu item.

        If either "title" or "message" contains a string, a message box
        with a title and a message is displayed before exiting.


        Examples:
         ; unconditional termination w/o message box (same as Exit)
         Terminate(@TRUE, "", "")

         ; basically a no-op:
         Terminate(@FALSE, "", "This will never terminate")

         ; exits with message if variable is less than zero:
         Terminate(a < 0, "Error", "Cannot use negative numbers")

         ; exits w/o message if answer isn't "YES":
         Terminate(answer != "YES", "", "")


        See Also:
           Display, Exit, Message, Pause









         ________________________________________________________________
                                                                      236

                                                                  TextBox
         ________________________________________________________________




        TextBox
        Displays a file in a listbox on the screen and returns the selected
        line.


        Syntax:
         TextBox (title, filename)

        Parameters:
         (s) title      listbox title.
         (s) filename   file containing contents of listbox.

        Returns:
         (s)            highlighted string, if any.

        This function loads a file into a Windows listbox and displays the
        listbox to the user.  TextBox has two primary uses:  First, it can
        be used to display multi-line messages to the user.  In addition,
        because of its ability to return a selected line, it may be used as
        a multiple choice question box.  The line highlighted by the user
        (if any) will be returned to the program.  If the user does not
        make a selection, a null string ("") is returned.

        If disk drive and path are not part of the filename, the current
        directory will be examined first, and then the DOS path will be
        searched to find the desired file.

        TextBox is like TextBoxSelect, except that with TextBoxSelect the
        items in the displayed box are sorted and with TextBox they are
        left unsorted.


        Example:
         ; Display WIN.INI
         a = TextBox("Choose a line", "c:\windows\win.ini")
         Display(3, "Chosen line", a)

        which produces (at least on my system):











         ________________________________________________________________
                                                                      237

                                                                  TextBox
         ________________________________________________________________

              ..........................................
              .            Choose a line               .
              ..........................................
              . _____________________________________  .
              . | [windows]                       |^|  .
              . | load=                           |x|  .
              . | run=                            |x|  .
              . | Beep=yes                        |x|  .
              . |<<Spooler=yes>>                  |x|  .
              . | BorderWidth=2                   |x|  .
              . | CursorBlinkRate=530             |x|  .
              . | DoubleClickSpeed=452            |x|  .
              . | swapdisk=                       |x|  .
              . | MousePresent=yes                |x|  .
              . |_________________________________|v|  .
              .                                        .
              .      [OK]                 [Cancel]     .
              ..........................................

        and then:

              ........................
              .      Chosen line     .
              ........................
              .                      .
              .      Spooler=yes     .
              .                      .
              .         [OK]         .
              ........................


        See Also:
           ItemSelect, TextBoxSort, TextSelect



















         ________________________________________________________________
                                                                      238

                                                              TextBoxSort
         ________________________________________________________________




        TextBoxSort
        Displays a file in a sorted listbox on the screen and returns the
        selected line.




        Syntax:
         TextBoxSort (title, filename)

        Parameters:
         (s) title       listbox title.
         (s) filename    file containing contents of listbox.

        Returns:
         (s)             highlighted string, if any.

        This function loads a file into a Windows listbox, which is sorted
        alphabetically and displayed to the user.  The line highlighted by
        the user (if any) will be returned to the program.  If the user
        does not make a selection, a null string ("") is returned.

        If disk drive and path are not part of the filename, the current
        directory will be examined first, and then the DOS path will be
        searched to find the desired file.

        TextBox is like TextBoxSelect, except that with TextBoxSelect the
        items in the displayed box are sorted and with TextBox they are
        left unsorted.


        Example:
         a = TextBoxSort("Select a phone number", "phones.txt")
         Display(3, "Selected number is", a)


        See Also:
           ItemSelect, TextBox, TextSelect











         ________________________________________________________________
                                                                      239

                                                               TextSelect
         ________________________________________________________________




        TextSelect
        Allows the user to choose an item from an unsorted listbox.


        Syntax:
         TextSelect (title, list, delimiter)

        Parameters:
         (s) title      the title of dialog box to display.
         (s) list       a string containing a list of items to choose from.
         (s) delimiter  a string containing the character to act as
                        delimiter between items in the list.

        Returns:
         (s)            the selected item.

        This function displays a dialog box with a listbox inside.  This
        listbox is filled with an unsorted list of items taken from a
        string you provide to the function.

        Each item in the string must be separated (delimited) by a
        character, which you also pass to the function.

        The user selects one of the items by either doubleclicking on it,
        or single-clicking and pressing OK.  The item is returned as a
        string.

        If you create the list with the FileItemize or DirItemize functions
        you will be using a space-delimited list.  WinItemize, however,
        creates a tab-delimited list of window titles since titles can have
        embedded blanks.

        TextSelect is like ItemSelect, except that with TextSelect the
        displayed box is larger and the items in the box are not sorted
        alphabetically.


        Example:
         DirChange(DirWindows(0))
         inifiles = FileItemize("*.ini")
         ini = TextSelect("Select an INI file to edit", inifiles, " ")
         If ini == "" Then Exit
         RunZoom("notepad.exe", ini)


        See Also:
           AskLine, Dialog, DirItemize, FileItemize, ItemSelect, TextBox,
           TextBoxSort, WinItemize

         ________________________________________________________________
                                                                      240

                                                                     Then
         ________________________________________________________________




        Then
        Continues a previous If statement.


        Syntax:
         Then statement

        Parameters:
         (s) statement any valid WIL function or command.

        This command continues the last-encountered If command.  It
        provides a method of conditionally executing multiple statements,
        without having to test the condition more than once.  If the
        previous If condition was true, the statement following the Then
        keyword is executed.  If the previous If condition was false, the
        statement following the Then keyword is ignored.


        Example:
         answer = AskYesNo("Financial Management", "Run WinCheck now?")
         If answer == @YES Then DirChange("c:\win\check")
         Then Run("wincheck.exe", "")
         Then WinWaitClose("WinCheck")
         Message("Okay", "Processing complete")


        See Also:
           Else, Goto, If ... Then





















         ________________________________________________________________
                                                                      241

                                                                  Version
         ________________________________________________________________




        Version
        Returns the version number of the parent program currently running.


        Syntax:
         Version ( )

        Parameters:
         (none)

        Returns:
         (s)          parent program version number.

        Use this function to determine the version of the parent program
        that is currently running.


        Example:
         ver = Version()
         Message("Version number", ver)


        See Also:
           DOSVersion, Environment, VersionDLL WinVersion

























         ________________________________________________________________
                                                                      242

                                                               VersionDLL
         ________________________________________________________________




        VersionDLL
        Returns the version number of the WIL Interpreter currently
        running.


        Syntax:
         VersionDLL ( )

        Parameters:
         (none)

        Returns:
         (s)          WIL Interpreter version number.

        Use this function to determine the version of the WIL Interpreter
        that is currently running.  It is useful to verify that a WIL
        program generated with the latest version of the language will
        operate properly on what may be a different machine with a
        different version of the WIL Interpreter installed.


        Example:
         ver = VersionDLL()
         If ver >= "1.0c" Then Goto proceed
         Message("Sorry", "WIL Interpreter version 1.0c or higher
         required")
         Exit
         :proceed
         NetDialog()


        See Also:
           DOSVersion, Environment, Version, WinVersion
















         ________________________________________________________________
                                                                      243

                                                               WaitForKey
         ________________________________________________________________




        WaitForKey
        Waits for a specific key to be pressed.


        Syntax:
         WaitForKey (key1, key2, key3, key4, key5)

        Parameters:
         (s) key1 - key5    five keystrokes to wait for.

        Returns:
         (i)                position of the selected keystroke (1-5).

        WaitForKey requires five parameters, each of which represents a
        keystroke (refer to the SendKey function for a list of special
        keycodes which can be used).  The WIL program will be suspended
        until one of the specified keys are pressed, at which time the
        WaitForKey function will return a number from 1 to 5, indicating
        the position of the "key" that was selected, and the program will
        continue.  You can specify a null string ("") for one or more of
        the "key" parameters if you don't need to use all five.

        WaitForKey will detect its keystrokes in most, but not all, Windows
        applications.  Any keystroke that is pressed is also passed on to
        the underlying application.


        Example:
         k = WaitForKey("{F11}", "{F12}", "{INSERT}", "", "")
         If k == 1 Then Message("WaitForKey", "You pressed the F11 key")
         If k == 2 Then Message("WaitForKey", "You pressed the F12 key")
         If k == 3 Then Message("WaitForKey", "You pressed the Insert key")


        See Also:
           IgnoreInput, IsKeyDown













         ________________________________________________________________
                                                                      244

                                                                WallPaper
         ________________________________________________________________




        WallPaper
        Changes the Windows wallpaper.


        Syntax:
         WallPaper (bmp-name, tile)


        Parameters:
         (s) bmp-name   Name of the BMP wallpaper file.
         (i) tile       @TRUE if wallpaper should be tiled;
                        @FALSE if wallpaper should not be tiled.

        Returns:
         (i)            always 0.

        This function immediately changes the Windows wallpaper.  It can
        even be used for wallpaper "slide shows."


        Example:
         DirChange("c:\windows")
         a = FileItemize("*.bmp")
         a = ItemSelect("Select New paper", a, " ")
         tile = @FALSE
         If FileSize(a) < 40000 Then tile = @TRUE
         Wallpaper(a, tile)


        See Also:
           WinParmSet


















         ________________________________________________________________
                                                                      245

                                                              WinActivate
         ________________________________________________________________




        WinActivate
        Activates a previously running window.


        Syntax:
         WinActivate (partial-winname)

        Parameters:
         (s) partial-winname     either an initial portion of, or an entire
                                 window name.  The most-recently used
                                 window whose title matches the name will
                                 be activated.

        Returns:
         (i)          @TRUE if a window was found to activate;
                      @FALSE if no windows were found.

        Use this function to activate windows for user input.

        This function works only with top-level (parent) application
        windows.


        Example:
         Run("notepad.exe", "")
         Run("clock.exe", "")
         WinActivate("Notepad")


        See Also:
           WinCloseNot, WinGetActive, WinName, WinShow


















         ________________________________________________________________
                                                                      246

                                                               WinArrange
         ________________________________________________________________




        WinArrange
        Arranges, tiles, and/or stacks application windows.


        Syntax:
         WinArrange (style)

        Parameters:
         (i) style    one of the following: @STACK, @TILE (or @ARRANGE),
                      @ROWS, or @COLUMNS.

        Returns:
         (i)          always 1.

        Use this function to rearrange the open windows on the screen.
        (Any iconized programs are unaffected.)

        If there are more than four open windows and you specify @ROWS, or
        if there are more than three open windows and you specify @COLUMNS,
        @TILE will be used instead.

        This function works only with top-level (parent) application
        windows.


        Example:
         ; Reveal all windows
         WinArrange(@TILE)


        See Also:
           IconArrange, WinHide, WinIconize, WinItemize, WinPlace, WinShow,
           WinZoom
















         ________________________________________________________________
                                                                      247

                                                                 WinClose
         ________________________________________________________________




        WinClose
        Closes an open window.


        Syntax:
         WinClose (partial-winname)

        Parameters:
         (s) partial-winname     either an initial portion of, or an entire
                                 window name.  The most-recently used
                                 window whose title matches the name will
                                 be closed.

        Returns:
         (i)          @TRUE if a window was found to close;
                      @FALSE if no windows were found.

        Use this function to close windows.

        WinClose will not close the window which contains the currently-
        executing WIL program.  You can, however, use EndSession to end the
        current Windows session.

        This function works only with top-level (parent) application
        windows.


        Example:
         Run("notepad.exe", "")
         WinClose("Notepad")


        See Also:
           EndSession, WinCloseNot, WinHide, WinIconize, WinItemize,
           WinWaitClose














         ________________________________________________________________
                                                                      248

                                                              WinCloseNot
         ________________________________________________________________




        WinCloseNot
        Closes all windows, except those provided as parameters.


        Syntax:
         WinCloseNot (partial-winname [, partial-winname...])

        Parameters:
         (s) partial-winname     either an initial portion of, or an entire
                                 window name.  Any windows whose titles
                                 match the partial names will stay open.

        Returns:
         (i)          always 1.

        Use this function to close all windows except those specifically
        listed in the parameter strings.

        At least one partial window name must be given.  A null-string
        parameter would match all windows, or, in other words, close
        nothing.

        This function works only with top-level (parent) application
        windows.


        Example:
         ; The statement below will close all windows except:
         ; 1) Program Manager (starts with 'Program')
         ; 2) Clock  (starts with 'Clo' )
         WinCloseNot("Program", "Clo")


        See Also:
           EndSession, WinClose, WinHide, WinIconize, WinItemize,
           WinWaitClose













         ________________________________________________________________
                                                                      249

                                                                WinConfig
         ________________________________________________________________




        WinConfig
        Returns WIN3 mode flags.


        Syntax:
         WinConfig ( )

        Parameters:
         (none)

        Returns:
         (i)          sum of Windows configuration bits.


        Returns Windows configuration information as a number, which is the
        sum of the following individual bits:

           1    Protected Mode
           2    80286 CPU
           4    80386 CPU
           8    80486 CPU
           16   Standard Mode
           32   Enhanced Mode
           64   8086 CPU
           128  80186 CPU
           256  Large PageFrame
           512  Small PageFrame
           1024 80x87 Installed

        You will need to use bitwise operators to extract the individual
        bits.


        Examples:
         cfg = WinConfig()
         If cfg & 32 Then Display(2, "Windows Mode", "Enhanced Mode")
         If cfg & 16 Then Display(2, "Windows Mode", "Standard Mode")
         If !(cfg & 1) Then Display(2, "Windows Mode", "Real Mode")

         cfg = WinConfig()
         If cfg & 1024 Then Display(2, "Math co-processor", "Yes")
         If !(cfg & 1024) Then Display(2, "Math co-processor", "No")

        See Also:
           NetGetCaps, WinMetrics, WinParmGet, WinResources




         ________________________________________________________________
                                                                      250

                                                               WinExeName
         ________________________________________________________________




        WinExeName
        Returns the name of the executable file which created a specified
        window.


        Syntax:
         WinExeName (partial-winname)

        Parameters:
         (s) partial-winname     the initial part of, or an entire, window
                                 name.

        Returns:
         (s)                     name of the EXE file.

        Returns the name of the EXE file which created the first window
        found whose title matches "partial-winname".

        "Partial-winname" is the initial part of a window name, and may be
        a complete window name.  It is case-sensitive.  You should specify
        enough characters so that "partial-winname" matches only one
        existing window.

        This function works only with top-level (parent) application
        windows.


        Example:
         prog = WinExeName("WinCheck")
         WinClose("WinCheck")
         Delay(5)
         Run(prog, "")


        See Also:
           AppExist, AppWaitClose, Run, WinExist, WinGetActive, WinName













         ________________________________________________________________
                                                                      251

                                                                 WinExist
         ________________________________________________________________




        WinExist
        Tells if specified window exists.


        Syntax:
         WinExist (partial-winname)

        Parameters:
         (s) partial-winname     the initial part of, or an entire, window
                                 name.

        Returns:
         (i)          @TRUE if a matching window is found;
                      @FALSE if a matching window is not found.

        Note: The partial window name you give must match the initial
        portion of the window name (as appears in the title bar) exactly,
        including proper case (upper or lower) and punctuation.

        This function works only with top-level (parent) application
        windows.


        Example:
         If WinExist("Clock") == @FALSE Then RunIcon("Clock", "")

        See Also:
           AppExist, WinActivate, WinClose, WinExeName, WinGetActive,
           WinItemize, WinState




















         ________________________________________________________________
                                                                      252

                                                             WinGetActive
         ________________________________________________________________




        WinGetActive
        Gets the title of the active window.


        Syntax:
         WinGetActive ( )

        Parameters:
         (none)

        Returns:
         (s)          title of active window.

        Use this function to determine which window is currently active.


        Example:
         currentwin = WinGetActive()


        See Also:
           WinActivate, WinExeName, WinItemize, WinName, WinPlaceGet,
           WinPosition, WinTitle


























         ________________________________________________________________
                                                                      253

                                                                  WinHelp
         ________________________________________________________________




        WinHelp
        Calls a Windows help file.


        Syntax:
         WinHelp (help-file, function, keyword)

        Parameters:
         (s) help-file    name of the Windows help file, with an optional
                          full path.
         (s) function     function to perform (see below).
         (s) keyword      keyword to look up in the help file
                          (if applicable), or "".

        Returns:
         (i)              @TRUE if successful; @FALSE if unsuccessful.


        This command can be used to perform several functions from a
        Windows help (.HLP) file.  It requires that the Windows help
        program WINHELP.EXE be accessible.  The desired function is
        indicated by the "function" parameter (which is not case-
        sensitive).  The possible choices for "function" are:


























         ________________________________________________________________
                                                                      254

                                                                  WinHelp
         ________________________________________________________________

           "Contents"    Brings up the Contents page for the help file.

           "Key"         Brings up help for the keyword specified by the
                         "keyword" parameter.  You must specify a complete
                         keyword, and it must be spelled correctly.  If
                         there is more than one occurrence of "keyword" in
                         the help file, a search box will be displayed
                         which allow you to select the desired topic from
                         the available choices.

           "PartialKey"  Brings up help for the keyword specified by the
                         "keyword" parameter.  You may specify a partial
                         keyword name:  if it matches more than one keyword
                         in the help file, a search box  will be displayed
                         which allow you to select the desired one from the
                         available choices.  You may also specify a null
                         string ("") for "keyword", in which case you will
                         get a search dialog containing all keywords in the
                         help file.

           "Command"     Executes the help macro specified by the "keyword"
                         parameter.

           "Quit"        Closes the WINHELP.EXE window, unless another
                         application is still using it.

           "HelpOnHelp"  Brings up the help file for the Windows help
                         program (WINHELP.HLP).


        For the functions which do not require a keyword (i.e., "Contents",
        "Quit", and "HelpOnHelp"), specify a null string ("") for the
        "keyword" parameter.


        Example:
         WinHelp("wil.hlp", "Key", "ItemSelect")















         ________________________________________________________________
                                                                      255

                                                                  WinHide
         ________________________________________________________________




        WinHide
        Hides a window.


        Syntax:
         WinHide (partial-winname)

        Parameters:
         (s) partial-winname     either an initial portion of, or an entire
                                 window name.  The most-recently used
                                 window whose title matches the name will
                                 be hidden.

        Returns:
         (i)          @TRUE if a window was found to hide;
                      @FALSE if no windows were found.

        Use this function to hide windows.  The programs are still running
        when they are hidden.

        A partial-window name of "" (null string) hides the window making
        the current call to the WIL Interpreter.

        This function works only with top-level (parent) application
        windows.


        Example:
         Run("notepad.exe", "")
         WinHide("Notepad")
         Delay(3)
         WinShow("Notepad")


        See Also:
           RunHide, WinClose, WinIconize, WinPlace













         ________________________________________________________________
                                                                      256

                                                               WinIconize
         ________________________________________________________________




        WinIconize
        Iconizes a window.


        Syntax:
         WinIconize (partial-winname)

        Parameters:
         (s) partial-winname     either an initial portion of, or an entire
                                 window name.  The most-recently used
                                 window whose title matches the name will
                                 be iconized.

        Returns:
         (i)          @TRUE if a window was found to iconize;
                      @FALSE if no windows were found.

        Use this function to turn a window into an icon at the bottom of
        the screen.

        A partial-window name of "" (null string) iconizes the current WIL
        Interpreter window.

        This function works only with top-level (parent) application
        windows.


        Example:
         Run("clock.exe", "")
         WinIconize("Clo")  ; partial window name used here


        See Also:
           IconArrange, RunIcon, WinClose, WinHide, WinPlace, WinShow,
           WinZoom














         ________________________________________________________________
                                                                      257

                                                               WinItemize
         ________________________________________________________________




        WinItemize
        Returns a tab-delimited list of all open windows.


        Syntax:
         WinItemize ( )

        Parameters:
         (none)

        Returns:
         (s)          list of the titles of all open windows.

        This function compiles a list of all the open application windows'
        titles and separates the titles by tabs.  This is especially useful
        in conjunction with the ItemSelect function, which enables the user
        to choose an item from such a tab-delimited list.

        Note this behaves somewhat differently than FileItemize and
        DirItemize, which create space-delimited lists.  This is because
        window titles regularly contain embedded spaces.

        This function works only with top-level (parent) application
        windows.


        Example:
         ; Find a window
         allwins = WinItemize()
         htab = Num2Char(9)
         mywind = ItemSelect("Windows", allwins, htab)
         WinActivate(mywind)


        See Also:
           DirItemize, FileItemize, ItemSelect, TextSelect, WinClose,
           WinCloseNot, WinGetActive, WinName, WinPlaceGet, WinPosition












         ________________________________________________________________
                                                                      258

                                                               WinMetrics
         ________________________________________________________________




        WinMetrics
        Returns Windows system information.


        Syntax:
         WinMetrics (request#)

        Parameters:
         (i) request#   see below.

        Returns:
         (i)            see below.

        The request# parameter determines what piece of information will be
        returned.


































         ________________________________________________________________
                                                                      259

                                                               WinMetrics
         ________________________________________________________________

           Req# Return value
          -1    Number of colors supported by video driver
           0    Width of screen, in pixels
           1    Height of screen, in pixels
           2    Width of arrow on vertical scrollbar
           3    Height of arrow on horizontal scrollbar
           4    Height of window title bar
           5    Width of window border lines
           6    Height of window border lines
           7    Width of dialog box frame
           8    Height of dialog box frame
           9    Height of thumb box on scrollbar
           10   Width of thumb box on scrollbar
           11   Width of an icon
           12   Height of an icon
           13   Width of a cursor
           14   Height of a cursor
           15   Height of a one line menu bar
           16   Width of full screen window
           17   Height of a full screen window
           18   Height of Kanji window (Japanese)
           19   Is a mouse present (0 = No, 1 = Yes)
           20   Height of arrow on vertical scrollbar
           21   Width of arrow on horizontal scrollbar
           22   Is debug version of Windows running (0 = No, 1 = Yes)
           23   Are Left and Right mouse buttons swapped (0 = No, 1 = Yes)
           24   Reserved
           25   Reserved
           26   Reserved
           27   Reserved
           28   Minimum width of a window
           29   Minimum height of a window
           30   Width of bitmaps in title bar
           31   Height of bitmaps in title bar
           32   Width of sizeable window frame
           33   Height of sizeable window frame
           34   Minimum tracking width of a window
           35   Minimum tracking height of a window

        Example:
         mouse = "NO"
         If WinMetrics(19) == 1 Then mouse = "YES"
         Message("Is there a mouse installed?", mouse)


        See Also:
           Environment, MouseInfo, NetGetCaps, WinConfig, WinParmGet,
           WinResources




         ________________________________________________________________
                                                                      260

                                                                  WinName
         ________________________________________________________________




        WinName
        Returns the name of the window calling the WIL Interpreter.


        Syntax:
         WinName ( )

        Parameters:
         (none)

        Returns:
         (s)          window name.

        Returns the name of the window making the current call to the WIL
        Interpreter.


        Example:
         tab = Num2Char(9)
         allwins = WinItemize()
         win = ItemSelect("Close window", allwins, tab)
         If win == WinName() Then Goto nocando
         WinClose(win)
         Exit
         :nocando
         Message("Sorry", "I can't close myself")


        See Also:
           WinActivate, WinExeName, WinGetActive, WinItemize, WinTitle



















         ________________________________________________________________
                                                                      261

                                                               WinParmGet
         ________________________________________________________________




        WinParmGet
        Returns system information.


        Syntax:
         WinParmGet (request#)

        Parameters:
         (i) request# see below.

        Returns:
         (s)          see below.

        Note: This function requires Windows 3.1 or higher.

        The request# parameter determines what piece of information will be
        returned.

          Req#   Meaning             Return value

           1   Beeping               0 = Off, 1 = On
           2   Mouse sensitivity     "threshold1 threshold2 speed"
           3   Border Width          Width in pixels
           4   Keyboard Speed        Keyboard Repeat rate
           5   LangDriver            name of LANGUAGE.DLL
           6   Horiz. Icon Spacing   Spacing in pixels
           7   Screen Save Timeout   Timeout in seconds
           8   Is screen saver on    0 = No, 1 = Yes
           9   Desktop Grid size     Grid Size
           10  Wallpaper BMP file    BMP file name
           11  Desktop Pattern       Pattern codes (string of 8
                                                    space-delimited nums.)
           12  Keyboard Delay        Delay in milliseconds
           13  Vert. Icon Spacing    Spacing in pixels
           14  Icon Title Wrap       0 = No, 1 = Yes
           15  MenuDropAlign         0 = Right, 1 = Left
           16  DoubleClickWidth      Allowable horiz. movement in pixels
                                     for DblClick
           17  DoubleClickHeight     Allowable vert. movement in pixels for
                                     DblClick
           18  DoubleClickSpeed      Max time in millisecs between clicks
                                     for DblClick
           19  MouseButtonSwap       0 = Not swapped, 1 = swapped
           20  Fast Task Switch      0 = Off, 1 = On


        Example:
         If WinParmGet(8) == 1 Then Message("", "Screen saver is active")

         ________________________________________________________________
                                                                      262

                                                               WinParmGet
         ________________________________________________________________



        See Also:
           Environment, MouseInfo, NetGetCaps, WinConfig, WinMetrics,
           WinParmSet, WinResources















































         ________________________________________________________________
                                                                      263

                                                               WinParmSet
         ________________________________________________________________




        WinParmSet
        Sets system information.


        Syntax:
         WinParmSet (request#, new-value, ini-control)

        Parameters:
         (i) request#       see WinParmGet
         (s) new-value      see WinParmGet
         (i) ini-control    see below.

        Returns:
         (int)              previous value of the setting.

        Note: This function requires Windows 3.1 or higher.

        See WinParmSet for a list of valid request#'s and values.

        The "ini-control" parameter determines to what extent the value
        gets updated:

           0   Set system value in memory only for future reference
           1   Write new value to appropriate INI file
           2   Broadcast message to all applications informing them of new
               value
           3   Both 1 and 2


        Example:
         WinParmSet(9, "2", 3)   ; sets desktop grid size to 2


        See Also:
           WallPaper, WinParmGet














         ________________________________________________________________
                                                                      264

                                                                 WinPlace
         ________________________________________________________________




        WinPlace
        Places a window anywhere on the screen.


        Syntax:
         WinPlace (x-ulc, y-ulc, x-brc, y-brc, partial-winname)

        Parameters:
         (i) x-ulc             how far from the left of the screen to place
                               the upper-left corner (0-1000).
         (i) y-ulc             how far from the top of the screen to place
                               the upper-left corner (0-1000).
         (i) x-brc             how far from the left of the screen to place
                               bottom-right corner (10-1000) or @NORESIZE.
         (i) y-brc             how far from the top of the screen to place
                               the bottom-right corner (10-1000) or
                               @NORESIZE or @ABOVEICONS.
         (s) partial-winname   either an initial portion of, or an entire
                               window name.  The most-recently used window
                               whose title matches the name will be moved
                               to the new position.

        Returns:
         (i)          @TRUE if a window was found to move;
                      @FALSE if no windows were found.

        Use this function to move windows on the screen.  (You cannot,
        however, move icons or windows that have been maximized to full
        screen.)

        The "x-ulc", "y-ulc", "x-brc", and "y-brc" parameters are based on
        a logical screen that is 1000 points wide by 1000 points high.

        You can move the window without changing the width and/or height by
        specifying @NORESIZE for the "x-brc" and/or "y-brc" parameters,
        respectively.

        You can fix the bottom of the window to sit just above the line of
        icons along the bottom of the screen by specifying a "y-brc" of
        @ABOVEICONS.

        Some sample parameters:

           Upper left quarter of the screen:    0,    0,  500,  500
           Upper right quarter:               500,    0, 1000,  500
           Center quarter:                    250,  250,  750,  750
           Lower left eighth:                   0,  750,  500, 1000


         ________________________________________________________________
                                                                      265

                                                                 WinPlace
         ________________________________________________________________

        This function works only with top-level (parent) application
        windows.


        Example:
         WinPlace(0, 0, 200, 200, "Clock")


        See Also:
           WinArrange, WinHide, WinIconize, WinPlaceSet, WinPosition,
           WinShow, WinZoom









































         ________________________________________________________________
                                                                      266

                                                              WinPlaceGet
         ________________________________________________________________




        WinPlaceGet
        Returns window coordinates.


        Syntax:
         WinPlaceGet (win-type, partial-winname)

        Parameters:
         (i) win-type            @ICON, @NORMAL, or @ZOOMED
         (s) partial-winname     the initial part of, or an entire, window
                                 name.

        Returns:
         (s)                     window coordinates (see below).

        This function returns the coordinates for an iconized, normal, or
        zoomed window.

        "Partial-winname" is the initial part of a window name, and may be
        a complete window name.  It is case-sensitive.  You should specify
        enough characters so that "partial-winname" matches only one
        existing window.  If it matches more than one window, the most
        recently accessed window which it matches will be used.

        The returned value is a string of either 2 or 4 numbers, as
        follows:

           Iconic windows   "x y"     (upper left corner of the icon)
           Normal windows   "upper-x upper-y lower-x lower-y"
           Zoomed windows   "x y"     (upper left corner of the window)

        All coordinates are relative to a virtual 1000x1000 screen.

        This function works only with top-level (parent) application
        windows.


        Examples:
         Run("clock.exe", "")
         pos = WinPlaceGet(@NORMAL, "Clock")
         Delay(2)
         WinPlaceSet(@NORMAL, "Clock", "250 250 750 750")
         Delay(2)
         WinPlaceSet(@NORMAL, "Clock", pos)


        See Also:
           WinGetActive, WinItemize, WinPlaceSet, WinPosition, WinState

         ________________________________________________________________
                                                                      267

                                                              WinPlaceSet
         ________________________________________________________________




        WinPlaceSet
        Sets window coordinates.


        Syntax:
         WinPlaceSet (win-type, partial-winname, position-string)

        Parameters:
         (i) win-type            @ICON, @NORMAL, or @ZOOMED
         (s) partial-winname     the initial part of, or an entire, window
                                 name.
         (s) position-string     window coordinates (see below).

        Returns:
         (s)                     previous coordinates.

        This function sets the coordinates for an iconized, normal, or
        zoomed window.  The window does not have to be in the desired state
        to set the coordinates; for example, you can set the iconized
        position for a normal window so that when the window is
        subsequently iconized, it will go to the coordinates that you've
        set.

        "Partial-winname" is the initial part of a window name, and may be
        a complete window name.  It is case-sensitive.  You should specify
        enough characters so that "partial-winname" matches only one
        existing window.  If it matches more than one window, the most
        recently accessed window which it matches will be used.

        "Position-string" is a string of either 2 or 4 numbers, as follows:

           Iconic windows   "x y"     (upper left corner of the icon)
           Normal windows   "upper-x upper-y lower-x lower-y"
           Zoomed windows   "x y"     (upper left corner of the window)

        All coordinates are relative to a virtual 1000x1000 screen.

        This function works only with top-level (parent) application
        windows.


        Examples:
         WinPlaceSet(@ICON, "Clock", "10 950")

         WinPlaceSet(@NORMAL, "Clock", "250 250 750 750")

         WinPlaceSet(@ZOOMED, "Clock", "-5 -5")


         ________________________________________________________________
                                                                      268

                                                              WinPlaceSet
         ________________________________________________________________


        See Also:
           IconArrange, WinActivate, WinArrange, WinPlace, WinPlaceGet,
           WinState
















































         ________________________________________________________________
                                                                      269

                                                              WinPosition
         ________________________________________________________________




        WinPosition
        Returns Window position.


        Syntax:
         WinPosition (partial-winname)

        Parameters:
         (s) partial-winname     the initial part of, or an entire, window
                                 name.

        Returns:
         (s)                     window coordinates, delimited by commas.


        Returns the current window position information for the selected
        window.  It returns 4 comma-separated numbers (see WinPlace for
        details).

        This function works only with top-level (parent) application
        windows.


        Example:
         Run("clock.exe", "")                   ; start Clock
         WinPlace(0,0,300,300, "Clock")         ; place Clock
         pos = WinPosition("Clock")             ; save position
         delay(2)
         WinPlace(200,200,300,300, "Clock")     ; move Clock
         delay(2)
         WinPlace(%pos%, "Clock")               ; restore Clock


        See Also:
           WinGetActive, WinItemize, WinPlace, WinPlaceGet, WinState














         ________________________________________________________________
                                                                      270

                                                             WinResources
         ________________________________________________________________




        WinResources
        Returns information on available memory and resources.


        Syntax:
         WinResources (request#)

        Parameters:
         (i) request#    see below

        Returns:
         (i)             see below.

        The value of request# determined the piece of information returned.

           Req#   Return value

           0  Total available memory, in bytes
           1  Theoretical maximum available memory, in bytes
           2  Percent of free system resources (lower of GDI and USER)
           3  Percent of free GDI resources
           4  Percent of free USER resources


        Example:
         mem = WinResources(0)
         Message("Available memory", "%mem% bytes")


        See Also:
           WinConfig, WinMetrics, WinParmGet


















         ________________________________________________________________
                                                                      271

                                                                  WinShow
         ________________________________________________________________




        WinShow
        Shows a window in its "normal" state.


        Syntax:
         WinShow (partial-winname)

        Parameters:
         (s) partial-winname     either an initial portion of, or an entire
                                 window name.  The most-recently used
                                 window whose title matches the name will
                                 be shown.

        Returns:
         (i)                     @TRUE if a window was found to show;
                                 @FALSE if no windows were found.

        Use this function to restore a window to its "normal" size and
        position.

        A partial-window name of "" (null string) restores the current WIL
        interpreter window.


        Example:
         RunZoom("notepad.exe", "")
         ; other processing...
         WinShow("Notepad")


        See Also:
           WinArrange, WinHide, WinIconize, WinZoom

















         ________________________________________________________________
                                                                      272

                                                                 WinState
         ________________________________________________________________




        WinState
        Returns the current state of a window.


        Syntax:
         WinState (partial-winname)

        Parameters:
         (s) partial-winname     the initial part of, or an entire, window
                                 name.

        Returns:
         (i)                     window state (see below).

        "Partial-winname" is the initial part of a window name, and may be
        a complete window name.  It is case-sensitive.  You should specify
        enough characters so that "partial-winname" matches only one
        existing window.  If it matches more than one window, the most
        recently accessed window which it matches will be used.

        Possible return values are as follows.

           Value Symbolic name   Meaning

          -1                 Specified window exists, but is hidden
           0                 Specified window does not exist
           1     @ICON       Specified window is iconic (minimized)
           2     @NORMAL     Specified window is a normal window
           3     @ZOOMED     Specified window is zoomed (maximized)

        This function works only with top-level (parent) application
        windows.


        Example:
         If WinState("Notepad") == @ICON Then WinShow("Notepad")


        See Also:
           Run, WinExist, WinGetActive, WinHide, WinIconize, WinItemize,
           WinPlace, WinPlaceGet, WinPlaceSet, WinPosition, WinShow,
           WinZoom







         ________________________________________________________________
                                                                      273

                                                                 WinTitle
         ________________________________________________________________




        WinTitle
        Changes the title of a window.


        Syntax:
         WinTitle (partial-winname, new-name)

        Parameters:
         (s) partial-winname     either an initial portion of, or an entire
                                 window name.  The most-recently used
                                 window whose title matches the name will
                                 be shown.
         (s) new-name            the new name of the window.

        Returns:
         (i)          @TRUE if a window was found to rename;
                      @FALSE if no windows were found.

        Use this function to change a window's title.

        A partial-window name of "" (null string) refers to the current WIL
        interpreter window.

        Warning:  Some applications may rely upon their window's title
        staying the same!  Therefore, the WinTitle function should be used
        with caution and adequate testing.

        This function works only with top-level (parent) application
        windows.


        Example:
         ; Capitalize title of window
         htab = Num2Char(9)
         allwinds = WinItemize()
         mywin = ItemSelect("Uppercase Windows", allwinds, htab)
         WinTitle(mywin, StrUpper(mywin))
         Drop(htab, allwinds, mywin)


        See Also:
           WinGetActive, WinItemize, WinName







         ________________________________________________________________
                                                                      274

                                                               WinVersion
         ________________________________________________________________




        WinVersion
        Provides the version number of the current Windows system.


        Syntax:
         WinVersion (level)

        Parameters:
         (i) level    either @MAJOR or @MINOR.

        Returns:
         (i)          either major or minor part of the Windows version
                      number.

        Use this command to determine which version of Windows is currently
        running.

        @MAJOR returns the integer part of the Windows version number; i.e.
        1.0, 2.11, 3.0, etc.

        @MINOR returns the decimal part of the Windows version number; i.e.
        1.0, 2.11, 3.0, etc.


        Example:
         minorver = WinVersion(@MINOR)
         majorver = WinVersion(@MAJOR)
         Message("Windows Version", StrCat(majorver, ".", minorver))


        See Also:
           Version, DOSVersion

















         ________________________________________________________________
                                                                      275

                                                             WinWaitClose
         ________________________________________________________________




        WinWaitClose
        Suspends the WIL program execution until a specified window has
        been closed.


        Syntax:
         WinWaitClose (partial-winname)

        Parameters:
         (s) partial-winname     either an initial portion of, or an entire
                                 window name.  WinWaitClose suspends
                                 execution until all matching windows have
                                 been closed.

        Returns:
         (i)          @TRUE if at least one window was found to wait for;
                      @FALSE if no windows were found.

        Use this function to suspend the WIL program's execution until the
        user has finished using a given window and has manually closed it.

        This function works only with top-level (parent) application
        windows.


        Example:
         Run("clock.exe", "")
         Display(4, "Note", "Close Clock to continue")
         WinWaitClose("Clock")
         Message("Continuing...", "Clock closed")


        See Also:
           Delay, RunWait, WinExist, Yield















         ________________________________________________________________
                                                                      276

                                                                  WinZoom
         ________________________________________________________________




        WinZoom
        Maximizes a window to full-screen.


        Syntax:
         WinZoom (partial-winname)

        Parameters:
         (s) partial-winname     either an initial portion of, or an entire
                                 window name.  The most-recently used
                                 window whose title matches the name will
                                 be shown.

        Returns:
         (i)                     @TRUE if a window was found to zoom;
                                 @FALSE if no windows were found.

        Use this function to "zoom" windows to full screen size.

        A partial-window name of "" (null string) zooms the current WIL
        interpreter window.

        This function works only with top-level (parent) application
        windows.


        Example:
         Run("notepad.exe", "")
         WinZoom("Notepad")
         Delay(3)
         WinShow("Notepad")


        See Also:
           RunZoom, WinHide, WinIconize, WinPlace, WinShow














         ________________________________________________________________
                                                                      277

                                                                    Yield
         ________________________________________________________________




        Yield
        Provides time for other windows to do processing.


        Syntax:
         Yield

        Parameters:
         (none)

        Returns:
         (not applicable)

        Use this command to give other running windows time to process.
        This command will allow each open window to process 20 or more
        messages.


        Example:
         ; run Excel and give it some time to start up
         sheet = AskLine ("Excel", "File to run:", "")
         Run("excel.exe", sheet)
         Yield
         Yield
         Yield


        See Also:
           Delay, Exclusive




















         ________________________________________________________________
                                                                      278

                                        APPENDIX A - PREDEFINED CONSTANTS
         ________________________________________________________________


                                     APPENDIX A

                                Predefined Constants

        WIL provides you with a number of predefined integer constants to
        help make your WIL programs more mnemonic:


        Logical Conditions                  String Handling
        @FALSE                              @FWDSCAN
        @NO                                 @BACKSCAN
        @OFF
        @TRUE                               Menu Handling
        @YES                                @ENABLE
        @ON                                 @DISABLE
                                            @UNCHECK
        Window Arranging                    @CHECK
        @NORESIZE
        @ABOVEICONS                         System Control
        @STACK                              @MAJOR
        @ARRANGE                            @MINOR
        @TITLE
        @ROWS                               Error Handling
        @COLUMNS                            @CANCEL
                                            @NOTIFY
        Window Status                       @OFF
        @NORMAL
        @ZOOMED                             Keyboard Status
        @ICON                               @SHIFT
        @HIDDEN                             @CTRL

        Menu Handling                       Debug Control
        @CHECK                              @PARSEONLY
        @UNCHECK
        @DISABLE                            INI File Management
        @ENABLE                             @WHOLESECTION















         ________________________________________________________________
                                                                      279

                                                      APPENDIX B - ERRORS
         ________________________________________________________________


                                     APPENDIX B

                                       Errors

        If the current error mode is @CANCEL (the default), any WIL errors
        encountered while processing a WIL program cause the item to be
        canceled with an error message.




        Minor Errors
        Minor errors are ignored if the current error mode has been set to
        @OFF.  If the error mode is @NOTIFY the user has the option of
        continuing with the WIL program or canceling it.

        1006 File Copy/Move: No matching files found
        1017 File Delete: No matching files found
        1018 File Delete: Delete Failed
        1024 File Rename: No matching files found
        1025 File Rename: Rename failed
        1028 LogDisk: Requested drive not online
        1029 DirMake: Dir not created
        1030 DirRemove: Dir not removed
        1031 DirChange: Dir not found/changed
        1039 WinClose: Window not found
        1040 WinHide: Window not found
        1041 WinIconize: Window not found
        1042 WinZoom: Window not found
        1043 WinShow: Window not found
        1044 WinPlace: Window not found
        1045 WinActivate: Window not found
        1077 FileOpen: Open failed
        1083 FileAttrGet: File not found
        1086 FileAttrSet: File not found or access denied
        1100 StrIndex/StrScan 3rd parameter out of bounds
        1119 WinPosition: Window not found
        1121 WinTitle: Window not found
        1125 FileTimeGet: File not found
        1128 FileTimeTouch: File not found
        1150 DDEExec: DDE Post failed
        1155 DDEReq: DDE Post failed
        1163 DDEPoke: DDE Post failed
        1164 DDEPoke: DDE Timeout
        1165 DDEReq: DDE Timeout
        1166 DDEExec: DDE Timeout
        1172 WinExeName: Window not found
        1173 Net: No network found
        1174 Net: Security Violation
        1175 Net: Function not supported

         ________________________________________________________________
                                                                      281

                                                      APPENDIX B - ERRORS
         ________________________________________________________________

        1176 Net: Out of Memory
        1177 Net: Network Error
        1178 Net: Windows function failed
        1179 Net: Invalid type of request
        1180 Net: Invalid Pointer
        1181 Net: Cancelled at users request
        1182 Net: Bad user / Not logged in
        1183 Net: Buffer too small - Internal Error
        1184 Net: Invalid Network name
        1185 Net: Invalid Local Name
        1186 Net: Invalid Password
        1187 Net: Local Device already connected
        1188 Net: Not a valid local device or network name
        1189 Net: Not a redirected local device or current net name
        1190 Net: Files were open with FORCE=FALSE
        1191 Net: Function busy
        1192 Net: Unknown network error
        1193 Function not supported in this version of Windows
        1194 PlaySounds: File not found
        1195 PlayMedia: Unrecognised Error
        1200 WinPlaceGet/Set: Window not found
        1201 WinPlaceGet/Set: Function failed
        1207 SnapShot: Out of memory
        1208 SnapShot: Palette Creation Error
        1209 SnapShot: Cannot open clipboard
        1213 Cmd Extender: Minor error occurred
        1216 RunWait Commands not supported in 3.0 Debug Windows
        1217 WinHelp: Invalid SubCommand Requested



        Moderate Errors
        If the error mode is @NOTIFY or @OFF, the user has the option of
        continuing with the WIL program or canceling it.

        2001 SendKey: Illegal Parameters
        2002 File Copy/Move: 'From' file illegal
        2003 File Copy/Move: 'To'   file illegal
        2004 File Copy/Move: Cannot put wildcards into fixed root
        2005 File Copy/Move: Cannot put wildcards into fixed extension
        2007 File Move: Unable to rename source file
        2016 File Delete: File name illegal
        2019 File Rename: 'From' file illegal
        2020 File Rename: 'To' file illegal
        2021 File Rename: Can't change disk drives. Use MOVE instead.
        2022 File Rename: Cannot put wildcards into a fixed root
        2023 File Rename: Cannot put wildcards into a fixed extension
        2038 WinCloseNot Function Syntax error
        2058 StrCat: Function syntax error
        2060 AVERAGE function syntax error
        2093 Dialog Box: Bad Filespec, using *.*

         ________________________________________________________________
                                                                      282

                                                      APPENDIX B - ERRORS
         ________________________________________________________________

        2106 SetDisplay: Type not NAME, DATE, SIZE, KIND or UNSORTED
        2112 FileSize: File Not Found
        2118 FileCopy/Move: Destination file same as source
        2120 SetDisplay: Display type not SHORT or LONG
        2122 FileAppend: Target cannot be wildcarded
        2203 Dir Rename: 'From' file illegal
        2204 Dir Rename: 'To' file illegal
        2214 Cmd Extender: Moderate Error Occurred



        Fatal Errors
        Fatal errors cause the current WIL program to be canceled with an
        error message, regardless of the error mode in effect.  (We show
        the error codes here for consistency, but in practice you will
        never be able to call LastError after a fatal error.)

        3008 File Copy/Move: 'From' file open error
        3009 SendKey: Could not open DEBUG TEXT file
        3010 SendKey: Could not install hook - Already Active??
        3011 File Copy/Move: 'From' file length error
        3012 File Copy/Move: No room left on disk.  Out of space??
        3013 File Copy/Move: 'To' file open error
        3014 File Copy/Move: I/O Error
        3015 File Move:  Unable to remove source file
        3026 LogDisk: Illegal disk drive
        3027 LogDisk: DOS reports no disks!!  ???
        3032 GoTo unable to lock memory for batch file
        3033 GoTo label not found
        3034 Clipboard owned by another app.  Cannot open.
        3035 Clipboard does not contain text for CLIPAPPEND.
        3036 Clipboard cannot hold that much text (>64000 bytes)
        3037 Unable to get memory for clipboard.  Close some apps
        3046 Internal Error 3046. Function not defined
        3047 Variable name over 30 chars. Too Long
        3048 Substitution %Variable% not followed by a % (Use %% for %)
        3049 No variables exist??!!
        3050 Undefined variable
        3051 Undefined variable or function
        3052 Uninitialized variable or undefined function
        3053 Character string too long (>256 chars??)
        3054 Unrecognizable item found on line
        3055 Variable name over 30 chars. Too Long
        3056 Variable could not be converted to string
        3057 Variable could not be converted to integer
        3059 Illegal Bounds for STRSUB function
        3061 Illegal Syntax
        3062 Attempt to divide by zero
        3063 Internal Error 3063. Binary op not found
        3064 Internal Error 3064. Unary op not found
        3065 Unbalanced Parenthesis

         ________________________________________________________________
                                                                      283

                                                      APPENDIX B - ERRORS
         ________________________________________________________________

        3066 Wrong Number of Arguments in Function
        3067 Function Syntax. Opening parenthesis missing.
        3068 Function Syntax. Illegal delimiter found.
        3069 Bad assignment statement. (Use == for equality testing)
        3070 Internal error 3070.  Too many arguments defined.
        3071 Missing or incomplete statement
        3072 THEN not found in IF statement
        3073 Goto Label not specified
        3074 Expression continues past expected end.
        3075 Call: Parse of file/parameter line failed
        3076 FileOpen: READ or WRITE not properly specified
        3078 FileOpen: Too many (>5) files open
        3079 FileClose: Invalid file handle
        3080 FileClose: File not currently open
        3081 FileRead: Invalid file handle
        3082 FileRead: File not currently open
        3084 FileWrite: Invalid file handle
        3085 FileWrite: File not currently open
        3087 FileRead:  File not open for reading
        3088 FileRead: Attempt to read past end of file
        3089 FileWrite: File not open for writing
        3090 Dialog Box: File open error
        3091 Dialog Box: Box too large (20x60 max)
        3092 Dialog Box: Non-text control used w/filebox.
        3094 Dialog Box: Window Registration Failed
        3095 Compare: Not an integer or string compare
        3096 Memory allocation failure.  Out of memory for strings
        3097 Memory allocation failure.  Out of memory for variables
        3098 IntErr: NULL pointer passed to xstrxxx subroutines
        3099 CallExt function disabled.  Not currently available.
        3101 Substituted line too long. (> 256 characters)
        3102 Drop: Can only drop variables
        3103 IsDefined: Attempting to test non-variable item
        3104 Dialog Box: Window Creation Failed
        3105 CALL and CALLEXT not supported in compiled versions
        3107 Run:  Filetype is not COM, EXE, PIF or BAT
        3108 FileItemize: Unable to lock file info segment
        3109 FileItemize: Unable to unlock file info segment
        3110 FileItemize: Unable to lock file index segment
        3111 FileItemize: Unable to unlock file index segment
        3113 FileSize: Filelength I/O Error
        3114 FileSize: Buffer Overrun Error
        3115 FileDelete: Buffer Overrun Error
        3116 FileRename: Buffer Overrun Error
        3117 FileCopy/Move: Buffer Overrun Error
        3123 WaitForKey: Invalid key codes specified
        3124 WinMetrics: Invalid code
        3126 FileAttrSet: Buffer Overrun Error
        3127 FileTimeTouch: Buffer Overrun Error
        3138 DDE: Too many DDE conversations
        3139 DDEInitiate: Client window create failed

         ________________________________________________________________
                                                                      284

                                                      APPENDIX B - ERRORS
         ________________________________________________________________

        3140 DDEInitiate: GlobalAddAtom failure
        3142 DDETerminate: Channel does not exist
        3144 DDETerminate: Internal Error 3144
        3145 DDEExec: GlobalAlloc failed
        3146 DDEExec: Global Lock failed
        3147 DDEExec: Bad channel number
        3149 DDEExec: Internal Error 3149
        3154 DDEReq: GlobalAddAtom failed
        3156 DDEReq: GlobalLock failed
        3160 DDEPoke: GlobalAlloc failed
        3161 DDEPoke: GlobalAddAtom failed
        3162 DDEPoke: GlobalLock failed
        3167 DDE Recv Data: GlobalLock 1 failed
        3168 DDE Recv Data: GlobalAlloc 2 failed
        3169 DDE Recv Data: GlobalLock 2 failed
        3170 DDEInitiate: Internal Error 3170
        3171 IntControl: Invalid IntControl opcode
        3196 PlayMedia: Do not use WAIT or NOTIFY in MCI string
        3197 WinResources: Invalid request number
        3198 WinParmGet/Set: Invalid request number
        3199 WinPlaceGet/Set: Invalid window-size number
        3202 WinPlaceSet: Wrong number of window co-ordinates
        3205 MouseInfo: Invalid request number
        3206 SnapShot: Invalid request number
        3210 Cmd Extender: Out of memory to save result
        3211 Call:  More than 6 levels of Calls
        3212 PlayMedia: Notify Window creation failed
        3215 Cmd Extender: Severe error occurred
        3218 Dialog: Dialog name too long (>16 chars)
        3219 Dialog: Format variable missing
        3220 Dialog: Format version not supported
        3221 Dialog: x, y, width or height variables bad
        3222 Dialog: Control definition variable missing
        3223 Dialog: Bad Control type in definition variable
        3224 Dialog: Bad or missing Value for Radio/Checkbox button
        3225 Dialog: Too many items in definition variable
















         ________________________________________________________________
                                                                      285


                                                     APPENDIX C - BROWSER
         ________________________________________________________________


                                     APPENDIX C

                                      Browser

        The Browser program lets you view a file's contents in a variety of
        ways.

        The default is to show the file in Windows' "ANSI text" mode:


        File
        These menu items let you open a new file to view, re-read the
        current file, and perform other housekeeping functions including
        exiting the program.


        Hide & Seek
        Browser gives you the ability to filter which lines you view with
        its Hide & Seek commands.  You can hide or show specific lines by
        entering a word to look for.


        Clip Copy
        Lets you copy portions of the file into the Windows Clipboard.


        Clip Append
        Lets you add portions of the file onto the end of the Windows
        Clipboard.


        Options
        These menu items let you change how you view the file; changing for
        example between ASCII text mode (which interprets some special
        characters differently than ANSI text) and hex-dump formats.













         ________________________________________________________________
                                                                      286


                                                                    INDEX
         ________________________________________________________________


                                       INDEX


        A
        Abs  61, 67-69
        AppExist  69-70
        AppWaitClose  70-71
        AskLine  23, 54, 69-73
        AskPassword  73-74
        AskYesNo  22, 54, 74-75
        Average  61, 75-76

        B
        Beep  23, 54, 76-77
        Browser  286
        ButtonNames  77-78

        C
        Call  61, 78-80
        Char2Num  59, 80-81
        ClipAppend  61, 81-82
        ClipGet  61, 82-83
        ClipPut  61, 83-84
        Comments  50-51
        Conditional Branching
          see also   Terminate
        Constants  46-48
          predefined  47-48
        CurrentFile  84-85

        D
        DateTime  63, 85-87
        DDEExecute  87-88
        DDEInitiate  88-89
        DDEPoke  89-90
        DDERequest  90-91
        DDETerminate  91-92
        DDETimeout  92-93
        Debug  61, 93-96
        Delay  23, 62, 96-97
        Dialog  54, 97-102
        DialogBox  54, 102-4
        DirChange  28, 56, 104-5
        Directory Management
          in WIL  56-57
        DirGet  28, 57, 105-6
        DirHome  57, 106-7
        DirItemize  34, 57, 107-8
         ________________________________________________________________
                                                                      287


                                                                    INDEX
         ________________________________________________________________

        DirMake  57, 108-9
        DirRemove  57, 109-10
        DirRename  57, 110-11
        DirWindows  111-12
        DiskFree  57, 112-13
        DiskScan  113-14
        Display  21, 54, 114-15
        DOSVersion  63, 115-16
        Drop  62, 116-17

        E
        Else  117-18
        EndSession  28, 62, 117-19
        Environment  38, 63, 119-20
        ErrorMode  31, 62, 120-21
        Errors  53-54, 279-83
          fatal  282-83
          minor  281
          moderate  281-82
          see also   Debug,  ErrorMode,  LastError
        Exclusive  62, 121-22
        Execute  62, 122-23
        Exit  62, 123-24

        F
        File Management  28
          in WIL  55-56
        FileAppend  55, 124-25
        FileAttrGet  125-26
        FileAttrSet  126-27
        FileClose  55, 127-28
        FileCopy  29, 55, 128-29
        FileDelete  29, 55, 129-30
        FileExist  28, 55, 130-31
        FileExtension  55, 131-32
        FileItemize  32, 55, 132-33
        FileLocate  55, 133-34
        FileMove  55, 134-35
        FileOpen  55, 135-36
        FilePath  55, 136-37
        FileRead  56, 137-38
        FileRename  29, 56, 138-39
        FileRoot  56, 139-40
        FileSize  56, 140-41
        FileTimeGet  141-42
        FileTimeTouch  142-43
        FileWrite  56, 143-44

        G
         ________________________________________________________________
                                                                      288


                                                                    INDEX
         ________________________________________________________________

        Goto  18, 62, 144-45

        I
        IconArrange  145-46
        Identifiers  48
        If ... Then  16, 146-47
        IgnoreInput  62, 147-48
        IniDelete  148-49
        IniDeletePvt  149-50
        IniItemize  150-51
        IniItemizePvt  151-52
        IniRead  56, 152-53
        IniReadPvt  56, 153-54
        IniWrite  56, 154-55
        IniWritePvt  56, 155-56
        IntControl  156-59
        IsDefined  62, 159-60
        IsKeyDown  62, 160-61
        IsLicensed  64, 161-62
        IsMenuChecked  162-63
        IsMenuEnabled  163-64
        IsNumber  59, 164-65
        ItemCount  59, 165-66
        ItemExtract  60, 166-67
        ItemInsert  167-68
        ItemLocate  168-69
        ItemRemove  169-70
        ItemSelect  33, 54, 167-72
        ItemSort  172-73

        K
        Keywords  48-49

        L
        LastError  62, 172-74
        LogDisk  57, 174-75

        M
        Max  61, 175-76
        menu files
          menu structure  45
          menuitems  45-46
        MenuChange  176-77
        Message  22, 54, 177-78
        Microsoft Windows
          date & time formatting  85
          determining the version  64, 275-76
        Min  61, 178-79
        MouseInfo  179-81
         ________________________________________________________________
                                                                      289


                                                                    INDEX
         ________________________________________________________________


        N
        NetAddCon  181-82
        NetAttach  182-83
        NetBrowse  182-84
        NetCancelCon  184-85
        NetDetach  185-86
        NetDialog  185-86
        NetGetCaps  186-89
        NetGetCon  189-90
        NetGetUser  190-91
        NetLogin  191-92
        NetLogout  191-93
        NetMapRoot  193-94
        NetMemberGet  194-95
        NetMemberSet  195-96
        NetMsgAll  196-97
        NetMsgSend  197-98
        Num2Char  36, 60, 191-99

        O
        Operators  49-50
          Precedence  50

        P
        Parameters
          function  52-53
        ParseData  60, 199-200
        Pause  22, 54, 200-201
        PlayMedia  201-3
        PlayMidi  203-4
        PlayWaveForm  204-6

        R
        Random  61, 206-7
        Reload  207-8
        Return  62, 207-9
        Run  20, 59, 213-15
        RunHide  59, 211
        RunHideWait  211-12
        RunIcon  21, 59, 213-14
        RunIconWait  213-14
        Running programs  20
          DOS programs  38
          in WIL  59
        RunWait  213-15
        RunZoom  21, 59, 213-16
        RunZoomWait  216-17

         ________________________________________________________________
                                                                      290


                                                                    INDEX
         ________________________________________________________________


        S
        Sample WBT file  40
        SendKey  39, 63, 216-20
        SKDebug  62, 220-21
        SnapShot  221-22
        Sounds  222-23
        Statements  51
          reference  63-278
        StrCat  37, 60, 223-24
        StrCmp  60, 224-25
        StrFill  60, 225-26
        StrFix  60, 226-27
        StriCmp  60, 227-28
        StrIndex  60, 228-29
        StrLen  60, 229-30
        StrLower  60, 230-31
        StrReplace  60, 231-32
        StrScan  60, 232-33
        StrSub  61, 233-34
        StrTrim  61, 234-35
        StrUpper  61, 235-36
        Substitution  51-52
          and StrCat  223-24

        T
        Terminate  236-37
        TextBox  54, 55, 237-39
        TextBoxSort  239-40
        TextSelect  239-41
        Then  241-42

        V
        Variables  16, 48
        Version  64, 241-43
        VersionDLL  243-44

        W
        WaitForKey  243-45
        WallPaper  63, 245-46
        WIL programs
          error handling  53-54
          statement summary  54-63
          statements  63-278
          WIL language components  46-51
        WinActivate  25, 57, 246-47
        WinArrange  58, 247-48
        WinClose  26, 58, 248-49
        WinCloseNot  26, 58, 249-50
         ________________________________________________________________
                                                                      291


                                                                    INDEX
         ________________________________________________________________

        WinConfig  64, 250-51
        Window Management  24
          in WIL  57-59
        WinExeName  251-52
        WinExist  26, 58, 252-53
        WinGetActive  58, 253-54
        WinHelp  254-56
        WinHide  58, 254-57
        WinIconize  24, 58, 257-58
        WinItemize  58, 258-59
        WinMetrics  259-61
        WinName  261-62
        WinParmGet  262-64
        WinParmSet  264-65
        WinPlace  58, 265-67
        WinPlaceGet  267-68
        WinPlaceSet  268-70
        WinPosition  58, 270-71
        WinResources  271-72
        WinShow  24, 58, 272-73
        WinState  273-74
        WinTitle  59, 274-75
        WinVersion  64, 275-76
        WinWaitClose  26, 59, 276-77
        WinZoom  24, 59, 277-78

        Y
        Yield  63, 278





















         ________________________________________________________________
                                                                        292
