#ifndef __FRAME_P_H__
#define __FRAME_P_H__

extern struct frame * make_frame _P_((int mini_p));
extern struct frame * make_frame_without_minibuffer _P_((register Lisp_Object
                                                         mini_window));
extern struct frame * make_minibuffer_frame _P_((void));
extern struct frame * make_terminal_frame _P_((void));
extern Lisp_Object next_frame _P_((Lisp_Object frame, Lisp_Object minibuf));
extern Lisp_Object prev_frame _P_((Lisp_Object frame, Lisp_Object minibuf));
extern Lisp_Object get_frame_param _P_((register struct frame *frame,
                                        Lisp_Object prop));
extern _VOID_ store_in_alist _P_((Lisp_Object *alistptr, Lisp_Object prop,
                                  Lisp_Object val));
extern _VOID_ store_frame_param _P_((struct frame *f, Lisp_Object prop,
                                     Lisp_Object val));
extern _VOID_ choose_minibuf_frame _P_((void));
extern _VOID_ syms_of_frame _P_((void));
extern _VOID_ keys_of_frame _P_((void));

DEFUN_P(Fframep, (Lisp_Object obj));
DEFUN_P(Fframe_live_p, (Lisp_Object object));
DEFUN_P(Fselect_frame, (Lisp_Object frame, Lisp_Object no_enter));
DEFUN_P(Fhandle_switch_frame, (Lisp_Object frame, Lisp_Object no_enter));
DEFUN_P(Fselected_frame, (void));
DEFUN_P(Fwindow_frame, (Lisp_Object window));
DEFUN_P(Fframe_root_window, (Lisp_Object frame));
DEFUN_P(Fframe_selected_window, (Lisp_Object frame));
DEFUN_P(Fframe_list, (void));
DEFUN_P(Fnext_frame, (Lisp_Object frame, Lisp_Object miniframe));
DEFUN_P(Fdelete_frame, (Lisp_Object frame));
DEFUN_P(Fmouse_position, (void));
DEFUN_P(Fset_mouse_position, (Lisp_Object frame, Lisp_Object x,
                              Lisp_Object y));
DEFUN_P(Fmake_frame_visible, (Lisp_Object frame));
DEFUN_P(Fmake_frame_invisible, (Lisp_Object frame));
DEFUN_P(Ficonify_frame, (Lisp_Object frame));
DEFUN_P(Fframe_visible_p, (Lisp_Object frame));
DEFUN_P(Fvisible_frame_list, (void));
DEFUN_P(Fraise_frame, (Lisp_Object frame));
DEFUN_P(Flower_frame, (Lisp_Object frame));
DEFUN_P(Fredirect_frame_focus, (Lisp_Object frame, Lisp_Object focus_frame));
DEFUN_P(Fframe_focus, (Lisp_Object frame));
DEFUN_P(Fframe_parameters, (Lisp_Object frame));    
DEFUN_P(Fframe_parameters, (Lisp_Object frame));
DEFUN_P(Fmodify_frame_parameters, (Lisp_Object frame, Lisp_Object alist));
DEFUN_P(Fframe_char_height, (Lisp_Object frame));
DEFUN_P(Fframe_char_width, (Lisp_Object frame));
DEFUN_P(Fframe_pixel_width, (Lisp_Object frame));
DEFUN_P(Fframe_pixel_height, (Lisp_Object frame));
DEFUN_P(Fset_frame_height, (Lisp_Object frame, Lisp_Object rows,
                            Lisp_Object pretend));
DEFUN_P(Fset_frame_width, (Lisp_Object frame, Lisp_Object cols,
                           Lisp_Object pretend));
DEFUN_P(Fset_frame_size, (Lisp_Object frame, Lisp_Object cols,
                          Lisp_Object rows));
DEFUN_P(Fset_frame_position, (Lisp_Object frame, Lisp_Object xoffset,
                              Lisp_Object yoffset));

#endif
