LS(1)                   USER COMMANDS                     LS(1)

NAME
     ls - list the contents of a directory.               [Version 1.1]

SYNOPSIS
     ls [ -aAcCdDFglLrRtuz1 ] filename ...

DESCRIPTION
     ls is a command similar to DIR but gives its output in a more
     comprehensive format. It lists not only file names but also owner
     and permissions associated with each file and directory.

     With the -l (long) option, output is divided into several fields:
     the permissions field, the attribute field (-z option), owner, file
     size, modification date, DOS short-name (-D option) and file name:

        -rwxdr-x-r-x- ----a-- Administrator    34304 Aug 09 10:21 ls.exe

  Permissions Field
     The mode printed under the -l option contains characters interpreted
     as follows. (If the file system is not a NT file system, this part
     is not printed.)
          d  entry is a directory
	  t  entry is a temporary file
          s  entry is a system file
          a  entry is an atomic-write file
          x  entry is an xaction write file
          -  entry is a plain file

     The next 12 characters are interpreted as three sets of four
     characters each. The first set refers to owner permissions; 
     the next set is a combined maximum of access rights explicitly granted
     to other users or groups, for example if one user is explicitly
     granted write access, this is indicated with a "w" in this set; the
     last set refers to all other users of the system. Within each set,
     the characters indicate permission to read, to write, to execute the
     file as a program and to change permissions or owner of the file.
     
     In general, an upper case letter indicates permission granted but with
     some limitations. The permissions are indicated as follows:
          r  file is readable/directory is listable

          w  write allowed, no restrictions
          W  file allows write but not append/directory allows file 
	     file creation only (no subdirs)
	  a  file allows append only/directory allows subdir creation only
	  *  the file is not writable, but ownership or protection
	     can be changed (should be seen as a warning)
	  =  the file is writable, but the read-only attribute prevents
	     writing (see the ATTRIB command)

          x  file is executable/directory is traversable

	  d  delete granted for this file (or directory) as well as for
	     all subdirectories
	  D  delete granted but not for subdirectories
	  c  delete granted only for subdirectories

          -  the indicated permission is not granted
          ?  the indicated permission is not known by ls (this only occurs
	     in the owner set if there are negative access rights present)

  Attribute Field
     The characters in the attribute field is printed for DOS file systems
     or if the -z option was specified. It should be interpreted as follows:
	  d  entry is a directory
	  s  entry is a system file
	  r  entry is read-only (see ATTRIB command)
	  h  entry is hidden (ls needs -a option to show it in listing)
	  a  entry has the archive bit set
	  T  entry is a temporary file
	  A  entry is marked with atomic write
	  X  entry is marked with xaction write

OPTIONS
     -a   List all entries; in the absence of this option,
          hidden entries and . and .. do not show up

     -A   Same as -a, except that `.' and `..' do not show up

     -c   Show creation time instead of last modification time

     -C   Force multi-column output, with entries sorted down the
          columns;  this is the default when output is to a terminal.

     -d   If argument is a directory, list only its name (not its
          contents);  often  used  with -l to get the status of a
          directory.

     -D   Show MS-DOS short filenames (8+3 characters)

     -F   Mark directories with a trailing slash /

     -g   In unix ls, this would show the group ownership of the file.
          Since NT ignores group ownership and the group access field shows
	  a superset of all group and user rights, this option is ignored.

     -h   Print version and short usage information

     -l   List in long format as shown above

     -L   Force lower case letters in file names

     -r   Reverse the order of sort to get reverse alphabetic  or
          oldest first as appropriate.

     -R   Recursively list subdirectories encountered.

     -t   Sort by time modified  (latest  first)  instead  of  by name.

     -u   Use time of last access instead  of  last  modification date

     -z   Print file attribute field as well (see above)

     -1   (ls only) Force one entry per line output format;  this
          is the default when output is not to a terminal.


BUGS
     The ? output for owner protection should be removed. This involves
     a group check membership for the owner though.

     Further field testing is needed before we know all types of ACL-lists
     are interpreted correctly. Please report all problems!

     The output device is assumed to be 80 columns wide.


COYPRIGHT
     This program can be freely distributed and used as long as it is
     not sold or made part of any commercial product. No responsibility
     is taken for the program, for its output, correctness etc. Use it
     on your own risk.

AUTHOR
     Please send comments, suggestions and bug reports to:
	Tomas Olovsson  [olovsson@ce.chalmers.se]

