/********************************************************************
 * hdpr2.ctl - PC installer control file for Persuasion 2.0
 *
 * Copyright (C) 1990 Aldus Corporation.  All rights reserved.
 *
 * ABSTRACT:
 * All product-specific text goes in the .CTL file.  Nothing in the .RC
 * file should be product-specific.  Both the .CTL and the .RC files
 * must be localized.
 *
 * When localizing, only text in "double quotes" need be translated.
 * (Although, if the names of files on the distribution diskettes have
 * been changed, they'll have to be changed in this control file too.)
 *
 *******************************************************************/

/* The PRODUCT command is required.  
 */
PRODUCT "Filter Driver Pack"
VERSIONREQ "1.02"      /* minimum installer version required */


/* There is one DISK statement for each distribution disk.  It gives
 * the name by which the user will be asked for the disk, and a list
 * of the files on the disk.  In addition to the file names, the list
 * of files contains the sizes of the files (uncompressed, in bytes)
 * and the subdirectories in which the files can be found.  If the
 * file is in the root, the subdirectory can be left off.  The options
 * CHECKDATE or NOREPLACE can be specified after the subdirectory.  Lines
 * are separated by commas.
 *
 * This part of the control file will be created automatically by the
 * Disk Builder Utility.
 */


DISK "Disk 1"
   {
   (C)ALDUS.'91         62,
   ALDSETUP.EXE     170048,
   ALDSETRS.RSL      30208,
   FTDR720.CTL        9238,
   ALDIM.PC~        149200,
   IMAGE.TXT          5802,
   123IMP.FL~        72576  "FILTERS"  CHECKDATE,
   ASCIIMP.FL~        8336  "FILTERS"  CHECKDATE,
   CHARTIMP.FL~       8480  "FILTERS"  CHECKDATE,
   EXCELIMP.FL~      79648  "FILTERS"  CHECKDATE,
   CHREXPC.tb~        3811  "FILTERS"  CHECKDATE,
   CHRIMPC.tb~        3785  "FILTERS"  CHECKDATE,
   TEIMP.FL~         60480  "FILTERS"  CHECKDATE,
   DCAIMP.FL~         8768  "FILTERS"  CHECKDATE,
   VPIMP.FL~        125203  "FILTERS"  CHECKDATE,
   WINWDIMP.FL~      39936  "FILTERS"  CHECKDATE,
   WNWD2IMP.FL~      47104  "FILTERS"  CHECKDATE,
   WP5EXP.FL~        11264  "FILTERS"  CHECKDATE,
   WP5IMP.FL~        36864  "FILTERS"  CHECKDATE,
   XY3IMP.FL~        29297  "FILTERS"  CHECKDATE,
   XY3EXP.FL~        39831  "FILTERS"  CHECKDATE,
   SAMAWIMP.FL~      14997  "FILTERS"  CHECKDATE,
   FILTERS.TXT       13500  "FILTERS"
   }



DIALOG ContQuit "&Continue" "&Cancel"
  {
	CAPTION "Language selection"
	TEXT
	{
	"This disk pack is designed to be used with US English,"
	"Canadian English or International English versions of Aldus"
	"products.  If the language of your Aldus product is other"
	"than US, Canadian or International English, select ""Cancel"""
	"and read the FILTERS.TXT file on this disk for further "
	"instructions."
        }
  }

DIALOG WhichLang "&US Engl" "&Intl Engl"
  {
	CAPTION "English language selection"
	TEXT
	{
	"Select ""US Engl"" for US Aldus Products or select ""Intl Engl"""  
	"for Canadian and International English products."
	"Read the FILTERS.TXT file on this disk for further instructions."
        }
  }

DIALOG FilterWarning "&Continue"
  {
	TEXT
	{
	"The more filters you install, the more time it takes for"
	"Aldus products to start up. Install only the filters you need."
	}
  }

DIALOG SucRead "&OK"
{
    CAPTION "Setup complete"
    TEXT
    {
	"All items you selected have been successfully installed."
	" "
	"You may now exit this program or choose to read the"
	"FILTERS.TXT file, which has been added to the View menu.  You may"
	"also choose to examine other information provided from the "
	"Diagnostics or View menus in Aldus Setup."
    }
}


PACKAGE FILTERS	"Filters" SELECTED
  {
    GETALDDIR AldDir
    DISPLAY ContQuit Answer
    IF Answer EQS "&Continue"
    {
    DISPLAY WhichLang Answer1
    IF Answer1 EQS "&Intl Engl"
        {
	CONCAT AldDir "UKENGLSH" UKDIR
	CONCAT UKDIR "FILTERS" FiltDir
	DISPLAY FilterWarning

    FILES FiltDir
	{
	FILTERS.TXT
	}
    /*  Add the README menu item to the VIEW menu       */
    ONINSTALL
        {
        WINDOWSMENU FiltDir "FILTERS.TXT" "FILTERS.TXT" 
        }

    CONCAT UKDIR "SETUP" SetupDir
    FILES SetupDir
        {
        ALDSETUP.EXE
        ALDSETRS.RSL
	FTDR720.CTL
        }

    SELECT2 "Select filters" FiltDir
        {
        TEXT
            {
            "Select the filters you want to install or remove:"
            " "
            }
        ITEMS
	{
	ASCIIMP.FL~ "ASCII Text Import" "[AldusImports]" "ASCII Text Import=ASCIIMP.FLT,TXT",
	DCAIMP.FL~ "RFT Import" "[AldusImports]" "RFT Import=DCAIMP.FLT,RFT",
	DCAIMP.FL~ "DCA Import" "[AldusImports]" "DCA Import=DCAIMP.FLT,DCA",
	EXCELIMP.FL~ "Excel Spreadsheet Import" "[AldusImports]" "Excel Spreadsheet Import=EXCELIMP.FLT,XLS",
	CHARTIMP.FL~ "Excel Chart Import" "[AldusImports]" "Excel Chart Import=CHARTIMP.FLT,XLC",
	123IMP.FL~ "Lotus 1-2-3 Rel 1A (.WKS) Import" "[AldusImports]" "Lotus 1-2-3 Rel 1A (.WKS) Import=123IMP.FLT,WKS",
	123IMP.FL~ "Lotus 1-2-3 Rel 2-2.2 (.WK1) Import" "[AldusImports]" "Lotus 1-2-3 Rel 2-2.2 (.WK1) Import=123IMP.FLT,WK1",
	123IMP.FL~ "Lotus 1-2-3 Rel 3 (.WK3) Import" "[AldusImports]" "Lotus 1-2-3 Rel 3 (.WK3) Import=123IMP.FLT,WK3",
	123IMP.FL~ "Symphony 1.0-1.01 (.WRK) Import" "[AldusImports]" "Symphony 1.0-1.01 (.WRK) Import=123IMP.FLT,WRK",
	123IMP.FL~ "Symphony 1.1-2.0 (.WR1) Import" "[AldusImports]" "Symphony 1.1-2.0 (.WR1) Import=123IMP.FLT,WR1",
	WINWDIMP.FL~ "Word for Windows 1.0 Import" "[AldusImports]" "Word for Windows 1.0 Import=WINWDIMP.FLT,DOC",
	WNWD2IMP.FL~ "Word for Windows 2.0 Import" "[AldusImports]" "Word for Windows 2.0 Import=WNWD2IMP.FLT,DOC",
	SAMAWIMP.FL~ "Samna Word Import" "[AldusImports]" "Samna Word Import=SAMAWIMP.FLT,SAM",
	TEIMP.FL~ "Table Editor Import" "[AldusImports]" "Table Editor Import=TEIMP.FLT,TBL",
	VPIMP.FL~ "Ventura Publisher Import" "[AldusImports]" "Ventura Publisher Import=VPIMP.FLT,CHP",
	XY3EXP.FL~ "XYWrite III Export" "[AldusExports]" "XYWrite III Export=XY3EXP.FLT,XY3",
	XY3IMP.FL~ "XYWrite III Import" "[AldusImports]" "XYWrite III Import=XY3IMP.FLT,XY3",
	WP5EXP.FL~ "WordPerfect 5.0-5.1 Export" "[AldusExports]" "WordPerfect 5.0-5.1 Export=WP5EXP.FLT,WP5",
	WP5IMP.FL~ "WordPerfect 5.0-5.1 Import" "[AldusImports]" "WordPerfect 5.0-5.1 Import=WP5IMP.FLT,WP5"
	}  /* end items */
        HELP
	{
	"Hold down Ctrl and click to select the import"
	"filters that you want to install from the "
	"""Available for installation"" list."
	" "
	"To remove a filter, select it from the ""Currently"
	"installed"" list.  Keep in mind that removing"
	"a filter for Persuasion also removes it for other"
	"Aldus programs you may have, such as PageMaker."
	}
        }  /* end select */

 	ONINSTALL
		{
		DISPLAY SucRead
		}
	} /*end CE/IE*/

    IF Answer1 EQS "&US Engl"
        {
	CONCAT AldDir "USENGLSH" USDIR
	CONCAT USDIR "FILTERS" FiltDir
	DISPLAY FilterWarning

    /*  Add the README menu item to the VIEW menu       */
    ONINSTALL
        {
        WINDOWSMENU FiltDir "FILTERS.TXT" "FILTERS.TXT" 
        }


    CONCAT USDIR "SETUP" SetupDir
    FILES SetupDir
        {
        ALDSETUP.EXE
        ALDSETRS.RSL
	FTDR720.CTL
        }
    FILES FiltDir
	{
	FILTERS.TXT
	}

    SELECT2 "Select filters" FiltDir
        {
        TEXT
            {
            "Select the filters you want to install or remove:"
            " "
            }
        ITEMS
	{
	ASCIIMP.FL~ "ASCII Text Import" "[AldusImports]" "ASCII Text Import=ASCIIMP.FLT,TXT",
	DCAIMP.FL~ "RFT Import" "[AldusImports]" "RFT Import=DCAIMP.FLT,RFT",
	DCAIMP.FL~ "DCA Import" "[AldusImports]" "DCA Import=DCAIMP.FLT,DCA",
	EXCELIMP.FL~ "Excel Spreadsheet Import" "[AldusImports]" "Excel Spreadsheet Import=EXCELIMP.FLT,XLS",
	CHARTIMP.FL~ "Excel Chart Import" "[AldusImports]" "Excel Chart Import=CHARTIMP.FLT,XLC",
	123IMP.FL~ "Lotus 1-2-3 Rel 1A (.WKS) Import" "[AldusImports]" "Lotus 1-2-3 Rel 1A (.WKS) Import=123IMP.FLT,WKS",
	123IMP.FL~ "Lotus 1-2-3 Rel 2-2.2 (.WK1) Import" "[AldusImports]" "Lotus 1-2-3 Rel 2-2.2 (.WK1) Import=123IMP.FLT,WK1",
	123IMP.FL~ "Lotus 1-2-3 Rel 3 (.WK3) Import" "[AldusImports]" "Lotus 1-2-3 Rel 3 (.WK3) Import=123IMP.FLT,WK3",
	123IMP.FL~ "Symphony 1.0-1.01 (.WRK) Import" "[AldusImports]" "Symphony 1.0-1.01 (.WRK) Import=123IMP.FLT,WRK",
	123IMP.FL~ "Symphony 1.1-2.0 (.WR1) Import" "[AldusImports]" "Symphony 1.1-2.0 (.WR1) Import=123IMP.FLT,WR1",
	WINWDIMP.FL~ "Word for Windows 1.0 Import" "[AldusImports]" "Word for Windows 1.0 Import=WINWDIMP.FLT,DOC",
	WNWD2IMP.FL~ "Word for Windows 2.0 Import" "[AldusImports]" "Word for Windows 2.0 Import=WNWD2IMP.FLT,DOC",
	SAMAWIMP.FL~ "Samna Word Import" "[AldusImports]" "Samna Word Import=SAMAWIMP.FLT,SAM",
	TEIMP.FL~ "Table Editor Import" "[AldusImports]" "Table Editor Import=TEIMP.FLT,TBL",
	VPIMP.FL~ "Ventura Publisher Import" "[AldusImports]" "Ventura Publisher Import=VPIMP.FLT,CHP",
	XY3EXP.FL~ "XYWrite III Export" "[AldusExports]" "XYWrite III Export=XY3EXP.FLT,XY3",
	XY3IMP.FL~ "XYWrite III Import" "[AldusImports]" "XYWrite III Import=XY3IMP.FLT,XY3",
	WP5EXP.FL~ "WordPerfect 5.0-5.1 Export" "[AldusExports]" "WordPerfect 5.0-5.1 Export=WP5EXP.FLT,WP5",
	WP5IMP.FL~ "WordPerfect 5.0-5.1 Import" "[AldusImports]" "WordPerfect 5.0-5.1 Import=WP5IMP.FLT,WP5"
	}  /* end items */
        HELP
	{
	"Hold down Ctrl and click to select the import"
	"filters that you want to install from the "
	"""Available for installation"" list."
	" "
	"To remove a filter, select it from the ""Currently"
	"installed"" list.  Keep in mind that removing"
	"a filter for Persuasion also removes it for other"
	"Aldus programs you may have, such as PageMaker."
	}
        }  /* end select */

 	ONINSTALL
		{
		DISPLAY SucRead
		}

        }  /* end US */
     } /*end continue/quit */
}



