/**********************************************************************/
/*                  BDDVTBTN.cpp by Bob Bourbonnais                   */
/*              released to the public domain 1/26/92                 */
/*          This program shows how to switch to different             */
/*           routines based on the button pressed using               */
/*           Dynamic Dispatched Virtual Tables, DDVT                  */
/**********************************************************************/
#include <owl.h>
#include <dialog.h>
#include "bwcc.h"                        // needed for BWCC

class TMyDialog : public TDialog
  {
  public:
    TMyDialog(LPSTR lpDialogName)          // constructor calls
      : TDialog(NULL,lpDialogName)         // base class constructor
      {
      BWCCGetVersion();    // activate Borland Windows Custom Controls
      }
    virtual void Ok(RTMessage Msg);        // redefines the DDVT function
					   // for the OK button #1
					   // as defined in Base class
					   // TDialog
    virtual void Cancel(RTMessage Msg);    // redefines the DDVT for the
					   // cancel button in TDialog

    // The following Dynamic Dispatch Virtual Functions are linked
    // to their associated subroutines

    virtual void HandleAbort(RTMessage Msg)
      = [ID_FIRST + IDABORT];                // IDABORT is Button 3
    virtual void HandleRetry(RTMessage Msg)
      = [ID_FIRST + IDRETRY];                // IDRETRY is Button 4
    virtual void HandleIgnore(RTMessage Msg)
      = [ID_FIRST + IDIGNORE];               // IDIGNORE is Button 5
    virtual void HandleYes(RTMessage Msg)
      = [ID_FIRST + IDYES];                  // IDYES is Button 6
    virtual void HandleNo(RTMessage Msg)
      = [ID_FIRST + IDNO];                   // IDNO is Button 7
    virtual void HandleButton8(RTMessage Msg)
      = [ID_FIRST + 8];                      // Button #8

    virtual void DefChildProc(RTMessage Msg);  // Default handler for
					       // Buttons not covered
					       // by DDVT
  };
void TMyDialog::Ok(RTMessage Msg)  // Redefines button handler inherited
  {                                // from TDailog for Button #1 IDOK
  BWCCMessageBox(HWindow,"It will now call the IDOK in TDialog that will close this Dialog",
			 "Button #1 was pressed",MB_OK);
  TDialog::Ok(Msg);
  }
void TMyDialog::Cancel(RTMessage Msg)  // Redefines button handler inherited
  {                                    // from TDailog for Button #2 IDCANCEL
  BWCCMessageBox(HWindow,"It will now call the IDCANCEL in the base classTDialog",
			 "Button #2 was pressed",MB_OK);
  TDialog::Cancel(Msg);
  }

void TMyDialog::HandleAbort(RTMessage)
  {
  BWCCMessageBox(HWindow,"The Abort Button was pressed",
			  "Button #3 was pressed",MB_OK);
  }
void TMyDialog::HandleRetry(RTMessage)
  {
  BWCCMessageBox(HWindow,"The Retry button was pressed",
			 "Button #4 was pressed",MB_OK);
  }
void TMyDialog::HandleIgnore(RTMessage)
  {
  BWCCMessageBox(HWindow,"The Ignore button was pressed",
			  "Button #5 was pressed",MB_OK);
  }
void TMyDialog::HandleYes(RTMessage)
  {
  BWCCMessageBox(HWindow,"The Yes button was pressed",
			 "Button #6 was pressed",MB_OK);
  }
void TMyDialog::HandleNo(RTMessage)
  {
  BWCCMessageBox(HWindow,"The No Button was pressed",
			 "Button #7 was pressed",MB_OK);
  }
void TMyDialog::HandleButton8(RTMessage)
  {
  BWCCMessageBox(HWindow,"The Button labled Button was pressed",
			  "Button #8 was pressed",MB_OK);
  }

void TMyDialog::DefChildProc(RTMessage Msg)
  {
  MessageBeep(0);
  BWCCMessageBox(HWindow,"Not Implemented","Feature",MB_OK);
  MessageBeep(0);
  TDialog::DefChildProc(Msg);
  }

class TDialog1App : public TApplication  // Application Class to contain
  {                                      // the application
  public:
    TDialog1App(LPSTR lpName, HANDLE hInstance,  // constructor calls the
		HANDLE hPrevInstance,            // base class constructor
		LPSTR lpCmdLine, int nCmdShow)
		:TApplication(lpName, hInstance,
			      hPrevInstance,
			      lpCmdLine, nCmdShow) {};

    virtual void InitMainWindow(); // overrides base class InitMainWindow
  };

void TDialog1App::InitMainWindow() // to initialize a dialog box
  {                                // as the main window
  MainWindow = new TMyDialog("MAINWINDOWDIALOG");
  }

int PASCAL WinMain(HANDLE hInstance,              // main entry point from
		   HANDLE hPrevInstance,          // windows to this program
		   LPSTR lpCmdLine , int nCmdShow)
  {
  TDialog1App Dialog1("Dialog Tester",hInstance,  // create instance of
		       hPrevInstance,             // the dialog application
		       lpCmdLine,nCmdShow);
  Dialog1.Run();                                  // run it
  return (Dialog1.Status);                        // exit
  }
/**********************************************************************/
