/**********************************************************************/
/*                  BDEFCASE.cpp by Bob Bourbonnais                   */
/*              released to the public domain 1/26/92                 */
/*           This program shows how to trap for individual            */
/*           Button messages in the DefChild Process using            */
/*                          switch and case.                          */
/*         This is the old style of windows message processing        */
/*         It is recommended that the newer Dynamic Dispatch          */
/*    Virtual Table, DDVT, style be used instead of switch and case.  */
/*               See BDDVTBTN.cpp for an example of DDVT.             */
/**********************************************************************/
#include <owl.h>
#include <dialog.h>
#include "bwcc.h"                        // needed for BWCC

class TMyDialog : public TDialog
  {
  public:
    TMyDialog(LPSTR lpDialogName)          // constructor calls
      : TDialog(NULL,lpDialogName)         // base class constructor
      {
      BWCCGetVersion();    // activate Borland Windows Custom Controls
      }
    virtual void DefChildProc(RTMessage Msg); // redefined default
					      // message processing
    // Note: if this is a Window instead of a dialog box, then
    // redefine DefCommandProc instead.
  };

void TMyDialog::DefChildProc(RTMessage Msg)
  {
  switch (Msg.WParam)    // switch and case to process button messages
    {                    // this is the old style of message processing
    case (3):            // The next program, BDDVTBTN, shows a much
      {                  // better way of processing individual button
      MessageBeep(0);    // messages
      BWCCMessageBox(HWindow,"Button #3 The Abort Button Was Pressed",
			     "Button Pressed",MB_OK);
      break;
      };
    case (4):
      {
      MessageBeep(0);
      BWCCMessageBox(HWindow,"Button #4 The Retry Button Was Pressed",
			     "Button Pressed",MB_OK);
      break;
      };
    case (5):
      {
      MessageBeep(0);
      BWCCMessageBox(HWindow,"Button #5 The Ignore Button Was Pressed",
			     "Button Pressed",MB_OK);
      break;
      }
    case (6):
      {
      MessageBeep(0);
      BWCCMessageBox(HWindow,"Button #6 The Yes Button Was Pressed",
			     "Button Pressed",MB_OK);
      break;
      }
    case (7):
      {
      MessageBeep(0);
      BWCCMessageBox(HWindow,"Button #7 The No Button Was Pressed",
			     "Button Pressed",MB_OK);
      break;
      }
    case (8):
      {
      MessageBeep(0);
      BWCCMessageBox(HWindow,"Button #8 The Button that says Button Was Pressed",
			     "Button Pressed",MB_OK);
      break;
      }
    default:
      {
      MessageBeep(0);
      BWCCMessageBox(HWindow,"Message Out of range","Error",MB_OK);
      break;
      }
    }
  TDialog::DefChildProc(Msg);
  };

class TDialog1App : public TApplication  // Application Class to contain
  {                                      // the application
  public:
    TDialog1App(LPSTR lpName, HANDLE hInstance,  // constructor calls the
		HANDLE hPrevInstance,            // base class constructor
		LPSTR lpCmdLine, int nCmdShow)
		:TApplication(lpName, hInstance,
			      hPrevInstance,
			      lpCmdLine, nCmdShow) {};

    virtual void InitMainWindow(); // overrides base class InitMainWindow
  };

void TDialog1App::InitMainWindow() // to initialize a dialog box
  {                                // as the main window
  MainWindow = new TMyDialog("MAINWINDOWDIALOG");
  }

int PASCAL WinMain(HANDLE hInstance,              // main entry point from
		   HANDLE hPrevInstance,          // windows to this program
		   LPSTR lpCmdLine , int nCmdShow)
  {
  TDialog1App Dialog1("Dialog Tester",hInstance,  // create instance of
		       hPrevInstance,             // the dialog application
		       lpCmdLine,nCmdShow);
  Dialog1.Run();                                  // run it
  return (Dialog1.Status);                        // exit
  }
/**********************************************************************/
