/**********************************************************************/
/*                 BDEFPROC.cpp by Bob Bourbonnais                    */
/*              released to the public domain 1/26/92                 */
/*         This program shows how to add a default button             */
/*        processing function to a dialog box main window.            */
/*        To add the same functionality to a regular window           */
/*        over ride DefCommandProc instead of DefChildProc.           */
/**********************************************************************/
#include <owl.h>
#include <dialog.h>
#include "bwcc.h"                          // needed for BWCC

class TMyDialog : public TDialog           // derive a class to add
  {                                        // default button handling
  public:
    TMyDialog(LPSTR lpDialogName)          // constructor calls
      : TDialog(NULL,lpDialogName)         // base class constructor
      {
      BWCCGetVersion();    // activate Borland Windows Custom Controls
      }
    virtual void DefChildProc(RTMessage Msg); // default button handler
  };

void TMyDialog::DefChildProc(RTMessage Msg)   // default button handler
  {
  MessageBeep(0);                             // make sound and display
  BWCCMessageBox(HWindow,"Not Implemented",   // a BWCC message box
		 "Feature",MB_OK);
  TDialog::DefChildProc(Msg);                 // pass messages along
  }                                           // to base class handler

class TDialog1App : public TApplication  // Application Class to contain
  {                                      // the application
  public:
    TDialog1App(LPSTR lpName, HANDLE hInstance,  // constructor calls the
		HANDLE hPrevInstance,            // base class constructor
		LPSTR lpCmdLine, int nCmdShow)
		:TApplication(lpName, hInstance,
			      hPrevInstance,
			      lpCmdLine, nCmdShow) {};

    virtual void InitMainWindow(); // overrides base class InitMainWindow
  };

void TDialog1App::InitMainWindow() // to initialize a dialog box
  {                                // as the main window
  MainWindow = new TMyDialog("MAINWINDOWDIALOG");
  }

int PASCAL WinMain(HANDLE hInstance,              // main entry point from
		   HANDLE hPrevInstance,          // windows to this program
		   LPSTR lpCmdLine , int nCmdShow)
  {
  TDialog1App Dialog1("Dialog Tester",hInstance,  // create instance of
		       hPrevInstance,             // the dialog application
		       lpCmdLine,nCmdShow);
  Dialog1.Run();                                  // run it
  return (Dialog1.Status);                        // exit
  }
/**********************************************************************/
