/**********************************************************************/
/*                  BWSPLBIT.cpp by Bob Bourbonnais                   */
/*              released to the public domain 1/12/91                 */
/*                 This program shows the basics of                   */
/*                  Borland Windows Custom Controls                   */
/*               BWCC needs the bwcc.h to be included                 */
/*                    in both the .CPP and .RC                        */
/*                It also needs BWCCGetVersion();                     */
/*                    to activate the library.                        */
/*              The Project file must include BWCC.LIB                */
/*        The .RC file must have BORDLG as the dialog class           */
/*          and then the controls can be of special types             */
/*                         such as BorShade.                          */
/*    Remember to add #includes for windows.h and bwcc.h to the .RC   */
/**********************************************************************/
#include <owl.h>
#include <dialog.h>
#include "bwcc.h"                        // needed for BWCC

class TDialog1App : public TApplication  // Application Class to contain
  {                                      // the application
  public:
    TDialog1App(LPSTR lpName, HANDLE hInstance,  // constructor calls the
		HANDLE hPrevInstance,            // base class constructor
		LPSTR lpCmdLine, int nCmdShow)
		:TApplication(lpName, hInstance,
			      hPrevInstance,
			      lpCmdLine, nCmdShow) {};

    virtual void InitMainWindow(); // overrides base class InitMainWindow
  };

void TDialog1App::InitMainWindow() // to initialize a dialog box
  {                                // as the main window
  BWCCGetVersion();                // Activate BWCC Library
  MainWindow = new TDialog(NULL, "MAINWINDOWDIALOG");
  }

int PASCAL WinMain(HANDLE hInstance,              // main entry point from
		   HANDLE hPrevInstance,          // windows to this program
		   LPSTR lpCmdLine , int nCmdShow)
  {
  TDialog1App Dialog1("Dialog Tester",hInstance,  // create instance of
		       hPrevInstance,             // the dialog application
		       lpCmdLine,nCmdShow);
  Dialog1.Run();                                  // run it
  return (Dialog1.Status);                        // exit
  }
/**********************************************************************/
