#include "c:\iwf\kernel\kernel.h"

//---------------------------------------
//Defines.
//---------------------------------------
#define  NO   0
#define  YES  1

#define  nMFBUFFERS 4                  // # of memory frame buffers
#define  nXFBUFFERS 4                  // # of hardware frame buffers
#define  nMODULES   16                 // # of user modules

#define  GAIN       59                 // Default camera input gain
#define  OFFSET     19                 // Default camera input offset
#define  FOCAL      16                 // Default camera focal length

#define  GWW_SCALE  0                  // Window word offset for scale value
#define  GWW_IMAGE  2                  // Window word offset for image pointer

// Macro defines for getting extra window information
#define GetImage(hWnd)         (IMAGE *)GetWindowWord(hWnd,GWW_IMAGE)
#define GetScale(hWnd)         (WORD   )GetWindowWord(hWnd,GWW_SCALE)
#define SetImage(hWnd,image)   SetWindowWord(hWnd,GWW_IMAGE,(WORD)image)
#define SetScale(hWnd,scale)   SetWindowWord(hWnd,GWW_SCALE,(WORD)scale)
#define RefreshImage(hWnd)     InvalidateRect(hWnd,NULL,FALSE)

void SetUndoImage(IMAGE *image);
IMAGE *GetUndoImage(void);

// Geometric Procedures.
void iwf_Scale(void);
void iwf_Flip_Horz(void);
void iwf_Flip_Vert(void);
void iwf_Rotate(int dir);


// CONTROL.H (control procedure declarations)

void Status(HWND hWndParent);
void Convolve(HWND hWndParent);

BOOL FAR PASCAL _export DP_About  (HWND hDlg,WORD wMsg,WORD wParam,LONG lParam);
BOOL FAR PASCAL _export DP_Process(HWND hDlg,WORD wMsg,WORD wParam,LONG lParam);
BOOL FAR PASCAL _export DP_Filters(HWND hDlg,WORD wMsg,WORD wParam,LONG lParam);
BOOL FAR PASCAL _export DP_Convolve(HWND hDlg,WORD wMsg,WORD wParam,LONG lParam);
BOOL FAR PASCAL _export DP_LUT    (HWND hDlg,WORD wMsg,WORD wParam,LONG lParam);
BOOL FAR PASCAL _export DP_Aspect (HWND hDlg,WORD wMsg,WORD wParam,LONG lParam);
BOOL FAR PASCAL _export DP_Profiler(HWND hDlg,WORD wMsg,WORD wParam,LONG lParam);


// Windows extensions.
void MessageStop(char *format, ...);
void wputs(HDC hDC,char *sz);
void wprintf(HDC hDC,char *format, ...);
void MoveRel(HDC hDC,int dx,int dy);
void ToggleMenuState(HWND hWnd,WORD id,BOOL *state);
BOOL DrawBitmap(HDC hDC,int x,int y,HANDLE hBM);
BOOL PickColor(HWND hWndOwner,COLORREF *cr);
long fstr(FILE *fp,char *string);
int  CallDialogBox(HWND hWnd,FARPROC lpProcName,LPSTR lpResName);
HPALETTE CreateLogPalette(int size);


HWND CreateImageWindow(HWND hWndParent);

int  FileNew   (HWND hWnd);
int  FileOpen  (HWND hWnd);
int  FileSave  (HWND hWnd);
int  FileSaveAs(HWND hWnd);
int  FilePrint (HWND hWnd);

extern IMAGE *_undo;                   // Undo image buffer pointer.
extern char  _cwdImage[80];            // Image working directory

#define  MAXIMAGES  10                 // Maximum number of images displayable.
#define  MAXMODULES 10                 // Maximum number of modules displayable.
#define  MAXTOOLS    8                 // Maximum number of buttons displayable.

#define GetSourceWindow() hWndSrc
#define GetTargetWindow() hWndDst
#define GetModuleWindow() hWndMod
#define GetStatusWindow() hWndStatus

/*
Client rectangles for use with mouse click procedures
and screen update. The coordinates of these rectangles
vary depending on the screen size.
*/

extern HWND _hWndImage[MAXIMAGES];      // Handles to the images.
extern HWND _hWndModule[MAXMODULES];    // Window handles for images.
extern HWND hWndSrc;                   // Handle to current source image.
extern HWND hWndDst;                   // Handle to current destination image.
extern HWND hWndMod;                   // Handle to current module.
extern HWND hWndStatus;                // Handle to status bar.

extern HPALETTE hPalMain;              // Handle to logical palette

extern PALETTEENTRY peGray  [64];
extern PALETTEENTRY pePseudo[64];
extern PALETTEENTRY peUser [128];
extern PALETTEENTRY peMain [256];

extern COLORREF crDlg;



