/*
	DIALOG.HPP - (C) 1991 by Joachim Kainz 'On a mission from Bhudda'
*/
	#if !defined (__DIALOG_HPP)
	#define __DIALOG_HPP 1

	#include "windows.hpp"

	#define JFK_DIALOG	(JFK_WINDOW+3)

	class DIALOG : public WINDOW {

	  protected:
		static FARPROC2 lpFnOOPWndProc;

		WORD wResult;

		virtual METHOD WMShowWindow	 (BOOL bShow, long lShow);
		virtual METHOD WMEraseBkgnd	 (HANDLE hDC			);
		virtual METHOD WMActivate	 (
				WORD wActivate,
				BOOL bMin,
				HWND hLast
			   );
		virtual METHOD WMSetFocus 	   (HWND hLast				 );
		virtual METHOD WMClose 		   (						 );
		virtual METHOD WMNCDestroy 	   (						 );
		virtual METHOD WMLButtonDown   (WORD wOtherKeys, POINT pt);
		virtual METHOD WMNCLButtonDown (WORD wNCHitTest, POINT pt);
		virtual METHOD WMGetFont 	   (						 );
		virtual METHOD WMDestroy	   (						 );
		virtual METHOD WMInitDialog	   (DWORD dwParam			 );

		virtual METHOD WMCommand	(WORD wID, WORD wMsg, HWND hCtl) DEFMETH
		virtual METHOD WMSysCommand	(WORD wID, POINT pt			   );
		virtual METHOD WMTimer		(WORD wID, FARPROC			   ) DEFMETH
		virtual METHOD WMHScroll	(WORD wScrollCode, HWND hCtl   ) DEFMETH
		virtual METHOD WMVScroll	(WORD wScrollCode, HWND hCtl   ) DEFMETH
		virtual METHOD WMInitMenu	(HMENU hMenu				   ) DEFMETH

		virtual METHOD WMInitMenuPopUp (
				HMENU hPopUp,
				WORD  wIndex,
				BOOL
				bSystem
			   ) DEFMETH

		virtual METHOD WMMenuSelect	(WORD wMenu, WORD wFlag			   ) DEFMETH
		virtual METHOD WMMenuChar	(WORD wKey, HMENU hMenu, WORD wMenu) DEFMETH
		virtual METHOD WMEnterIdle	(WORD wPrevious, HANDLE hPrevious  ) DEFMETH

		virtual METHOD WndDlgProc (WORD wMsg, WORD wParam, long lParam);

		void     EXPORT EndDialog     (WORD wResult);
		WORD     EXPORT GetResult     (			   ) { return wResult; }
		FARPROC2 EXPORT GetOOPWndProc (            ) const;

		friend long FAR PASCAL DefOOPDlgProc (HWND, WORD, WORD, LONG);

	  public:
		EXPORT DIALOG (
				LPSTR	lpDlg,
				HWND	hWndParent  = NULL,
				HICON   hIcon		= NULL,
				FARPROC	lpfnProc	= NULL,
				DWORD	dwParam		= NULL
		);

		WORD EXPORT modal		(						  			);
		void EXPORT SetItemText (WORD wItem, LPSTR lpText			);
		void EXPORT GetItemText (WORD wItem, LPSTR lpText, WORD wLen);
		void EXPORT LimitText	(WORD wItem, WORD  wChars			);
		void EXPORT EnableItem	(WORD wItem, BOOL bEnable			);
	};

	#endif
