/*
	DLGTEMP.HPP - Generic DialogBox-Class
	(C) 1991 by Joachim Kainz 'On a mission from Bhudda'
*/
	#if !defined (__DLGTEMP_HPP)
	#define __DLGTEMP_HPP 1

	#include "jfklib.hpp"

	class DLGITEMTEMPLATE {

	  private:
		int		x,
				y,
				cx,
				cy,
				nID;
		long	lStyle;
		LPSTR	lpClass,
				lpText;
		BYTE	byInfo;
		PSTR	pData;

		LPSTR GetCtlClass (LPSTR &lpDlg				 );
		BOOL  CopyDlgItem (const DLGITEMTEMPLATE &dit);

		BOOL Reset ();

	  public:
		EXPORT ~DLGITEMTEMPLATE (						   );
		EXPORT DLGITEMTEMPLATE (						   );
		EXPORT DLGITEMTEMPLATE (const DLGITEMTEMPLATE &dit);

		DLGITEMTEMPLATE EXPORT operator = (const DLGITEMTEMPLATE &dit);

		WORD	EXPORT GetSize ();

		BOOL	EXPORT ConvertResource	(LPSTR &lpDlg);
		BOOL	EXPORT MakeResource	( PSTR & pDlg);

		long	EXPORT Style	  () { return lStyle;	}
		BYTE	EXPORT Info	  () { return byInfo;	}
		int		EXPORT X		  () { return x;		}
		int		EXPORT Y		  () { return y;		}
		int		EXPORT Width	  () { return cx;		}
		int		EXPORT Height	  () { return cy;		}
		int		EXPORT ID		  () { return nID;		}
		PSTR	EXPORT Data	  () { return pData;	}
		LPSTR	EXPORT Class	  () { return lpClass;	}
		LPSTR	EXPORT Text	  () { return lpText;	}
	};

	typedef DLGITEMTEMPLATE near * PDLGITEMTEMPLATE;

	class DLGTEMPLATE {

	  private:
		BOOL			 bValid;
		PDLGITEMTEMPLATE pdtit;

		long	lStyle;
		BYTE	byItemCount;
		int		x,
				y,
				cx,
				cy;
		LPSTR	lpMenuName,
				lpClassName,
				lpCaptionText;

		struct {

			int		nSize;
			LPSTR	lpFaceName;

		} font;

	  public:
		EXPORT ~DLGTEMPLATE (			);
		EXPORT DLGTEMPLATE (LPSTR lpDlg);

		DLGITEMTEMPLATE EXPORT operator []   (WORD wItem);
						EXPORT operator PSTR ();

		BOOL	EXPORT IsValid   () { return bValid;			}
		long	EXPORT Style	  () { return lStyle;			}
		BYTE	EXPORT ItemCount () { return byItemCount;		}
		int		EXPORT X		  () { return x;				}
		int		EXPORT Y		  () { return y;				}
		int		EXPORT Width	  () { return cx;				}
		int		EXPORT Height	  () { return cy;				}
		LPSTR	EXPORT MenuName  () { return lpMenuName;		}
		LPSTR	EXPORT ClassName () { return lpClassName;		}
		LPSTR	EXPORT Caption	  () { return lpCaptionText;	}
		int		EXPORT FontSize  () { return font.nSize;		}
		LPSTR	EXPORT FontName  () { return font.lpFaceName;	}

		BOOL EXPORT SetClass (LPSTR lpNewClsName);

		WORD EXPORT GetSize ();

	};

	#endif
