/*
	HELLO.CPP - (C) 1991 by Joachim Kainz 'On a mission from Bhudda'
*/
	#include "hello.hpp"
	#include <string.h>

	HANDLE hInst;

	int PASCAL WinMain (
				HANDLE	hInst,
				HANDLE	hPrevInstance,
				LPSTR	lpCmdLine,
				int		nCmdShow
			   )
	{
		SetInstance (hInst);

		HELLO hello (nCmdShow);

		if (!IsWindow (hello))
			return FALSE;

		return MsgLoop (hello);
	}

	HELLO::HELLO (int nCmdShow) : TOPLEVEL (nCmdShow)
	{
		LOGFONT lf;

		memset (&lf, 0, sizeof lf);

		LoadString (
			GetInstance (),
			ID_FONT,
			(LPSTR) lf.lfFaceName,
			sizeof lf.lfFaceName
		);
		lf.lfHeight = 38;
		lf.lfWidth  = 50;

		hFont  = CreateFontIndirect (&lf);
		pTitle = new char [20];

		LoadString (GetInstance (), ID_HI_FOLKS, pTitle, 20);
	}

	METHOD HELLO::WMClose ()
	{
		delete pTitle;

		DeleteObject (hFont);

		DestroyWindow (GetWindowHandle ());

		return 0l;
	}

	METHOD HELLO::WMPaint()
	{
		PAINTSTRUCT ps;
		RECT		rt;

		BeginPaint	  (GetWindowHandle (), &ps);

		SetMapMode	   (ps.hdc,		 MM_ANISOTROPIC);
		GetClientRect  (GetWindowHandle (), 	&rt);
		SetViewportExt (ps.hdc, rt.right, rt.bottom);
		SetWindowOrg   (ps.hdc, 0,    0		   	   );

		rt.right  = 450;
		rt.bottom = 40;

		SetWindowExt (ps.hdc, rt.right, rt.bottom);

		HFONT hOldFont = SelectObject (ps.hdc, hFont);

		DrawText (
			ps.hdc,
			pTitle,
			-1,
			&rt,
			DT_CENTER | DT_VCENTER | DT_SINGLELINE
		);

		SelectObject (ps.hdc, hOldFont);

		EndPaint  (GetWindowHandle (), &ps);

		return 0l;
	}
