/*
	MDI.CPP - (C) 1990 by Joachim Kainz 'On a mission from Bhudda'
*/
	#include "mdi.hpp"

	HWND MDI::hMDIClient = NULL;

	EXPORT MDI::MDI (
			int		 nCmdShow,
			int		 x,
			int		 y,
			int		 cx,
			int		 cy,
			long	 lStyle,
			LPSTR    lpName,
			LPSTR	 lpMenu,
			long	 lExStyle,
			WORD	 wStyle,
			HCURSOR	 hCursor,
			HICON	 hIcon,
			HBRUSH	 hBackGrnd,
			WORD	 wClsExtra,
			WORD	 wWndExtra,
			LPSTR	 lpParam,
			LPSTR	 lpClass,
			FARPROC2 lpFnProc
	) : TOPLEVEL (
			SW_HIDE,
			x,
			y,
			cx,
			cy,
			lStyle,
			lpName,
			lpMenu,
			lExStyle,
			wStyle,
			hCursor,
			hIcon,
			hBackGrnd,
			wClsExtra,
			wClsExtra,
			lpParam,
			lpClass,
			lpFnProc
		)
	{
		if (hMDIClient != NULL)
			return;            	// Only one MDI-Window is allowed!

		if (!GetWindowHandle ())
			return;

		// Erzeugen des MDI-Client-Windows

		CLIENTCREATESTRUCT ccs;

		ccs.hWindowMenu	 = NULL;
		ccs.idFirstChild = ID_MDICHILD;

		hMDIClient = CreateWindow (
						"mdiclient",
						NULL,
						WS_MDICLIENT,
						0,
						0,
						0,
						0,
						GetWindowHandle (),
						0,
						GetInstance (),
						(LPSTR) &ccs
					 );

		if (!GetMDIClient ())
			return;

		msg.SetMDIMode (GetWindowHandle (), GetMDIClient ());
		ShowWindow     (GetMDIClient    (), SW_SHOW        );

		if (nCmdShow != SW_HIDE)
			ShowWindow (GetWindowHandle (), nCmdShow);
	}

	HMENU EXPORT MDI::MDISetMenu (HMENU hNewAppMenu, HMENU hNewPopUp)
	{
		HMENU hOld =
				(HMENU) SendMessage (
							GetMDIClient (),
							WM_MDISETMENU,
							NULL,
							MAKELONG (hNewAppMenu, hNewPopUp)
						);
		DrawMenuBar (GetWindowHandle ());

		return hOld;
	}

	HWND EXPORT MDI::GetNextChild (HWND hChild)
	{
		if (hChild)
			hChild = GetWindow (hChild, GW_HWNDNEXT);

		else
			hChild = GetWindow (GetMDIClient (), GW_CHILD);

		while (hChild) {

			if (!GetWindow (hChild, GW_OWNER))
				break;

			hChild = GetWindow (hChild, GW_HWNDNEXT);

		}

		return hChild;
	}

	long EXPORT MDI::SendAllChildren(
						WORD wMsg,
						WORD wParam,
						long lParam,
						BOOL bBreakOnFalse
					 )
	{
		long lReturn;
		HWND hChild,
			 hNext;

		for (hChild=GetNextChild (); hChild; hChild = hNext) {

			hNext = GetNextChild (hChild);

			lReturn = SendMessage (hChild, wMsg, wParam, lParam);

			if (!lReturn && bBreakOnFalse)
				return NULL;

		}

		return lReturn;
	}

