/*
	MDICHILD.CPP - (C) 1990 by Joachim Kainz 'On a mission from Bhudda'
*/
	#include "mdi.hpp"
	#include <string.h>

	EXPORT MDICHILD::MDICHILD (
				LPSTR lpName,
				HICON hIcon,
				int	  x,
				int	  y,
				int	  cx,
				int	  cy,
				long  lStyle,
				long  lParam,
				LPSTR lpClass
	) : WINDOW (
			CS_VREDRAW | CS_HREDRAW,
			LoadCursor (NULL, IDC_ARROW),
			hIcon,
			COLOR_WINDOW+1,
			0,
			0,
			lpClass,
			DefMDIChildProc
		)
	{
		MDICREATESTRUCT mdi;
		LPSTR			lpTitle;

		if (HIWORD (lpName))
			lpTitle = _fstrdup (lpName);

		else
			for (WORD wLen=64;; wLen*=2) {

				lpTitle = new char [wLen];

				if (
					LoadString (
						GetInstance (),
						LOWORD (lpName),
						lpTitle,
						wLen
					) < wLen-1
				)
					break;

				delete lpTitle;

			}

		mdi.szClass	= lpClass;
		mdi.szTitle	= lpTitle;
		mdi.hOwner	= GetInstance ();
		mdi.x		= x;
		mdi.y		= y;
		mdi.cx		= cx;
		mdi.cy		= cy;
		mdi.style	= lStyle;
		mdi.lParam	= lParam;

		hWnd = (HWND) ::SendMessage (
							MDI::GetMDIClient (),
							WM_MDICREATE,
							NULL,
							(long) &mdi
					  );

		delete lpTitle;

		if (!GetWindowHandle ())
			return;

		SetWindowLong (GetWindowHandle (), 0, (long) this);

		lpDefWndProc =
			   (FARPROC2) SetWindowLong (
							GetWindowHandle (),
							GWL_WNDPROC,
							(long) GetOOPWndProc ()
						  );

		SendMessage (self, WM_CREATE, NULL,	(long) &mdi);
	}

	METHOD MDICHILD::WMChildActivate ()
	{
		return DefMDIChildProc (
					GetWindowHandle (),
					WM_CHILDACTIVATE,
					NULL,
					0l
			   );
	}

	METHOD MDICHILD::WMMove	(POINT pt)
	{
		return DefMDIChildProc (
				GetWindowHandle (),
				WM_MOVE,
				NULL,
				*(long *) &pt
			   );
	}

	METHOD MDICHILD::WMGetMinMaxInfo (LPRECT lprt)
	{
		return DefMDIChildProc (
				GetWindowHandle (),
				WM_GETMINMAXINFO,
				NULL,
				(long) lprt
			   );
	}

	METHOD MDICHILD::WMMenuChar (WORD wKey, HMENU hMenu, WORD wMenu)
	{
		return DefMDIChildProc (
				GetWindowHandle (),
				WM_MENUCHAR,
				wKey,
				MAKELONG (wMenu, hMenu)
			   );
	}

	METHOD MDICHILD::WMSetFocus (HWND hLast)
	{
		return DefMDIChildProc (GetWindowHandle (), WM_SETFOCUS, hLast, 0l);
	}

	METHOD MDICHILD::WMSize (WORD wSizing, int nWidth, int nHeigth)
	{
		return DefMDIChildProc (
				GetWindowHandle (),
				WM_SIZE,
				wSizing,
				MAKELONG (nWidth, nHeigth)
			   );
	}

	METHOD MDICHILD::WndMdiProc (WORD wMsg, WORD wParam, long lParam)
	{
		switch (wMsg) {

		  case WM_PARENTNOTIFY:
			return WMParentNotify (
					HIWORD (lParam),
					wParam,
					LOWORD (lParam)
				   );

		  case WM_MDIACTIVATE:
			return WMMDIActivate (
					wParam,
					HIWORD (lParam),
					LOWORD (lParam)
				   );

		}

		return DefMDIChildProc (GetWindowHandle (),	wMsg, wParam, lParam);
	}

	METHOD MDICHILD::WndDlgProc (WORD wMsg, WORD wParam, long lParam)
	{
		switch (wMsg) {

		  case WM_COMMAND:
			return WMCommand (
						wParam,
						HIWORD (lParam),
						LOWORD (lParam)
				   );

		  case WM_SYSCOMMAND:
			return WMSysCommand (wParam, MAKEPOINT (lParam));

		  case WM_TIMER:
			return WMTimer (wParam, (FARPROC) lParam);

		  case WM_HSCROLL:
			return WMHScroll (wParam, HIWORD (lParam));

		  case WM_VSCROLL:
			return WMVScroll (wParam, HIWORD (lParam));

		  case WM_INITMENU:
			return WMInitMenu (wParam);

		  case WM_INITDIALOG:
			return WMInitDialog (lParam);

		  case WM_INITMENUPOPUP:
			return WMInitMenuPopUp	(
						wParam,
						LOWORD (lParam),
						HIWORD (lParam)
					 );

		  case WM_MENUSELECT:
			return WMMenuSelect (wParam, LOWORD (lParam));

		  case WM_MENUCHAR:
			return WMMenuChar (
						wParam,
						HIWORD (lParam),
						LOWORD (lParam)
				   );

		  case WM_ENTERIDLE:
			return WMEnterIdle (wParam, LOWORD (lParam));

		}

		return DefMDIChildProc (GetWindowHandle (),	wMsg, wParam, lParam);
	}

	METHOD MDICHILD::WMSysCommand	(WORD wID, POINT pt)
	{
		return DefMDIChildProc (
				GetWindowHandle (),
				WM_SYSCOMMAND,
				wID,
				*(long*)&pt
			   );
	};

	METHOD MDICHILD::WMSetText(LPSTR lpText)
	{
		return DefMDIChildProc(GetWindowHandle (), WM_SETTEXT, NULL, (long) lpText);
	}

	METHOD MDICHILD::WMMenuSelect (WORD wMenu, WORD wFlag)
	{
		return DefMDIChildProc(
				GetWindowHandle (),
				WM_MENUSELECT,
				wMenu,
				MAKELONG (wFlag, NULL)
			   );
	}

	METHOD MDICHILD::WMClose ()
	{
		return SendMessage (
				MDI::GetMDIClient (),
				WM_MDIDESTROY,
				GetWindowHandle (),
				0l
			   );
	}
