/*
	MDIDEMO.CPP - (C) 1991 by Joachim Kainz 'On a mission from Bhudda'
*/
	#include "mdidemo.hpp"
	#include <string.h>

	WORD DEMOCHILD::wCount = 0;

	int PASCAL WinMain (
				HANDLE	hInst,
				HANDLE	hPrevInstance,
				LPSTR	lpCmdLine,
				int		nCmdShow
			   )
	{
		SetInstance (hInst);

		MDIDEMO mdi (nCmdShow);

		if (!IsWindow (mdi))
			return FALSE;

		new DEMOCHILD ();

		return MsgLoop (mdi);
	}

	DEMOCHILD::DEMOCHILD () :
		MDICHILD (MAKEINTRESOURCE (ID_FONT+(wCount++)%7))
	{
		LOGFONT lf;

		memset (&lf, 0, sizeof lf);

		GetWindowText (
			GetWindowHandle (),
			(LPSTR) lf.lfFaceName,
			sizeof lf.lfFaceName
		);
		lf.lfHeight  = 38;
		lf.lfWidth   = 50;
		lf.lfQuality = PROOF_QUALITY;

		hFont  = CreateFontIndirect (&lf);
		pTitle = new char [20];

		LoadString (GetInstance (), ID_HI_FOLKS, pTitle, 20);

		InvalidateRect (GetWindowHandle (), NULL, TRUE);
	}

	METHOD DEMOCHILD::WMPaint()
	{
		PAINTSTRUCT ps;
		RECT		rt;

		BeginPaint	  (GetWindowHandle (), &ps);

		SetMapMode	   (ps.hdc,		 MM_ANISOTROPIC);
		GetClientRect  (GetWindowHandle (), 	&rt);
		SetViewportExt (ps.hdc, rt.right, rt.bottom);
		SetWindowOrg   (ps.hdc, 0,    0		   	   );

		rt.right  = 450;
		rt.bottom = 40;

		SetWindowExt (ps.hdc, rt.right, rt.bottom);

		HFONT hOldFont = SelectObject (ps.hdc, hFont);

		DrawText (
			ps.hdc,
			pTitle,
			-1,
			&rt,
			DT_CENTER | DT_VCENTER | DT_SINGLELINE
		);

		SelectObject (ps.hdc, hOldFont);

		EndPaint  (GetWindowHandle (), &ps);

		return 0l;
	}

	METHOD DEMOCHILD::WMDestroy ()
	{
		delete pTitle;

		DeleteObject (hFont);

		return MDICHILD::WMDestroy ();
	}

	MDIDEMO::MDIDEMO (int nShow) : MDI (SW_HIDE)
	{
		HMENU hMenu = GetMenu (GetWindowHandle ());

		MDISetMenu (
			hMenu,
			GetSubMenu (hMenu, 1)
		);

		ShowWindow (self, nShow);
	}

	METHOD MDIDEMO::WMCommand (WORD wID, WORD wMsg, HWND hCtl)
	{
		switch (wID) {

		  case ID_FILE_OPEN:
			new DEMOCHILD ();
			return 0l;

		}

		return MDI::WMCommand (wID, wMsg, hCtl);
	}
