/*
	MSGLOOP.CPP - Die Windows-Nachrichtenschleife
	(C) 1990 by Joachim Kainz 'On a mission from Bhudda'
*/
	#include "msgloop.hpp"
	#include <string.h>

	void EXPORT MSGLOOP::ProcessMsg (LPMSG lpMsg)
	{
		if (IsMDILoop ())
			if (TranslateMDISysAccel (GetMDIClient (), lpMsg))
				return;

		for (WORD m=0; m<wDlg; m++)
			if (IsDialogMessage (phDlg [m], lpMsg))
				return;

		TranslateMessage (lpMsg);
		DispatchMessage  (lpMsg);
	}

	int EXPORT MSGLOOP::Loop ()
	{
		MSG msg;

		while (GetMessage (&msg, NULL, NULL, NULL))
			ProcessMsg (&msg);

		return msg.wParam;
	}

	int EXPORT MSGLOOP::Peek ()
	{
		MSG msg;

		if (!PeekMessage (&msg, NULL, NULL, NULL, PM_REMOVE))
			return FALSE;

		ProcessMsg (&msg);

		return TRUE;
	}

	BOOL EXPORT MSGLOOP::SetMDIMode (HWND hwnd, HWND hmdiClient)
	{
		hWnd		= hwnd;
		hMDIClient	= hmdiClient;

		return TRUE;
	}

	EXPORT MSGLOOP::MSGLOOP ()
	{
		memset (this, 0, sizeof *this);
	}

	EXPORT MSGLOOP::~MSGLOOP ()
	{
		if (wMaxDlg)
			delete phDlg;
	}

	BOOL EXPORT MSGLOOP::AddDlg (HWND hDlg)
	{
		if (wMaxDlg <= wDlg) {

			if (wMaxDlg) {

				HWND * pNewDlg = new HWND [wMaxDlg+2];

				if (!pNewDlg)
					return FALSE;

				memmove (pNewDlg, phDlg, wDlg*sizeof (HWND));

				delete phDlg;

				phDlg = pNewDlg;

			} else
				phDlg = new HWND [wMaxDlg+2];

			wMaxDlg = LocalSize ((HANDLE) phDlg)/sizeof (HWND);

		}

		if (!phDlg)
			return FALSE;

		phDlg [wDlg++] = hDlg;

		return TRUE;
	}

	BOOL EXPORT MSGLOOP::RemoveDlg (HWND hDlg)
	{
		if (!wMaxDlg)
			return TRUE;

		if (!hDlg) {

			delete phDlg;

			wDlg	=
			wMaxDlg	= 0;

			return TRUE;

		}

		for (WORD m=0; m<wDlg; m++)
			if (phDlg [m] == hDlg) {

				wDlg--;
				memmove (phDlg+m, phDlg+m+1, wDlg-m);
				return TRUE;

			}

		return FALSE;
	}
