// winsb.cpp
#include<windows.h>
#include"winsb.h"

void WinScrollBar::ScrollProc(WORD wParam, LONG lParam)
    {
    switch(wParam)
        {
        case SB_LINEUP:     // move up
            curPosition -= numLineScroll;
            break;
        case SB_LINEDOWN:   // move down
            curPosition += numLineScroll;
            break;
        case SB_PAGEUP:     // move up a 'page'
            curPosition -= numPageScroll;
            break;
        case SB_PAGEDOWN:   // move down a 'page'
            curPosition += numPageScroll;
            break;
        case SB_TOP:        // go to top
            curPosition = minPosition;
            break;
        case SB_BOTTOM:     // go to bottom
            curPosition = maxPosition;
            break;
        case SB_THUMBPOSITION:    // reset to new position
            curPosition = LOWORD(lParam);
            break;
        }
    curPosition = max(0, min(curPosition, maxPosition));
    }
