#include<iostream.h>
// conventional strcpy...
char *strcpy(char *dest, const char *source) {
    char *d = dest;
    while((*dest++ = *source++));
    return d;
}
// strcpy that accepts a length argument...
char *strcpy(char *dest, const char *source, size_t len) {
    char *d = dest;
    while(len && (*dest++ = *source++)) len--;
    while(len--) *dest++ = '\0';
    return d;
}
typedef char far *FPTR;
// strcpy that copies far pointers...
FPTR strcpy(FPTR dest, FPTR source) {
    char far *d = dest;
    while((*dest++ = *source++));
    return d;
}
void main(void) {
    char destbuf[50];
    FPTR fptr = "This is referred to as a far pointer\n";
    strcpy(destbuf,"Copy this...\n");
    cout << destbuf;
    strcpy((FPTR)destbuf,fptr);
    cout << destbuf; strcpy(destbuf,"Then only copy 35 characters of this...", 35);
    cout << destbuf;
    cout << destbuf;
}
