#ifndef INC_ELEMENT_HXX
#define INC_ELEMENT_HXX

#ifndef INC_TYPES_HXX
#include "types.hxx"
#endif



template <class T> class Element 
{
	public:
		T* GetData();
		Element<T>* GetPrevious();
		Element<T>* GetNext();
		Element(T* d, Element<T>* p=0, Element<T>* n=0);
		~Element();
		void SetPrevious(Element<T>* p);
		void SetNext(Element<T>* n);
		void SetData(T* d);
	private:
		T* Data;
		Element<T>* Next;
		Element<T>* Previous;
};

template <class T> T* Element<T> :: GetData()
{
	return Data;
}

template <class T> Element<T>* Element<T> :: GetPrevious()
{
	return Previous;
}

template <class T> Element<T>* Element<T> :: GetNext()
{
	return Next;
}

template <class T> Element<T> :: Element(T* d, Element<T>* p, Element<T>* n)
{
	Data=d;
	Previous=p;
	Next=n;
}

template <class T> Element<T> :: ~Element()
{
	delete Data;
}

template <class T> void Element<T> :: SetPrevious(Element<T>* p)
{
	Previous=p;
}

template <class T> void Element<T> :: SetNext(Element<T>* n)
{
	Next=n;
}

template <class T> void Element<T> :: SetData(T* d)
{
	Data=d;
}


#endif

