/*
 * stat.h -- interface to status bar
 * Copyright (c) Stephen Crane February 1993
 */

#define SF_LEFT		0x0000
#define	SF_RIGHT	0x0001
#define SF_CENTRE	0x0002
#define SF_MAX		0x0010

/*
 * CreateStatus -- create a status bar.
 * hparent -- status bar lives at the bottom of this window.
 * style -- status bar's style, e.g. WS_VISIBLE | WS_CHILD | WS_CLIPSIBLINGS
 * area -- returned status bar client area.
 * hf -- font to be used to draw the text.
 * strs -- an array of pointers to maximum-length strings.
 * ns -- the number of strings to be displayed.
 */
HWND FAR PASCAL CreateStatus (HWND hparent, DWORD style, LPRECT area, HFONT hf, LPSTR FAR *strs, int ns);

/*
 * UpdateStatus -- update a single element in the status bar.
 * hstat -- status bar window.
 * style -- style to be used when drawing text, i.e. TA_LEFT | TA_CENTER | TA_RIGHT.
 * n -- index of string to be updated.
 * str -- new string to be displayed.
 */
BOOL FAR PASCAL UpdateStatus (HWND hstat, UINT style, int n, LPSTR str);

/*
 * DestroyStatus -- destroy a status bar.
 * hstat -- the condemned status bar window.
 */
void FAR PASCAL DestroyStatus (HWND hstat);
