// telsckvw.cpp : implementation of the CTelsockView class
//

#include "stdafx.h"
#include "winsock.h"
#include "telsock.h"
#include "mainfrm.h"
#include "teldoc.h"
#include "telsckvw.h"
#include "getstdlg.h"
#include "hostdlg.h"
#include "dispdlg.h"
#include "tcpdlg.h"

#define DESIRED_WINSOCK_VERSION         0x0101  // we'd like winsock ver 1.1...
#define MINIMUM_WINSOCK_VERSION         0x0001  // ...but we'll take ver 1.0

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTelsockView

IMPLEMENT_DYNCREATE(CTelsockView, CFormView)

BEGIN_MESSAGE_MAP(CTelsockView, CFormView)
 	ON_MESSAGE(WSA_READ,OnWSA_READ)
	ON_MESSAGE(WSA_ACCEPT,OnWSA_ACCEPT)
	//{{AFX_MSG_MAP(CTelsockView)
	ON_COMMAND(ID_WINSOCK_SENDTCP, OnWinsockSendtcp)
	ON_COMMAND(ID_WINSOCK_LISTEN, OnWinsockListen)
	ON_COMMAND(ID_WINSOCK_HOSTNAME, OnWinsockHostname)
	ON_COMMAND(ID_WINSOCK_CONNECT, OnWinsockConnect)
	ON_COMMAND(ID_WINSOCK_CANCEL, OnWinsockCancel)
	ON_COMMAND(ID_WINSOCK_ALISTEN, OnWinsockAlisten)
	ON_COMMAND(ID_WINSOCK_TLISTEN, OnWinsockTlisten)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_TELSOCK_READ, OnClickedTelsockRead)
	ON_BN_CLICKED(IDC_TELSOCK_WRITE, OnClickedTelsockWrite)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTelsockView construction/destruction

CTelsockView::CTelsockView()
	: CFormView(CTelsockView::IDD)
{
	//{{AFX_DATA_INIT(CTelsockView)
	m_nsubscriber = 0;
	m_nenable = 0;
	m_nstatus = 0;
	m_nremote = 0;
	//}}AFX_DATA_INIT
}

CTelsockView::~CTelsockView()
{
	if (m_porthandle >= 0)
		;//CloseComm(m_porthandle);
}

void CTelsockView::OnInitialUpdate()
{
	WSADATA WSAData;
  char szTemp[80];
	int status;
  if ((status = WSAStartup(DESIRED_WINSOCK_VERSION, &WSAData)) == 0) 
  {
    MessageBox(WSAData.szDescription, WSAData.szSystemStatus, MB_OK);
  }
  else 
  {
    sprintf(szTemp, "%d is the err", status);
    MessageBox(szTemp, "Error", MB_OK);
  }
	/*
	m_porthandle = OpenComm("LPT1",256,256);
	if (m_porthandle < 0)
	{
    wsprintf(szTemp,"OpenComm failed: %d",m_porthandle);
    MessageBox(szTemp, "Error", MB_OK);
	}
	*/
	CFormView::OnInitialUpdate();
}

void CTelsockView::DoDataExchange(CDataExchange* pDX)
{
	// ClassWizard maintains mappings between data of the CTelsockView
	// class and the controls in the dialog template resource for this
	// form view.

	//{{AFX_DATA_MAP(CTelsockView)
	DDX_Radio(pDX, IDC_TELSOCK_RADIO1, m_nsubscriber);
	DDX_Radio(pDX, IDC_TELSOCK_RADIO5, m_nenable);
	DDX_Radio(pDX, IDC_TELSOCK_RADIO18, m_nstatus);
	DDX_Radio(pDX, IDC_TELSOCK_RADIO24, m_nremote);
	//}}AFX_DATA_MAP

}


/////////////////////////////////////////////////////////////////////////////
// CTelsockView drawing
void CTelsockView::OnUpdate(CView*, LPARAM lHint, CObject* pHint)
{
	// OnUpdate() is called whenever the document has changed and,
	// therefore, the view needs to redisplay some or all of itself.

	CTelsockDoc* pDoc = GetDocument();
	UpdateData(FALSE);  // Copy the view form object's data to the
						// controls (via DoDataExchange).

	Invalidate();       // Repaint the entire form view.
}

/////////////////////////////////////////////////////////////////////////////
// CTelsockView diagnostics

#ifdef _DEBUG
void CTelsockView::AssertValid() const
{
	CFormView::AssertValid();
}

void CTelsockView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CTelsockDoc* CTelsockView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CTelsockDoc)));
	return (CTelsockDoc*) m_pDocument;
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CTelsockView message handlers

void CTelsockView::OnWinsockSendtcp()
{
	// TODO: Add your command handler code here
      /*
      *   Send a message to (via TCP connection) to remote host.
      */
//      case IDM_SENDTCP:
//         DialogBox(hInst,                /* current instance         */
//            "GetString",                 /* resource to use          */
//            hWnd,                        /* parent handle            */
//            GetSendString);              /* instance address         */
	CTelsockDoc* pdoc = GetDocument();
	CGetStringDlg dlg;
	dlg.m_csstring = pdoc->m_csstring;
	if (dlg.DoModal() == IDOK)
	{
  	pdoc->m_csstring = dlg.m_csstring;
	      /*
        *   Assumption -- The GetString dialog box proc fills the global
        *   string buffer, szBuff, with the desired string to send.
        */	
    send(pdoc->sock, (const char*)pdoc->m_csstring, pdoc->m_csstring.GetLength(), NO_FLAGS_SET );
	}
//        break;   /* IDM_SENDTCP */
	
}

void CTelsockView::OnWinsockListen()
{
// TODO: Add your command handler code here
//      case IDM_LISTEN:
//      {
	char szTemp[80];

	CTelsockDoc* pdoc = GetDocument();
  pdoc->sock = socket( AF_INET, SOCK_STREAM, 0);
  if (pdoc->sock == INVALID_SOCKET) 
  {
  	MessageBox("socket() failed", "Error", MB_OK);
    closesocket(pdoc->sock);
    return;
  }
  /*
  *   Retrieve the IP address and TCP Port number
  */
  if (!FillAddr(&pdoc->local_sin, FALSE))
    return;
  /*
  *   Disable/enable proper menu items.
  */
  CMenu* pcmenu = ((CMainFrame*)theApp.m_pMainWnd)->GetMenu();
  pcmenu->EnableMenuItem(ID_WINSOCK_HOSTNAME, MF_GRAYED);
  pcmenu->EnableMenuItem(ID_WINSOCK_LISTEN, MF_GRAYED);
  pcmenu->EnableMenuItem(ID_WINSOCK_ALISTEN, MF_GRAYED);
  pcmenu->EnableMenuItem(ID_WINSOCK_TLISTEN, MF_GRAYED);
  pcmenu->EnableMenuItem(ID_WINSOCK_CONNECT, MF_GRAYED);
  
  SetWindowText("Waiting for connection..");

  /*
  *   Associate an address with a socket. (bind)
  */
  if (bind( pdoc->sock, (struct sockaddr FAR *) &pdoc->local_sin, sizeof(pdoc->local_sin)) == SOCKET_ERROR) 
  {
    sprintf(szTemp, "%d is the error", WSAGetLastError());
  	MessageBox(szTemp, "bind(sock) failed", MB_OK);
    return;
  }
  if (listen( pdoc->sock, MAX_PENDING_CONNECTS ) < 0) 
  {
    sprintf(szTemp, "%d is the error", WSAGetLastError());
    MessageBox(szTemp, "listen(sock) failed", MB_OK);
    return;
  }
  pdoc->acc_sin_len = sizeof(pdoc->acc_sin);
  pdoc->sock = accept( pdoc->sock,(struct sockaddr FAR *) &pdoc->acc_sin,(int FAR *) &pdoc->acc_sin_len );
  if (pdoc->sock < 0) 
  {
    sprintf(szTemp, "%d is the error", WSAGetLastError());
    MessageBox(szTemp, "accept(sock) failed", MB_OK);
    return;
  }
  MessageBox("accept()", "Accepted a connection!", MB_OK);
  /*
  *   Now have a connection --
  *   SetConnectMenus() grays/enables proper menu items
  */
  SetConnectMenus();
  /*
  *   Send main window a WSA_READ when either data is pending on
  *   the socket (FD_READ) or the connection is closed (FD_CLOSE)
  */
  if ((pdoc->status = WSAAsyncSelect( pdoc->sock, m_hWnd, WSA_READ, FD_READ | FD_CLOSE )) > 0) 
  {
    wsprintf(szTemp, "%d (0x%x)");
    MessageBox("Error on WSAAsyncSelect()", szTemp, MB_OK);
    closesocket( pdoc->sock );
  }
}
//      break;   /* IDM_LISTEN */
	

void CTelsockView::OnWinsockHostname()
{
	// TODO: Add your command handler code here
      /*
      *   Display host information.
      */
//      case IDM_HOSTNAME:

         /*
         *  Prompt the user and retrieve the text name of the host.
         */
  //       status = DialogBox(hInst,
  //          "HOSTNAME",
  //          hWnd,
  //          GetHostName);
  
  CTelsockDoc* pdoc = GetDocument();
  CHostnameDlg dlg;
	dlg.m_cshostname = pdoc->m_cshostname;
	if (dlg.DoModal() == IDOK)
	{
  //       if (status == TRUE) {   /* If user hit "OK" .. */
		pdoc->m_cshostname = dlg.m_cshostname;
	
         /*
         *   Get the host information
         */

		if ((pdoc->phe = gethostbyname( (const char *)pdoc->m_cshostname )) == NULL) 
    {
      MessageBox("gethostbyname() failed", "Error", MB_OK);
      return;
    }
    else 
    {

         /*
         *   Display the host information ..
         */
//            DialogBox(hInst,
//               "DISPLAYHOST",
//               hWnd,
//               DisplayHostEnt);
			CDisplayHostDlg dlg1;
			dlg1.phe = pdoc->phe;
			dlg1.DoModal();
    }
  }
//      break;   /* IDM_HOSTNAME */	
}

void CTelsockView::OnWinsockConnect()
{
	CTelsockDoc* pdoc = GetDocument();
	// TODO: Add your command handler code here
  //    case IDM_CONNECT: /* Client - connect to remote host */
  //    {
         /*

         When a network client wants to connect to a server,
         it must have:
            1.) a TCP port number (gotten via getservbyname())
            and
            2.) an IP address of the remote host (gotten via gethostbyname()).

         The following summarizes the steps used to connect.
         Make a dialog box (HostName)
         Get the name of the remote host computer in which
          to connect from the user (store string in "szBuff" global var)
       * Check to see if the hosts file knows the computer (gethostbyname)
       * Get the host information (hostent structure filled)
       * Fill in the address of the remote host into the servent structure (memcpy)
       * Make a dialog box (TCPPORTNUM)
       * Get the NAME of the port to connect to on the remote host from the
         user.
       * Get the port number (getservbyname)
       * Fill in the port number of the servent structure
         Establish a connection (connect)

         The * prefixed steps are done in the FillAddr() procedure.


         */
         SOCKADDR_IN dest_sin;  /* DESTination Socket INternet */



         /* Get the name of the remote host. Store the string in szBuff. */

  //       status = DialogBox(hInst,
  //          "HOSTNAME",
  //          hWnd,
  //          GetHostName);

  //       if (!status)   /* User cancelled request from prev. dialog box */
  //          break;
	char szTemp[80];
	CHostnameDlg dlg;
	dlg.m_cshostname = pdoc->m_cshostname;
	if (dlg.DoModal() == IDOK)
	{
  	pdoc->m_cshostname = dlg.m_cshostname;
    pdoc->sock = socket( AF_INET, SOCK_STREAM, 0);
         if (pdoc->sock == INVALID_SOCKET) {
            MessageBox("socket() failed", "Error", MB_OK);
            return;
         }

         /*
         *    Retrieve the IP address and TCP Port number
         *    Global variable pdoc->m_cshostname contains the remote host name.
         */
         if (!FillAddr(&dest_sin, TRUE)) {
            closesocket( pdoc->sock );
            return;
         }


         if (connect( pdoc->sock, (PSOCKADDR) &dest_sin, sizeof(dest_sin)) < 0) 
         {
            closesocket( pdoc->sock );
            MessageBox("connect() failed", "Error", MB_OK);
            return;
         }
         MessageBox("connect() worked!", "Success!", MB_OK);

         /*
         *   Now have a connection --
         *   SetConnectMenus() grays/enables proper menu items
         */
         SetConnectMenus();

         /*
         *   Send main window a WSA_READ when either data is pending on
         *   the socket (FD_READ) or the connection is closed (FD_CLOSE)
         */
         if ((pdoc->status = WSAAsyncSelect( pdoc->sock, m_hWnd, WSA_READ, FD_READ | FD_CLOSE )) > 0) {
            wsprintf(szTemp, "%d (0x%x)");
            MessageBox( "Error on WSAAsyncSelect()", szTemp, MB_OK);
            closesocket( pdoc->sock );
         }
	}
  //    }
      //break;   /* IDM_CONNECT */	
}

void CTelsockView::OnWinsockCancel()
{
	// TODO: Add your command handler code here
      /*
      *   Cancel an asynchronous call.
      */
//      case IDM_CANCEL:
         CTelsockDoc* pdoc = GetDocument();
         WSAAsyncSelect( pdoc->sock, m_hWnd, 0, 0);
         SetWindowText("Async Listen cancelled..");

         /*
         *   Disable/enable proper menu items.
         */
         CMenu* pcmenu = ((CMainFrame*)theApp.m_pMainWnd)->GetMenu();
   		pcmenu->EnableMenuItem(ID_WINSOCK_HOSTNAME, MF_ENABLED);
         pcmenu->EnableMenuItem(ID_WINSOCK_LISTEN, MF_ENABLED);
         pcmenu->EnableMenuItem(ID_WINSOCK_CONNECT, MF_ENABLED);
         pcmenu->EnableMenuItem(ID_WINSOCK_ALISTEN, MF_ENABLED);
         pcmenu->EnableMenuItem(ID_WINSOCK_TLISTEN, MF_ENABLED);
         pcmenu->EnableMenuItem(ID_WINSOCK_CANCEL, MF_GRAYED);
         pcmenu->EnableMenuItem(ID_WINSOCK_SENDTCP, MF_GRAYED);

         //break;   /* IDM_CANCEL */
	
}

void CTelsockView::OnWinsockAlisten()
{
	// TODO: Add your command handler code here
//      case IDM_ALISTEN:
//      {
         char szTemp[80];
         CTelsockDoc* pdoc = GetDocument();

         pdoc->sock = socket( AF_INET, SOCK_STREAM, 0);
         if (pdoc->sock == INVALID_SOCKET) {
            MessageBox("socket() failed", "Error", MB_OK);
            return;
         }
         /*
         *   Retrieve the IP address and TCP Port number
         */

         if (!FillAddr(&pdoc->local_sin, FALSE)) {
            closesocket( pdoc->sock );
            return;
         }

         /*
         *   Disable/enable proper menu items.
         */
         CMenu* pcmenu = ((CMainFrame*)theApp.m_pMainWnd)->GetMenu();
   		pcmenu->EnableMenuItem(ID_WINSOCK_HOSTNAME, MF_GRAYED);
         pcmenu->EnableMenuItem(ID_WINSOCK_LISTEN, MF_GRAYED);
         pcmenu->EnableMenuItem(ID_WINSOCK_CONNECT, MF_GRAYED);
         pcmenu->EnableMenuItem(ID_WINSOCK_ALISTEN, MF_GRAYED);
         pcmenu->EnableMenuItem(ID_WINSOCK_TLISTEN, MF_GRAYED);
         pcmenu->EnableMenuItem(ID_WINSOCK_CANCEL, MF_ENABLED);

         SetWindowText("Waiting for connection.. (Async)");


         /*
         *   Associate an address with a socket. (bind)
         */
         if (bind( pdoc->sock, (struct sockaddr FAR *) &pdoc->local_sin, sizeof(pdoc->local_sin)) == SOCKET_ERROR) 
         {
            sprintf(szTemp, "%d is the error", WSAGetLastError());

            MessageBox(szTemp, "bind(sock) failed", MB_OK);
            closesocket( pdoc->sock );
            return;
         }

         if (listen( pdoc->sock, MAX_PENDING_CONNECTS ) < 0) 
         {
            sprintf(szTemp, "%d is the error", WSAGetLastError());

            MessageBox(szTemp, "listen(sock) failed", MB_OK);
            return;
         }

         /*
         *   Send window a WSA_ACCEPT when something is trying to connect.
         */
         if ((pdoc->status = WSAAsyncSelect( pdoc->sock, m_hWnd, WSA_ACCEPT, FD_ACCEPT)) > 0) 
         {
            wsprintf( szTemp, "%d (0x%x)");
            MessageBox("Error on WSAAsyncSelect()", szTemp, MB_OK);
            SetWindowText("Async listen cancelled");
            closesocket( pdoc->sock );
         }

//      }
//      break;   /* IDM_ALISTEN */
	
}

void CTelsockView::OnWinsockTlisten()
{
	// TODO: Add your command handler code here
      /*
//      * Listen in the main thread -- spawn and accept two network
//      *  connections inside two threads.
      
      //case IDM_TLISTEN:
      //{
         CTelsockDoc* pdoc = GetDocument();
         static THREADPACK tp;

         pdoc->sock = socket( AF_INET, SOCK_STREAM, 0);
         if (pdoc->sock == INVALID_SOCKET) {
            MessageBox("socket() failed", "Error", MB_OK);
            closesocket(pdoc->sock);
            return;
         }

         
      //   *   Retrieve the IP address and TCP Port number
         

         if (!FillAddr(&pdoc->local_sin, FALSE, (const char *)pdoc->m_cshostsname ))
            return;

         
         //*   Disable/enable proper menu items.
         
         CMenu* pcmenu = ((CMainFrame*)theApp.m_pMainWnd)->GetMenu();
   		pcmenu->EnableMenuItem(ID_WINSOCK_HOSTNAME, MF_GRAYED);
         pcmenu->EnableMenuItem(ID_WINSOCK_LISTEN, MF_GRAYED);
         pcmenu->EnableMenuItem(ID_WINSOCK_CONNECT, MF_GRAYED);
         pcmenu->EnableMenuItem(ID_WINSOCK_ALISTEN, MF_GRAYED);
         pcmenu->EnableMenuItem(ID_WINSOCK_TLISTEN, MF_GRAYED);
         pcmenu->EnableMenuItem(ID_WINSOCK_SENDTCP, MF_GRAYED);

         SetWindowText("Waiting for connection..");


         
         //   Associate an address with a socket. (bind)
         
         if (bind( pdoc->sock, (struct sockaddr FAR *) &pdoc->local_sin, sizeof(pdoc->local_sin)) == SOCKET_ERROR) {
            sprintf(szBuff, "%d is the error", WSAGetLastError());

            MessageBox(szBuff, "bind(sock) failed", MB_OK);
            return;
         }

         if (listen( pdoc->sock, MAX_PENDING_CONNECTS ) < 0) {
            sprintf(szBuff, "%d is the error", WSAGetLastError());

            MessageBox(szBuff, "listen(sock) failed", MB_OK);
            return;
         }

         tp.nThread = 0;
         tp.hWnd = m_hWnd;

         _beginthread(AcceptThreadProc, 0, &tp);

         //}
         //end  IDM_TLISTEN 
*/
}
/****************************************************************************\
*
*    FUNCTION: AcceptThreadProc(PTHREADPACK tp)
*
*    PURPOSE:  Use blocking accept() calls and display a message box when
*              a connection is made.
*
*\***************************************************************************/

void CTelsockView::AcceptThreadProc( PTHREADPACK ptp )
{
/*
   SOCKADDR_IN acc_sin;    // Accept socket address - internet style 
   int acc_sin_len;        // Accept socket address length 
   int status;
   char szMsg[ MY_MSG_LENGTH ];


   CTelsockDoc* pdoc = GetDocument();
   acc_sin_len = sizeof(acc_sin);

   wsprintf( szBuff, "thread #%d created.", ptp->nThread);
   ::MessageBox(ptp->hWnd, szBuff, "FYI", MB_OK);

   pdoc->sock = accept( pdoc->sock,(struct sockaddr FAR *) &acc_sin,
            (int FAR *) &acc_sin_len );

   if (pdoc->sock < 0) {
      sprintf(szBuff, "%d is the error", WSAGetLastError());

      MessageBox(ptp->hWnd, szBuff, "accept(sock) failed", MB_OK);

   }

   wsprintf( szBuff, "Thread #%d accepted something\n\nCheck for incoming messages?", ptp->nThread);

   
   //   Now have a connection --
   //   SetConnectMenus() grays/enables proper menu items
   
   SetConnectMenus( );


   while (1) {

      
      //   By default sockets are created in blocking mode.
      //   Just keep reading until process destroyed.
      
      status = recv( sock, szMsg, MY_MSG_LENGTH, NO_FLAGS_SET );

      if (status == SOCKET_ERROR) {
         wsprintf( szMsg, "Error %d", WSAGetLastError() );
         MessageBox( ptp->hWnd, szMsg, "Error with recv()", MB_OK);
         _endthread();
      }
          szMsg[status] = '\0';  // NULL-terminate the string 

      if (status)
         ::MessageBox( ptp->hWnd, szMsg, "From thread", MB_OK);
      else  {
         ::MessageBox( ptp->hWnd, "Connection broken", "Error", MB_OK);
         _endthread();
      }

   }    // while (forever) 
*/
}

/****************************************************************************
*
*    FUNCTION: SetConnectMenus( HWND )
*
*    PURPOSE: Gray/Enable the proper menu items after a connection has been
*             established.
*
*\***************************************************************************/

void CTelsockView::SetConnectMenus()
{
   /*
   *   Disable/enable proper menu items.
   */
   CMenu* pcmenu = ((CMainFrame*)theApp.m_pMainWnd)->GetMenu();
   pcmenu->EnableMenuItem(ID_WINSOCK_HOSTNAME, MF_ENABLED );
   pcmenu->EnableMenuItem(ID_WINSOCK_LISTEN, MF_GRAYED );
   pcmenu->EnableMenuItem(ID_WINSOCK_CONNECT, MF_GRAYED );
   pcmenu->EnableMenuItem(ID_WINSOCK_ALISTEN, MF_GRAYED );
   pcmenu->EnableMenuItem(ID_WINSOCK_TLISTEN, MF_GRAYED );
   pcmenu->EnableMenuItem(ID_WINSOCK_CANCEL, MF_GRAYED );
   pcmenu->EnableMenuItem(ID_WINSOCK_SENDTCP, MF_ENABLED );

   /*
   *   Reflect socket connection in title bar.
   */
   SetWindowText("Connected");
}

   /*
   *    Notification if data is waiting on a socket.  This comes
   *    from Windows Sockets (via WSAAsyncSelect()).
   */
LRESULT CTelsockView::OnWSA_READ(WPARAM wparam,LPARAM lparam)
{
	CTelsockDoc* pdoc = GetDocument();
      char szTemp[ MY_MSG_LENGTH ];

      if (WSAGETSELECTEVENT(lparam) == FD_READ) 
      {
         pdoc->status = recv((SOCKET)wparam, szTemp, MY_MSG_LENGTH, NO_FLAGS_SET );

         if (pdoc->status) 
         {
            szTemp[ pdoc->status ] = '\0';
            MessageBox(szTemp, "WSA_READ", MB_OK);
         }
         else
            MessageBox("Connection broken", "Error", MB_OK);
      }
      else     /* FD_CLOSE -- connection dropped */
			{
         MessageBox("Connection lost", "WSA_READ", MB_OK);
				 CMenu* pcmenu = ((CMainFrame*)theApp.m_pMainWnd)->GetMenu();
         pcmenu->EnableMenuItem(ID_WINSOCK_HOSTNAME, MF_ENABLED);
         pcmenu->EnableMenuItem(ID_WINSOCK_LISTEN, MF_ENABLED);
         pcmenu->EnableMenuItem(ID_WINSOCK_CONNECT, MF_ENABLED);
         pcmenu->EnableMenuItem(ID_WINSOCK_ALISTEN, MF_ENABLED);
         pcmenu->EnableMenuItem(ID_WINSOCK_TLISTEN, MF_ENABLED);
         pcmenu->EnableMenuItem(ID_WINSOCK_CANCEL, MF_GRAYED);
         pcmenu->EnableMenuItem(ID_WINSOCK_SENDTCP, MF_GRAYED);
      }
   return TRUE;       // WSA_READ
}

LRESULT CTelsockView::OnWSA_ACCEPT(WPARAM wparam,LPARAM lparam) // Notification if a socket connection is pending.       
{  
  char szTemp[80];
  CTelsockDoc* pdoc = GetDocument();
  //   Disable/enable proper menu items.
      
      CMenu* pcmenu = ((CMainFrame*)theApp.m_pMainWnd)->GetMenu();
      pcmenu->EnableMenuItem(ID_WINSOCK_HOSTNAME, MF_ENABLED);
      pcmenu->EnableMenuItem(ID_WINSOCK_LISTEN, MF_ENABLED);
      pcmenu->EnableMenuItem(ID_WINSOCK_CONNECT, MF_ENABLED);
      pcmenu->EnableMenuItem(ID_WINSOCK_ALISTEN, MF_ENABLED);
      pcmenu->EnableMenuItem(ID_WINSOCK_TLISTEN, MF_ENABLED);
      pcmenu->EnableMenuItem(ID_WINSOCK_CANCEL, MF_GRAYED);

      if (WSAGETSELECTERROR( lparam ) == 0)    // Success 
  {
         /*
         *   Accept the incoming connection.
         */
         pdoc->acc_sin_len = sizeof( pdoc->acc_sin );
         pdoc->sock = accept( pdoc->sock,(struct sockaddr FAR *) &pdoc->acc_sin,
            (int FAR *) &pdoc->acc_sin_len );

         if (pdoc->sock < 0) {
            sprintf(szTemp, "%d is the error", WSAGetLastError());

            MessageBox(szTemp, "accept(sock) failed", MB_OK);
            return FALSE;
         }

         MessageBox("accept()", "Accepted a connection!", MB_OK);

         /*
         *   Now have a connection --
         *   SetConnectMenus() grays/enables proper menu items
         */
         SetConnectMenus( );

         /*
         *   Send main window a WSA_READ when either data is pending on
         *   the socket (FD_READ) or the connection is closed (FD_CLOSE)
         */
         if ((pdoc->status = WSAAsyncSelect( pdoc->sock, m_hWnd, WSA_READ, FD_READ | FD_CLOSE )) > 0) {
            wsprintf(szTemp, "%d (0x%x)", pdoc->status, pdoc->status);
            MessageBox("Error on WSAAsyncSelect()", szTemp, MB_OK);
            closesocket( pdoc->sock );
         }
      }
      else 
      {
         MessageBox("accept()", "Error occured!", MB_OK);

         /*
         *   Cancel any further notifications.
         */
         WSAAsyncSelect( pdoc->sock, m_hWnd, 0, 0);
         SetWindowText("Async Listen call canceled");
      }
 return TRUE; /* WSA_ACCEPT */
}

void CTelsockView::OnDestroy()
{
	CFormView::OnDestroy();
	
	// TODO: Add your message handler code here
  WSACleanup();
  PostQuitMessage(0);
}

/****************************************************************************\
*
*    FUNCTION:  FillAddr(HWND, PSOCKADDR_IN, BOOL, LPSTR)
*
*    PURPOSE:  Retrieves the IP address and port number.
*
*    COMMENTS:
*        This function is called in two conditions.
*            1.) When a client is preparing to call connect(), or
*            2.) When a server host is going to call bind(), listen() and
*                accept().
*        In both situations, a SOCKADDR_IN structure is filled.
*        However, different fields are filled depending on the condition.
*
*   ASSUMPTION:
*      szBuff is a global variable that contains the remote host name or NULL
*      if local.
*      bConnect determines if the socket address is being set up for a listen()
*      (bConnect == TRUE) or a connect() (bConnect == FALSE)
*
*
*\***************************************************************************/

BOOL CTelsockView::FillAddr(PSOCKADDR_IN psin, BOOL bConnect)
{
  DWORD dwSize;
  LPHOSTENT phe;
  LPSERVENT pse;
  char szTemp[80];
  //int status;

	CTelsockDoc* pdoc = GetDocument();
  psin->sin_family = AF_INET;
 
  //   If we are setting up for a listen() call (bConnect = FALSE),
  //  fill servent with our address.
   
  if (!bConnect) {
    //   Retrieve my ip address.  Assuming the hosts file in
    //   in %systemroot%/system/drivers/etc/hosts contains my computer name.      
    dwSize = sizeof(szTemp);	
		gethostname(szTemp, (int) dwSize);
		pdoc->m_cshostname = szTemp;
  }

  phe = gethostbyname((const char *)pdoc->m_cshostname);
   if (phe == NULL) {
      sprintf(szTemp, "%d is the error. Make sure '%s' is listed in the hosts file.", WSAGetLastError(), (const char *)pdoc->m_cshostname);
      MessageBox(szTemp, "gethostbyname() failed.", MB_OK);
      return FALSE;
   }
   _fmemcpy((char FAR *)&(psin->sin_addr), (char FAR *)phe->h_addr,
      phe->h_length);
   
   //   Retrieve the Port number
   
//   status = DialogBox(hInst,             /* current instance         */
//      "TCPPORTNUM",                      /* resource to use          */
//      hWnd,                              /* parent handle            */
//      GetTcpPort);                       /* instance address         */
	CTCPPortNumDlg dlg;
	pdoc->status = dlg.DoModal();
  switch(pdoc->status) {
    case 0:               /* User cancelled request from prev. dialog box */
       return FALSE;

    case 1:               // actual port number entered 
      psin->sin_port = htons(pdoc->portno);        // Convert to network ordering 
      break;
	 
		case 2:               // service name entereted      
      //   Find the service name, szBuff, which is a type tcp protocol in
      //   the "services" file.
         
      pse = getservbyname((const char *)pdoc->m_cshostname, "tcp");
      if (pse == NULL)  
      {
        sprintf(szTemp, "%d is the error. Make sure this is a valid TCP service.", WSAGetLastError());
        MessageBox(szTemp, "getservbyname(sock) failed", MB_OK);
        return FALSE;
      }
      psin->sin_port = pse->s_port;
      break;

    default:
    return FALSE;
  }
  return TRUE;
}

void CTelsockView::OnClickedTelsockRead()
{
	// TODO: Add your control notification handler code here
	UpdateData (TRUE);
}

void CTelsockView::OnClickedTelsockWrite()
{
	// TODO: Add your control notification handler code here
	UpdateData (TRUE);
	/*
	TransmitCommChar(m_porthandle, 0x00);
	char ch;
	switch (m_nsubscriber)
	{
		case 0: ch = (char) 0x40; break;
		case 1: ch = (char) 0x50; break;
		case 2: ch = (char) 0x60; break;
		case 3: ch = (char) 0x70; break;
	}                        
	switch (m_nenable)
	{
		case 0: ch += (char) 0x00; break;
		case 1: ch += (char) 0x01; break;
		case 2: ch += (char) 0x02; break;
		case 3: ch += (char) 0x03; break;
		case 4: ch += (char) 0x04; break;
		case 5: ch += (char) 0x05; break;
		case 6: ch += (char) 0x06; break;
		case 7: ch += (char) 0x07; break;
		case 8: ch += (char) 0x08; break;
		case 9: ch += (char) 0x09; break;
		case 10: ch += (char) 0x0a; break;
		case 11: ch += (char) 0x0b; break;
		case 12: ch += (char) 0x0c; break;
	}
  TransmitCommChar(m_porthandle, ch);
	*/
}
